/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.job;

import es.caib.bpm.beans.home.BPMJobExecutorLocalHome;
import es.caib.bpm.beans.local.BPMJobExecutorLocal;
import es.caib.bpm.job.JobExecutor;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;

public class JobExecutorThread
extends Thread {
    private static Logger log = Logger.getLogger((Class)(class$es$caib$bpm$job$JobExecutorThread == null ? (class$es$caib$bpm$job$JobExecutorThread = JobExecutorThread.class$("es.caib.bpm.job.JobExecutorThread")) : class$es$caib$bpm$job$JobExecutorThread));
    BPMJobExecutorLocal executor = null;
    final JobExecutor jobExecutor;
    final int idleInterval;
    final int maxIdleInterval;
    final long maxLockTime;
    int currentIdleInterval;
    volatile boolean isActive = true;
    static /* synthetic */ Class class$es$caib$bpm$job$JobExecutorThread;

    BPMJobExecutorLocal getExecutor() throws CreateException, NamingException {
        if (this.executor == null) {
            Object o = new InitialContext().lookup("java:local/ejb/BPMJobExecutorBeanLocal");
            BPMJobExecutorLocalHome executorHome = (BPMJobExecutorLocalHome)o;
            this.executor = executorHome.create();
        }
        return this.executor;
    }

    public JobExecutorThread(String name, JobExecutor jobExecutor, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(name);
        this.jobExecutor = jobExecutor;
        this.idleInterval = idleInterval;
        this.maxIdleInterval = maxIdleInterval;
        this.maxLockTime = maxLockTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.currentIdleInterval = this.idleInterval;
        while (this.isActive) {
            try {
                List acquiredJobs = this.getExecutor().getJobs(this.getName());
                if (!acquiredJobs.isEmpty()) {
                    Iterator iter = acquiredJobs.iterator();
                    while (iter.hasNext() && this.isActive) {
                        Long l = (Long)iter.next();
                        log.info((Object)("Executing job " + l));
                        Exception e = this.executor.executeJob(l.longValue());
                        if (e == null) continue;
                        this.executor.anotateFailure(l.longValue(), e);
                    }
                } else {
                    long waitPeriod;
                    log.info((Object)"No job to execute");
                    if (this.isActive && (waitPeriod = this.getWaitPeriod()) > 0L) {
                        JobExecutor jobExecutor = this.jobExecutor;
                        synchronized (jobExecutor) {
                            this.jobExecutor.wait(waitPeriod);
                        }
                    }
                }
                this.currentIdleInterval = this.idleInterval;
            }
            catch (InterruptedException e) {
                log.info((Object)((this.isActive ? "active" : "inactive") + " job executor thread '" + this.getName() + "' got interrupted"));
            }
            catch (Exception e) {
                log.error((Object)("exception in job executor thread. waiting " + this.currentIdleInterval + " milliseconds"), (Throwable)e);
                try {
                    JobExecutor waitPeriod = this.jobExecutor;
                    synchronized (waitPeriod) {
                        this.jobExecutor.wait(this.currentIdleInterval);
                    }
                }
                catch (InterruptedException e2) {
                    log.debug((Object)"delay after exception got interrupted", (Throwable)e2);
                }
                this.currentIdleInterval <<= 1;
                if (this.currentIdleInterval <= this.maxIdleInterval && this.currentIdleInterval >= 0) continue;
                this.currentIdleInterval = this.maxIdleInterval;
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    protected void executeJob(Long id) {
        try {
            log.debug((Object)("executing " + id));
            this.getExecutor().executeJob(id.longValue());
        }
        catch (Exception e) {
            log.info((Object)("exception while executing " + id), (Throwable)e);
            this.executor.anotateFailure(id.longValue(), e);
        }
    }

    private static boolean isPersistenceException(Throwable throwable) {
        do {
            if (!(throwable instanceof HibernateException)) continue;
            return true;
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    protected Date getNextDueDate() throws CreateException, NamingException {
        return this.getExecutor().getNextDueDate(this.getName());
    }

    protected long getWaitPeriod() throws CreateException, NamingException {
        long interval = this.currentIdleInterval;
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTime = System.currentTimeMillis();
            long nextDueTime = nextDueDate.getTime();
            if (nextDueTime < currentTime + (long)this.currentIdleInterval) {
                interval = nextDueTime - currentTime;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

