/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.job;

import es.caib.bpm.beans.home.BPMJobExecutorLocalHome;
import es.caib.bpm.beans.local.BPMJobExecutorLocal;
import java.util.Date;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class LockMonitorThread
extends Thread {
    int lockMonitorInterval;
    int maxLockTime;
    int lockBufferTime;
    boolean isActive = true;
    private static Logger log = Logger.getLogger((Class)(class$es$caib$bpm$job$LockMonitorThread == null ? (class$es$caib$bpm$job$LockMonitorThread = LockMonitorThread.class$("es.caib.bpm.job.LockMonitorThread")) : class$es$caib$bpm$job$LockMonitorThread));
    static /* synthetic */ Class class$es$caib$bpm$job$LockMonitorThread;

    public LockMonitorThread(int lockMonitorInterval, int maxLockTime, int lockBufferTime) {
        this.lockMonitorInterval = lockMonitorInterval;
        this.maxLockTime = maxLockTime;
        this.lockBufferTime = lockBufferTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.isActive) {
                try {
                    this.unlockOverdueJobs();
                    if (!this.isActive || this.lockMonitorInterval <= 0) continue;
                    Thread.sleep(this.lockMonitorInterval);
                }
                catch (InterruptedException e) {
                    log.info((Object)("lock monitor thread '" + this.getName() + "' got interrupted"));
                }
                catch (Exception e) {
                    log.error((Object)("exception in lock monitor thread. waiting " + this.lockMonitorInterval + " milliseconds"), (Throwable)e);
                    try {
                        Thread.sleep(this.lockMonitorInterval);
                    }
                    catch (InterruptedException e2) {
                        log.debug((Object)"delay after exception got interrupted", (Throwable)e2);
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            log.error((Object)"exception in lock monitor thread", (Throwable)e);
            return;
        }
        finally {
            log.info((Object)(this.getName() + " leaves cyberspace"));
        }
    }

    protected void unlockOverdueJobs() throws NamingException, CreateException {
        Object o = new InitialContext().lookup("java:local/ejb/BPMJobExecutorBeanLocal");
        BPMJobExecutorLocalHome executorHome = (BPMJobExecutorLocalHome)o;
        BPMJobExecutorLocal executor = executorHome.create();
        Date threshold = new Date(System.currentTimeMillis() - (long)this.maxLockTime - (long)this.lockBufferTime);
        executor.unlockOverdueJobs(threshold);
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

