package es.caib.bpm.beans;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;

import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanFilter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermsFilter;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Version;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.xpath.DefaultXPath;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ActionLog;
import org.jbpm.graph.log.ProcessInstanceCreateLog;
import org.jbpm.graph.log.ProcessInstanceEndLog;
import org.jbpm.graph.log.TransitionLog;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.identity.hibernate.IdentitySessionFactory;
import org.jbpm.job.Job;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.logging.exe.LoggingInstance;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.xml.sax.SAXException;

import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.business.ProcessDefinitionRolesBusiness;
import es.caib.bpm.business.UserInterfaceBusiness;
import es.caib.bpm.business.VOFactory;
import es.caib.bpm.config.Configuration;
import es.caib.bpm.entity.AuthenticationLog;
import es.caib.bpm.entity.DBProperty;
import es.caib.bpm.entity.ProcessDefinitionProperty;
import es.caib.bpm.entity.UserInterface;
import es.caib.bpm.exception.BPMErrorCodes;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.exception.InvalidConfigurationException;
import es.caib.bpm.exception.InvalidParameterException;
import es.caib.bpm.index.DirectoryFactory;
import es.caib.bpm.index.Indexer;
import es.caib.bpm.util.Timer;
import es.caib.bpm.utils.ColeccionesUtils;
import es.caib.bpm.utils.FechaUtils;
import es.caib.bpm.vo.ProcessLog;
import es.caib.bpm.vo.TaskDefinition;

/**
 * @ejb.bean name="BPMEngine" display-name="Name for BPMEngine"
 *           description="Description for BPMEngine" jndi-name="ejb/BPMEngine"
 *           type="Stateful" view-type="remote"
 */
public class BPMEngineBean implements SessionBean {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private transient SessionContext context = null;
    private transient File tempFile = null;
    private transient FileOutputStream outputStream = null;
    private String userName = null;
    private transient Logger log = null;
    private transient Vector userGroups = null;

	private String messages  [];

    public BPMEngineBean() {
        log = Logger.getLogger(BPMEngineBean.class);
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
        this.outputStream = null;
        this.tempFile = null;
		flushContext();
    }

    private void flushContext()  {
        if (myContext != null) {
            myContext.setActorId(null);
            try {
                myContext.close();
            } finally {
            	myContext = null;
            }
        }
    }

    public void ejbRemove() throws EJBException {
		flushContext();
    }

    /**
     * 
     * @throws CreateException
     */
    
    public void ejbCreate() throws CreateException {

        if (isInternalService())
        {
        	userName = context.getCallerPrincipal().getName();
        }
        else
        {
        	if ("nobody".equals (context.getCallerPrincipal().getName()))
	            //usuario anónimo nobody sin acceso
	        	throw new CreateException("Anonymous access not authorized");
	
	        if (userName == null) {
	            //usuario anónimo,  pero con nombre de usuario
	        	userName = context.getCallerPrincipal().getName();
	        } else if (!userName.equals(context.getCallerPrincipal().getName())) {
	            throw new EJBException("Session Tampering detected");
	        }
        }
    }

    public void setSessionContext(SessionContext context) throws EJBException {
        this.context = context;
    }

    public static final String OBSERVER_ROLE = "observer";
    public static final String SUPERVISOR_ROLE = "supervisor";
    public static final String BPM_EJB_APP = "BPM_EJB";
    public static final String INITIATOR_ROLE = "initiator";

    public es.caib.bpm.vo.TaskInstance addComment(
            es.caib.bpm.vo.TaskInstance task, String comment) {
        JbpmContext jbpmContext = null;
        Session session = null;

        try {
            jbpmContext = getContext();

            
            session = jbpmContext.getSession();

            TaskInstance ti = jbpmContext
                    .getTaskInstanceForUpdate(task.getId());
            Comment c = new Comment(getUserName(), comment);
            ti.addComment(c);
            jbpmContext.save(ti);
            return VOFactory.newTaskInstance(ti);
        } catch (RuntimeException ex) {
            throw ex;
        } finally {
            flushContext();
        }

    }

    JbpmContext myContext;

    public JbpmContext getContext() {
        if (myContext == null) {
            myContext = Configuration.getConfig().createJbpmContext();
            if (!getUserName().equals(context.getCallerPrincipal().getName())) {
                throw new EJBException("Session Tampering detected");
            }
            myContext.setActorId(getUserName());
//            myContext.getServices().getLoggingService();
        }
        return myContext;
    }

    public es.caib.bpm.vo.ProcessInstance cancel(
            es.caib.bpm.vo.ProcessInstance process) {
        JbpmContext context = getContext();
        ;
        try {
        	ProcessInstance instance = context.getProcessInstance(process
                    .getId());
        	startAuthenticationLog(instance.getRootToken());
            instance.end();
            for (Iterator it = instance.getTaskMgmtInstance()
                    .getTaskInstances().iterator(); it.hasNext();) {
                org.jbpm.taskmgmt.exe.TaskInstance taskInstance = (TaskInstance) it
                        .next();

                if (!taskInstance.hasEnded()) {
                    taskInstance.cancel();
                }
            }
            endAuthenticationLog(instance.getRootToken());
            context.save(instance);
            return VOFactory.newProcessInstance(instance);
        } finally {
            flushContext();
        }
    }

    public es.caib.bpm.vo.TaskInstance cancel(es.caib.bpm.vo.TaskInstance task) {
        JbpmContext context = getContext();
        try {
            TaskInstance instance = context.getTaskInstance(task.getId());
            startAuthenticationLog(instance.getToken());
            instance.cancel();
            endAuthenticationLog(instance.getToken());
            context.save(instance);
            return VOFactory.newTaskInstance(instance);
        } finally {
            flushContext();
        }
    }

    public es.caib.bpm.vo.TaskInstance delegateTaskToUser(
            es.caib.bpm.vo.TaskInstance task, String username) {
        JbpmContext context = getContext();
        ;
        try {
            TaskInstance instance = context.getTaskInstance(task.getId());
            startAuthenticationLog(instance.getToken());
            instance.setActorId(username);
            endAuthenticationLog(instance.getToken());
            context.save(instance);
            return VOFactory.newTaskInstance(instance);
        } finally {
            flushContext();
        }
    }

    public es.caib.bpm.vo.TaskInstance executeTask(
            es.caib.bpm.vo.TaskInstance task, String transitionName)
            throws BPMException {
        JbpmContext context = getContext();
        ;
        try {
            TaskInstance instance = doUpdate(context, task);
            startAuthenticationLog(instance.getToken());
            instance.end(transitionName);
            endAuthenticationLog(instance.getToken());
            context.save(instance);
            return VOFactory.newTaskInstance(instance);
        } catch (Exception e) {
            markForRollback();
            throw new BPMException("Error during transition: ", e, -1);
        } finally {
            flushContext();
        }
    }

    private void markForRollback() {
        try {
            context.setRollbackOnly();
        } catch (IllegalStateException e) {
            throw new EJBException(e);
        }
    }
    
    private interface AltresTasques {
    	List findAltresTasques (JbpmContext context, String usuariId, Collection altresIds);
    }
    
    public List findGroupTasks() throws BPMException {
        JbpmContext context = getContext();
        try {
            AltresTasques altresTasques = new AltresTasques() {
				public List findAltresTasques(JbpmContext context, String usuariId,
						Collection altresIds) {
					Vector tasques = new Vector();

		            Query q = context.getSession().createQuery("select distinct ti.id "+
		                    "from org.jbpm.taskmgmt.exe.TaskInstance ti "+
		                      "join ti.pooledActors pooledActor "+
		                    "where pooledActor.actorId in ( :actorIds ) "+
		                      "and ti.actorId is not null "+
		                      "and ti.actorId != :myself "+
		                      "and ti.isSuspended != true "+
		                      "and ti.isCancelled != true "+
		                      "and ti.isOpen = true");
		            q.setParameterList("actorIds", altresIds);
		            q.setParameter("myself", usuariId);
		            for (Iterator i = q.list().iterator(); i.hasNext();) {
		                Long taskInstanceId = (Long) i.next();
		                TaskInstance instance = context.getTaskInstance(taskInstanceId.longValue());
		                try {
		                    if (instance == null)
		                       log.warn("Unable to load task "+taskInstanceId.longValue());
		                    else
		                       tasques.add(VOFactory.newTaskInstance(instance));
		                } catch (RuntimeException e) {
		                    log.warn("Unable to deserialize task "+instance.getId(), e);
		                }
		            }
		            return tasques;
				}
            	
            };
            Vector v = getUserGroups(context);
            if (v.size()<= 1000) 
            	return altresTasques.findAltresTasques(context, getUserName(), v);
            else {
            	Vector tasks = new Vector();
            	// Recuperem les tasques dels primers 1000 grups [0,1000[ = [0,999]
            	tasks.addAll(altresTasques.findAltresTasques(context, getUserName(), v.subList(0, 1000)));            	
				
				// Definim els rangos per afegir les tasques 
				ArrayList posicions = new ArrayList ();
				int posFin = 1000;
				
				while (posFin < v.size()) {
					posicions.add(new Integer(posFin));
					if (posFin + 1000 < v.size())
						posFin += 1000;
					else { 
						posFin = v.size();
						posicions.add(new Integer(posFin));
					}
				}
				for (int i=0; i < posicions.size()-1; i++) {
					List tasques = altresTasques
							.findAltresTasques(context, getUserName(), v
									.subList(((Integer) posicions.get(i)).intValue(), 
											((Integer) posicions.get(i + 1)).intValue()));
						
					// Afegim les tasques obtingudes en el rango actual
					tasks.addAll(tasques);					
				}	            	
            	
            	return tasks;
            }
            
        } finally {
            flushContext();
        }
    }

    /**
     * Recupera los roles del usuario.
     * Si el nombre del usuario es "anonymous", se le asigna el grupo "anonymous"
     * Si el usuario es anónimo (no hace login), pero el nombre de usuario no es "anonymous" se trata como un usuario del sistema.
     * Esto es útil para llamadas entre ejb's sin login que hacen un run-as
     * 
     * @param context
     * @return
     * @throws BPMException
     */
    private Vector getUserGroups(JbpmContext context) throws BPMException {
/**/   	Timer t1=new Timer();
    	
    	//cache
    	if (userGroups != null && userGroups.size()!=0)
            return userGroups;
        else
        	userGroups=new Vector();
        
    	

        userGroups.add(getUserName());

        
        IdentitySession session=new IdentitySession(getContext().getSession());


        User user = session.getUserByName(userName);
        
        if((user==null && userName!=null) || isInternalService()){
        	userGroups.add("anonymous"); //PJR afegim el rol anonymous al usuari anonymous	
        }else{
        	if (user == null) {
        
        		throw new BPMException("Usuari amb codi '" + userName
                    + "' no trobat al sistema JBPM.", null, 0);
        	}
	        for (Iterator it = user.getMemberships().iterator(); it.hasNext();) {
	            Membership member = (Membership) it.next();
	            Group group = member.getGroup();
	            if (member.getRole() == null) {
	                userGroups.add(group.getName());
	            } else {
	                addGroupRecursive(userGroups, group, member.getRole());
	            }
	        }
        }
        t1.logTime("BPM-BEAN.getUserGroups",Integer.parseInt(System.getProperty("es.caib.ibkey.timer.databaseTask.milis","1000")));
        return userGroups;
    }

    private String getUserName() {
        return userName;
    }

    private void addGroupRecursive(Vector v, Group group, String role) {
        v.add(group.getName() + "/" + role);
        for (Iterator it = group.getChildren().iterator(); it.hasNext();) {
            Group child = (Group) it.next();
            addGroupRecursive(v, child, role);
        }
    }

    public List findInitiatorProcessDefinitions() throws BPMException {
        return findProcessDefinitionByRole("initiator", true);
    }

    public List findProcessDefinitionByRole(String role, boolean onlyEnabled) throws BPMException {
        JbpmContext context = getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            Vector resultadoFinal = new Vector();
            for (Iterator it = context.getGraphSession()
                    .findLatestProcessDefinitions().iterator(); it.hasNext();) {
                ProcessDefinition definition = (ProcessDefinition) it.next();

                if (business.isUserAuthorized(role, getUserGroups(context),
                        definition)) {
                	es.caib.bpm.vo.ProcessDefinition def =VOFactory.newProcessDefinition(
                            definition, context);
                	if ( def.isEnabled() || ! onlyEnabled)
                		resultadoFinal.add(def);
                }
            }
            return resultadoFinal;
        } finally {
            flushContext();
        }
    }

    public List findMyProcesses() {
        JbpmContext context = getContext();
        try {
            Vector resultadoFinal = new Vector();

            Session session = context.getSession();
            Query query = session.createQuery("select pi "
                    + "from org.jbpm.graph.exe.ProcessInstance as pi "
                    + "where pi.end is null " + "order by pi.start desc");
            for (Iterator it = query.iterate(); it.hasNext();) {
                ProcessInstance instance = (ProcessInstance) it.next();
                List logs = instance.getLoggingInstance().getLogs(
                        ProcessInstanceCreateLog.class);
                if (logs.size() > 0) {
                    ProcessInstanceCreateLog log = (ProcessInstanceCreateLog) logs
                            .get(0);
                    if (getUserName().equals(log.getActorId())) {
                        resultadoFinal.add(VOFactory
                                .newProcessInstance(instance));
                    }
                }
            }
            return resultadoFinal;
        } finally {
            flushContext();
        }
    }

    public List findNewTasks() throws BPMException {
        JbpmContext context = getContext();
        try {
            Vector resultadoFinal = new Vector();
            List tasks = context.getTaskMgmtSession().findPooledTaskInstances(
                    getUserGroups(context));
            for (Iterator it = tasks.iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                if (instance.getStart() == null && instance.isOpen()
                        && !instance.isCancelled())
                    try {
                        resultadoFinal.add(VOFactory.newTaskInstance(instance));
                    } catch (RuntimeException e) {
                        log.warn("Unable to desearilize task "+instance.getId(), e);
                    }
            }
            tasks = context.getTaskMgmtSession().findTaskInstances(
                    getUserName());
            for (Iterator it = tasks.iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                if (instance.getStart() == null && instance.isOpen()
                        && !instance.isCancelled())
                    try {
                        resultadoFinal.add(VOFactory.newTaskInstance(instance));
                    } catch (RuntimeException e) {
                        log.warn("Unable to desearilize task "+instance.getId(), e);
                    }
            }
            return resultadoFinal;
        } finally {
            flushContext();
        }
    }

    public List findObserverProcessDefinitions() throws BPMException {
        return findProcessDefinitionByRole(OBSERVER_ROLE, true);
    }

    public List findOpenTasks() throws BPMException {
        JbpmContext context = getContext();
        try {
            Vector resultadoFinal = new Vector();
            List tasks = context.getTaskMgmtSession().findPooledTaskInstances(
                    getUserGroups(context));
            for (Iterator it = tasks.iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                if (instance.getStart() != null && instance.isOpen()
                        && !instance.isCancelled()) {
                    try {
                        resultadoFinal.add(VOFactory.newTaskInstance(instance));
                    } catch (RuntimeException e) {
                        log.warn("Unable to serialize task " + instance.getId(),
                                e);
                    }

                }
            }
            tasks = context.getTaskMgmtSession().findTaskInstances(
                    getUserName());
            for (Iterator it = tasks.iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                if (instance.getStart() != null && instance.isOpen()
                        && !instance.isCancelled())
                    try {
                        resultadoFinal.add(VOFactory.newTaskInstance(instance));
                    } catch (RuntimeException e) {
                        log.warn("Unable to serialize task " + instance.getId(),
                                e);
                    }

            }
            return resultadoFinal;
        } finally {
            flushContext();
        }
    }

    public List findMyTasks() throws BPMException {
        JbpmContext context = getContext();
        try {
            Vector resultadoFinal = new Vector();
            // u88683: solucionem problema de oracle quan n'hi ha més de 1000 elements
            // és una restricció ORA-01795: maximum number of expressions in a list is 1000
            List tasks = null;
            List userGroups = getUserGroups(context); //mai null
			if (userGroups.size() <= 1000) {//Permés fins a 1000
				tasks = context.getTaskMgmtSession().findPooledTaskInstances(
						getUserGroups(context));
			} else {
				// Recuperem les tasques dels primers 1000 grups [0,1000[ = [0,999]
				tasks = context.getTaskMgmtSession().findPooledTaskInstances(userGroups.subList(0, 1000));
				
				if (tasks.isEmpty()) {// o tasks.equals(Collections.EMPTY_LIST) o tasks.equals(Collections.emptyList()) 
					// Arreglem problema de emptylist que ens pot tornar el findPooledTaskInstances
					// quan no té cap tasca per als actorid dels primers 1000 grups
					// i que després falla al addAll() sobre una llista buida inmutable
					tasks = new ArrayList(); //u88683 - 04/03/2011
				}
				
				// Definim els rangos per afegir les tasques 
				ArrayList posicions = new ArrayList ();
				int posFin = 1000;
				
				while (posFin < userGroups.size()) {
					posicions.add(new Integer(posFin));
					if (posFin + 1000 < userGroups.size())
						posFin += 1000;
					else { 
						posFin = userGroups.size();
						posicions.add(new Integer(posFin));
					}
				}
				for (int i=0; i < posicions.size()-1; i++) {
					List tasques = context.getTaskMgmtSession()
							.findPooledTaskInstances(
									userGroups.subList(((Integer)posicions.get(i)).intValue(),
											((Integer)posicions.get(i + 1)).intValue()));
					// Afegim les tasques obtingudes en el rango actual
					tasks.addAll(tasques);					
				}								
				
			}

            for (Iterator it = tasks.iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                if (instance.isOpen() && !instance.isCancelled()) {
                    try {
                        resultadoFinal.add(VOFactory.newTaskInstance(instance));
                    } catch (RuntimeException e) {
                        log.warn("Unable to serialize task " + instance.getId(),
                                e);
                    }

                }
            }

            tasks = context.getTaskMgmtSession().findTaskInstances(
                    getUserName());
            
            for (Iterator it = tasks.iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                if (instance.isOpen() && !instance.isCancelled())
                    try {
                        resultadoFinal.add(VOFactory.newTaskInstance(instance));
                    } catch (RuntimeException e) {
                        log.warn("Unable to serialize task " + instance.getId(),
                                e);
                    }

            }

            return resultadoFinal;
        } finally {
            flushContext();
        }
    }
    public List findMyTasksLightweight() throws BPMException {
        JbpmContext context = getContext();
        Timer t2=new Timer();
/**/    Timer t1=new Timer(new Timer[]{t2});
        try {
            Vector resultadoFinal = new Vector();
            // u88683: solucionem problema de oracle quan n'hi ha més de 1000 elements
            // és una restricció ORA-01795: maximum number of expressions in a list is 1000
            List tasks = null;
            List userGroups = getUserGroups(context); //mai null


/**/		t1.reset();            
			if (userGroups.size() <= 1000) {//Permés fins a 1000
				tasks = context.getTaskMgmtSession().findPooledTaskInstances(
						getUserGroups(context));
			} else {
				// Recuperem les tasques dels primers 1000 grups [0,1000[ = [0,999]
				tasks = context.getTaskMgmtSession().findPooledTaskInstances(userGroups.subList(0, 1000));
				
				if (tasks.isEmpty()) {// o tasks.equals(Collections.EMPTY_LIST) o tasks.equals(Collections.emptyList()) 
					// Arreglem problema de emptylist que ens pot tornar el findPooledTaskInstances
					// quan no té cap tasca per als actorid dels primers 1000 grups
					// i que després falla al addAll() sobre una llista buida inmutable
					tasks = new ArrayList(); //u88683 - 04/03/2011
				}
				
				// Definim els rangos per afegir les tasques 
				ArrayList posicions = new ArrayList ();
				int posFin = 1000;
				
				while (posFin < userGroups.size()) {
					posicions.add(new Integer(posFin));
					if (posFin + 1000 < userGroups.size())
						posFin += 1000;
					else { 
						posFin = userGroups.size();
						posicions.add(new Integer(posFin));
					}
				}
				for (int i=0; i < posicions.size()-1; i++) {
					List tasques = context.getTaskMgmtSession()
							.findPooledTaskInstances(
									userGroups.subList(((Integer)posicions.get(i)).intValue(),
											((Integer)posicions.get(i + 1)).intValue()));
					// Afegim les tasques obtingudes en el rango actual
					tasks.addAll(tasques);					
				}								
				
			}
/**/		t1.logTime("findMyTasksLightweight.findPooledTaskInstances",Integer.parseInt(System.getProperty("es.caib.ibkey.timer.databaseTask.milis","1000")));

            for (Iterator it = tasks.iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                if (instance.isOpen() && !instance.isCancelled()) {
                    try {
                        resultadoFinal.add(VOFactory.newLightweightTaskInstance(instance));
                    } catch (RuntimeException e) {
                        log.warn("Unable to serialize task " + instance.getId(),
                                e);
                    }

                }
            }
/**/        t1.reset();
            tasks = context.getTaskMgmtSession().findTaskInstances(
                    getUserName());
/**/        t1.logTime("findMyTasksLightweight.findTaskInstances",Integer.parseInt(System.getProperty("es.caib.ibkey.timer.databaseTask.milis","1000")));
            
            for (Iterator it = tasks.iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                if (instance.isOpen() && !instance.isCancelled())
                    try {
                        resultadoFinal.add(VOFactory.newLightweightTaskInstance(instance));
                    } catch (RuntimeException e) {
                        log.warn("Unable to serialize task " + instance.getId(),
                                e);
                    }

            }
            return resultadoFinal;
        } finally {
/**/        t1.reset();
            flushContext();
/**/        t1.logTime("findMyTasksLightweight.flushContext",Integer.parseInt(System.getProperty("es.caib.ibkey.timer.databaseTask.milis","1000")));
        }
    }

    public List findProcessDefinitions(String name, boolean onlyLastVersions) {
        JbpmContext context = getContext();
        try {

            Vector resultadoFinal = new Vector();

            List definitions;
            if (name == null && onlyLastVersions)
                definitions = context.getGraphSession()
                        .findLatestProcessDefinitions();
            else if (name == null && !onlyLastVersions)
                definitions = context.getGraphSession()
                        .findAllProcessDefinitions();
            else if (onlyLastVersions) {
                definitions = new Vector();
                ProcessDefinition def = context.getGraphSession()
                        .findLatestProcessDefinition(name);
                if (def != null)
                    definitions.add(def);
            } else
                definitions = context.getGraphSession()
                        .findAllProcessDefinitionVersions(name);

            for (Iterator it = definitions.iterator(); it.hasNext();) {
                ProcessDefinition def = (ProcessDefinition) it.next();
                resultadoFinal
                        .add(VOFactory.newProcessDefinition(def, context));
            }
            return resultadoFinal;
            //FIXME no es recullen ni infora les excepcions
        } finally {
            flushContext();
        }
    }

    public List findProcessInstances(List definitions, String processId,
            String estado, String actor, Date startDate, boolean finalizada)
            throws BPMException {
        JbpmContext context = getContext();
        try {

            Query query = context.getSession().getNamedQuery(
                    "searchProcessInstance");

            if (definitions != null) {
                try {
                    query.setParameterList("id", ColeccionesUtils
                            .getValorCampoElemento(definitions, "getId"));
                } catch (Exception ex) {
                    throw new InvalidParameterException(
                            BPMErrorCodes.PARAMETRO_INVALIDO);
                }
            }

            if (!processId.trim().equals("")) {
                query.setParameter("processId", new Long(processId));
            } else {
                query.setParameter("processId", new Long(-1));
            }

            query.setParameter("estado", estado);

            if (finalizada) {
                query.setParameter("finalizada", "FINALIZADA");
            } else {
                query.setParameter("finalizada", null);
            }

            try {
                if (startDate != null) {
                    query.setParameter("fechaDesde", FechaUtils
                            .establecerFechaInicioDia(startDate));
                    query.setParameter("fechaHasta", FechaUtils
                            .establecerFechaFinDia(startDate));
                } else {
                    Calendar calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);

                    query.setParameter("fechaDesde", new Date(0L));
                    query.setParameter("fechaHasta", calendar.getTime());
                }
            } catch (Exception ex) {
                throw new InvalidParameterException(
                        BPMErrorCodes.PARAMETRO_INVALIDO);
            }

            ArrayList resultado = new ArrayList();

            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);

            for (Iterator it = query.iterate(); it.hasNext();) {
                 ProcessInstance p = (ProcessInstance) it.next();
    
                 try {
                    if (business.isUserAuthorized(OBSERVER_ROLE,
                            getUserGroups(context), p.getProcessDefinition())
                            || business.isUserAuthorized(SUPERVISOR_ROLE,
                                    getUserGroups(context), p
                                            .getProcessDefinition()))
                        resultado.add(VOFactory.newProcessInstance(p));
                } catch (JbpmException e) {
                    log.warn(e);
                }
                
            }

            return resultado;
        } finally {
            flushContext();
        }
    }

    public List searchProcessInstances(String query, String startDate, String endDate, boolean finished)
            throws BPMException {
        JbpmContext context = getContext();
        ArrayList resultado = new ArrayList();
        try {
        	IndexSearcher is = new IndexSearcher(DirectoryFactory.getDirectory(context.getSession()));
        	QueryParser qp = new QueryParser (Version.LUCENE_30, "$contents", DirectoryFactory.getAnalyzer());
        	org.apache.lucene.search.Query q = qp.parse(query);
        	// Verifiquem el format de les dates
        	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        	String dataInici=null, dataFi=null;
        	if (startDate !=null && !"".equals(startDate)) {
        		dataInici = startDate;
        	} else {
        		Calendar dataIniciWF = Calendar.getInstance();
        		dataIniciWF.set(2005, 1,1); //data d'inici 1 de gener de 2005
        		dataInici = sdf.format(dataIniciWF.getTime());
        	}
        	if (endDate !=null && !"".equals(endDate)) {
        		dataFi = endDate;
        	} else {
	        	// 	Posem com a limit superior demà: //TODO: revisar, si posen dataIni > hui
        		if (dataInici!=null) {
        			try {
        				Date d_dataInici = sdf.parse(dataInici);
        				Calendar dema = Calendar.getInstance();
        				dema.set(Calendar.HOUR_OF_DAY, 0);
        				dema.set(Calendar.MINUTE, 0);
        				dema.set(Calendar.SECOND, 0);
        				dema.set(Calendar.MILLISECOND,0);
        				dema.add(Calendar.DATE, 1);
        				if (d_dataInici.getTime() >= dema.getTimeInMillis()) {
        					throw new BPMException ("Error: No es permet que la Data d'Inici siga posterior a hui",-1);
        				}
        			} 
        			catch (java.text.ParseException ex) {
        				
        			}
        		}
        		Calendar dema = Calendar.getInstance();
        		dema.add(Calendar.DATE, 2); //afegim 2 dies
        		dataFi = sdf.format(dema.getTime());
        	}
        		
        	TopDocs hits;
        	BooleanFilter b = new BooleanFilter(); 
        	boolean complexQuery = false;
    		if (startDate!=null && !"".equals(startDate)) {
    			TermRangeFilter fstart = new TermRangeFilter("$startDate",dataInici,dataFi,true,true); //inclusiu
    			b.add(new FilterClause(fstart,BooleanClause.Occur.MUST));
    			complexQuery = true;
    		}
    		if (endDate!=null && !"".equals(endDate)) {
    			TermRangeFilter fend = new TermRangeFilter("$endDate",dataInici,dataFi,true,true); //inclusiu
    			b.add(new FilterClause(fend,BooleanClause.Occur.MUST));
    			complexQuery = true;
    		}
    		
        	if (!finished) { 
        		TermsFilter f = new TermsFilter ();
        		f.addTerm(new Term ("$end", "false"));
        		b.add(new FilterClause(f, BooleanClause.Occur.MUST));
        		complexQuery = true;
    			if (complexQuery)
    				hits = is.search(q, b, 1000);
    			else
    				hits = is.search(q, f, 1000); // Sense filtre de dates
        		
        	} else {
        		if (complexQuery)
    				hits = is.search(q, b, 1000);
        		else 
        			hits = is.search(q, 1000); // Sense cap filtre
        	}
        	
        	for(int i = 0; i < hits.totalHits; i++){
        		int id = hits.scoreDocs[i].doc;
        		org.apache.lucene.document.Document d = is.getIndexReader().document(id);
        		Field f = d.getField("$id");
        		if ( f != null)
        		{
        			long processId = Long.parseLong(f.stringValue());
        			try {
                			es.caib.bpm.vo.ProcessInstance proc = getProcess(processId);
                			if (proc != null)
                			{
                				resultado.add(proc);
                			}
        			} catch (SecurityException e) {
        			    // Ignorar
        			}
        		}
            }
        	is.close();
            return resultado;
        } catch (CorruptIndexException e) {
			throw new BPMException ("Error intern. Índex corrupte", e, -1);
		} catch (IOException e) {
			throw new BPMException ("Error intern. Índex corrupte", e, -1);
		} catch (ParseException e) {
			throw new BPMException ("Error al paràmetre de cerca: "+e.getMessage(), -1);
		} catch (ArrayIndexOutOfBoundsException e) { //Problema quan obtenim més de maximRes resultats (IndexSearcher. search(xxxx,maximRes))
			throw new BPMException ("Massa registres trobats: és necessari donar un filtre més restrictiu.", -1);
		} catch (Exception e) {
			throw new BPMException ("Error: "+e.getMessage(),-1); //Enmascarem d'altres excepcions
		} finally {
            flushContext();
        }
    }

    public List findProcessInstances(es.caib.bpm.vo.ProcessDefinition def)
            throws BPMException {
        JbpmContext context = getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            Vector resultadoFinal = new Vector();
            ProcessDefinition definition = context.getGraphSession()
                    .getProcessDefinition(def.getId());

            if (business.isUserAuthorized(OBSERVER_ROLE,
                    getUserGroups(context), definition)
                    || business.isUserAuthorized(SUPERVISOR_ROLE,
                            getUserGroups(context), definition)) {
                {
                    for (Iterator it = context.getGraphSession()
                            .findProcessInstances(definition.getId())
                            .iterator(); it.hasNext();) {
                        ProcessInstance instance = (ProcessInstance) it.next();
                        try {
                            resultadoFinal.add(VOFactory
                                .newProcessInstance(instance));
                        } catch (JbpmException e )
                        {
                            log.warn (e);
                        }
                    }
                }
            }
            return resultadoFinal;
        } finally {
            flushContext();
        }
    }

    public List findSupervisorProcessDefinitions() throws BPMException {
        return findProcessDefinitionByRole(SUPERVISOR_ROLE, false);
    }

    public List findTaskDefinitions(es.caib.bpm.vo.ProcessDefinition def)
            throws BPMException {
        JbpmContext context = getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            Vector resultadoFinal = new Vector();
            ProcessDefinition definition = context.getGraphSession()
                    .getProcessDefinition(def.getId());

            if (business.isUserAuthorized(OBSERVER_ROLE,
                    getUserGroups(context), definition)
                    || business.isUserAuthorized(SUPERVISOR_ROLE,
                            getUserGroups(context), definition)) {
                {
                    for (Iterator it = definition.getNodes().iterator(); it
                            .hasNext();) {
                        Node n = (Node) it.next();
                        if (n instanceof TaskNode) {
                            TaskNode tn = (TaskNode) n;
                            for (Iterator it2 = tn.getTasks().iterator(); it2
                                    .hasNext();) {
                                Task task = (Task) it2.next();

                                resultadoFinal.add(VOFactory
                                        .newTaskDefinition(task));
                            }
                        }
                    }
                }
            }
            return resultadoFinal;
        } finally {
            flushContext();
        }
    }

    public List findTasks(List def, TaskDefinition task, String actor,
            Date processStartDate, Date taskCreationDate, boolean finalizada)
            throws BPMException {
        JbpmContext context = getContext();
        List resultado = new Vector();
        Query query = null;
        List searchObjects = null;
        GregorianCalendar calendar = null;

        try {
            query = context.getSession().getNamedQuery("searchTasksInstance");

            if (def != null) {
                try {
                    query.setParameterList("processId", ColeccionesUtils
                            .getValorCampoElemento(def, "getId"));
                } catch (Exception e) {
                    throw new InvalidParameterException(
                            BPMErrorCodes.PARAMETRO_INVALIDO);
                }
            }

            query.setParameter("processInstanceId", new Long(-1));

            if (task != null) {
                query.setParameter("taskId", new Long(task.getId()));
            } else {
                query.setParameter("taskId", new Long(-1));
            }

            if (finalizada) {
                query.setParameter("finalizada", "FINALIZADA");
            } else {
                query.setParameter("finalizada", null);
            }

            query.setParameter("actor", actor);

            try {
                if (processStartDate != null) {
                    query.setParameter("fechaDesdeProceso", FechaUtils
                            .establecerFechaInicioDia(processStartDate));
                    query.setParameter("fechaHastaProceso", FechaUtils
                            .establecerFechaFinDia(processStartDate));
                } else {
                    calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);

                    query.setParameter("fechaDesdeProceso", new Date(0L));
                    query.setParameter("fechaHastaProceso", calendar.getTime());
                }

                if (taskCreationDate != null) {
                    query.setParameter("fechaDesde", FechaUtils
                            .establecerFechaInicioDia(taskCreationDate));
                    query.setParameter("fechaHasta", FechaUtils
                            .establecerFechaFinDia(taskCreationDate));
                } else {
                    calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);

                    query.setParameter("fechaDesde", new Date(0L));
                    query.setParameter("fechaHasta", calendar.getTime());
                }
            } catch (Exception ex) {
                throw new InvalidParameterException(
                        BPMErrorCodes.PARAMETRO_INVALIDO);
            }

            resultado = new Vector();

            for (Iterator it = query.list().iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                try {
                    resultado.add(VOFactory.newTaskInstance(instance));
                } catch (RuntimeException e)
                {
                    log.warn ("Unable to serialize task "+instance.getId(), e);
                }
            }
        } finally {
            flushContext();
        }

        return resultado;
    }

    public List findTasks(List def, String processId, TaskDefinition task,
            String actor, Date processStartDate, Date taskCreationDate,
            boolean finalizada) throws BPMException {
        JbpmContext context = getContext();
        List resultado = new Vector();
        Query query = null;
        List searchObjects = null;
        GregorianCalendar calendar = null;

        try {
            query = context.getSession().getNamedQuery("searchTasksInstance");

            if (def != null) {
                try {
                    query.setParameterList("processId", ColeccionesUtils
                            .getValorCampoElemento(def, "getId"));
                } catch (Exception e) {
                    throw new InvalidParameterException(
                            BPMErrorCodes.PARAMETRO_INVALIDO);
                }
            } else {
                def.add(new Integer(-1));
                query.setParameter("processId", def);
            }

            if (!processId.trim().equals("")) {
                query.setParameter("processInstanceId", new Long(processId));
            } else {
                query.setParameter("processInstanceId", new Long(-1));
            }

            if (task != null) {
                query.setParameter("taskId", new Long(task.getId()));
            } else {
                query.setParameter("taskId", new Long(-1));
            }

            if (finalizada) {
                query.setParameter("finalizada", "FINALIZADA");
            } else {
                query.setParameter("finalizada", null);
            }

            query.setParameter("actor", actor);

            try {
                if (processStartDate != null) {
                    query.setParameter("fechaDesdeProceso", FechaUtils
                            .establecerFechaInicioDia(processStartDate));
                    query.setParameter("fechaHastaProceso", FechaUtils
                            .establecerFechaFinDia(processStartDate));
                } else {
                    calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);

                    query.setParameter("fechaDesdeProceso", new Date(0L));
                    query.setParameter("fechaHastaProceso", calendar.getTime());
                }

                if (taskCreationDate != null) {
                    query.setParameter("fechaDesde", FechaUtils
                            .establecerFechaInicioDia(taskCreationDate));
                    query.setParameter("fechaHasta", FechaUtils
                            .establecerFechaFinDia(taskCreationDate));
                } else {
                    calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);

                    query.setParameter("fechaDesde", new Date(0L));
                    query.setParameter("fechaHasta", calendar.getTime());
                }
            } catch (Exception ex) {
                throw new InvalidParameterException(
                        BPMErrorCodes.PARAMETRO_INVALIDO);
            }

            resultado = new Vector();

            for (Iterator it = query.list().iterator(); it.hasNext();) {
                TaskInstance instance = (TaskInstance) it.next();
                try {
                    resultado.add(VOFactory.newTaskInstance(instance));
                } catch (RuntimeException e) {
                    log.warn(e);
                }
            }
        } finally {
            flushContext();
        }

        return resultado;
    }

    public es.caib.bpm.vo.ProcessDefinition getDefinition(
            es.caib.bpm.vo.ProcessInstance process) {
        JbpmContext context = getContext();
        try {
            ProcessInstance instance = context.getProcessInstance(process
                    .getId());
            return VOFactory.newProcessDefinition(instance
                    .getProcessDefinition(), context);
        } finally {
            flushContext();
        }
    }

    public TaskDefinition getDefinition(es.caib.bpm.vo.TaskInstance task) {
        JbpmContext context = getContext();
        try {
            TaskInstance instance = context.loadTaskInstance(task.getId());
            return VOFactory.newTaskDefinition(instance.getTask());
        } finally {
            flushContext();
        }
    }

    public es.caib.bpm.vo.ProcessInstance getProcessInstance(
            es.caib.bpm.vo.TaskInstance task) {
        JbpmContext context = getContext();
        try {
            TaskInstance instance = context.loadTaskInstance(task.getId());
            return VOFactory.newProcessInstance(instance.getToken()
                    .getProcessInstance());
        } finally {
            flushContext();
        }
    }

	public es.caib.bpm.vo.ProcessInstance newProcess(
            es.caib.bpm.vo.ProcessDefinition def) throws BPMException {
        return newProcess (def, true);
    }

    public es.caib.bpm.vo.ProcessInstance newProcess(
            es.caib.bpm.vo.ProcessDefinition def, boolean start) throws BPMException {
        JbpmContext context = getContext();
        try {
        	
            ProcessDefinition definition = context.getGraphSession()
                    .findLatestProcessDefinition(def.getName());
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            if (! isInternalService() && 
                    ! business.isUserAuthorized(INITIATOR_ROLE,
                    getUserGroups(context), definition))
                throw new SecurityException("No autoritzat a crear el procés");
            
            ProcessDefinitionProperty prop = getProcessDefinitionDisabledProperty(context, definition);
            if (prop != null &&
            		"true".equals(prop.getValue()))
            	throw new BPMException("This process has been disabled", 2);

            ProcessInstance pi = new ProcessInstance(definition);
            if (start) 
            {
            	startAuthenticationLog(pi.getRootToken());
            	pi.signal();
            	endAuthenticationLog(pi.getRootToken());
            	context.save(pi);
            }
            return VOFactory.newProcessInstance(pi);
        } catch (Exception e) {
            markForRollback();
            if (e instanceof BPMException)
            	throw (BPMException) e;
            else
            	throw new BPMException("No pot crear el procés", e, -1);
        } finally {
            flushContext();
        }
    }

    public void update(es.caib.bpm.vo.ProcessInstance process) throws BPMException {
        JbpmContext context = getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);

            ProcessInstance pi = context.loadProcessInstance(process.getId());
            if (! isInternalService() && 
                pi.getRootToken().getNode().getId() !=
            	pi.getProcessDefinition().getStartState().getId())
            {
                throw new BPMException("No es pot modificar un procés ja iniciat",-1);
            }
            if ( isInternalService() || 
                    business.isUserAuthorized(INITIATOR_ROLE,
                    getUserGroups(context), pi.getProcessDefinition()))
            {
                ContextInstance ctx = pi.getContextInstance();
                HashMap map = new HashMap();
                
            	startAuthenticationLog(pi.getRootToken());
                if(process.getVariables()!=null)
                	map.putAll(process.getVariables());
                
                if(ctx.getVariables()!=null){
	                // Borrar y modificar variables
	                for (Iterator it = ctx.getVariables().keySet().iterator(); it
	                        .hasNext();) {
	                    String key = (String) it.next();
	                    Object value = map.get(key); //PJR canvio value=map.get(key) : això no feia un update!
	                    ctx.setVariable(key, value);
	                    map.remove(key);
	                }
                }
	            
                // Agregar variables
                for (Iterator it = map.keySet().iterator(); it.hasNext();) {
                    String key = (String) it.next();
                    Object value = map.get(key);
                    ctx.setVariable(key, value);
                }
            	endAuthenticationLog(pi.getRootToken());
            	context.save(pi);
            } else {
                throw new SecurityException("Not authorized");
            }
        } finally {
            flushContext();
        }

    }

    public void startProcess(es.caib.bpm.vo.ProcessInstance process) throws BPMException {
        JbpmContext context = getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);

            ProcessInstance pi = context.loadProcessInstance(process.getId());
            if (pi.getRootToken().getNode().getId() !=
            	pi.getProcessDefinition().getStartState().getId())
            {
                throw new BPMException("No es pot modificar un procés ja iniciat",-1);
            }
            if ( ! isInternalService() || 
                    business.isUserAuthorized(INITIATOR_ROLE,
                    getUserGroups(context), pi.getProcessDefinition()))
            {
            	startAuthenticationLog(pi.getRootToken());
                pi.signal();
            	endAuthenticationLog(pi.getRootToken());
            	context.save(pi);
            } else {
                throw new SecurityException("Not authorized");
            }
        } finally {
            flushContext();
        }

    }
    
    public es.caib.bpm.vo.TaskInstance reserveTask(
            es.caib.bpm.vo.TaskInstance task) throws BPMException {
        JbpmContext context = getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);

            TaskInstance ti = context.loadTaskInstance(task.getId());
        	startAuthenticationLog(ti.getToken());
            if (business.canAccess(getUserGroups(context), ti)) {
                ti.setActorId(getUserName());
            } else {
                throw new SecurityException("Not authorized");
            }
        	endAuthenticationLog(ti.getToken());
            context.save(ti);
            return VOFactory.newTaskInstance(ti);
        } finally {
            flushContext();
        }
    }

    public int[] getCoordinates(es.caib.bpm.vo.TaskInstance task)
            throws DocumentException {
        Node node = null;
        JbpmContext context = getContext();
        try {
            TaskInstance instance = context.getTaskInstance(task.getId());
            node = instance.getTask().getTaskNode();

            return getCoordinates(node);
        } catch (RuntimeException ex) {
            throw ex;
        } finally {
            flushContext();
        }
    }

	public int[] getCoordinates(es.caib.bpm.vo.ProcessInstance processVO)
			throws DocumentException {
		Node node = null;
		JbpmContext context = getContext();
		try {
			ProcessInstance pi = context.getProcessInstance(processVO.getId());
			node = pi.getRootToken().getNode();
			return getCoordinates(node);
		} catch (RuntimeException ex) {
			throw ex;
		} finally {
			flushContext();
		}
	}

	private int [] getCoordinates(Node node)
			throws DocumentException {
		ProcessDefinition definition;
		String nodeName;
		XPath xPath;
		byte[] resultado;
		int result[] = new int[4];
		if (node != null)
		{
			definition = node.getProcessDefinition();
	
			resultado = definition.getFileDefinition().getBytes("gpd.xml");
	
			nodeName = node.getName();
	
			// Hacer el PARSE XML del documento
			org.dom4j.io.SAXReader reader = new org.dom4j.io.SAXReader();
			Document doc = reader.read(new ByteArrayInputStream(resultado));
	
			xPath = new DefaultXPath("//node[@name='" + nodeName.replaceAll("'", "&apos;") + "']");
			Element domNode = (Element) xPath.selectSingleNode(doc);
	
			if (domNode == null)
			{
			    result[0] = result[1] = result[2] = result[3] = 0;;
			} else {
			    result[0] = Integer.valueOf(domNode.attribute("x").getValue())
			            .intValue();
			    result[1] = Integer.valueOf(domNode.attribute("y").getValue())
			            .intValue();
			    result[2] = Integer.valueOf(domNode.attribute("width").getValue())
			            .intValue();
			    result[3] = Integer.valueOf(domNode.attribute("height").getValue())
			            .intValue();
			}
		}
		return result;
	}

    public es.caib.bpm.vo.ProcessDefinition getProcessDefinition(
            es.caib.bpm.vo.ProcessInstance process) {
        JbpmContext context = getContext();
        try {
            ProcessInstance instance = context.loadProcessInstance(process
                    .getId());
            ProcessDefinition definition = instance.getProcessDefinition();
            return VOFactory.newProcessDefinition(definition, context);
        } finally {
            flushContext();
        }
    }

    public byte[] getProcessDefinitionImage(es.caib.bpm.vo.ProcessDefinition def) {
        JbpmContext context = getContext();

        byte[] resultado = null;

        try {
            ProcessDefinition definition = context.getGraphSession()
                    .getProcessDefinition(def.getId());

            return definition.getFileDefinition().getBytes("processimage.jpg");

        } catch (RuntimeException ex) {
            throw ex;
        } finally {
            flushContext();
        }
    }

    public String getUI(es.caib.bpm.vo.ProcessInstance procVO) {
        JbpmContext context = getContext();

        try {
        	ProcessInstance pi = context.getProcessInstance(procVO.getId());
            ProcessDefinition pd = pi.getProcessDefinition();
            FileDefinition fd = pd.getFileDefinition();

            try {
	            byte b[] = fd.getBytes("ui/default.zul");
	            if (b != null)
	            {
	            	try {
	            		return  new String(b, "UTF-8");
	                } catch (UnsupportedEncodingException e) {
	                    throw new RuntimeException(e);
	                }
	            }
            } catch (JbpmException e) {
            	// Page does not exist
            }
            return null;
        } finally {
            flushContext();
        }
    }

    public String getUI(es.caib.bpm.vo.TaskInstance task) {
        JbpmContext context = getContext();

        try {
            TaskInstance instance = context.getTaskInstance(task.getId());
            ProcessDefinition pd = instance.getContextInstance()
                    .getProcessInstance().getProcessDefinition();
            FileDefinition fd = pd.getFileDefinition();

            String url = getUIfor(context, pd, instance.getTask().getName());
            if (url != null) {
                byte ba[] = (byte[]) fd.getBytes(url);
                try {
                    if (ba != null)
                        return new String(ba, "UTF-8");
                } catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }

            String name = "ui/" + task.getName().replaceAll(" ", "[ _\\\\-.]?")
                    + "\\..+";
            Pattern p = Pattern.compile(name, Pattern.CASE_INSENSITIVE);
            Map map = fd.getBytesMap();
            for (Iterator it = map.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                if (p.matcher(key).matches()) {
                    byte ba[] = (byte[]) map.get(key);
                    try {
                        if (ba != null)
                            return new String(ba, "UTF-8");
                    } catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return null;
        } finally {
            flushContext();
        }
    }

    private String getUIfor(JbpmContext context, ProcessDefinition pd,
            String taskName) {
        Criteria busqueda = context.getSession().createCriteria(
                UserInterface.class);
        busqueda.add(Restrictions.eq("processDefinitionId",
                new Long(pd.getId())));
        busqueda.add(Restrictions.eq("tarea", taskName));

        List resultado = busqueda.list();

        for (Iterator it = resultado.iterator(); it.hasNext();) {
            UserInterface ui = (UserInterface) it.next();
            return ui.getFileName();
        }
        return null;
    }

    public Map getUIClassesForTask(es.caib.bpm.vo.ProcessDefinition def)
            throws SQLException, IOException {
        JbpmContext context = getContext();

        try {
            ProcessDefinition process = context.getGraphSession()
                    .getProcessDefinition(def.getId());
            FileDefinition fd = process.getFileDefinition();
            Map map = fd.getBytesMap();
            Map newMap = new HashMap();
            for (Iterator it = map.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                if (key.startsWith("classes/")) {
                    byte[] ba = (byte[]) map.get(key);
                    if (ba != null) {
                        String resource = key.substring(8);
                        newMap.put(resource, ba);
                    }
                }
            }
            return newMap;
        } finally {
            flushContext();
        }
    }
    
    public InputStream getResourceAsStream(es.caib.bpm.vo.ProcessInstance process,String resource){
    	JbpmContext context = getContext();
        try {
            ProcessInstance instance = context.loadProcessInstance(process.getId());
            ProcessDefinition definition = instance.getProcessDefinition();

            return definition.getFileDefinition().getInputStream(resource);
        } finally {
            flushContext();
        }
    }

    public es.caib.bpm.vo.TaskInstance startTask(
            es.caib.bpm.vo.TaskInstance task) throws BPMException {
        JbpmContext context = getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);

            TaskInstance ti = context.loadTaskInstance(task.getId());
            if (business.canAccess(getUserGroups(context), ti)) {
            	startAuthenticationLog(ti.getToken());
                if (ti.getStart() == null)
                    ti.start(getUserName());
                else
                    ti.setActorId(getUserName());
            	endAuthenticationLog(ti.getToken());
            	context.save(ti);
            } else {
                throw new SecurityException("Not authorized");
            }
            return VOFactory.newTaskInstance(ti);
        } finally {
            flushContext();
        }
    }

    public void remove() throws RemoveException, EJBException {
    }

    private String [] deployProcessParDefinition(File tempFile) throws BPMException, IOException, LoginException, XPathExpressionException, ParserConfigurationException, FactoryConfigurationError, SAXException, NamingException, CreateException, DocumentException {
        ProcessDefinition definition = null;
        InputStream streamLectura = null;
        UserInterfaceBusiness business = null;
        JbpmContext context = null;

        try {
            context = getContext();

            streamLectura = new FileInputStream(tempFile);

            definition = ProcessDefinition
                    .parseParZipInputStream(new ZipInputStream(streamLectura));

            streamLectura.close();

            context.deployProcessDefinition(definition);

            business = new UserInterfaceBusiness(context);

            return business.procesarDefinicionUI(tempFile, definition);
        } finally {
            flushContext();
            if (streamLectura != null) {
                streamLectura.close();
            }
        }
    }

    /* Despliegue */

    public void openDeployParDefinitionTransfer() throws BPMException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }

            this.tempFile = getTempFile();

            this.outputStream = new FileOutputStream(this.tempFile);
        } catch (Exception ex) {
            throw new BPMException(ex, BPMErrorCodes.ERROR_ENTRADA_SALIDA);
        }
    }

    public void nextDeployParDefinitionPackage(byte[] filePackage, int length)
            throws BPMException {
        try {
            this.outputStream.write(filePackage, 0, length);
        } catch (Exception ex) {
            throw new BPMException(ex, BPMErrorCodes.ERROR_ENTRADA_SALIDA);
        }
    }

    public void endDeployParDefinitionTransfer() throws BPMException {
        InputStream streamLectura = null;

        try {
            this.outputStream.close();

            messages = deployProcessParDefinition(this.tempFile);

            this.tempFile.delete();
            this.tempFile = null;

            this.outputStream = null;
        } catch (JpdlException ex) {
            generateUpgradeMessages(ex);
            try {
                if (streamLectura != null) {
                    streamLectura.close();
                }
            } catch (Exception exInterna) {
            }

            context.setRollbackOnly();
            throw new BPMException(ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        } catch (Exception ex) {
            generateUpgradeMessage(ex);
            try {
                if (streamLectura != null) {
                    streamLectura.close();
                }
            } catch (Exception exInterna) {
            }

            context.setRollbackOnly();
            throw new BPMException(ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        }
    }
    
    /** Realizar upgrade de un proceso */
    
    public void upgradeProcess(es.caib.bpm.vo.ProcessInstance instanceVO) throws BPMException {
        InputStream streamLectura = null;

        JbpmContext context = getContext();
        try {
        	
    		
    		ProcessInstance process = context.loadProcessInstance(instanceVO.getId());
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);

            if (business.isUserAuthorized(SUPERVISOR_ROLE, getUserGroups(context), process)) {
            	
                UserInterfaceBusiness business2 = new UserInterfaceBusiness(context);
            	messages = business2.upgradeProcess (process);
            }
        } catch (JpdlException ex) {
            generateUpgradeMessages(ex);
            context.setRollbackOnly();
            throw new BPMException(ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        } catch (Exception ex) {
            generateUpgradeMessage(ex);
            context.setRollbackOnly();
            throw new BPMException(ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        } finally {
            flushContext();
        }
    }

    public es.caib.bpm.vo.ProcessDefinition enableProcessDefinition(es.caib.bpm.vo.ProcessDefinition defVO) throws BPMException {
    	return disableProcessDefinition(defVO, "false");
    }
    public es.caib.bpm.vo.ProcessDefinition disableProcessDefinition(es.caib.bpm.vo.ProcessDefinition defVO) throws BPMException {
    	return disableProcessDefinition(defVO, "true");
    }

    public es.caib.bpm.vo.ProcessDefinition disableProcessDefinition(es.caib.bpm.vo.ProcessDefinition defVO, String value) throws BPMException {
        InputStream streamLectura = null;

        JbpmContext context = getContext();
        try {
        	
    		
    		ProcessDefinition def = context.getGraphSession().loadProcessDefinition(defVO.getId());
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);

            if (business.isUserAuthorized(SUPERVISOR_ROLE, getUserGroups(context), def)) {
                ProcessDefinitionProperty prop;
                prop = getProcessDefinitionDisabledProperty(context, def);
                if (prop == null) {
                	prop = new ProcessDefinitionProperty();
	                prop.setProcessDefinitionId(
	                		new Long(def.getId()));
	                prop.setName("disabled");
                }
	            prop.setValue(value);
                context.getSession().save(prop);
            }
            return VOFactory.newProcessDefinition(def, context);
        } catch (JpdlException ex) {
            generateUpgradeMessages(ex);
            context.setRollbackOnly();
            throw new BPMException(ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        } catch (Exception ex) {
            generateUpgradeMessage(ex);
            context.setRollbackOnly();
            throw new BPMException(ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        } finally {
            flushContext();
        }
    }

	private ProcessDefinitionProperty getProcessDefinitionDisabledProperty(
			JbpmContext context, ProcessDefinition def) {
		ProcessDefinitionProperty prop;
		Query q = context.getSession().createQuery("select pdp "+
		        "from es.caib.bpm.entity.ProcessDefinitionProperty pdp "+
		        "where pdp.name = 'disabled' and pdp.processDefinitionId=:id ");
		q.setParameter("id", new Long(def.getId()));
		prop = (ProcessDefinitionProperty) q.uniqueResult();
		return prop;
	}

	private void generateUpgradeMessages(JpdlException ex) {
		Vector v = new Vector ();
		List l = ex.getProblems();
		String message;
		for (Iterator it = l.iterator(); it.hasNext(); )
		{
		    Problem p = (Problem) it.next();
		    if (p.getLine() == null) 
		    {
		        message = p.getDescription();
		        if (p.getException() != null)
		               message = message +": "+ p.getException().toString();
		    }
		    else
		        message = p.getResource()+" line "+p.getLine()+": "+p.getDescription();
		    v.add (message);
		}
		messages = (String[]) v.toArray(new String[v.size()]);
	}

	private void generateUpgradeMessage(Exception ex) {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		PrintStream p = new PrintStream (out);
		ex.printStackTrace(p);
		p.close();
		messages = new String [] { out.toString() };
	}


    /**
     * Recupera un archivo temporario unico.
     * 
     * @return
     * @throws IOException
     * @throws FileNotFoundException
     * @throws InvalidConfigurationException
     */
    private synchronized File getTempFile() throws FileNotFoundException,
            IOException, InvalidConfigurationException {
        String jbossTemp = System.getProperty("jboss.server.temp.dir");
        if (jbossTemp == null)
            jbossTemp = System.getProperty("java.io.tmpdir");

        File tmp = new File(new File(jbossTemp), "bpm");
        tmp.mkdirs();

        return File.createTempFile("jbpmwf", ".par", tmp);
    }

    public List getPendingTasks(es.caib.bpm.vo.ProcessInstance process)
            throws BPMException {
        JbpmContext jbpmContext = null;

        try {
            jbpmContext = getContext();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(jbpmContext);
            if (process == null)
                return null;

            ProcessInstance instance = jbpmContext.getProcessInstance(process
                    .getId());
            Vector v = new Vector();

            if (instance.getTaskMgmtInstance() != null &&
            		instance.getTaskMgmtInstance().getTaskInstances() != null)
            {
	            for (Iterator it = instance.getTaskMgmtInstance()
	                    .getTaskInstances().iterator(); it.hasNext();) {
	                TaskInstance task = (TaskInstance) it.next();
	                if (!task.hasEnded()
	                        && business.canAccess(getUserGroups(jbpmContext), task)) {
	                    try {
	                        v.add(VOFactory.newTaskInstance(task));
	                    } catch (RuntimeException e)
	                    {
	                        log.warn ("Unable to serialize task "+task.getId(), e);
	                    }
	                }
	            }
            }
            return v;

        } catch (RuntimeException ex) {
            throw ex;
        } finally {
            flushContext();
        }
    }

    public List getActiveTasks(es.caib.bpm.vo.ProcessInstance process)
    throws BPMException {
	JbpmContext jbpmContext = null;
	
	try {
	    jbpmContext = getContext();
	    ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
	    business.setContext(jbpmContext);
	    if (process == null)
	        return null;
	    
	    ProcessInstance instance = jbpmContext.getProcessInstance(process
	            .getId());
	
	    Vector v = new Vector();
	
	    boolean canObserve = business.isUserAuthorized(OBSERVER_ROLE, getUserGroups(jbpmContext), instance) ||
			business.isUserAuthorized(SUPERVISOR_ROLE, getUserGroups(jbpmContext), instance); 
	    if (instance.getTaskMgmtInstance() != null &&
	    		instance.getTaskMgmtInstance().getTaskInstances() != null)
	    {
	        for (Iterator it = instance.getTaskMgmtInstance()
	                .getTaskInstances().iterator(); it.hasNext();) {
	            TaskInstance task = (TaskInstance) it.next();
	            if (!task.hasEnded()) {
	                try {
	            	    if ( canObserve || business.canAccess(getUserGroups(jbpmContext), task)) {
	            	    	v.add(VOFactory.newTaskInstance(task));
	            	    }
	                } catch (RuntimeException e)
	                {
	                    log.warn ("Unable to serialize task "+task.getId(), e);
	                }
	            }
	        }
	    }
	    return v;
	
	} catch (RuntimeException ex) {
	    throw ex;
	} finally {
	    flushContext();
	}
	}

    public List getActiveJobs(es.caib.bpm.vo.ProcessInstance process)
    throws BPMException {
	JbpmContext jbpmContext = null;
	
	try {
	    jbpmContext = getContext();
	    ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
	    business.setContext(jbpmContext);
	    if (process == null)
	        return null;
	    
	    ProcessInstance instance = jbpmContext.getProcessInstance(process
	            .getId());
	
	    if ( !business.isUserAuthorized(OBSERVER_ROLE, getUserGroups(jbpmContext), instance))
	    	return null;
	    
	    Vector v = new Vector();
	
	    populateJobs ( jbpmContext, instance.getRootToken(), v);
	    return v;
	
	} catch (RuntimeException ex) {
	    throw ex;
	} finally {
	    flushContext();
	}
	}


    private void populateJobs(JbpmContext jbpmContext, Token token, Vector v) {
    	
		List l = jbpmContext.getJobSession().findJobsByToken(token);
		for (Iterator it = l.iterator(); it.hasNext();)
		{
			Job j = (Job) it.next();
			v.add ( VOFactory.newJob(j));
		}
		for (Iterator it = token.getActiveChildren().values().iterator(); it.hasNext();)
		{
			Token childToken = (Token) it.next();
			populateJobs(jbpmContext, childToken, v);
		}
	}

    public List getActiveJobs()
    throws BPMException {
	JbpmContext jbpmContext = null;
	
	try {
	    jbpmContext = getContext();
	    ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
	    business.setContext(jbpmContext);

	    Query q = jbpmContext.getSession().getNamedQuery("dueDateJobs");
	    q.setParameter("now", new Date());
		List l = q.list ();
		
		Vector v = new Vector ();
		for (Iterator it = l.iterator(); it.hasNext();)
		{
			Job j = (Job) it.next();
			ProcessInstance pi = j.getProcessInstance();
		    if (business.isUserAuthorized(SUPERVISOR_ROLE, getUserGroups(jbpmContext), pi))
				v.add ( VOFactory.newJob(j));
		}
	    
	    return v;
	
	} catch (RuntimeException ex) {
	    throw ex;
	} finally {
	    flushContext();
	}
	}



	public es.caib.bpm.vo.TaskInstance getTask(long id) throws BPMException {
           JbpmContext jbpmContext = null;

        try {
            jbpmContext = getContext();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(jbpmContext);
            
            TaskInstance task = jbpmContext.getTaskInstance(id);
            if (task == null)
                return null;
        

            if (business.canAccess(getUserGroups(jbpmContext), task)) {
                return VOFactory.newTaskInstance(task);
            } else {
                return null;
            }
        } catch (RuntimeException ex) {
            throw ex;
        } finally {
            flushContext();
        }
    }


    /**
     * Recupera el procés 
     * si es servei intern (run-as amb rol BPM_INTERNAL), 
     * si es rol OBSERVER_ROLE, 
     * si es rol INITIATOR_ROLE, 
     * si es rol SUPERVISOR_ROLE, 
     * si té assignada alguna tasca del procés
     */

    public es.caib.bpm.vo.ProcessInstance getProcess(long id) throws BPMException {
        JbpmContext jbpmContext = null;

     try {
         jbpmContext = getContext();
         ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
         business.setContext(jbpmContext);
         
         ProcessInstance process = jbpmContext.getProcessInstance(id);
         ProcessDefinition definition=process.getProcessDefinition();
         if (process == null)
             return null;
     
         if (! isInternalService() 
            && ! business.isUserAuthorized(OBSERVER_ROLE,getUserGroups(jbpmContext), definition)
        	&& !business.isUserAuthorized(INITIATOR_ROLE,getUserGroups(jbpmContext), definition)
        	&& !business.isUserAuthorized(SUPERVISOR_ROLE,getUserGroups(jbpmContext), definition)){
        	 Collection list = process.getTaskMgmtInstance().getTaskInstances();
        	 for (Iterator it = list.iterator(); it.hasNext();)
        	 {
        		 TaskInstance ti = (TaskInstance) it.next();
        		 if (business.canAccess(getUserGroups(jbpmContext), ti))
        		 {
                     return VOFactory.newProcessInstance(process);
        		 }
        	 }
             throw new SecurityException("No autoritzat a accedir al procés");             
         } else {
             return VOFactory.newProcessInstance(process);
         }
     } catch (RuntimeException ex) {
         throw ex;
     } finally {
         flushContext();
     }
 }

    private void recursiveFillTokens (Token rootToken, Collection tokens) {
    	es.caib.bpm.vo.Token t2 =  VOFactory.newToken(rootToken);
    	tokens.add(t2);
    	for (Iterator it = rootToken.getChildren().values().iterator(); it.hasNext() ; ) {
    		recursiveFillTokens((Token) it.next(), tokens);
    	}
    }
    
	public es.caib.bpm.vo.Token[] getTokens(long id) throws BPMException {
        JbpmContext jbpmContext = null;

        try {
            jbpmContext = getContext();
            ProcessInstance process = jbpmContext.getProcessInstance(id);
        
        	Vector v = new Vector(1);
        	recursiveFillTokens(process.getRootToken(), v);
            	
        	return (es.caib.bpm.vo.Token[]) v.toArray(new es.caib.bpm.vo.Token[v.size()]);
        } catch (RuntimeException ex) {
            throw ex;
        } finally {
            flushContext();
        }
	}

    public void update(es.caib.bpm.vo.TaskInstance task) throws BPMException {
        JbpmContext context = getContext();
        try {
            doUpdate(context, task);

        } finally {
            flushContext();
        }

    }

    public void updateSwimlane(es.caib.bpm.vo.TaskInstance task,
            String swimlane, String actorIds[]) throws BPMException {
        JbpmContext context = getContext();
        ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
        business.setContext(context);

        try {
            TaskInstance ti = context.loadTaskInstance(task.getId());
            if (business.canAccess(getUserGroups(context), ti)) {
            	startAuthenticationLog(ti.getToken());
                SwimlaneInstance swimlaneInstance = ti.getTaskMgmtInstance()
                        .getSwimlaneInstance(swimlane);
                swimlaneInstance.setPooledActors(actorIds);
                endAuthenticationLog(ti.getToken());
                context.save(ti);
            }
        } finally {
            flushContext();
        }

    }

    private TaskInstance doUpdate(JbpmContext context,
            es.caib.bpm.vo.TaskInstance task) throws BPMException {
        ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
        business.setContext(context);

        TaskInstance ti = context.loadTaskInstance(task.getId());
        if (business.canAccess(getUserGroups(context), ti)) {
            startAuthenticationLog(ti.getToken());
            ti.setActorId(task.getActorId());
            ti.setBlocking(task.isBlocking());
            ti.setDescription(task.getDescription());
            ti.setName(task.getName());
            ti.setDueDate(task.getDueDate());
            ti.setEnd(task.getEnd());
            ti.setPriority(task.getPriority());
            ti.setSignalling(task.isSignalling());

            Vector v = new Vector();
            v.addAll(task.getPooledActors());
            // Borrar y modificar pooled actors
            if (ti.getPooledActors() != null)
            {
                for (Iterator it = ti.getPooledActors().iterator(); it.hasNext();) {
                    PooledActor actor = (PooledActor) it.next();
                    String name = null;
                    if (actor.getActorId() != null)
                        name = actor.getActorId();
                    else if (actor.getSwimlaneInstance() != null)
                        name = actor.getSwimlaneInstance().getName();
    
                    if (name != null) {
                        if (!v.contains(name)) {
                            it.remove();
                        }
                    }
                }
                // Agregar actores
                for (Iterator it = task.getPooledActors().iterator(); it.hasNext();) {
                    String key = (String) it.next();
                    PooledActor actor = new PooledActor();
                    SwimlaneInstance swimlane = ti.getTaskMgmtInstance()
                            .getSwimlaneInstance(key);
                    if (swimlane != null) {
                        actor.setSwimlaneInstance(swimlane);
                    } else {
                        actor.setActorId(key);
                    }
                    ti.getPooledActors().add(actor);
                }
            }

            HashMap map = new HashMap();
            map.putAll(task.getVariables());
            // Borrar y modificar variables
            for (Iterator it = ti.getVariables().keySet().iterator(); it
                    .hasNext();) {
                String key = (String) it.next();
                Object value = map.get(key);
                ti.setVariable(key, value);
                map.remove(key);
            }
            // Agregar variables
            for (Iterator it = map.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                Object value = map.get(key);
                ti.setVariable(key, value);
            }
            endAuthenticationLog(ti.getToken());
            context.save(ti);
            return ti;
        } else {
            throw new SecurityException("Not authorized");
        }
    }

    public String [] getDeployMessages () {
        return messages;
    }

    /**
	 * @return the jBpmConfiguration
	 */
	public  JbpmConfiguration getJBpmConfiguration() {
		return Configuration.getConfig();
	}

	/**
	 * Hace el signal de una instancia si tiene permisos de supervisor
	 * 
	 * @param instanceVO
	 * @throws BPMException
	 */
	public void signal(es.caib.bpm.vo.ProcessInstance instanceVO) throws BPMException {
		signal(instanceVO, null);
	}
	
	/**
	 * Hace el signal de una instancia si tiene permisos de supervisor
	 * 
	 * @param instanceVO
	 * @param transitionName
	 * @throws BPMException
	 */
	
	public void signal(es.caib.bpm.vo.ProcessInstance instanceVO, String transitionName)
    throws BPMException {
	    
		JbpmContext context = getContext();

		try {
		    ProcessInstance instance = context.loadProcessInstance(instanceVO.getId());
	        ProcessDefinition definition = instance.getProcessDefinition();	    

		    ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
		    business.setContext(context);
		
		    if (isInternalService() || 
		    		business.isUserAuthorized(SUPERVISOR_ROLE, getUserGroups(context), definition)) {
		    	startAuthenticationLog(instance.getRootToken());
		        if(transitionName!=null)
		        	instance.signal(transitionName);
		        else
		        	instance.signal();
		        endAuthenticationLog(instance.getRootToken());
		        context.save(instance);
		    }
		} finally {
			flushContext();
		}
    }

	/** Obtiene el log de un proceso
	 * 
	 * @param id Identificador del rpcoeso
	 * @return
	 * @throws BPMException
	 */
	public ProcessLog[] getProcessLog(es.caib.bpm.vo.ProcessInstance instanceVO) throws BPMException {
        JbpmContext context = getContext();
        try {
    		ProcessInstance process = context.loadProcessInstance(instanceVO.getId());
    		Vector parsedLogs = new Vector();
    		parseLog(context, process, parsedLogs, process.getRootToken());
    		Collections.sort(parsedLogs, new Comparator () {
				public int compare(Object arg0, Object arg1) {
					ProcessLog l1 = (ProcessLog) arg0;
					ProcessLog l2 = (ProcessLog) arg1;
					return l1.getDate().compareTo(l2.getDate());
				}
    		});
    		ProcessLog [] logs =  (ProcessLog[]) parsedLogs.toArray(new ProcessLog[parsedLogs.size()]);
    		return logs;
        } finally {
            flushContext();
        }

	}
	
	private void parseLog(JbpmContext context, ProcessInstance process, Vector parsedLogs,
			Token t) {
		Criteria criteria= null;
		
		criteria= context.getSession().createCriteria(org.jbpm.logging.log.ProcessLog.class);
		
		criteria.add(Restrictions.eq("token", t));
		criteria.add(Restrictions.isNull("parent"));
		Iterator it = criteria.list().iterator();
		while (it.hasNext())
		{
			org.jbpm.logging.log.ProcessLog pl = (org.jbpm.logging.log.ProcessLog) it.next();
			parseLog(process, parsedLogs, pl);
		}
		for ( Iterator it2 = t.getChildren().values().iterator();
			it2.hasNext();) 
		{
			Token childToken = (Token) it2.next();
			parseLog(context, process, parsedLogs, childToken);
		}
			
	}

	private void parseLog(ProcessInstance process, Vector parsedLogs,
			org.jbpm.logging.log.ProcessLog pl) {
		ProcessLog logLine = new ProcessLog();
		logLine.setDate(pl.getDate());
		logLine.setProcessId(process.getId());
		logLine.setUser(pl.getActorId());
		StringBuffer b = new StringBuffer ();
		org.jbpm.logging.log.ProcessLog pl2 = pl.getParent();
		while (pl2 != null) 
		{
			b.append("\\ ");
			pl2 = pl2.getParent();
		}
//		log.debug(b.toString()+pl.getId()+" - "+pl.getClass().getName()+": "+pl.toString());
		if (pl instanceof ProcessInstanceCreateLog)
		{
			logLine.setAction("Procés iniciat");
			parsedLogs.add(logLine);
		}
		else if (pl instanceof TransitionLog)
		{
			TransitionLog tl = (TransitionLog) pl;
			logLine.setAction(
					(tl.getTransition().getName() != null ? 
							tl.getTransition().getName()+": " :
							"") +
					tl.getSourceNode().getName()+ " -> "+
					tl.getDestinationNode().getName());
			parsedLogs.add(logLine);
		}
		else if (pl instanceof ProcessInstanceEndLog)
		{
			logLine.setAction("Fin del procés");
			parsedLogs.add(logLine);
		}
		else if (pl instanceof ActionLog)
		{
			ActionLog al = (ActionLog) pl;
			if (al.getException() != null)
			{
				logLine.setAction("Error a la tasca automàtica "+al.getAction().getName()+":\n"+
						al.getException());
				parsedLogs.add(logLine);
			}
		}
		else if (pl instanceof CompositeLog)
		{
			CompositeLog cl = (CompositeLog) pl;
			for (Iterator it = cl.getChildren().iterator(); it.hasNext();)
			{
				org.jbpm.logging.log.ProcessLog child = (org.jbpm.logging.log.ProcessLog) it.next();
				if (child != null) {
					parseLog(process, parsedLogs, child);
				}
			}
		}
	}
	
	private boolean isInternalService ()
	{
		return context.isCallerInRole("BPM_INTERNAL");
	}
	
	  /**
	   * convenience method for starting a composite log. When you add composite logs, make sure you put the
	   * {@link #endCompositeLog()} in a finally block.
	   */
	  public void startAuthenticationLog(Token token)
	  {
	    LoggingInstance li = (LoggingInstance) token.getProcessInstance().getInstance(LoggingInstance.class);
	    if (li == null)
	    {
	    	li = new LoggingInstance ();
	    	token.getProcessInstance().addInstance(li);
	    }
    	AuthenticationLog log = new AuthenticationLog();
    	log.setToken(token);
    	log.setActorId(getUserName());
    	li.startCompositeLog(log);
	  }

	  /**
	   * convenience method for ending a composite log. Make sure you put this in a finally block.
	   */
	  public void endAuthenticationLog(Token token)
	  {
	    LoggingInstance li = (LoggingInstance)token.getProcessInstance().getInstance(LoggingInstance.class);
	    if (li != null)
	    {
	      li.endCompositeLog();
	    }
	  }

	  public boolean canAdmin (es.caib.bpm.vo.ProcessInstance instanceVO) throws BPMException
	  {
	        JbpmContext context = getContext();
	        try {
	        	
	    		
	    		ProcessInstance process = context.loadProcessInstance(instanceVO.getId());
	            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
	            business.setContext(context);

	            return business.isUserAuthorized(SUPERVISOR_ROLE, getUserGroups(context), process); 
	        } finally {
	            flushContext();
	        }
	  }

	  public void resumeJob (es.caib.bpm.vo.Job jobvo) throws BPMException
	  {
		    enableJob(jobvo, true);
	  }

	  public void pauseJob (es.caib.bpm.vo.Job jobvo) throws BPMException
	  {
		    enableJob(jobvo, false);
	  }

	  public void enableJob (es.caib.bpm.vo.Job jobvo, boolean enable) throws BPMException
	  {
		    
			JbpmContext context = getContext();

			try {
				Job job = context.getJobSession().getJob(jobvo.getId());
				if (job == null)
					throw new BPMException("Aquesta tasca no existeix", -1);
			    ProcessInstance instance = job.getProcessInstance();
			    ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
			    business.setContext(context);
		
			    if (isInternalService() || 
			    		business.isUserAuthorized(SUPERVISOR_ROLE, getUserGroups(context), instance)) {
			    	startAuthenticationLog(instance.getRootToken());
			    	job.setSuspended(!enable);
			        endAuthenticationLog(instance.getRootToken());
			        context.save(instance);
			    }
			} finally {
				flushContext();
			}
		  
	  }

	  public void retryJob (es.caib.bpm.vo.Job jobvo) throws BPMException
	  {
			JbpmContext context = getContext();

			try {
				Job job = context.getJobSession().getJob(jobvo.getId());
				if (job == null)
					throw new BPMException("Aquesta tasca no existeix", -1);
			    ProcessInstance instance = job.getProcessInstance();
			    ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
			    business.setContext(context);
		
			    if (isInternalService() || 
			    		business.isUserAuthorized(SUPERVISOR_ROLE, getUserGroups(context), instance)) {
			    	startAuthenticationLog(instance.getRootToken());
			    	job.setSuspended(false);
			    	job.setRetries(1);
			    	job.setException(null);
			        endAuthenticationLog(instance.getRootToken());
			        context.save(instance);
			    }
			} finally {
				flushContext();
			}
		  
	  }
	  /**
	   * Gestió de la configuració
	   */ 
	  public Map getConfiguration ()
	  {
			JbpmContext context = getContext();
			HashMap m = new HashMap();
			
			try {
	            Query q = context.getSession().createQuery("select prop "+
	                    "from es.caib.bpm.entity.DBProperty prop "+
	                    "where prop.app='"+BPMEngineLocal.BPM_APPLICATION_ID+"'");
	            for (Iterator i = q.list().iterator(); i.hasNext();) {
	            	DBProperty prop = (DBProperty) i.next();
	            	m.put (prop.getKey(), prop.getValue());
	            }
	            return m;
			} finally {
				flushContext();
			}
	  }
	  /**
	   * Gestió de la configuració
	 * @throws IOException 
	   */ 
	  public void changeConfiguration (Map m) throws IOException
	  {
			JbpmContext context = getContext();
			HashSet s = new HashSet(m.keySet());
			try {
	            Query q = context.getSession().createQuery("select prop "+
	                    "from es.caib.bpm.entity.DBProperty prop "+
	                    "where prop.app='"+BPMEngineLocal.BPM_APPLICATION_ID+"'");
	            for (Iterator i = q.list().iterator(); i.hasNext();) {
	            	DBProperty prop = (DBProperty) i.next();
	            	String value = (String) m.get(prop.getKey());
	            	if (value == null)
	            		context.getSession().delete(prop);
	            	else
	            	{
	            		prop.setValue(value);
	            		context.getSession().save(prop);
	            		s.remove(prop.getKey());
	            	}
	            }
	            for (Iterator i = s.iterator(); i.hasNext();)
	            {
	            	String key = (String) i.next();
	            	DBProperty prop = new DBProperty();
	            	prop.setApp(BPMEngineLocal.BPM_APPLICATION_ID);
	            	prop.setKey(key);
	            	prop.setValue((String) m.get(key));
	            	context.getSession().save(prop);
	            }
	            DirectoryFactory.reconfigureDirectory(context);
			} finally {
				flushContext();
			}
	  }
	  
	  public void reindex () throws IOException
	  {
		  Indexer.getIndexer().reindexAll();
	  }
	  
	  public void ping () 
	  {
		  // Nothing to do
	  }
	  
    public InputStream getResourceAsStream(es.caib.bpm.vo.ProcessDefinition processdef,String resource){
    	JbpmContext context = getContext();
        try {
            ProcessDefinition definition = context.getGraphSession().getProcessDefinition(processdef.getId());

            return definition.getFileDefinition().getInputStream(resource);
        } finally {
            flushContext();
        }
    }
    
}
