package es.caib.bpm.beans;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.proxy.HibernateProxy;
import org.jbpm.JbpmConfiguration;
import org.jbpm.identity.Membership;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.identity.hibernate.IdentitySessionFactory;

import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.identity.vo.User;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;




public class BPMIdentityBean implements SessionBean{


	private static final long serialVersionUID = 1L;
	
	private SessionContext context;
	private Logger log;

	private IdentitySession identitySession;
	
	public BPMIdentityBean() {
		 log = Logger.getLogger(BPMIdentityBean.class);
	}
	
	/**
     * 
     * @throws CreateException
     */
    
    public void ejbCreate() throws CreateException {
    }
	
	public void ejbActivate() throws EJBException, RemoteException {
	}

	public void ejbPassivate() throws EJBException, RemoteException {
	}

	public void ejbRemove() throws EJBException, RemoteException {
		
	}

	public void setSessionContext(SessionContext context) throws EJBException, RemoteException {
        this.context = context;
		
	}
	


	private boolean isInternalService ()
	{
		return context.isCallerInRole("BPM_INTERNAL");
	}

	
	protected IdentitySession getIdentitySession(){
		if(identitySession==null){			
			Configuration conf=IdentitySessionFactory.createConfiguration();
			identitySession=new IdentitySessionFactory(conf).openIdentitySession();
		}
		
		return identitySession;

		
	}
	
	
/*********  BUSINESS METHODS DECLARATIONS **/	
	
	/**
	 * Retorna un array on les columnes són: codiUsuari, Nom, Llinatges, GrupPrimari
	 * @param nom
	 * @param llinatges
	 * @return
	 */
	public Collection buscaUsuariPerNomEmail(String nom, String email) throws WorkflowException {
		
		try {
			
	        Query q=getIdentitySession().getSession().createQuery("select u from org.jbpm.identity.User u where u.name like :name and u.email like :email");
	        q.setString("name", "%"+nom+"%");
	        q.setString("email", "%"+email+"%");
	        
	        return User.entityToVO(q.list());
	        
		}catch(Exception e){
			Logger.getLogger(this.getClass().getName()).error(e);
			throw new SystemWorkflowException(e);
		}
		
	}
}
