package es.caib.bpm.beans;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import org.apache.log4j.Logger;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.svc.Services;

import es.caib.bpm.beans.local.BPMJobExecutorLocal;
import es.caib.bpm.config.Configuration;
import es.caib.bpm.index.Indexer;

public class BPMJobExecutorBean implements SessionBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	static Integer lock = new Integer(10001);
	static Logger log = Logger.getLogger(BPMJobExecutorBean.class);
	private SessionContext ctx;

	public void anotateFailure(long id, Exception e) {
		JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
		try {
			JobSession jobSession = jbpmContext.getJobSession();
			Job job = jobSession.loadJob(id);
			log.debug("exception while executing " + job, e);
			StringWriter memoryWriter = new StringWriter();
			e.printStackTrace(new PrintWriter(memoryWriter));
			job.setException(memoryWriter.toString());
			job.setRetries(job.getRetries() - 1);
			Date d = new Date (System.currentTimeMillis()+10 * 60 * 1000); // Esperar deu minuts
			job.setDueDate(d);
			job.setLockOwner(null);
			jbpmContext.getSession().update(job);
		} finally {
			jbpmContext.close();
		}
	}

	public Exception executeJob(long id) {
		JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
		try {
			JobSession jobSession = jbpmContext.getJobSession();
			Job job = jobSession.loadJob(id);
			boolean success = job.execute(jbpmContext);
			if (ctx.getRollbackOnly()) {
				return new JbpmException("Transaction timeout");
			}
			if (success)
				jobSession.deleteJob(job);
			return null;
		} catch (Exception e) {
			try {
				ctx.setRollbackOnly();
			} catch (Exception e2 ) {
				ctx.setRollbackOnly();
				throw new EJBException(e2);
			}
			return e;
		} finally {
			jbpmContext.close();
		}
	}

	public Date getNextDueDate(String lockOwner) {
		JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
		try {
			Date nextDueDate = null;
			JobSession jobSession = jbpmContext.getJobSession();
			Job job = jobSession.getFirstDueJob(lockOwner, null);
			if (job != null) {
				nextDueDate = job.getDueDate();
			}
			return nextDueDate;
		} finally {
			jbpmContext.close();
		}
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void ejbRemove() {
	}

	public void ejbCreate() throws CreateException {
	}

	public List getJobs(String lockOwner) {
		Vector jobs = new Vector();
		Collection acquiredJobs;
		synchronized (lock) {
			log.debug("acquiring jobs for execution...");
			List jobsToLock = Collections.EMPTY_LIST;
			JbpmContext jbpmContext = Configuration.getConfig()
					.createJbpmContext();
			try {
				JobSession jobSession = jbpmContext.getJobSession();
				log.debug("querying for acquirable job...");
				Job job = jobSession.getFirstAcquirableJob(lockOwner);
				if (job != null) {
					if (job.isExclusive()) {
						log.debug("found exclusive " + job);
						ProcessInstance processInstance = job
								.getProcessInstance();
						log.debug("finding other exclusive jobs for "
								+ processInstance);
						jobsToLock = jobSession.findExclusiveJobs(lockOwner,
								processInstance);
						log.debug("trying to obtain exclusive locks on "
								+ jobsToLock + " for " + processInstance);
					} else {
						log.debug("trying to obtain lock on " + job);
						jobsToLock = Collections.singletonList(job);
					}

					Date lockTime = new Date();
					for (Iterator iter = jobsToLock.iterator(); iter.hasNext();) {
						job = (Job) iter.next();
						job.setLockOwner(lockOwner);
						job.setLockTime(lockTime);
						jbpmContext.getSession().update(job);
						jobs.add(new Long(job.getId()));
					}

				} else {
					log.debug("no acquirable jobs in job table");
				}
			} finally {
				jbpmContext.close();
			}
		}
		return jobs;
	}

	public void unlockOverdueJobs(Date threshold) {
		JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
		try {
			JobSession jobSession = jbpmContext.getJobSession();

			List jobsWithOverdueLockTime = jobSession
					.findJobsWithOverdueLockTime(threshold);
			Iterator iter = jobsWithOverdueLockTime.iterator();
			while (iter.hasNext()) {
				Job job = (Job) iter.next();
				// unlock
				log.info("unlocking " + job + " owned by thread "
						+ job.getLockOwner());
				job.setLockOwner(null);
				job.setLockTime(null);
				jobSession.saveJob(job);
			}

		} finally {
			jbpmContext.close();
		}
	}

	public void setSessionContext(SessionContext arg0) throws EJBException,
			RemoteException {
		ctx = arg0;
	}

	public void indexPendingProcesses () {
		Indexer i = Indexer.getIndexer ();
		JbpmContext ctx = Configuration.getConfig().createJbpmContext();
		try {
			i.flush(ctx.getSession());
		} catch (Exception e) {
			log.warn("Error indexant", e);
		} finally {
			ctx.close();
		}
	}
}
