package es.caib.bpm.business;

import java.lang.reflect.Constructor;
import java.security.cert.X509Certificate;

import org.jbpm.security.AuthenticationService;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;



public class AuthenticationServiceFactory implements ServiceFactory {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7437201257360080496L;

	public void close() {

	}

	/**
	 * Configura el servicio de autenticación, a partir de una propiedad de sistema.
	 * Por defecto seycon.
	 */
	public Service openService() {
		try{
			String authenticationServiceClassName=System.getProperty("es.caib.bpm.authenticationServiceDelegate", "es.caib.bpm.security.SeyconAuthenticationService");
			Class authenticationServiceClass=this.getClass().getClassLoader().loadClass(authenticationServiceClassName);
			Constructor constructor=authenticationServiceClass.getConstructor(
					new Class[] {
							X509Certificate[].class,
							boolean.class 
					}
				);
			AuthenticationService authenticationService=(AuthenticationService)constructor.newInstance(null);
			return authenticationService;
		}catch(Exception e){
			return null;
		}
	}

}
