package es.caib.bpm.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.ejb.SessionContext;

import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;

import es.caib.bpm.beans.BPMEngineBean;
import es.caib.bpm.dal.ProcessDefinitionRolesDal;
import es.caib.bpm.entity.ProcessDefinitionUserRole;

public class ProcessDefinitionRolesBusiness {

	public boolean isUserAuthorized(String appRole, Vector userRoles,
			ProcessDefinition definition) {
		Swimlane swim = definition.getTaskMgmtDefinition().getSwimlane(appRole);
		if (swim == null)
			return checkOldAuthorization(appRole, userRoles, definition);
		else {
			String members = swim.getActorIdExpression();
			if (members == null)
				members = swim.getPooledActorsExpression();
			if (members == null)
				return checkOldAuthorization(appRole, userRoles, definition);
			else
			{
				String parsedMembers[] = getDefinitionActors(members);
				for (int i = 0; i < parsedMembers.length; i++) {
					if (userRoles.contains(parsedMembers[i]))
						return true;
				}
				return false;
			}
		}
	}

	private String[] getDefinitionActors(String pooledActorsExpression) {
		ExecutionContext executionContext = ExecutionContext.currentExecutionContext();
		if (executionContext == null)
			executionContext = new ExecutionContext ( (Token) null);
		String[] pooledActors = null;
		Object result = JbpmExpressionEvaluator.evaluate(
				pooledActorsExpression, executionContext);
		if (result == null) {
			throw new JbpmException("pooled-actors expression '"
					+ pooledActorsExpression + "' returned null");
		}

		if (result instanceof String[]) {
			pooledActors = (String[]) result;

		} else if (result instanceof Collection) {
			Collection collection = (Collection) result;
			pooledActors = (String[]) collection.toArray(new String[collection
					.size()]);

		} else if (result instanceof String) {
			List pooledActorList = new ArrayList();
			StringTokenizer tokenizer = new StringTokenizer((String) result,
					",");
			while (tokenizer.hasMoreTokens()) {
				pooledActorList.add(tokenizer.nextToken().trim());
			}
			pooledActors = (String[]) pooledActorList
					.toArray(new String[pooledActorList.size()]);
		} else {
			throw new JbpmException(
					"pooled-actors expression '"
							+ pooledActorsExpression
							+ "' didn't resolve to a comma separated String, a Collection or a String[]: '"
							+ result + "' (" + result.getClass().getName()
							+ ")");
		}
		return pooledActors;
	}

	public boolean isUserAuthorized(String appRole, Vector userRoles,
			ProcessInstance pi) {
		ExecutionContext ctx = new ExecutionContext(pi.getRootToken());
		ExecutionContext.pushCurrentContext(ctx);
		try {
			Swimlane swim = pi.getProcessDefinition().getTaskMgmtDefinition().getSwimlane(appRole);
			if (swim == null)
				return checkOldAuthorization(appRole, userRoles, pi.getProcessDefinition());
			else {
				SwimlaneInstance swimInstance = pi.getTaskMgmtInstance().
					getInitializedSwimlaneInstance(ctx, swim);
				if (swimInstance.getActorId() != null &&
						userRoles.contains(swimInstance.getActorId()))
					return true;
				if (swimInstance.getPooledActors() != null) {
					Iterator it = swimInstance.getPooledActors().iterator();
					while (it.hasNext()) {
						PooledActor actor = (PooledActor) it.next();
						if (userRoles.contains(actor.getActorId()))
							return true;
					}
				}
				return false;
			}
		} finally {
			ExecutionContext.popCurrentContext(ctx);
		}
	}


	private boolean checkOldAuthorization(String appRole, Vector userRoles, 
			ProcessDefinition roleDefinition) {

		ProcessDefinitionRolesDal dal = new ProcessDefinitionRolesDal();
		dal.setContext(this.context);

		List resultado = dal
				.findProcessDefinitionRoles(roleDefinition, appRole);

		if (resultado.isEmpty())
			return true;
		
		for (Iterator it = resultado.iterator(); it.hasNext();) {
			ProcessDefinitionUserRole role = (ProcessDefinitionUserRole) it
					.next();
			if (userRoles.contains(role.getUserRole()))
				return true;

		}

		return false;
	}

	public void setContext(JbpmContext context) {
		this.context = context;
	}

	public JbpmContext getContext() {
		return context;
	}

	private JbpmContext context = null;

	public boolean canAccess(Vector userGroups, TaskInstance ti) {
		if (ti.getActorId() != null && userGroups.contains(ti.getActorId()))
			return true;
		
		if (isUserAuthorized(BPMEngineBean.SUPERVISOR_ROLE, userGroups, ti.getProcessInstance()))
			return true;
		if (ti.getSwimlaneInstance() != null) {
			SwimlaneInstance swim = ti.getSwimlaneInstance();
			String actorId = swim.getActorId();
			if (actorId != null && userGroups.contains(actorId))
				return true;
			if (swim.getPooledActors() != null) {
				for (Iterator it = userGroups.iterator(); it.hasNext();) {
					String group = (String) it.next();
					for (Iterator it2 = swim.getPooledActors().iterator(); it2
							.hasNext();) {
						PooledActor actor = (PooledActor) it2.next();
						if (group.equals(actor.getActorId()))
							return true;
					}
				}
			}
		}
		if (ti.getPooledActors() != null) {
			for (Iterator it = userGroups.iterator(); it.hasNext();) {
				String group = (String) it.next();
				for (Iterator it2 = ti.getPooledActors().iterator(); it2
						.hasNext();) {
					PooledActor actor = (PooledActor) it2.next();
					if (group.equals(actor.getActorId()))
						return true;
				}
			}
		}
		return false;
	}

}
