/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.beans;

import es.caib.bpm.business.ProcessDefinitionRolesBusiness;
import es.caib.bpm.business.UserInterfaceBusiness;
import es.caib.bpm.business.VOFactory;
import es.caib.bpm.config.Configuration;
import es.caib.bpm.entity.AuthenticationLog;
import es.caib.bpm.entity.DBProperty;
import es.caib.bpm.entity.ProcessDefinitionProperty;
import es.caib.bpm.entity.UserInterface;
import es.caib.bpm.exception.BPMErrorCodes;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.exception.InvalidConfigurationException;
import es.caib.bpm.exception.InvalidParameterException;
import es.caib.bpm.index.DirectoryFactory;
import es.caib.bpm.index.Indexer;
import es.caib.bpm.util.Timer;
import es.caib.bpm.utils.ColeccionesUtils;
import es.caib.bpm.utils.FechaUtils;
import es.caib.bpm.vo.Job;
import es.caib.bpm.vo.ProcessLog;
import es.caib.bpm.vo.TaskDefinition;
import es.caib.bpm.vo.TaskInstance;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermsFilter;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Version;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.xpath.DefaultXPath;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ActionLog;
import org.jbpm.graph.log.ProcessInstanceCreateLog;
import org.jbpm.graph.log.ProcessInstanceEndLog;
import org.jbpm.graph.log.TransitionLog;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.logging.exe.LoggingInstance;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.xml.sax.SAXException;

public class BPMEngineBean
implements SessionBean {
    private static final long serialVersionUID = 1L;
    private transient SessionContext context = null;
    private transient File tempFile = null;
    private transient FileOutputStream outputStream = null;
    private String userName = null;
    private transient Logger log = Logger.getLogger((Class)(class$es$caib$bpm$beans$BPMEngineBean == null ? (class$es$caib$bpm$beans$BPMEngineBean = BPMEngineBean.class$("es.caib.bpm.beans.BPMEngineBean")) : class$es$caib$bpm$beans$BPMEngineBean));
    private transient Vector userGroups = null;
    private String[] messages;
    public static final String OBSERVER_ROLE = "observer";
    public static final String SUPERVISOR_ROLE = "supervisor";
    public static final String BPM_EJB_APP = "BPM_EJB";
    public static final String INITIATOR_ROLE = "initiator";
    JbpmContext myContext;
    static /* synthetic */ Class class$es$caib$bpm$beans$BPMEngineBean;
    static /* synthetic */ Class class$org$jbpm$graph$log$ProcessInstanceCreateLog;
    static /* synthetic */ Class class$es$caib$bpm$entity$UserInterface;
    static /* synthetic */ Class class$org$jbpm$logging$log$ProcessLog;
    static /* synthetic */ Class class$org$jbpm$logging$exe$LoggingInstance;

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
        this.outputStream = null;
        this.tempFile = null;
        this.flushContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushContext() {
        if (this.myContext != null) {
            this.myContext.setActorId(null);
            try {
                this.myContext.close();
            }
            finally {
                this.myContext = null;
            }
        }
    }

    public void ejbRemove() throws EJBException {
        this.flushContext();
    }

    public void ejbCreate() throws CreateException {
        if (this.isInternalService()) {
            this.userName = this.context.getCallerPrincipal().getName();
        } else {
            if ("nobody".equals(this.context.getCallerPrincipal().getName())) {
                throw new CreateException("Anonymous access not authorized");
            }
            if (this.userName == null) {
                this.userName = this.context.getCallerPrincipal().getName();
            } else if (!this.userName.equals(this.context.getCallerPrincipal().getName())) {
                throw new EJBException("Session Tampering detected");
            }
        }
    }

    public void setSessionContext(SessionContext context) throws EJBException {
        this.context = context;
    }

    public TaskInstance addComment(TaskInstance task, String comment) {
        JbpmContext jbpmContext = null;
        Session session = null;
        try {
            jbpmContext = this.getContext();
            session = jbpmContext.getSession();
            org.jbpm.taskmgmt.exe.TaskInstance ti = jbpmContext.getTaskInstanceForUpdate(task.getId());
            Comment c = new Comment(this.getUserName(), comment);
            ti.addComment(c);
            jbpmContext.save(ti);
            TaskInstance taskInstance = VOFactory.newTaskInstance(ti);
            return taskInstance;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    public JbpmContext getContext() {
        if (this.myContext == null) {
            this.myContext = Configuration.getConfig().createJbpmContext();
            if (!this.getUserName().equals(this.context.getCallerPrincipal().getName())) {
                throw new EJBException("Session Tampering detected");
            }
            this.myContext.setActorId(this.getUserName());
        }
        return this.myContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public es.caib.bpm.vo.ProcessInstance cancel(es.caib.bpm.vo.ProcessInstance process) {
        JbpmContext context = this.getContext();
        try {
            ProcessInstance instance = context.getProcessInstance(process.getId());
            this.startAuthenticationLog(instance.getRootToken());
            instance.end();
            Iterator it = instance.getTaskMgmtInstance().getTaskInstances().iterator();
            while (it.hasNext()) {
                org.jbpm.taskmgmt.exe.TaskInstance taskInstance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (taskInstance.hasEnded()) continue;
                taskInstance.cancel();
            }
            this.endAuthenticationLog(instance.getRootToken());
            context.save(instance);
            es.caib.bpm.vo.ProcessInstance processInstance = VOFactory.newProcessInstance(instance);
            return processInstance;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInstance cancel(TaskInstance task) {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance = context.getTaskInstance(task.getId());
            this.startAuthenticationLog(instance.getToken());
            instance.cancel();
            this.endAuthenticationLog(instance.getToken());
            context.save(instance);
            TaskInstance taskInstance = VOFactory.newTaskInstance(instance);
            return taskInstance;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInstance delegateTaskToUser(TaskInstance task, String username) {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance = context.getTaskInstance(task.getId());
            this.startAuthenticationLog(instance.getToken());
            instance.setActorId(username);
            this.endAuthenticationLog(instance.getToken());
            context.save(instance);
            TaskInstance taskInstance = VOFactory.newTaskInstance(instance);
            return taskInstance;
        }
        finally {
            this.flushContext();
        }
    }

    public TaskInstance executeTask(TaskInstance task, String transitionName) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance = this.doUpdate(context, task);
            this.startAuthenticationLog(instance.getToken());
            instance.end(transitionName);
            this.endAuthenticationLog(instance.getToken());
            context.save(instance);
            TaskInstance taskInstance = VOFactory.newTaskInstance(instance);
            return taskInstance;
        }
        catch (Exception e) {
            this.markForRollback();
            throw new BPMException("Error during transition: ", (Throwable)e, -1);
        }
        finally {
            this.flushContext();
        }
    }

    private void markForRollback() {
        try {
            this.context.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            throw new EJBException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findGroupTasks() throws BPMException {
        JbpmContext context = this.getContext();
        try {
            AltresTasques altresTasques = new AltresTasques(){

                public List findAltresTasques(JbpmContext context, String usuariId, Collection altresIds) {
                    Vector<TaskInstance> tasques = new Vector<TaskInstance>();
                    org.hibernate.Query q = context.getSession().createQuery("select distinct ti.id from org.jbpm.taskmgmt.exe.TaskInstance ti join ti.pooledActors pooledActor where pooledActor.actorId in ( :actorIds ) and ti.actorId is not null and ti.actorId != :myself and ti.isSuspended != true and ti.isCancelled != true and ti.isOpen = true");
                    q.setParameterList("actorIds", altresIds);
                    q.setParameter("myself", (Object)usuariId);
                    Iterator i = q.list().iterator();
                    while (i.hasNext()) {
                        Long taskInstanceId = (Long)i.next();
                        org.jbpm.taskmgmt.exe.TaskInstance instance = context.getTaskInstance(taskInstanceId.longValue());
                        try {
                            if (instance == null) {
                                BPMEngineBean.this.log.warn((Object)("Unable to load task " + taskInstanceId));
                                continue;
                            }
                            tasques.add(VOFactory.newTaskInstance(instance));
                        }
                        catch (RuntimeException e) {
                            BPMEngineBean.this.log.warn((Object)("Unable to deserialize task " + instance.getId()), (Throwable)e);
                        }
                    }
                    return tasques;
                }
            };
            Vector v = this.getUserGroups(context);
            if (v.size() <= 1000) {
                List list = altresTasques.findAltresTasques(context, this.getUserName(), v);
                return list;
            }
            Vector tasks = new Vector();
            tasks.addAll(altresTasques.findAltresTasques(context, this.getUserName(), v.subList(0, 1000)));
            ArrayList<Integer> posicions = new ArrayList<Integer>();
            int posFin = 1000;
            while (posFin < v.size()) {
                posicions.add(new Integer(posFin));
                if (posFin + 1000 < v.size()) {
                    posFin += 1000;
                    continue;
                }
                posFin = v.size();
                posicions.add(new Integer(posFin));
            }
            for (int i = 0; i < posicions.size() - 1; ++i) {
                List tasques = altresTasques.findAltresTasques(context, this.getUserName(), v.subList((Integer)posicions.get(i), (Integer)posicions.get(i + 1)));
                tasks.addAll(tasques);
            }
            Vector vector = tasks;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    private Vector getUserGroups(JbpmContext context) throws BPMException {
        Timer t1 = new Timer();
        if (this.userGroups != null && this.userGroups.size() != 0) {
            return this.userGroups;
        }
        this.userGroups = new Vector();
        this.userGroups.add(this.getUserName());
        IdentitySession session = new IdentitySession(this.getContext().getSession());
        User user = session.getUserByName(this.userName);
        if (user == null && this.userName != null || this.isInternalService()) {
            this.userGroups.add("anonymous");
        } else {
            if (user == null) {
                throw new BPMException("Usuari amb codi '" + this.userName + "' no trobat al sistema JBPM.", null, 0);
            }
            Iterator it = user.getMemberships().iterator();
            while (it.hasNext()) {
                Membership member = (Membership)it.next();
                Group group = member.getGroup();
                if (member.getRole() == null) {
                    this.userGroups.add(group.getName());
                    continue;
                }
                this.addGroupRecursive(this.userGroups, group, member.getRole());
            }
        }
        t1.logTime("BPM-BEAN.getUserGroups", Integer.parseInt(System.getProperty("es.caib.ibkey.timer.databaseTask.milis", "1000")));
        return this.userGroups;
    }

    private String getUserName() {
        return this.userName;
    }

    private void addGroupRecursive(Vector v, Group group, String role) {
        v.add(group.getName() + "/" + role);
        Iterator it = group.getChildren().iterator();
        while (it.hasNext()) {
            Group child = (Group)it.next();
            this.addGroupRecursive(v, child, role);
        }
    }

    public List findInitiatorProcessDefinitions() throws BPMException {
        return this.findProcessDefinitionByRole(INITIATOR_ROLE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findProcessDefinitionByRole(String role, boolean onlyEnabled) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            Vector<es.caib.bpm.vo.ProcessDefinition> resultadoFinal = new Vector<es.caib.bpm.vo.ProcessDefinition>();
            Iterator it = context.getGraphSession().findLatestProcessDefinitions().iterator();
            while (it.hasNext()) {
                es.caib.bpm.vo.ProcessDefinition def;
                ProcessDefinition definition = (ProcessDefinition)it.next();
                if (!business.isUserAuthorized(role, this.getUserGroups(context), definition) || !(def = VOFactory.newProcessDefinition(definition, context)).isEnabled() && onlyEnabled) continue;
                resultadoFinal.add(def);
            }
            Vector<es.caib.bpm.vo.ProcessDefinition> vector = resultadoFinal;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findMyProcesses() {
        JbpmContext context = this.getContext();
        try {
            Vector<es.caib.bpm.vo.ProcessInstance> resultadoFinal = new Vector<es.caib.bpm.vo.ProcessInstance>();
            Session session = context.getSession();
            org.hibernate.Query query = session.createQuery("select pi from org.jbpm.graph.exe.ProcessInstance as pi where pi.end is null order by pi.start desc");
            Iterator it = query.iterate();
            while (it.hasNext()) {
                ProcessInstance instance = (ProcessInstance)it.next();
                List logs = instance.getLoggingInstance().getLogs(class$org$jbpm$graph$log$ProcessInstanceCreateLog == null ? BPMEngineBean.class$("org.jbpm.graph.log.ProcessInstanceCreateLog") : class$org$jbpm$graph$log$ProcessInstanceCreateLog);
                if (logs.size() <= 0) continue;
                ProcessInstanceCreateLog log = (ProcessInstanceCreateLog)logs.get(0);
                if (!this.getUserName().equals(log.getActorId())) continue;
                resultadoFinal.add(VOFactory.newProcessInstance(instance));
            }
            Vector<es.caib.bpm.vo.ProcessInstance> vector = resultadoFinal;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findNewTasks() throws BPMException {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance;
            Vector<TaskInstance> resultadoFinal = new Vector<TaskInstance>();
            List tasks = context.getTaskMgmtSession().findPooledTaskInstances((List)this.getUserGroups(context));
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (instance.getStart() != null || !instance.isOpen() || instance.isCancelled()) continue;
                try {
                    resultadoFinal.add(VOFactory.newTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to desearilize task " + instance.getId()), (Throwable)e);
                }
            }
            tasks = context.getTaskMgmtSession().findTaskInstances(this.getUserName());
            it = tasks.iterator();
            while (it.hasNext()) {
                instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (instance.getStart() != null || !instance.isOpen() || instance.isCancelled()) continue;
                try {
                    resultadoFinal.add(VOFactory.newTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to desearilize task " + instance.getId()), (Throwable)e);
                }
            }
            Vector<TaskInstance> vector = resultadoFinal;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    public List findObserverProcessDefinitions() throws BPMException {
        return this.findProcessDefinitionByRole(OBSERVER_ROLE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findOpenTasks() throws BPMException {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance;
            Vector<TaskInstance> resultadoFinal = new Vector<TaskInstance>();
            List tasks = context.getTaskMgmtSession().findPooledTaskInstances((List)this.getUserGroups(context));
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (instance.getStart() == null || !instance.isOpen() || instance.isCancelled()) continue;
                try {
                    resultadoFinal.add(VOFactory.newTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to serialize task " + instance.getId()), (Throwable)e);
                }
            }
            tasks = context.getTaskMgmtSession().findTaskInstances(this.getUserName());
            it = tasks.iterator();
            while (it.hasNext()) {
                instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (instance.getStart() == null || !instance.isOpen() || instance.isCancelled()) continue;
                try {
                    resultadoFinal.add(VOFactory.newTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to serialize task " + instance.getId()), (Throwable)e);
                }
            }
            Vector<TaskInstance> vector = resultadoFinal;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findMyTasks() throws BPMException {
        JbpmContext context = this.getContext();
        try {
            Vector<TaskInstance> resultadoFinal = new Vector<TaskInstance>();
            List tasks = null;
            Vector userGroups = this.getUserGroups(context);
            if (userGroups.size() <= 1000) {
                tasks = context.getTaskMgmtSession().findPooledTaskInstances((List)this.getUserGroups(context));
            } else {
                tasks = context.getTaskMgmtSession().findPooledTaskInstances(userGroups.subList(0, 1000));
                if (tasks.isEmpty()) {
                    tasks = new ArrayList();
                }
                ArrayList<Integer> posicions = new ArrayList<Integer>();
                int posFin = 1000;
                while (posFin < userGroups.size()) {
                    posicions.add(new Integer(posFin));
                    if (posFin + 1000 < userGroups.size()) {
                        posFin += 1000;
                        continue;
                    }
                    posFin = userGroups.size();
                    posicions.add(new Integer(posFin));
                }
                for (int i = 0; i < posicions.size() - 1; ++i) {
                    List tasques = context.getTaskMgmtSession().findPooledTaskInstances(userGroups.subList((Integer)posicions.get(i), (Integer)posicions.get(i + 1)));
                    tasks.addAll(tasques);
                }
            }
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                org.jbpm.taskmgmt.exe.TaskInstance instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (!instance.isOpen() || instance.isCancelled()) continue;
                try {
                    resultadoFinal.add(VOFactory.newTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to serialize task " + instance.getId()), (Throwable)e);
                }
            }
            tasks = context.getTaskMgmtSession().findTaskInstances(this.getUserName());
            it = tasks.iterator();
            while (it.hasNext()) {
                org.jbpm.taskmgmt.exe.TaskInstance instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (!instance.isOpen() || instance.isCancelled()) continue;
                try {
                    resultadoFinal.add(VOFactory.newTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to serialize task " + instance.getId()), (Throwable)e);
                }
            }
            Vector<TaskInstance> vector = resultadoFinal;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findMyTasksLightweight() throws BPMException {
        JbpmContext context = this.getContext();
        Timer t2 = new Timer();
        Timer t1 = new Timer(new Timer[]{t2});
        try {
            Vector<Object> resultadoFinal = new Vector<Object>();
            List tasks = null;
            Vector userGroups = this.getUserGroups(context);
            t1.reset();
            if (userGroups.size() <= 1000) {
                tasks = context.getTaskMgmtSession().findPooledTaskInstances((List)this.getUserGroups(context));
            } else {
                tasks = context.getTaskMgmtSession().findPooledTaskInstances(userGroups.subList(0, 1000));
                if (tasks.isEmpty()) {
                    tasks = new ArrayList();
                }
                ArrayList<Integer> posicions = new ArrayList<Integer>();
                int posFin = 1000;
                while (posFin < userGroups.size()) {
                    posicions.add(new Integer(posFin));
                    if (posFin + 1000 < userGroups.size()) {
                        posFin += 1000;
                        continue;
                    }
                    posFin = userGroups.size();
                    posicions.add(new Integer(posFin));
                }
                for (int i = 0; i < posicions.size() - 1; ++i) {
                    List tasques = context.getTaskMgmtSession().findPooledTaskInstances(userGroups.subList((Integer)posicions.get(i), (Integer)posicions.get(i + 1)));
                    tasks.addAll(tasques);
                }
            }
            t1.logTime("findMyTasksLightweight.findPooledTaskInstances", Integer.parseInt(System.getProperty("es.caib.ibkey.timer.databaseTask.milis", "1000")));
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                org.jbpm.taskmgmt.exe.TaskInstance instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (!instance.isOpen() || instance.isCancelled()) continue;
                try {
                    resultadoFinal.add(VOFactory.newLightweightTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to serialize task " + instance.getId()), (Throwable)e);
                }
            }
            t1.reset();
            tasks = context.getTaskMgmtSession().findTaskInstances(this.getUserName());
            t1.logTime("findMyTasksLightweight.findTaskInstances", Integer.parseInt(System.getProperty("es.caib.ibkey.timer.databaseTask.milis", "1000")));
            it = tasks.iterator();
            while (it.hasNext()) {
                org.jbpm.taskmgmt.exe.TaskInstance instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                if (!instance.isOpen() || instance.isCancelled()) continue;
                try {
                    resultadoFinal.add(VOFactory.newLightweightTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to serialize task " + instance.getId()), (Throwable)e);
                }
            }
            Vector<Object> vector = resultadoFinal;
            return vector;
        }
        finally {
            t1.reset();
            this.flushContext();
            t1.logTime("findMyTasksLightweight.flushContext", Integer.parseInt(System.getProperty("es.caib.ibkey.timer.databaseTask.milis", "1000")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findProcessDefinitions(String name, boolean onlyLastVersions) {
        JbpmContext context = this.getContext();
        try {
            List<ProcessDefinition> definitions;
            Vector<es.caib.bpm.vo.ProcessDefinition> resultadoFinal = new Vector<es.caib.bpm.vo.ProcessDefinition>();
            if (name == null && onlyLastVersions) {
                definitions = context.getGraphSession().findLatestProcessDefinitions();
            } else if (name == null && !onlyLastVersions) {
                definitions = context.getGraphSession().findAllProcessDefinitions();
            } else if (onlyLastVersions) {
                definitions = new Vector();
                ProcessDefinition def = context.getGraphSession().findLatestProcessDefinition(name);
                if (def != null) {
                    definitions.add(def);
                }
            } else {
                definitions = context.getGraphSession().findAllProcessDefinitionVersions(name);
            }
            Iterator it = definitions.iterator();
            while (it.hasNext()) {
                ProcessDefinition def = (ProcessDefinition)it.next();
                resultadoFinal.add(VOFactory.newProcessDefinition(def, context));
            }
            Vector<es.caib.bpm.vo.ProcessDefinition> vector = resultadoFinal;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findProcessInstances(List definitions, String processId, String estado, String actor, Date startDate, boolean finalizada) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            org.hibernate.Query query = context.getSession().getNamedQuery("searchProcessInstance");
            if (definitions != null) {
                try {
                    query.setParameterList("id", ColeccionesUtils.getValorCampoElemento(definitions, "getId"));
                }
                catch (Exception ex) {
                    throw new InvalidParameterException(BPMErrorCodes.PARAMETRO_INVALIDO);
                }
            }
            if (!processId.trim().equals("")) {
                query.setParameter("processId", (Object)new Long(processId));
            } else {
                query.setParameter("processId", (Object)new Long(-1L));
            }
            query.setParameter("estado", (Object)estado);
            if (finalizada) {
                query.setParameter("finalizada", (Object)"FINALIZADA");
            } else {
                query.setParameter("finalizada", null);
            }
            try {
                if (startDate != null) {
                    query.setParameter("fechaDesde", (Object)FechaUtils.establecerFechaInicioDia(startDate));
                    query.setParameter("fechaHasta", (Object)FechaUtils.establecerFechaFinDia(startDate));
                } else {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);
                    query.setParameter("fechaDesde", (Object)new Date(0L));
                    query.setParameter("fechaHasta", (Object)calendar.getTime());
                }
            }
            catch (Exception ex) {
                throw new InvalidParameterException(BPMErrorCodes.PARAMETRO_INVALIDO);
            }
            ArrayList<es.caib.bpm.vo.ProcessInstance> resultado = new ArrayList<es.caib.bpm.vo.ProcessInstance>();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            Iterator it = query.iterate();
            while (it.hasNext()) {
                ProcessInstance p = (ProcessInstance)it.next();
                try {
                    if (!business.isUserAuthorized(OBSERVER_ROLE, this.getUserGroups(context), p.getProcessDefinition()) && !business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), p.getProcessDefinition())) continue;
                    resultado.add(VOFactory.newProcessInstance(p));
                }
                catch (JbpmException e) {
                    this.log.warn((Object)e);
                }
            }
            ArrayList<es.caib.bpm.vo.ProcessInstance> arrayList = resultado;
            return arrayList;
        }
        finally {
            this.flushContext();
        }
    }

    public List searchProcessInstances(String query, String startDate, String endDate, boolean finished) throws BPMException {
        JbpmContext context = this.getContext();
        ArrayList<es.caib.bpm.vo.ProcessInstance> resultado = new ArrayList<es.caib.bpm.vo.ProcessInstance>();
        try {
            TopDocs hits;
            IndexSearcher is = new IndexSearcher(DirectoryFactory.getDirectory(context.getSession()));
            QueryParser qp = new QueryParser(Version.LUCENE_30, "$contents", DirectoryFactory.getAnalyzer());
            Query q = qp.parse(query);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String dataInici = null;
            String dataFi = null;
            if (startDate != null && !"".equals(startDate)) {
                dataInici = startDate;
            } else {
                Calendar dataIniciWF = Calendar.getInstance();
                dataIniciWF.set(2005, 1, 1);
                dataInici = sdf.format(dataIniciWF.getTime());
            }
            if (endDate != null && !"".equals(endDate)) {
                dataFi = endDate;
            } else {
                if (dataInici != null) {
                    try {
                        Date d_dataInici = sdf.parse(dataInici);
                        Calendar dema = Calendar.getInstance();
                        dema.set(11, 0);
                        dema.set(12, 0);
                        dema.set(13, 0);
                        dema.set(14, 0);
                        dema.add(5, 1);
                        if (d_dataInici.getTime() >= dema.getTimeInMillis()) {
                            throw new BPMException("Error: No es permet que la Data d'Inici siga posterior a hui", -1);
                        }
                    }
                    catch (java.text.ParseException ex) {
                        // empty catch block
                    }
                }
                Calendar dema = Calendar.getInstance();
                dema.add(5, 2);
                dataFi = sdf.format(dema.getTime());
            }
            BooleanFilter b = new BooleanFilter();
            boolean complexQuery = false;
            if (startDate != null && !"".equals(startDate)) {
                TermRangeFilter fstart = new TermRangeFilter("$startDate", dataInici, dataFi, true, true);
                b.add(new FilterClause((Filter)fstart, BooleanClause.Occur.MUST));
                complexQuery = true;
            }
            if (endDate != null && !"".equals(endDate)) {
                TermRangeFilter fend = new TermRangeFilter("$endDate", dataInici, dataFi, true, true);
                b.add(new FilterClause((Filter)fend, BooleanClause.Occur.MUST));
                complexQuery = true;
            }
            if (!finished) {
                TermsFilter f = new TermsFilter();
                f.addTerm(new Term("$end", "false"));
                b.add(new FilterClause((Filter)f, BooleanClause.Occur.MUST));
                complexQuery = true;
                hits = complexQuery ? is.search(q, (Filter)b, 1000) : is.search(q, (Filter)f, 1000);
            } else {
                hits = complexQuery ? is.search(q, (Filter)b, 1000) : is.search(q, 1000);
            }
            for (int i = 0; i < hits.totalHits; ++i) {
                int id = hits.scoreDocs[i].doc;
                org.apache.lucene.document.Document d = is.getIndexReader().document(id);
                Field f = d.getField("$id");
                if (f == null) continue;
                long processId = Long.parseLong(f.stringValue());
                try {
                    es.caib.bpm.vo.ProcessInstance proc = this.getProcess(processId);
                    if (proc == null) continue;
                    resultado.add(proc);
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            is.close();
            ArrayList<es.caib.bpm.vo.ProcessInstance> arrayList = resultado;
            return arrayList;
        }
        catch (CorruptIndexException e) {
            throw new BPMException("Error intern. \u00cdndex corrupte", (Throwable)e, -1);
        }
        catch (IOException e) {
            throw new BPMException("Error intern. \u00cdndex corrupte", (Throwable)e, -1);
        }
        catch (ParseException e) {
            throw new BPMException("Error al par\u00e0metre de cerca: " + e.getMessage(), -1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BPMException("Massa registres trobats: \u00e9s necessari donar un filtre m\u00e9s restrictiu.", -1);
        }
        catch (Exception e) {
            throw new BPMException("Error: " + e.getMessage(), -1);
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findProcessInstances(es.caib.bpm.vo.ProcessDefinition def) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            Vector<es.caib.bpm.vo.ProcessInstance> resultadoFinal = new Vector<es.caib.bpm.vo.ProcessInstance>();
            ProcessDefinition definition = context.getGraphSession().getProcessDefinition(def.getId());
            if (business.isUserAuthorized(OBSERVER_ROLE, this.getUserGroups(context), definition) || business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), definition)) {
                Iterator it = context.getGraphSession().findProcessInstances(definition.getId()).iterator();
                while (it.hasNext()) {
                    ProcessInstance instance = (ProcessInstance)it.next();
                    try {
                        resultadoFinal.add(VOFactory.newProcessInstance(instance));
                    }
                    catch (JbpmException e) {
                        this.log.warn((Object)e);
                    }
                }
            }
            Vector<es.caib.bpm.vo.ProcessInstance> vector = resultadoFinal;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    public List findSupervisorProcessDefinitions() throws BPMException {
        return this.findProcessDefinitionByRole(SUPERVISOR_ROLE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findTaskDefinitions(es.caib.bpm.vo.ProcessDefinition def) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            Vector<TaskDefinition> resultadoFinal = new Vector<TaskDefinition>();
            ProcessDefinition definition = context.getGraphSession().getProcessDefinition(def.getId());
            if (business.isUserAuthorized(OBSERVER_ROLE, this.getUserGroups(context), definition) || business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), definition)) {
                Iterator it = definition.getNodes().iterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (!(n instanceof TaskNode)) continue;
                    TaskNode tn = (TaskNode)n;
                    Iterator it2 = tn.getTasks().iterator();
                    while (it2.hasNext()) {
                        Task task = (Task)it2.next();
                        resultadoFinal.add(VOFactory.newTaskDefinition(task));
                    }
                }
            }
            Vector<TaskDefinition> vector = resultadoFinal;
            return vector;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findTasks(List def, TaskDefinition task, String actor, Date processStartDate, Date taskCreationDate, boolean finalizada) throws BPMException {
        JbpmContext context = this.getContext();
        Vector<TaskInstance> resultado = new Vector<TaskInstance>();
        org.hibernate.Query query = null;
        Object searchObjects = null;
        GregorianCalendar calendar = null;
        try {
            query = context.getSession().getNamedQuery("searchTasksInstance");
            if (def != null) {
                try {
                    query.setParameterList("processId", ColeccionesUtils.getValorCampoElemento(def, "getId"));
                }
                catch (Exception e) {
                    throw new InvalidParameterException(BPMErrorCodes.PARAMETRO_INVALIDO);
                }
            }
            query.setParameter("processInstanceId", (Object)new Long(-1L));
            if (task != null) {
                query.setParameter("taskId", (Object)new Long(task.getId()));
            } else {
                query.setParameter("taskId", (Object)new Long(-1L));
            }
            if (finalizada) {
                query.setParameter("finalizada", (Object)"FINALIZADA");
            } else {
                query.setParameter("finalizada", null);
            }
            query.setParameter("actor", (Object)actor);
            try {
                if (processStartDate != null) {
                    query.setParameter("fechaDesdeProceso", (Object)FechaUtils.establecerFechaInicioDia(processStartDate));
                    query.setParameter("fechaHastaProceso", (Object)FechaUtils.establecerFechaFinDia(processStartDate));
                } else {
                    calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);
                    query.setParameter("fechaDesdeProceso", (Object)new Date(0L));
                    query.setParameter("fechaHastaProceso", (Object)calendar.getTime());
                }
                if (taskCreationDate != null) {
                    query.setParameter("fechaDesde", (Object)FechaUtils.establecerFechaInicioDia(taskCreationDate));
                    query.setParameter("fechaHasta", (Object)FechaUtils.establecerFechaFinDia(taskCreationDate));
                } else {
                    calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);
                    query.setParameter("fechaDesde", (Object)new Date(0L));
                    query.setParameter("fechaHasta", (Object)calendar.getTime());
                }
            }
            catch (Exception ex) {
                throw new InvalidParameterException(BPMErrorCodes.PARAMETRO_INVALIDO);
            }
            resultado = new Vector();
            Iterator it = query.list().iterator();
            while (it.hasNext()) {
                org.jbpm.taskmgmt.exe.TaskInstance instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                try {
                    resultado.add(VOFactory.newTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Unable to serialize task " + instance.getId()), (Throwable)e);
                }
            }
        }
        finally {
            this.flushContext();
        }
        return resultado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findTasks(List def, String processId, TaskDefinition task, String actor, Date processStartDate, Date taskCreationDate, boolean finalizada) throws BPMException {
        JbpmContext context = this.getContext();
        Vector<TaskInstance> resultado = new Vector<TaskInstance>();
        org.hibernate.Query query = null;
        Object searchObjects = null;
        GregorianCalendar calendar = null;
        try {
            query = context.getSession().getNamedQuery("searchTasksInstance");
            if (def != null) {
                try {
                    query.setParameterList("processId", ColeccionesUtils.getValorCampoElemento(def, "getId"));
                }
                catch (Exception e) {
                    throw new InvalidParameterException(BPMErrorCodes.PARAMETRO_INVALIDO);
                }
            } else {
                def.add(new Integer(-1));
                query.setParameter("processId", (Object)def);
            }
            if (!processId.trim().equals("")) {
                query.setParameter("processInstanceId", (Object)new Long(processId));
            } else {
                query.setParameter("processInstanceId", (Object)new Long(-1L));
            }
            if (task != null) {
                query.setParameter("taskId", (Object)new Long(task.getId()));
            } else {
                query.setParameter("taskId", (Object)new Long(-1L));
            }
            if (finalizada) {
                query.setParameter("finalizada", (Object)"FINALIZADA");
            } else {
                query.setParameter("finalizada", null);
            }
            query.setParameter("actor", (Object)actor);
            try {
                if (processStartDate != null) {
                    query.setParameter("fechaDesdeProceso", (Object)FechaUtils.establecerFechaInicioDia(processStartDate));
                    query.setParameter("fechaHastaProceso", (Object)FechaUtils.establecerFechaFinDia(processStartDate));
                } else {
                    calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);
                    query.setParameter("fechaDesdeProceso", (Object)new Date(0L));
                    query.setParameter("fechaHastaProceso", (Object)calendar.getTime());
                }
                if (taskCreationDate != null) {
                    query.setParameter("fechaDesde", (Object)FechaUtils.establecerFechaInicioDia(taskCreationDate));
                    query.setParameter("fechaHasta", (Object)FechaUtils.establecerFechaFinDia(taskCreationDate));
                } else {
                    calendar = new GregorianCalendar();
                    calendar.set(2200, 1, 1);
                    query.setParameter("fechaDesde", (Object)new Date(0L));
                    query.setParameter("fechaHasta", (Object)calendar.getTime());
                }
            }
            catch (Exception ex) {
                throw new InvalidParameterException(BPMErrorCodes.PARAMETRO_INVALIDO);
            }
            resultado = new Vector();
            Iterator it = query.list().iterator();
            while (it.hasNext()) {
                org.jbpm.taskmgmt.exe.TaskInstance instance = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                try {
                    resultado.add(VOFactory.newTaskInstance(instance));
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)e);
                }
            }
        }
        finally {
            this.flushContext();
        }
        return resultado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public es.caib.bpm.vo.ProcessDefinition getDefinition(es.caib.bpm.vo.ProcessInstance process) {
        JbpmContext context = this.getContext();
        try {
            ProcessInstance instance = context.getProcessInstance(process.getId());
            es.caib.bpm.vo.ProcessDefinition processDefinition = VOFactory.newProcessDefinition(instance.getProcessDefinition(), context);
            return processDefinition;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDefinition getDefinition(TaskInstance task) {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance = context.loadTaskInstance(task.getId());
            TaskDefinition taskDefinition = VOFactory.newTaskDefinition(instance.getTask());
            return taskDefinition;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public es.caib.bpm.vo.ProcessInstance getProcessInstance(TaskInstance task) {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance = context.loadTaskInstance(task.getId());
            es.caib.bpm.vo.ProcessInstance processInstance = VOFactory.newProcessInstance(instance.getToken().getProcessInstance());
            return processInstance;
        }
        finally {
            this.flushContext();
        }
    }

    public es.caib.bpm.vo.ProcessInstance newProcess(es.caib.bpm.vo.ProcessDefinition def) throws BPMException {
        return this.newProcess(def, true);
    }

    public es.caib.bpm.vo.ProcessInstance newProcess(es.caib.bpm.vo.ProcessDefinition def, boolean start) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessDefinition definition = context.getGraphSession().findLatestProcessDefinition(def.getName());
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            if (!this.isInternalService() && !business.isUserAuthorized(INITIATOR_ROLE, this.getUserGroups(context), definition)) {
                throw new SecurityException("No autoritzat a crear el proc\u00e9s");
            }
            ProcessDefinitionProperty prop = this.getProcessDefinitionDisabledProperty(context, definition);
            if (prop != null && "true".equals(prop.getValue())) {
                throw new BPMException("This process has been disabled", 2);
            }
            ProcessInstance pi = new ProcessInstance(definition);
            if (start) {
                this.startAuthenticationLog(pi.getRootToken());
                pi.signal();
                this.endAuthenticationLog(pi.getRootToken());
                context.save(pi);
            }
            es.caib.bpm.vo.ProcessInstance processInstance = VOFactory.newProcessInstance(pi);
            return processInstance;
        }
        catch (Exception e) {
            this.markForRollback();
            if (e instanceof BPMException) {
                throw (BPMException)e;
            }
            throw new BPMException("No pot crear el proc\u00e9s", (Throwable)e, -1);
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(es.caib.bpm.vo.ProcessInstance process) throws BPMException {
        block9: {
            JbpmContext context = this.getContext();
            try {
                ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
                business.setContext(context);
                ProcessInstance pi = context.loadProcessInstance(process.getId());
                if (!this.isInternalService() && pi.getRootToken().getNode().getId() != pi.getProcessDefinition().getStartState().getId()) {
                    throw new BPMException("No es pot modificar un proc\u00e9s ja iniciat", -1);
                }
                if (this.isInternalService() || business.isUserAuthorized(INITIATOR_ROLE, this.getUserGroups(context), pi.getProcessDefinition())) {
                    Object value;
                    String key;
                    Iterator it;
                    ContextInstance ctx = pi.getContextInstance();
                    HashMap map = new HashMap();
                    this.startAuthenticationLog(pi.getRootToken());
                    if (process.getVariables() != null) {
                        map.putAll(process.getVariables());
                    }
                    if (ctx.getVariables() != null) {
                        it = ctx.getVariables().keySet().iterator();
                        while (it.hasNext()) {
                            key = (String)it.next();
                            value = map.get(key);
                            ctx.setVariable(key, value);
                            map.remove(key);
                        }
                    }
                    it = map.keySet().iterator();
                    while (it.hasNext()) {
                        key = (String)it.next();
                        value = map.get(key);
                        ctx.setVariable(key, value);
                    }
                    this.endAuthenticationLog(pi.getRootToken());
                    context.save(pi);
                    break block9;
                }
                throw new SecurityException("Not authorized");
            }
            finally {
                this.flushContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(es.caib.bpm.vo.ProcessInstance process) throws BPMException {
        block5: {
            JbpmContext context = this.getContext();
            try {
                ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
                business.setContext(context);
                ProcessInstance pi = context.loadProcessInstance(process.getId());
                if (pi.getRootToken().getNode().getId() != pi.getProcessDefinition().getStartState().getId()) {
                    throw new BPMException("No es pot modificar un proc\u00e9s ja iniciat", -1);
                }
                if (!this.isInternalService() || business.isUserAuthorized(INITIATOR_ROLE, this.getUserGroups(context), pi.getProcessDefinition())) {
                    this.startAuthenticationLog(pi.getRootToken());
                    pi.signal();
                    this.endAuthenticationLog(pi.getRootToken());
                    context.save(pi);
                    break block5;
                }
                throw new SecurityException("Not authorized");
            }
            finally {
                this.flushContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInstance reserveTask(TaskInstance task) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            org.jbpm.taskmgmt.exe.TaskInstance ti = context.loadTaskInstance(task.getId());
            this.startAuthenticationLog(ti.getToken());
            if (!business.canAccess(this.getUserGroups(context), ti)) {
                throw new SecurityException("Not authorized");
            }
            ti.setActorId(this.getUserName());
            this.endAuthenticationLog(ti.getToken());
            context.save(ti);
            TaskInstance taskInstance = VOFactory.newTaskInstance(ti);
            return taskInstance;
        }
        finally {
            this.flushContext();
        }
    }

    public int[] getCoordinates(TaskInstance task) throws DocumentException {
        TaskNode node = null;
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance = context.getTaskInstance(task.getId());
            node = instance.getTask().getTaskNode();
            int[] nArray = this.getCoordinates((Node)node);
            return nArray;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    public int[] getCoordinates(es.caib.bpm.vo.ProcessInstance processVO) throws DocumentException {
        Node node = null;
        JbpmContext context = this.getContext();
        try {
            ProcessInstance pi = context.getProcessInstance(processVO.getId());
            node = pi.getRootToken().getNode();
            int[] nArray = this.getCoordinates(node);
            return nArray;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    private int[] getCoordinates(Node node) throws DocumentException {
        int[] result = new int[4];
        if (node != null) {
            ProcessDefinition definition = node.getProcessDefinition();
            byte[] resultado = definition.getFileDefinition().getBytes("gpd.xml");
            String nodeName = node.getName();
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)new ByteArrayInputStream(resultado));
            DefaultXPath xPath = new DefaultXPath("//node[@name='" + nodeName.replaceAll("'", "&apos;") + "']");
            Element domNode = (Element)xPath.selectSingleNode((Object)doc);
            if (domNode == null) {
                result[3] = 0;
                result[2] = 0;
                result[1] = 0;
                result[0] = 0;
            } else {
                result[0] = Integer.valueOf(domNode.attribute("x").getValue());
                result[1] = Integer.valueOf(domNode.attribute("y").getValue());
                result[2] = Integer.valueOf(domNode.attribute("width").getValue());
                result[3] = Integer.valueOf(domNode.attribute("height").getValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public es.caib.bpm.vo.ProcessDefinition getProcessDefinition(es.caib.bpm.vo.ProcessInstance process) {
        JbpmContext context = this.getContext();
        try {
            ProcessInstance instance = context.loadProcessInstance(process.getId());
            ProcessDefinition definition = instance.getProcessDefinition();
            es.caib.bpm.vo.ProcessDefinition processDefinition = VOFactory.newProcessDefinition(definition, context);
            return processDefinition;
        }
        finally {
            this.flushContext();
        }
    }

    public byte[] getProcessDefinitionImage(es.caib.bpm.vo.ProcessDefinition def) {
        JbpmContext context = this.getContext();
        Object resultado = null;
        try {
            ProcessDefinition definition = context.getGraphSession().getProcessDefinition(def.getId());
            byte[] byArray = definition.getFileDefinition().getBytes("processimage.jpg");
            return byArray;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * Exception decompiling
     */
    public String getUI(es.caib.bpm.vo.ProcessInstance procVO) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUI(TaskInstance task) {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.taskmgmt.exe.TaskInstance instance = context.getTaskInstance(task.getId());
            ProcessDefinition pd = instance.getContextInstance().getProcessInstance().getProcessDefinition();
            FileDefinition fd = pd.getFileDefinition();
            String url = this.getUIfor(context, pd, instance.getTask().getName());
            if (url != null) {
                byte[] ba = fd.getBytes(url);
                try {
                    if (ba != null) {
                        String string = new String(ba, "UTF-8");
                        return string;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            String name = "ui/" + task.getName().replaceAll(" ", "[ _\\\\-.]?") + "\\..+";
            Pattern p = Pattern.compile(name, 2);
            Map map = fd.getBytesMap();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!p.matcher(key).matches()) continue;
                byte[] ba = (byte[])map.get(key);
                try {
                    if (ba == null) continue;
                    String string = new String(ba, "UTF-8");
                    return string;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            String string = null;
            return string;
        }
        finally {
            this.flushContext();
        }
    }

    private String getUIfor(JbpmContext context, ProcessDefinition pd, String taskName) {
        Criteria busqueda = context.getSession().createCriteria(class$es$caib$bpm$entity$UserInterface == null ? (class$es$caib$bpm$entity$UserInterface = BPMEngineBean.class$("es.caib.bpm.entity.UserInterface")) : class$es$caib$bpm$entity$UserInterface);
        busqueda.add((Criterion)Restrictions.eq((String)"processDefinitionId", (Object)new Long(pd.getId())));
        busqueda.add((Criterion)Restrictions.eq((String)"tarea", (Object)taskName));
        List resultado = busqueda.list();
        Iterator it = resultado.iterator();
        if (it.hasNext()) {
            UserInterface ui = (UserInterface)it.next();
            return ui.getFileName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUIClassesForTask(es.caib.bpm.vo.ProcessDefinition def) throws SQLException, IOException {
        JbpmContext context = this.getContext();
        try {
            ProcessDefinition process = context.getGraphSession().getProcessDefinition(def.getId());
            FileDefinition fd = process.getFileDefinition();
            Map map = fd.getBytesMap();
            HashMap<String, byte[]> newMap = new HashMap<String, byte[]>();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                byte[] ba;
                String key = (String)it.next();
                if (!key.startsWith("classes/") || (ba = (byte[])map.get(key)) == null) continue;
                String resource = key.substring(8);
                newMap.put(resource, ba);
            }
            HashMap<String, byte[]> hashMap = newMap;
            return hashMap;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(es.caib.bpm.vo.ProcessInstance process, String resource) {
        JbpmContext context = this.getContext();
        try {
            ProcessInstance instance = context.loadProcessInstance(process.getId());
            ProcessDefinition definition = instance.getProcessDefinition();
            InputStream inputStream = definition.getFileDefinition().getInputStream(resource);
            return inputStream;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInstance startTask(TaskInstance task) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            org.jbpm.taskmgmt.exe.TaskInstance ti = context.loadTaskInstance(task.getId());
            if (business.canAccess(this.getUserGroups(context), ti)) {
                this.startAuthenticationLog(ti.getToken());
                if (ti.getStart() == null) {
                    ti.start(this.getUserName());
                } else {
                    ti.setActorId(this.getUserName());
                }
            } else {
                throw new SecurityException("Not authorized");
            }
            this.endAuthenticationLog(ti.getToken());
            context.save(ti);
            TaskInstance taskInstance = VOFactory.newTaskInstance(ti);
            return taskInstance;
        }
        finally {
            this.flushContext();
        }
    }

    public void remove() throws RemoveException, EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] deployProcessParDefinition(File tempFile) throws BPMException, IOException, LoginException, XPathExpressionException, ParserConfigurationException, FactoryConfigurationError, SAXException, NamingException, CreateException, DocumentException {
        ProcessDefinition definition = null;
        FileInputStream streamLectura = null;
        UserInterfaceBusiness business = null;
        JbpmContext context = null;
        try {
            context = this.getContext();
            streamLectura = new FileInputStream(tempFile);
            definition = ProcessDefinition.parseParZipInputStream((ZipInputStream)new ZipInputStream(streamLectura));
            ((InputStream)streamLectura).close();
            context.deployProcessDefinition(definition);
            business = new UserInterfaceBusiness(context);
            String[] stringArray = business.procesarDefinicionUI(tempFile, definition);
            return stringArray;
        }
        finally {
            this.flushContext();
            if (streamLectura != null) {
                ((InputStream)streamLectura).close();
            }
        }
    }

    public void openDeployParDefinitionTransfer() throws BPMException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            this.tempFile = this.getTempFile();
            this.outputStream = new FileOutputStream(this.tempFile);
        }
        catch (Exception ex) {
            throw new BPMException((Throwable)ex, BPMErrorCodes.ERROR_ENTRADA_SALIDA);
        }
    }

    public void nextDeployParDefinitionPackage(byte[] filePackage, int length) throws BPMException {
        try {
            this.outputStream.write(filePackage, 0, length);
        }
        catch (Exception ex) {
            throw new BPMException((Throwable)ex, BPMErrorCodes.ERROR_ENTRADA_SALIDA);
        }
    }

    public void endDeployParDefinitionTransfer() throws BPMException {
        InputStream streamLectura = null;
        try {
            this.outputStream.close();
            this.messages = this.deployProcessParDefinition(this.tempFile);
            this.tempFile.delete();
            this.tempFile = null;
            this.outputStream = null;
        }
        catch (JpdlException ex) {
            this.generateUpgradeMessages(ex);
            try {
                if (streamLectura != null) {
                    streamLectura.close();
                }
            }
            catch (Exception exInterna) {
                // empty catch block
            }
            this.context.setRollbackOnly();
            throw new BPMException((Throwable)ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        }
        catch (Exception ex) {
            this.generateUpgradeMessage(ex);
            try {
                if (streamLectura != null) {
                    streamLectura.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.context.setRollbackOnly();
            throw new BPMException((Throwable)ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        }
    }

    public void upgradeProcess(es.caib.bpm.vo.ProcessInstance instanceVO) throws BPMException {
        Object streamLectura = null;
        JbpmContext context = this.getContext();
        try {
            ProcessInstance process = context.loadProcessInstance(instanceVO.getId());
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            if (business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), process)) {
                UserInterfaceBusiness business2 = new UserInterfaceBusiness(context);
                this.messages = business2.upgradeProcess(process);
            }
        }
        catch (JpdlException ex) {
            this.generateUpgradeMessages(ex);
            context.setRollbackOnly();
            throw new BPMException((Throwable)ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        }
        catch (Exception ex) {
            this.generateUpgradeMessage(ex);
            context.setRollbackOnly();
            throw new BPMException((Throwable)ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        }
        finally {
            this.flushContext();
        }
    }

    public es.caib.bpm.vo.ProcessDefinition enableProcessDefinition(es.caib.bpm.vo.ProcessDefinition defVO) throws BPMException {
        return this.disableProcessDefinition(defVO, "false");
    }

    public es.caib.bpm.vo.ProcessDefinition disableProcessDefinition(es.caib.bpm.vo.ProcessDefinition defVO) throws BPMException {
        return this.disableProcessDefinition(defVO, "true");
    }

    public es.caib.bpm.vo.ProcessDefinition disableProcessDefinition(es.caib.bpm.vo.ProcessDefinition defVO, String value) throws BPMException {
        Object streamLectura = null;
        JbpmContext context = this.getContext();
        try {
            ProcessDefinition def = context.getGraphSession().loadProcessDefinition(defVO.getId());
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            if (business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), def)) {
                ProcessDefinitionProperty prop = this.getProcessDefinitionDisabledProperty(context, def);
                if (prop == null) {
                    prop = new ProcessDefinitionProperty();
                    prop.setProcessDefinitionId(new Long(def.getId()));
                    prop.setName("disabled");
                }
                prop.setValue(value);
                context.getSession().save((Object)prop);
            }
            es.caib.bpm.vo.ProcessDefinition processDefinition = VOFactory.newProcessDefinition(def, context);
            return processDefinition;
        }
        catch (JpdlException ex) {
            this.generateUpgradeMessages(ex);
            context.setRollbackOnly();
            throw new BPMException((Throwable)ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        }
        catch (Exception ex) {
            this.generateUpgradeMessage(ex);
            context.setRollbackOnly();
            throw new BPMException((Throwable)ex, BPMErrorCodes.ERROR_DESPLIEGUE_PROCESO);
        }
        finally {
            this.flushContext();
        }
    }

    private ProcessDefinitionProperty getProcessDefinitionDisabledProperty(JbpmContext context, ProcessDefinition def) {
        org.hibernate.Query q = context.getSession().createQuery("select pdp from es.caib.bpm.entity.ProcessDefinitionProperty pdp where pdp.name = 'disabled' and pdp.processDefinitionId=:id ");
        q.setParameter("id", (Object)new Long(def.getId()));
        ProcessDefinitionProperty prop = (ProcessDefinitionProperty)q.uniqueResult();
        return prop;
    }

    private void generateUpgradeMessages(JpdlException ex) {
        Vector<String> v = new Vector<String>();
        List l = ex.getProblems();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            String message;
            Problem p = (Problem)it.next();
            if (p.getLine() == null) {
                message = p.getDescription();
                if (p.getException() != null) {
                    message = message + ": " + p.getException().toString();
                }
            } else {
                message = p.getResource() + " line " + p.getLine() + ": " + p.getDescription();
            }
            v.add(message);
        }
        this.messages = v.toArray(new String[v.size()]);
    }

    private void generateUpgradeMessage(Exception ex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(out);
        ex.printStackTrace(p);
        p.close();
        this.messages = new String[]{out.toString()};
    }

    private synchronized File getTempFile() throws FileNotFoundException, IOException, InvalidConfigurationException {
        String jbossTemp = System.getProperty("jboss.server.temp.dir");
        if (jbossTemp == null) {
            jbossTemp = System.getProperty("java.io.tmpdir");
        }
        File tmp = new File(new File(jbossTemp), "bpm");
        tmp.mkdirs();
        return File.createTempFile("jbpmwf", ".par", tmp);
    }

    public List getPendingTasks(es.caib.bpm.vo.ProcessInstance process) throws BPMException {
        JbpmContext jbpmContext = null;
        try {
            jbpmContext = this.getContext();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(jbpmContext);
            if (process == null) {
                List list = null;
                return list;
            }
            ProcessInstance instance = jbpmContext.getProcessInstance(process.getId());
            Vector<TaskInstance> v = new Vector<TaskInstance>();
            if (instance.getTaskMgmtInstance() != null && instance.getTaskMgmtInstance().getTaskInstances() != null) {
                Iterator it = instance.getTaskMgmtInstance().getTaskInstances().iterator();
                while (it.hasNext()) {
                    org.jbpm.taskmgmt.exe.TaskInstance task = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                    if (task.hasEnded() || !business.canAccess(this.getUserGroups(jbpmContext), task)) continue;
                    try {
                        v.add(VOFactory.newTaskInstance(task));
                    }
                    catch (RuntimeException e) {
                        this.log.warn((Object)("Unable to serialize task " + task.getId()), (Throwable)e);
                    }
                }
            }
            Vector<TaskInstance> vector = v;
            return vector;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    public List getActiveTasks(es.caib.bpm.vo.ProcessInstance process) throws BPMException {
        JbpmContext jbpmContext = null;
        try {
            boolean canObserve;
            jbpmContext = this.getContext();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(jbpmContext);
            if (process == null) {
                List list = null;
                return list;
            }
            ProcessInstance instance = jbpmContext.getProcessInstance(process.getId());
            Vector<TaskInstance> v = new Vector<TaskInstance>();
            boolean bl = canObserve = business.isUserAuthorized(OBSERVER_ROLE, this.getUserGroups(jbpmContext), instance) || business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(jbpmContext), instance);
            if (instance.getTaskMgmtInstance() != null && instance.getTaskMgmtInstance().getTaskInstances() != null) {
                Iterator it = instance.getTaskMgmtInstance().getTaskInstances().iterator();
                while (it.hasNext()) {
                    org.jbpm.taskmgmt.exe.TaskInstance task = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                    if (task.hasEnded()) continue;
                    try {
                        if (!canObserve && !business.canAccess(this.getUserGroups(jbpmContext), task)) continue;
                        v.add(VOFactory.newTaskInstance(task));
                    }
                    catch (RuntimeException e) {
                        this.log.warn((Object)("Unable to serialize task " + task.getId()), (Throwable)e);
                    }
                }
            }
            Vector<TaskInstance> vector = v;
            return vector;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    public List getActiveJobs(es.caib.bpm.vo.ProcessInstance process) throws BPMException {
        JbpmContext jbpmContext = null;
        try {
            jbpmContext = this.getContext();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(jbpmContext);
            if (process == null) {
                List list = null;
                return list;
            }
            ProcessInstance instance = jbpmContext.getProcessInstance(process.getId());
            if (!business.isUserAuthorized(OBSERVER_ROLE, this.getUserGroups(jbpmContext), instance)) {
                List list = null;
                return list;
            }
            Vector v = new Vector();
            this.populateJobs(jbpmContext, instance.getRootToken(), v);
            Vector vector = v;
            return vector;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    private void populateJobs(JbpmContext jbpmContext, Token token, Vector v) {
        List l = jbpmContext.getJobSession().findJobsByToken(token);
        Iterator<Object> it = l.iterator();
        while (it.hasNext()) {
            org.jbpm.job.Job j = (org.jbpm.job.Job)it.next();
            v.add(VOFactory.newJob(j));
        }
        it = token.getActiveChildren().values().iterator();
        while (it.hasNext()) {
            Token childToken = (Token)it.next();
            this.populateJobs(jbpmContext, childToken, v);
        }
    }

    public List getActiveJobs() throws BPMException {
        JbpmContext jbpmContext = null;
        try {
            jbpmContext = this.getContext();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(jbpmContext);
            org.hibernate.Query q = jbpmContext.getSession().getNamedQuery("dueDateJobs");
            q.setParameter("now", (Object)new Date());
            List l = q.list();
            Vector<Job> v = new Vector<Job>();
            Iterator it = l.iterator();
            while (it.hasNext()) {
                org.jbpm.job.Job j = (org.jbpm.job.Job)it.next();
                ProcessInstance pi = j.getProcessInstance();
                if (!business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(jbpmContext), pi)) continue;
                v.add(VOFactory.newJob(j));
            }
            Vector<Job> vector = v;
            return vector;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    public TaskInstance getTask(long id) throws BPMException {
        JbpmContext jbpmContext = null;
        try {
            jbpmContext = this.getContext();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(jbpmContext);
            org.jbpm.taskmgmt.exe.TaskInstance task = jbpmContext.getTaskInstance(id);
            if (task == null) {
                TaskInstance taskInstance = null;
                return taskInstance;
            }
            if (business.canAccess(this.getUserGroups(jbpmContext), task)) {
                TaskInstance taskInstance = VOFactory.newTaskInstance(task);
                return taskInstance;
            }
            TaskInstance taskInstance = null;
            return taskInstance;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    public es.caib.bpm.vo.ProcessInstance getProcess(long id) throws BPMException {
        JbpmContext jbpmContext = null;
        try {
            jbpmContext = this.getContext();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(jbpmContext);
            ProcessInstance process = jbpmContext.getProcessInstance(id);
            ProcessDefinition definition = process.getProcessDefinition();
            if (process == null) {
                es.caib.bpm.vo.ProcessInstance processInstance = null;
                return processInstance;
            }
            if (!(this.isInternalService() || business.isUserAuthorized(OBSERVER_ROLE, this.getUserGroups(jbpmContext), definition) || business.isUserAuthorized(INITIATOR_ROLE, this.getUserGroups(jbpmContext), definition) || business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(jbpmContext), definition))) {
                Collection list = process.getTaskMgmtInstance().getTaskInstances();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    org.jbpm.taskmgmt.exe.TaskInstance ti = (org.jbpm.taskmgmt.exe.TaskInstance)it.next();
                    if (!business.canAccess(this.getUserGroups(jbpmContext), ti)) continue;
                    es.caib.bpm.vo.ProcessInstance processInstance = VOFactory.newProcessInstance(process);
                    return processInstance;
                }
                throw new SecurityException("No autoritzat a accedir al proc\u00e9s");
            }
            es.caib.bpm.vo.ProcessInstance processInstance = VOFactory.newProcessInstance(process);
            return processInstance;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    private void recursiveFillTokens(Token rootToken, Collection tokens) {
        es.caib.bpm.vo.Token t2 = VOFactory.newToken(rootToken);
        tokens.add(t2);
        Iterator it = rootToken.getChildren().values().iterator();
        while (it.hasNext()) {
            this.recursiveFillTokens((Token)it.next(), tokens);
        }
    }

    public es.caib.bpm.vo.Token[] getTokens(long id) throws BPMException {
        JbpmContext jbpmContext = null;
        try {
            jbpmContext = this.getContext();
            ProcessInstance process = jbpmContext.getProcessInstance(id);
            Vector v = new Vector(1);
            this.recursiveFillTokens(process.getRootToken(), v);
            es.caib.bpm.vo.Token[] tokenArray = v.toArray(new es.caib.bpm.vo.Token[v.size()]);
            return tokenArray;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TaskInstance task) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            this.doUpdate(context, task);
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSwimlane(TaskInstance task, String swimlane, String[] actorIds) throws BPMException {
        JbpmContext context = this.getContext();
        ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
        business.setContext(context);
        try {
            org.jbpm.taskmgmt.exe.TaskInstance ti = context.loadTaskInstance(task.getId());
            if (business.canAccess(this.getUserGroups(context), ti)) {
                this.startAuthenticationLog(ti.getToken());
                SwimlaneInstance swimlaneInstance = ti.getTaskMgmtInstance().getSwimlaneInstance(swimlane);
                swimlaneInstance.setPooledActors(actorIds);
                this.endAuthenticationLog(ti.getToken());
                context.save(ti);
            }
        }
        finally {
            this.flushContext();
        }
    }

    private org.jbpm.taskmgmt.exe.TaskInstance doUpdate(JbpmContext context, TaskInstance task) throws BPMException {
        ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
        business.setContext(context);
        org.jbpm.taskmgmt.exe.TaskInstance ti = context.loadTaskInstance(task.getId());
        if (business.canAccess(this.getUserGroups(context), ti)) {
            Object value;
            String key;
            this.startAuthenticationLog(ti.getToken());
            ti.setActorId(task.getActorId());
            ti.setBlocking(task.isBlocking());
            ti.setDescription(task.getDescription());
            ti.setName(task.getName());
            ti.setDueDate(task.getDueDate());
            ti.setEnd(task.getEnd());
            ti.setPriority(task.getPriority());
            ti.setSignalling(task.isSignalling());
            Vector v = new Vector();
            v.addAll(task.getPooledActors());
            if (ti.getPooledActors() != null) {
                Iterator it = ti.getPooledActors().iterator();
                while (it.hasNext()) {
                    PooledActor actor = (PooledActor)it.next();
                    String name = null;
                    if (actor.getActorId() != null) {
                        name = actor.getActorId();
                    } else if (actor.getSwimlaneInstance() != null) {
                        name = actor.getSwimlaneInstance().getName();
                    }
                    if (name == null || v.contains(name)) continue;
                    it.remove();
                }
                it = task.getPooledActors().iterator();
                while (it.hasNext()) {
                    String key2 = (String)it.next();
                    PooledActor actor = new PooledActor();
                    SwimlaneInstance swimlane = ti.getTaskMgmtInstance().getSwimlaneInstance(key2);
                    if (swimlane != null) {
                        actor.setSwimlaneInstance(swimlane);
                    } else {
                        actor.setActorId(key2);
                    }
                    ti.getPooledActors().add(actor);
                }
            }
            HashMap map = new HashMap();
            map.putAll(task.getVariables());
            Iterator it = ti.getVariables().keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                value = map.get(key);
                ti.setVariable(key, value);
                map.remove(key);
            }
            it = map.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                value = map.get(key);
                ti.setVariable(key, value);
            }
            this.endAuthenticationLog(ti.getToken());
            context.save(ti);
            return ti;
        }
        throw new SecurityException("Not authorized");
    }

    public String[] getDeployMessages() {
        return this.messages;
    }

    public JbpmConfiguration getJBpmConfiguration() {
        return Configuration.getConfig();
    }

    public void signal(es.caib.bpm.vo.ProcessInstance instanceVO) throws BPMException {
        this.signal(instanceVO, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(es.caib.bpm.vo.ProcessInstance instanceVO, String transitionName) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessInstance instance = context.loadProcessInstance(instanceVO.getId());
            ProcessDefinition definition = instance.getProcessDefinition();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            if (this.isInternalService() || business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), definition)) {
                this.startAuthenticationLog(instance.getRootToken());
                if (transitionName != null) {
                    instance.signal(transitionName);
                } else {
                    instance.signal();
                }
                this.endAuthenticationLog(instance.getRootToken());
                context.save(instance);
            }
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessLog[] getProcessLog(es.caib.bpm.vo.ProcessInstance instanceVO) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessLog[] logs;
            ProcessInstance process = context.loadProcessInstance(instanceVO.getId());
            Vector parsedLogs = new Vector();
            this.parseLog(context, process, parsedLogs, process.getRootToken());
            Collections.sort(parsedLogs, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    ProcessLog l1 = (ProcessLog)arg0;
                    ProcessLog l2 = (ProcessLog)arg1;
                    return l1.getDate().compareTo(l2.getDate());
                }
            });
            ProcessLog[] processLogArray = logs = parsedLogs.toArray(new ProcessLog[parsedLogs.size()]);
            return processLogArray;
        }
        finally {
            this.flushContext();
        }
    }

    private void parseLog(JbpmContext context, ProcessInstance process, Vector parsedLogs, Token t) {
        Criteria criteria = null;
        criteria = context.getSession().createCriteria(class$org$jbpm$logging$log$ProcessLog == null ? (class$org$jbpm$logging$log$ProcessLog = BPMEngineBean.class$("org.jbpm.logging.log.ProcessLog")) : class$org$jbpm$logging$log$ProcessLog);
        criteria.add((Criterion)Restrictions.eq((String)"token", (Object)t));
        criteria.add(Restrictions.isNull((String)"parent"));
        Iterator it = criteria.list().iterator();
        while (it.hasNext()) {
            org.jbpm.logging.log.ProcessLog pl = (org.jbpm.logging.log.ProcessLog)it.next();
            this.parseLog(process, parsedLogs, pl);
        }
        Iterator it2 = t.getChildren().values().iterator();
        while (it2.hasNext()) {
            Token childToken = (Token)it2.next();
            this.parseLog(context, process, parsedLogs, childToken);
        }
    }

    private void parseLog(ProcessInstance process, Vector parsedLogs, org.jbpm.logging.log.ProcessLog pl) {
        ProcessLog logLine = new ProcessLog();
        logLine.setDate(pl.getDate());
        logLine.setProcessId(process.getId());
        logLine.setUser(pl.getActorId());
        StringBuffer b = new StringBuffer();
        for (CompositeLog pl2 = pl.getParent(); pl2 != null; pl2 = pl2.getParent()) {
            b.append("\\ ");
        }
        if (pl instanceof ProcessInstanceCreateLog) {
            logLine.setAction("Proc\u00e9s iniciat");
            parsedLogs.add(logLine);
        } else if (pl instanceof TransitionLog) {
            TransitionLog tl = (TransitionLog)pl;
            logLine.setAction((tl.getTransition().getName() != null ? tl.getTransition().getName() + ": " : "") + tl.getSourceNode().getName() + " -> " + tl.getDestinationNode().getName());
            parsedLogs.add(logLine);
        } else if (pl instanceof ProcessInstanceEndLog) {
            logLine.setAction("Fin del proc\u00e9s");
            parsedLogs.add(logLine);
        } else if (pl instanceof ActionLog) {
            ActionLog al = (ActionLog)pl;
            if (al.getException() != null) {
                logLine.setAction("Error a la tasca autom\u00e0tica " + al.getAction().getName() + ":\n" + al.getException());
                parsedLogs.add(logLine);
            }
        } else if (pl instanceof CompositeLog) {
            CompositeLog cl = (CompositeLog)pl;
            Iterator it = cl.getChildren().iterator();
            while (it.hasNext()) {
                org.jbpm.logging.log.ProcessLog child = (org.jbpm.logging.log.ProcessLog)it.next();
                if (child == null) continue;
                this.parseLog(process, parsedLogs, child);
            }
        }
    }

    private boolean isInternalService() {
        return this.context.isCallerInRole("BPM_INTERNAL");
    }

    public void startAuthenticationLog(Token token) {
        LoggingInstance li = (LoggingInstance)token.getProcessInstance().getInstance(class$org$jbpm$logging$exe$LoggingInstance == null ? (class$org$jbpm$logging$exe$LoggingInstance = BPMEngineBean.class$("org.jbpm.logging.exe.LoggingInstance")) : class$org$jbpm$logging$exe$LoggingInstance);
        if (li == null) {
            li = new LoggingInstance();
            token.getProcessInstance().addInstance((ModuleInstance)li);
        }
        AuthenticationLog log = new AuthenticationLog();
        log.setToken(token);
        log.setActorId(this.getUserName());
        li.startCompositeLog((CompositeLog)log);
    }

    public void endAuthenticationLog(Token token) {
        LoggingInstance li = (LoggingInstance)token.getProcessInstance().getInstance(class$org$jbpm$logging$exe$LoggingInstance == null ? (class$org$jbpm$logging$exe$LoggingInstance = BPMEngineBean.class$("org.jbpm.logging.exe.LoggingInstance")) : class$org$jbpm$logging$exe$LoggingInstance);
        if (li != null) {
            li.endCompositeLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAdmin(es.caib.bpm.vo.ProcessInstance instanceVO) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            ProcessInstance process = context.loadProcessInstance(instanceVO.getId());
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            boolean bl = business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), process);
            return bl;
        }
        finally {
            this.flushContext();
        }
    }

    public void resumeJob(Job jobvo) throws BPMException {
        this.enableJob(jobvo, true);
    }

    public void pauseJob(Job jobvo) throws BPMException {
        this.enableJob(jobvo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableJob(Job jobvo, boolean enable) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.job.Job job = context.getJobSession().getJob(jobvo.getId());
            if (job == null) {
                throw new BPMException("Aquesta tasca no existeix", -1);
            }
            ProcessInstance instance = job.getProcessInstance();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            if (this.isInternalService() || business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), instance)) {
                this.startAuthenticationLog(instance.getRootToken());
                job.setSuspended(!enable);
                this.endAuthenticationLog(instance.getRootToken());
                context.save(instance);
            }
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryJob(Job jobvo) throws BPMException {
        JbpmContext context = this.getContext();
        try {
            org.jbpm.job.Job job = context.getJobSession().getJob(jobvo.getId());
            if (job == null) {
                throw new BPMException("Aquesta tasca no existeix", -1);
            }
            ProcessInstance instance = job.getProcessInstance();
            ProcessDefinitionRolesBusiness business = new ProcessDefinitionRolesBusiness();
            business.setContext(context);
            if (this.isInternalService() || business.isUserAuthorized(SUPERVISOR_ROLE, this.getUserGroups(context), instance)) {
                this.startAuthenticationLog(instance.getRootToken());
                job.setSuspended(false);
                job.setRetries(1);
                job.setException(null);
                this.endAuthenticationLog(instance.getRootToken());
                context.save(instance);
            }
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getConfiguration() {
        JbpmContext context = this.getContext();
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            org.hibernate.Query q = context.getSession().createQuery("select prop from es.caib.bpm.entity.DBProperty prop where prop.app='BPM'");
            Iterator i = q.list().iterator();
            while (i.hasNext()) {
                DBProperty prop = (DBProperty)i.next();
                m.put(prop.getKey(), prop.getValue());
            }
            HashMap<String, String> hashMap = m;
            return hashMap;
        }
        finally {
            this.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeConfiguration(Map m) throws IOException {
        JbpmContext context = this.getContext();
        HashSet s = new HashSet(m.keySet());
        try {
            org.hibernate.Query q = context.getSession().createQuery("select prop from es.caib.bpm.entity.DBProperty prop where prop.app='BPM'");
            Iterator<Object> i = q.list().iterator();
            while (i.hasNext()) {
                DBProperty prop = (DBProperty)i.next();
                String value = (String)m.get(prop.getKey());
                if (value == null) {
                    context.getSession().delete((Object)prop);
                    continue;
                }
                prop.setValue(value);
                context.getSession().save((Object)prop);
                s.remove(prop.getKey());
            }
            i = s.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                DBProperty prop = new DBProperty();
                prop.setApp("BPM");
                prop.setKey(key);
                prop.setValue((String)m.get(key));
                context.getSession().save((Object)prop);
            }
            DirectoryFactory.reconfigureDirectory(context);
        }
        finally {
            this.flushContext();
        }
    }

    public void reindex() throws IOException {
        Indexer.getIndexer().reindexAll();
    }

    public void ping() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(es.caib.bpm.vo.ProcessDefinition processdef, String resource) {
        JbpmContext context = this.getContext();
        try {
            ProcessDefinition definition = context.getGraphSession().getProcessDefinition(processdef.getId());
            InputStream inputStream = definition.getFileDefinition().getInputStream(resource);
            return inputStream;
        }
        finally {
            this.flushContext();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface AltresTasques {
        public List findAltresTasques(JbpmContext var1, String var2, Collection var3);
    }
}

