/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.beans;

import es.caib.bpm.config.Configuration;
import es.caib.bpm.index.Indexer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import org.apache.log4j.Logger;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;

public class BPMJobExecutorBean
implements SessionBean {
    private static final long serialVersionUID = 1L;
    static Integer lock = new Integer(10001);
    static Logger log = Logger.getLogger((Class)(class$es$caib$bpm$beans$BPMJobExecutorBean == null ? (class$es$caib$bpm$beans$BPMJobExecutorBean = BPMJobExecutorBean.class$("es.caib.bpm.beans.BPMJobExecutorBean")) : class$es$caib$bpm$beans$BPMJobExecutorBean));
    private SessionContext ctx;
    static /* synthetic */ Class class$es$caib$bpm$beans$BPMJobExecutorBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void anotateFailure(long id, Exception e) {
        JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            Job job = jobSession.loadJob(id);
            log.debug((Object)("exception while executing " + job), (Throwable)e);
            StringWriter memoryWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(memoryWriter));
            job.setException(memoryWriter.toString());
            job.setRetries(job.getRetries() - 1);
            Date d = new Date(System.currentTimeMillis() + 600000L);
            job.setDueDate(d);
            job.setLockOwner(null);
            jbpmContext.getSession().update((Object)job);
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception executeJob(long id) {
        JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            Job job = jobSession.loadJob(id);
            boolean success = job.execute(jbpmContext);
            if (this.ctx.getRollbackOnly()) {
                JbpmException jbpmException = new JbpmException("Transaction timeout");
                return jbpmException;
            }
            if (success) {
                jobSession.deleteJob(job);
            }
            Exception exception = null;
            return exception;
        }
        catch (Exception e) {
            try {
                this.ctx.setRollbackOnly();
            }
            catch (Exception e2) {
                this.ctx.setRollbackOnly();
                throw new EJBException(e2);
            }
            Exception exception = e;
            return exception;
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getNextDueDate(String lockOwner) {
        JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
        try {
            Date nextDueDate = null;
            JobSession jobSession = jbpmContext.getJobSession();
            Job job = jobSession.getFirstDueJob(lockOwner, null);
            if (job != null) {
                nextDueDate = job.getDueDate();
            }
            Date date = nextDueDate;
            return date;
        }
        finally {
            jbpmContext.close();
        }
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void ejbCreate() throws CreateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getJobs(String lockOwner) {
        Vector<Long> jobs = new Vector<Long>();
        Integer n = lock;
        synchronized (n) {
            log.debug((Object)"acquiring jobs for execution...");
            List jobsToLock = Collections.EMPTY_LIST;
            JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
            try {
                JobSession jobSession = jbpmContext.getJobSession();
                log.debug((Object)"querying for acquirable job...");
                Job job = jobSession.getFirstAcquirableJob(lockOwner);
                if (job != null) {
                    if (job.isExclusive()) {
                        log.debug((Object)("found exclusive " + job));
                        ProcessInstance processInstance = job.getProcessInstance();
                        log.debug((Object)("finding other exclusive jobs for " + processInstance));
                        jobsToLock = jobSession.findExclusiveJobs(lockOwner, processInstance);
                        log.debug((Object)("trying to obtain exclusive locks on " + jobsToLock + " for " + processInstance));
                    } else {
                        log.debug((Object)("trying to obtain lock on " + job));
                        jobsToLock = Collections.singletonList(job);
                    }
                    Date lockTime = new Date();
                    Iterator<Job> iter = jobsToLock.iterator();
                    while (iter.hasNext()) {
                        job = iter.next();
                        job.setLockOwner(lockOwner);
                        job.setLockTime(lockTime);
                        jbpmContext.getSession().update((Object)job);
                        jobs.add(new Long(job.getId()));
                    }
                } else {
                    log.debug((Object)"no acquirable jobs in job table");
                }
            }
            finally {
                jbpmContext.close();
            }
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockOverdueJobs(Date threshold) {
        JbpmContext jbpmContext = Configuration.getConfig().createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            List jobsWithOverdueLockTime = jobSession.findJobsWithOverdueLockTime(threshold);
            Iterator iter = jobsWithOverdueLockTime.iterator();
            while (iter.hasNext()) {
                Job job = (Job)iter.next();
                log.info((Object)("unlocking " + job + " owned by thread " + job.getLockOwner()));
                job.setLockOwner(null);
                job.setLockTime(null);
                jobSession.saveJob(job);
            }
        }
        finally {
            jbpmContext.close();
        }
    }

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        this.ctx = arg0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexPendingProcesses() {
        Indexer i = Indexer.getIndexer();
        JbpmContext ctx = Configuration.getConfig().createJbpmContext();
        try {
            i.flush(ctx.getSession());
        }
        catch (Exception e) {
            log.warn((Object)"Error indexant", (Throwable)e);
        }
        finally {
            ctx.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

