/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.business;

import es.caib.bpm.dal.ProcessDefinitionRolesDal;
import es.caib.bpm.entity.ProcessDefinitionUserRole;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class ProcessDefinitionRolesBusiness {
    private JbpmContext context = null;

    public boolean isUserAuthorized(String appRole, Vector userRoles, ProcessDefinition definition) {
        Swimlane swim = definition.getTaskMgmtDefinition().getSwimlane(appRole);
        if (swim == null) {
            return this.checkOldAuthorization(appRole, userRoles, definition);
        }
        String members = swim.getActorIdExpression();
        if (members == null) {
            members = swim.getPooledActorsExpression();
        }
        if (members == null) {
            return this.checkOldAuthorization(appRole, userRoles, definition);
        }
        String[] parsedMembers = this.getDefinitionActors(members);
        for (int i = 0; i < parsedMembers.length; ++i) {
            if (!userRoles.contains(parsedMembers[i])) continue;
            return true;
        }
        return false;
    }

    private String[] getDefinitionActors(String pooledActorsExpression) {
        ExecutionContext executionContext = ExecutionContext.currentExecutionContext();
        if (executionContext == null) {
            executionContext = new ExecutionContext((Token)null);
        }
        String[] pooledActors = null;
        Object result = JbpmExpressionEvaluator.evaluate((String)pooledActorsExpression, (ExecutionContext)executionContext);
        if (result == null) {
            throw new JbpmException("pooled-actors expression '" + pooledActorsExpression + "' returned null");
        }
        if (result instanceof String[]) {
            pooledActors = (String[])result;
        } else if (result instanceof Collection) {
            Collection collection = (Collection)result;
            pooledActors = collection.toArray(new String[collection.size()]);
        } else if (result instanceof String) {
            ArrayList<String> pooledActorList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer((String)result, ",");
            while (tokenizer.hasMoreTokens()) {
                pooledActorList.add(tokenizer.nextToken().trim());
            }
            pooledActors = pooledActorList.toArray(new String[pooledActorList.size()]);
        } else {
            throw new JbpmException("pooled-actors expression '" + pooledActorsExpression + "' didn't resolve to a comma separated String, a Collection or a String[]: '" + result + "' (" + result.getClass().getName() + ")");
        }
        return pooledActors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserAuthorized(String appRole, Vector userRoles, ProcessInstance pi) {
        ExecutionContext ctx = new ExecutionContext(pi.getRootToken());
        ExecutionContext.pushCurrentContext((ExecutionContext)ctx);
        try {
            Swimlane swim = pi.getProcessDefinition().getTaskMgmtDefinition().getSwimlane(appRole);
            if (swim == null) {
                boolean bl = this.checkOldAuthorization(appRole, userRoles, pi.getProcessDefinition());
                return bl;
            }
            SwimlaneInstance swimInstance = pi.getTaskMgmtInstance().getInitializedSwimlaneInstance(ctx, swim);
            if (swimInstance.getActorId() != null && userRoles.contains(swimInstance.getActorId())) {
                boolean bl = true;
                return bl;
            }
            if (swimInstance.getPooledActors() != null) {
                Iterator it = swimInstance.getPooledActors().iterator();
                while (it.hasNext()) {
                    PooledActor actor = (PooledActor)it.next();
                    if (!userRoles.contains(actor.getActorId())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ExecutionContext.popCurrentContext((ExecutionContext)ctx);
        }
    }

    private boolean checkOldAuthorization(String appRole, Vector userRoles, ProcessDefinition roleDefinition) {
        ProcessDefinitionRolesDal dal = new ProcessDefinitionRolesDal();
        dal.setContext(this.context);
        List resultado = dal.findProcessDefinitionRoles(roleDefinition, appRole);
        if (resultado.isEmpty()) {
            return true;
        }
        Iterator it = resultado.iterator();
        while (it.hasNext()) {
            ProcessDefinitionUserRole role = (ProcessDefinitionUserRole)it.next();
            if (!userRoles.contains(role.getUserRole())) continue;
            return true;
        }
        return false;
    }

    public void setContext(JbpmContext context) {
        this.context = context;
    }

    public JbpmContext getContext() {
        return this.context;
    }

    public boolean canAccess(Vector userGroups, TaskInstance ti) {
        if (ti.getActorId() != null && userGroups.contains(ti.getActorId())) {
            return true;
        }
        if (this.isUserAuthorized("supervisor", userGroups, ti.getProcessInstance())) {
            return true;
        }
        if (ti.getSwimlaneInstance() != null) {
            SwimlaneInstance swim = ti.getSwimlaneInstance();
            String actorId = swim.getActorId();
            if (actorId != null && userGroups.contains(actorId)) {
                return true;
            }
            if (swim.getPooledActors() != null) {
                Iterator it = ((AbstractList)userGroups).iterator();
                while (it.hasNext()) {
                    String group = (String)it.next();
                    Iterator it2 = swim.getPooledActors().iterator();
                    while (it2.hasNext()) {
                        PooledActor actor = (PooledActor)it2.next();
                        if (!group.equals(actor.getActorId())) continue;
                        return true;
                    }
                }
            }
        }
        if (ti.getPooledActors() != null) {
            Iterator it = ((AbstractList)userGroups).iterator();
            while (it.hasNext()) {
                String group = (String)it.next();
                Iterator it2 = ti.getPooledActors().iterator();
                while (it2.hasNext()) {
                    PooledActor actor = (PooledActor)it2.next();
                    if (!group.equals(actor.getActorId())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

