/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.business;

import es.caib.bpm.dal.ProcessDefinitionPropertyDal;
import es.caib.bpm.entity.ProcessDefinitionProperty;
import es.caib.bpm.entity.ProcessDefinitionUserRole;
import es.caib.bpm.entity.UserInterface;
import es.caib.bpm.exception.BPMException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserInterfaceBusiness {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private JbpmContext context = null;
    private static Logger log = Logger.getLogger((Class)(class$es$caib$bpm$business$UserInterfaceBusiness == null ? (class$es$caib$bpm$business$UserInterfaceBusiness = UserInterfaceBusiness.class$("es.caib.bpm.business.UserInterfaceBusiness")) : class$es$caib$bpm$business$UserInterfaceBusiness));
    static /* synthetic */ Class class$org$jbpm$graph$exe$ProcessInstance;
    static /* synthetic */ Class class$es$caib$bpm$business$UserInterfaceBusiness$SchemaLoader;
    static /* synthetic */ Class class$es$caib$bpm$business$UserInterfaceBusiness;

    public UserInterfaceBusiness(JbpmContext context) {
        this.context = context;
    }

    public String[] procesarDefinicionUI(File file, ProcessDefinition processDefinition) throws ZipException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException, LoginException, NamingException, CreateException, XPathExpressionException, BPMException, DocumentException {
        Document documentoXml = this.parseUIDescriptor(processDefinition);
        return this.procesarArchivoXML(documentoXml, processDefinition);
    }

    private Document parseUIDescriptor(ProcessDefinition processDefinition) throws ParserConfigurationException, FactoryConfigurationError, SAXException, BPMException, DocumentException, IOException {
        Object documentoXml = null;
        DocumentBuilder builder = null;
        SAXReader reader = new SAXReader(true);
        reader.setFeature("http://xml.org/sax/features/validation", true);
        reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)"/ui.xsd");
        reader.getXMLReader().setEntityResolver(new SchemaLoader());
        reader.setEntityResolver((EntityResolver)new SchemaLoader());
        InputStream in = processDefinition.getFileDefinition().getInputStream("ui.xml");
        if (in == null) {
            throw new BPMException("Missing ui.xml file", -1);
        }
        reader.read(in);
        builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(processDefinition.getFileDefinition().getInputStream("ui.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] procesarArchivoXML(Document documento, ProcessDefinition processDefinition) throws IOException, LoginException, NamingException, CreateException, XPathExpressionException, BPMException {
        Node elemento = null;
        Object elementoAux = null;
        String path = null;
        String tarea = null;
        ByteArrayOutputStream outputStream = null;
        InputStream streamLectura = null;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            String tag = (String)xpath.evaluate("/process/tag", documento, XPathConstants.STRING);
            if (tag != null) {
                ProcessDefinitionProperty prop = new ProcessDefinitionProperty();
                prop.setProcessDefinitionId(new Long(processDefinition.getId()));
                prop.setName("tag");
                prop.setValue(tag);
                this.context.getSession().save((Object)prop);
            } else {
                tag = "";
            }
            NodeList list = (NodeList)xpath.evaluate("/process/task", documento, XPathConstants.NODESET);
            for (int index = 0; index < list.getLength(); ++index) {
                elemento = list.item(index);
                tarea = (String)xpath.evaluate("@name", elemento, XPathConstants.STRING);
                path = (String)xpath.evaluate("file/@path", elemento, XPathConstants.STRING);
                UserInterface ui = new UserInterface();
                ui.setProcessDefinitionId(new Long(processDefinition.getId()));
                ui.setFileName(path);
                ui.setTarea(tarea);
                this.context.getSession().save((Object)ui);
            }
            this.procesarRolesDefinicionProceso(documento, processDefinition);
            NodeList upgrades = (NodeList)xpath.evaluate("/process/upgrade/process", documento, XPathConstants.NODESET);
            Vector messages = new Vector();
            for (int index = 0; index < upgrades.getLength(); ++index) {
                elemento = upgrades.item(index);
                this.doUpgrade(processDefinition, tag, elemento, messages);
            }
            String[] stringArray = messages.toArray(new String[0]);
            return stringArray;
        }
        finally {
            if (streamLectura != null) {
                streamLectura.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private void doUpgrade(ProcessDefinition processDefinition, String tag, Node elemento, Vector messages) throws XPathExpressionException {
        String tagMatch;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String name = (String)xpath.evaluate("name", elemento, XPathConstants.STRING);
        if (name == null || name.length() == 0) {
            name = processDefinition.getName();
        }
        if ((tagMatch = (String)xpath.evaluate("tag", elemento, XPathConstants.STRING)) == null || tagMatch.length() == 0) {
            tagMatch = tag;
        }
        String regex = tagMatch.replaceAll("\\.", "\\\\.").replaceAll("\\?", ".").replaceAll("\\*", ".*");
        Pattern pattern = Pattern.compile(regex);
        ProcessDefinitionPropertyDal propertyDal = new ProcessDefinitionPropertyDal();
        propertyDal.setContext(this.context);
        List definitions = this.context.getGraphSession().findAllProcessDefinitionVersions(name);
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            ProcessDefinition def = (ProcessDefinition)it.next();
            if (def.getId() == processDefinition.getId()) continue;
            String oldTag = propertyDal.getProcessDefinitionProperty(def.getId(), "tag");
            if (oldTag == null) {
                oldTag = "";
            }
            if (!pattern.matcher(oldTag).matches()) continue;
            this.doDefinitionUpgrade(def, processDefinition, elemento, messages);
        }
    }

    private void doDefinitionUpgrade(ProcessDefinition source, ProcessDefinition target, Node elemento, Vector messages) throws XPathExpressionException {
        Criteria busqueda = this.context.getSession().createCriteria(class$org$jbpm$graph$exe$ProcessInstance == null ? (class$org$jbpm$graph$exe$ProcessInstance = UserInterfaceBusiness.class$("org.jbpm.graph.exe.ProcessInstance")) : class$org$jbpm$graph$exe$ProcessInstance);
        busqueda.add((Criterion)Restrictions.eq((String)"processDefinition", (Object)source));
        busqueda.add(Restrictions.isNull((String)"end"));
        List resultado = busqueda.list();
        Iterator it = resultado.iterator();
        while (it.hasNext()) {
            ProcessInstance instance = (ProcessInstance)it.next();
            this.doProcessUpgrade(instance, elemento, target, messages);
        }
    }

    private boolean doProcessUpgrade(ProcessInstance instance, Node elemento, ProcessDefinition target, Vector messages) throws XPathExpressionException {
        Task targetTask;
        TaskInstance ti;
        boolean ok = true;
        Collection taskInstances = instance.getTaskMgmtInstance().getTaskInstances();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Hashtable<TaskInstance, Task> tasks = new Hashtable<TaskInstance, Task>();
        Hashtable tokens = new Hashtable();
        Iterator<Object> taskIterator = taskInstances.iterator();
        while (taskIterator.hasNext()) {
            ti = (TaskInstance)taskIterator.next();
            String sourceTask = ti.getTask().getName();
            String newTask = null;
            if (elemento != null) {
                xpath.setXPathVariableResolver(new DummyVariableResolver(sourceTask));
                newTask = xpath.evaluate("task[@source=$source]/@target", elemento);
            }
            if (newTask == null || newTask.length() == 0) {
                newTask = ti.getTask().getName();
            }
            if ((targetTask = target.getTaskMgmtDefinition().getTask(newTask)) == null) {
                String message = "Cannot upgrade task " + sourceTask + " to " + newTask + " for process " + instance.getId();
                messages.add(message);
                ok = false;
                continue;
            }
            tasks.put(ti, targetTask);
        }
        if (ok) {
            Token token = instance.getRootToken();
            ok = this.upgradeToken(token, target, elemento, tokens, messages);
        }
        if (ok) {
            taskIterator = tasks.keySet().iterator();
            while (taskIterator.hasNext()) {
                ti = (TaskInstance)taskIterator.next();
                String taskName = ti.getName();
                boolean exactName = taskName.equals(ti.getTask().getName());
                targetTask = (Task)tasks.get(ti);
                ti.setTask(targetTask);
                if (exactName) continue;
                ti.setName(taskName);
            }
            Iterator tokenIterator = tokens.keySet().iterator();
            while (tokenIterator.hasNext()) {
                Token token = (Token)tokenIterator.next();
                org.jbpm.graph.def.Node targetNode = (org.jbpm.graph.def.Node)tokens.get(token);
                token.setNode(targetNode);
            }
            instance.setProcessDefinition(target);
            messages.add("Upgraded process " + instance.getId());
        }
        return ok;
    }

    private boolean upgradeToken(Token token, ProcessDefinition target, Node upgradeDefinition, Hashtable translations, Vector messages) throws XPathExpressionException {
        org.jbpm.graph.def.Node newNode;
        if (token.getNode() == null) {
            return false;
        }
        String newNodeName = null;
        String nodeName = token.getNode().getName();
        if (upgradeDefinition != null) {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setXPathVariableResolver(new DummyVariableResolver(nodeName));
            newNodeName = xpath.evaluate("/node[source=$source]/@target", upgradeDefinition);
        }
        if (newNodeName == null || newNodeName.length() == 0) {
            newNodeName = nodeName;
        }
        if ((newNode = target.getNode(nodeName)) == null) {
            messages.add("Cannot upgrade node " + nodeName + " to " + newNodeName + " for process " + token.getProcessInstance().getId());
            return false;
        }
        translations.put(token, newNode);
        boolean ok = true;
        Iterator it = token.getChildren().entrySet().iterator();
        while (ok && it.hasNext()) {
            Token child = (Token)it.next();
            ok = this.upgradeToken(child, target, upgradeDefinition, translations, messages);
        }
        return ok;
    }

    private void procesarRolesDefinicionProceso(Document documento, ProcessDefinition def) throws BPMException {
        log.debug((Object)"Procesamos el rol initiator");
        this.procesarRolDefinicionProceso(documento, "initiator", def);
        log.debug((Object)"Procesamos el rol observer");
        this.procesarRolDefinicionProceso(documento, "observer", def);
        log.debug((Object)"Procesamos el rol supervisor");
        this.procesarRolDefinicionProceso(documento, "supervisor", def);
    }

    private void procesarRolDefinicionProceso(Document documento, String roleName, ProcessDefinition def) throws BPMException {
        Node nodeProceso = null;
        NodeList childs = null;
        Node elementoRolUser = null;
        String userName = null;
        ProcessDefinitionUserRole userRole = null;
        log.debug((Object)"Traemos el elemento del rol");
        nodeProceso = documento.getElementsByTagName(roleName).item(0);
        if (nodeProceso != null) {
            childs = nodeProceso.getChildNodes();
            StringBuffer actors = new StringBuffer();
            log.debug((Object)"Recorremos los hijos");
            for (int index = 0; index < childs.getLength(); ++index) {
                elementoRolUser = childs.item(index);
                log.debug((Object)"Verificamos que sea un elemento tipo user o role");
                if (elementoRolUser.getNodeType() != 1 || !elementoRolUser.getNodeName().equals("role") && !elementoRolUser.getNodeName().equals("user")) continue;
                userRole = new ProcessDefinitionUserRole();
                elementoRolUser = childs.item(index);
                userName = elementoRolUser.getAttributes().getNamedItem("name").getNodeValue();
                if (actors.length() >= 0) {
                    actors.append(", ");
                }
                actors.append(userName);
                log.debug((Object)"Generamos el elemento");
                userRole.setProcessDefinitionId(new Long(def.getId()));
                userRole.setUserRole(userName);
                userRole.setAppRole(roleName);
                userRole.setIsUser(new Boolean(!elementoRolUser.getNodeName().equals("role")));
                log.debug((Object)"Grabamos");
                this.context.getSession().save((Object)userRole);
            }
            if (actors.length() > 0) {
                TaskMgmtDefinition taskMgmt = def.getTaskMgmtDefinition();
                Swimlane sl = taskMgmt.getSwimlane(roleName);
                if (sl != null) {
                    throw new BPMException("There already is a swimlane named " + roleName, -1);
                }
                sl = new Swimlane(roleName);
                taskMgmt.addSwimlane(sl);
                sl.setPooledActorsExpression(actors.toString());
            }
        }
    }

    public JbpmContext getContext() {
        return this.context;
    }

    public void setContext(JbpmContext context) {
        this.context = context;
    }

    public String[] upgradeProcess(ProcessInstance process) throws XPathExpressionException, ParserConfigurationException, FactoryConfigurationError, SAXException, BPMException, DocumentException, IOException {
        Vector<String> messages = new Vector<String>();
        ProcessDefinition currentDefinition = process.getProcessDefinition();
        ProcessDefinition newestDefinition = this.context.getGraphSession().findLatestProcessDefinition(currentDefinition.getName());
        if (currentDefinition.getId() == newestDefinition.getId()) {
            messages.add(new String("There is nothing to upgrade"));
        } else {
            ProcessDefinitionPropertyDal propertyDal = new ProcessDefinitionPropertyDal();
            propertyDal.setContext(this.context);
            String oldTag = propertyDal.getProcessDefinitionProperty(currentDefinition.getId(), "tag");
            String newTag = propertyDal.getProcessDefinitionProperty(newestDefinition.getId(), "tag");
            Document d = this.parseUIDescriptor(newestDefinition);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setXPathVariableResolver(new DummyVariableResolver(oldTag));
            Node upgrade = (Node)xpath.evaluate("/process/upgrade/process[tag=$tag]", d, XPathConstants.NODE);
            if (upgrade == null) {
                messages.add("Forcing upgrade to " + newTag);
            } else {
                messages.add("Trying upgrade to " + newTag);
            }
            if (!this.doProcessUpgrade(process, upgrade, newestDefinition, messages)) {
                messages.add("Process not upgraded");
            }
        }
        return messages.toArray(new String[messages.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SchemaLoader
    implements EntityResolver {
        public static final String FILE_SCHEME = "file://";

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource((class$es$caib$bpm$business$UserInterfaceBusiness$SchemaLoader == null ? (class$es$caib$bpm$business$UserInterfaceBusiness$SchemaLoader = UserInterfaceBusiness.class$("es.caib.bpm.business.UserInterfaceBusiness$SchemaLoader")) : class$es$caib$bpm$business$UserInterfaceBusiness$SchemaLoader).getResourceAsStream("/es/caib/bpm/toolkit/xml/ui.xsd"));
        }
    }

    class DummyVariableResolver
    implements XPathVariableResolver {
        String sourceTask;

        public DummyVariableResolver(String sourceTask) {
            this.sourceTask = sourceTask;
        }

        public Object resolveVariable(QName variableName) {
            return this.sourceTask;
        }
    }
}

