/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.index;

import es.caib.bpm.entity.DBProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmContext;

public class DirectoryFactory {
    static Logger logger = Logger.getLogger((Class)(class$es$caib$bpm$index$DirectoryFactory == null ? (class$es$caib$bpm$index$DirectoryFactory = DirectoryFactory.class$("es.caib.bpm.index.DirectoryFactory")) : class$es$caib$bpm$index$DirectoryFactory));
    private static Directory d;
    static /* synthetic */ Class class$es$caib$bpm$index$DirectoryFactory;
    static /* synthetic */ Class class$es$caib$bpm$entity$DBProperty;

    public static synchronized Directory getDirectory(Session s) throws IOException {
        if (d == null) {
            DirectoryFactory.createDirectory(s);
        }
        return d;
    }

    private static void createDirectory(Session ctx) throws IOException {
        File f = DirectoryFactory.getFile(ctx);
        f.mkdirs();
        logger.debug((Object)("Inicializando directorio en " + f.getAbsolutePath()));
        d = new NIOFSDirectory(f);
    }

    private static File getFile(Session ctx) {
        DBProperty prop = (DBProperty)ctx.createCriteria(class$es$caib$bpm$entity$DBProperty == null ? (class$es$caib$bpm$entity$DBProperty = DirectoryFactory.class$("es.caib.bpm.entity.DBProperty")) : class$es$caib$bpm$entity$DBProperty).add((Criterion)Restrictions.eq((String)"app", (Object)"BPM")).add((Criterion)Restrictions.eq((String)"key", (Object)"lucene.dir")).uniqueResult();
        if (prop == null) {
            return new File(System.getProperty("es.caib.bpm.lucene.indexDirectory", "/app/document-manager/lucene"));
        }
        return new File(prop.getValue());
    }

    public static synchronized void clearDirectory(Session ctx) throws IOException {
        if (d != null) {
            logger.debug((Object)"Cerrando directorio lucene");
            d.close();
        }
        File f = DirectoryFactory.getFile(ctx);
        DirectoryFactory.recursiveDelete(new File[]{f});
        d = null;
        logger.debug((Object)("Limpiado directorio en " + f.getAbsolutePath()));
    }

    public static synchronized void reconfigureDirectory(JbpmContext ctx) throws IOException {
        d = null;
    }

    private static void recursiveDelete(File[] files) {
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isDirectory()) {
                DirectoryFactory.recursiveDelete(files[i].listFiles());
            }
            files[i].delete();
        }
    }

    public static Analyzer getAnalyzer() throws IOException {
        InputStreamReader r = new InputStreamReader((class$es$caib$bpm$index$DirectoryFactory == null ? (class$es$caib$bpm$index$DirectoryFactory = DirectoryFactory.class$("es.caib.bpm.index.DirectoryFactory")) : class$es$caib$bpm$index$DirectoryFactory).getResourceAsStream("stop-words.txt"), "UTF-8");
        StandardAnalyzer a = new StandardAnalyzer(Version.LUCENE_30, (Reader)r);
        return a;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

