/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.index;

import es.caib.bpm.config.Configuration;
import es.caib.bpm.index.DirectoryFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class Indexer {
    Logger l = Logger.getLogger((Class)(class$es$caib$bpm$index$Indexer == null ? (class$es$caib$bpm$index$Indexer = Indexer.class$("es.caib.bpm.index.Indexer")) : class$es$caib$bpm$index$Indexer));
    LinkedList documents = new LinkedList();
    private static Indexer theIndexer = null;
    static /* synthetic */ Class class$es$caib$bpm$index$Indexer;

    private Indexer() {
    }

    public static Indexer getIndexer() {
        if (theIndexer == null) {
            theIndexer = new Indexer();
        }
        return theIndexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Document d) {
        LinkedList linkedList = this.documents;
        synchronized (linkedList) {
            this.documents.addLast(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Session session) throws IOException {
        IndexWriter w;
        Directory dir = DirectoryFactory.getDirectory(session);
        try {
            w = new IndexWriter(dir, DirectoryFactory.getAnalyzer(), false, IndexWriter.MaxFieldLength.LIMITED);
        }
        catch (FileNotFoundException e) {
            w = new IndexWriter(dir, DirectoryFactory.getAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
        }
        try {
            boolean goon;
            Iterator it;
            LinkedList linkedList = this.documents;
            synchronized (linkedList) {
                it = this.documents.iterator();
                goon = it.hasNext();
            }
            while (goon) {
                Document d;
                linkedList = this.documents;
                synchronized (linkedList) {
                    d = (Document)it.next();
                    goon = it.hasNext();
                }
                this.l.debug((Object)("Deleting document " + d.get("$id")));
                w.deleteDocuments(new Term("$id", d.get("$id")));
                this.l.debug((Object)("Adding document " + d.get("$id")));
                w.addDocument(d);
                linkedList = this.documents;
                synchronized (linkedList) {
                    it.remove();
                }
                this.l.debug((Object)("Done document " + d.get("$id")));
            }
        }
        finally {
            w.close();
        }
    }

    public Document generateDocument(ProcessInstance pi) throws IOException {
        String id = Long.toString(pi.getId());
        Document d = new Document();
        d.add((Fieldable)new Field("$id", id, Field.Store.YES, Field.Index.ANALYZED));
        d.add((Fieldable)new Field("$definition", pi.getProcessDefinition().getName(), Field.Store.NO, Field.Index.ANALYZED));
        ContextInstance ci = pi.getContextInstance();
        StringBuffer contents = new StringBuffer();
        contents.append(pi.getProcessDefinition().getName());
        this.addTokenInfo(d, ci, pi.getRootToken(), contents);
        d.add((Fieldable)new Field("$contents", contents.toString(), Field.Store.NO, Field.Index.ANALYZED));
        d.add((Fieldable)new Field("$end", pi.getEnd() == null ? "false" : "true", Field.Store.NO, Field.Index.ANALYZED));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            d.add((Fieldable)new Field("$startDate", sdf.format(pi.getStart()), Field.Store.NO, Field.Index.ANALYZED));
            if (pi.getEnd() != null) {
                d.add((Fieldable)new Field("$endDate", sdf.format(pi.getEnd()), Field.Store.NO, Field.Index.ANALYZED));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return d;
    }

    public void index(ProcessInstance pi) throws IOException {
        this.enqueue(this.generateDocument(pi));
    }

    private StringBuffer addTokenInfo(Document d, ContextInstance ci, Token token, StringBuffer contents) {
        String prefix = token.isRoot() ? "" : token.getFullName() + "/";
        Map m = ci.getVariables(token);
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = m.get(key);
            if (value == null) continue;
            d.add((Fieldable)new Field(prefix + key, value.toString(), Field.Store.NO, Field.Index.ANALYZED));
            contents.append(" ");
            contents.append(value.toString());
        }
        StringBuffer comments = new StringBuffer();
        if (token.getComments() != null) {
            Iterator it2 = token.getComments().iterator();
            while (it2.hasNext()) {
                Comment c = (Comment)it2.next();
                if (c.getMessage() == null) continue;
                comments.append(c.getMessage());
                comments.append(" ");
            }
        }
        d.add((Fieldable)new Field(prefix + "comments", comments.toString(), Field.Store.NO, Field.Index.ANALYZED));
        contents.append(comments);
        Map children = token.getChildren();
        if (children != null && children.keySet() != null) {
            Iterator it3 = children.keySet().iterator();
            while (it3.hasNext()) {
                Token childToken = token.getChild((String)it3.next());
                this.addTokenInfo(d, ci, childToken, contents);
            }
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexAll() throws IOException {
        JbpmContext ctx = Configuration.getConfig().createJbpmContext();
        LinkedList linkedList = this.documents;
        synchronized (linkedList) {
            this.documents.clear();
            DirectoryFactory.clearDirectory(ctx.getSession());
        }
        try {
            Iterator itDef = ctx.getGraphSession().findAllProcessDefinitions().iterator();
            while (itDef.hasNext()) {
                ProcessDefinition def = (ProcessDefinition)itDef.next();
                Iterator itProc = ctx.getGraphSession().findProcessInstances(def.getId()).iterator();
                while (itProc.hasNext()) {
                    ProcessInstance pi = (ProcessInstance)itProc.next();
                    try {
                        Document d = this.generateDocument(pi);
                        this.enqueue(d);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            ctx.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

