/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.task;

import java.util.Iterator;
import java.util.Set;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class BPMTaskInstance
extends TaskInstance {
    private static final long serialVersionUID = 1L;

    public BPMTaskInstance() {
    }

    public BPMTaskInstance(String taskName, String actorId) {
        super(taskName, actorId);
    }

    public BPMTaskInstance(String taskName) {
        super(taskName);
    }

    public void setActorId(String actorId, boolean overwriteSwimlane) {
        super.setActorId(actorId, overwriteSwimlane);
        this.updateObserverSwimlane();
    }

    private void updateObserverSwimlane() {
        TaskMgmtDefinition def;
        Swimlane sld;
        SwimlaneInstance sl = this.getTaskMgmtInstance().getSwimlaneInstance("observer");
        if (sl == null && (sld = (def = this.getTaskMgmtInstance().getTaskMgmtDefinition()).getSwimlane("observer")) != null) {
            sl = this.getTaskMgmtInstance().createSwimlaneInstance(sld);
        }
        if (sl != null) {
            if (this.getActorId() != null) {
                this.addMemberToSwimlane(sl, this.getActorId());
            }
            if (this.getPooledActors() != null) {
                Iterator it = this.getPooledActors().iterator();
                while (it.hasNext()) {
                    PooledActor actor = (PooledActor)it.next();
                    this.addMemberToSwimlane(sl, actor.getActorId());
                }
            }
        }
    }

    private void addMemberToSwimlane(SwimlaneInstance sl, String actorId) {
        if (sl.getPooledActors() == null) {
            sl.setPooledActors(new String[]{actorId});
        } else {
            Iterator it = sl.getPooledActors().iterator();
            while (it.hasNext()) {
                PooledActor actor = (PooledActor)it.next();
                if (!actorId.equals(actor.getActorId())) continue;
                return;
            }
            sl.getPooledActors().add(new PooledActor(actorId));
        }
    }

    public void setPooledActors(Set pooledActors) {
        super.setPooledActors(pooledActors);
        this.updateObserverSwimlane();
    }

    public void setPooledActors(String[] actorIds) {
        super.setPooledActors(actorIds);
        this.updateObserverSwimlane();
    }
}

