/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.identity.seycon;

import es.caib.bpm.beans.home.SeyconBPMIdentityLocalHome;
import es.caib.bpm.beans.local.SeyconBPMIdentityLocal;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.identity.seycon.vo.User;
import es.caib.bpm.identity.vo.Group;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityManager {
    protected SeyconBPMIdentityLocal identityBean = IdentityManager.getIdentityBean();

    protected static SeyconBPMIdentityLocal getIdentityBean() throws NamingException, CreateException {
        try {
            InitialContext BPMContext = new InitialContext(System.getProperties());
            Object lookupObj = BPMContext.lookup(System.getProperty("es.caib.ibkey.identity.service.local", "java:local/ejb/SeyconBPMIdentityBeanLocal"));
            SeyconBPMIdentityLocalHome home = (SeyconBPMIdentityLocalHome)PortableRemoteObject.narrow((Object)lookupObj, SeyconBPMIdentityLocalHome.class);
            SeyconBPMIdentityLocal engine = home.create();
            return engine;
        }
        catch (NamingException e) {
            Logger.getLogger(IdentityManager.class).error((Object)e);
            throw e;
        }
        catch (CreateException e) {
            Logger.getLogger(IdentityManager.class).error((Object)e);
            throw e;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.identityBean.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Group obtenirGrupPerNom(String nomGrup) throws Exception {
        return this.identityBean.obtenirGrupPerNom(nomGrup);
    }

    public synchronized es.caib.bpm.identity.vo.User obtenirUsuariPerCodiUsuari(String user) throws Exception {
        return this.identityBean.obtenirUsuariPerCodiUsuari(user);
    }

    public synchronized Collection obtenirUsuarisPerRolGrup(String role) throws Exception {
        return this.identityBean.obtenirUsuarisPerRolGrup(role);
    }

    public synchronized Collection obtenirUsuarisPerRolQuePertanyenAlGrup(String role, String group) throws Exception {
        return this.identityBean.obtenirUsuarisPerRolQuePertanyenAlGrup(role, group);
    }

    public synchronized Collection obtenirUsuarisPerRolQuePertanyenAlGrup(String role, String group, boolean toString) throws Exception {
        return this.identityBean.obtenirUsuarisPerRolQuePertanyenAlGrup(role, group, toString);
    }

    public synchronized Collection obtenirUsuarisPerRolGrupExcloentGrupsHeretats(String role) throws Exception {
        return this.identityBean.obtenirUsuarisPerRolGrupExcloentGrupsHeretats(role);
    }

    public synchronized Group obtenirGrupParePerGrup(String group) throws Exception {
        return this.identityBean.obtenirGrupParePerGrup(group);
    }

    public synchronized Collection<String> obtenirGrupsPerCodiUsuari(String usercode) throws Exception {
        return this.identityBean.obtenirGrupsPerCodiUsuari(usercode);
    }

    public synchronized String obtenirCorreuPerCodiUsuari(String usercode) throws Exception {
        return this.identityBean.obtenirUsuariPerCodiUsuari(usercode).getEmail();
    }

    public synchronized es.caib.bpm.identity.vo.User obtenirUsuariPerNif(String nif) throws Exception {
        return this.identityBean.obtenirUsuariPerNif(nif);
    }

    public synchronized String obtenirGrupPerSeccioPressupostaria(String seccioPressupostaria) throws Exception {
        return this.identityBean.obtenirGrupPerSeccioPressupostaria(seccioPressupostaria).getName();
    }

    public synchronized String obtenirNifPerCodiUsuari(String usercode) throws Exception {
        return this.identityBean.obtenirUsuariPerCodiUsuari(usercode).getNif();
    }

    public synchronized String obtenirDireccioGeneralPerCodiUsuari(String _codiUsuari) throws Exception {
        String grupPrimari = this.obtenirGrupPrimariPerCodiUsuari(_codiUsuari);
        String grupActual = grupPrimari;
        if (grupActual != null) {
            if (this.obtenirDirectorPerGrup(grupActual) != null) {
                return grupActual;
            }
            Group g = this.obtenirGrupParePerGrup(grupActual);
            if (g != null) {
                return g.getName();
            }
            return null;
        }
        throw new Exception("No existeix cap IBK_DIRECTOR per a cap dels grups als qu\u00e8 pertany l'usuari " + _codiUsuari);
    }

    public synchronized String obtenirConselleriaPerDireccioGeneral(String direccioGeneral) throws Exception {
        Group g = this.obtenirGrupParePerGrup(direccioGeneral);
        return g.getName();
    }

    public synchronized String obtenirGrupPrimariPerCodiUsuari(String codiUsuari) throws Exception {
        return this.identityBean.obtenirGrupPrimariPerCodiUsuari(codiUsuari).getName();
    }

    public synchronized Object obtenirDirectorPerGrup(String grupActual) throws Exception {
        Collection users = this.obtenirUsuarisPerRolGrupExcloentGrupsHeretats(grupActual + "/IBK_DIRECTOR");
        if (users.size() > 1) {
            throw new Exception("No pot haber m\u00e9s d'un " + grupActual + "/IBK_DIRECTOR");
        }
        Iterator it = users.iterator();
        if (it.hasNext()) {
            return ((User)((Object)it.next())).getId();
        }
        return null;
    }

    public synchronized Object[] findUsersIdNomLlinatgesNifDgFromNomLlinatgesNif(String nom, String llinatges, String nif) throws BPMException {
        return this.identityBean.findUsersIdNomLlinatgesNifDgFromNomLlinatgesNif(nom, llinatges, nif);
    }

    public synchronized Object[] findUsersIdNomLlinatgesNifDgFromCodisUsuari(Collection codisUsuari) throws BPMException {
        return this.identityBean.findUsersIdNomLlinatgesNifDgFromCodisUsuari(codisUsuari);
    }
}

