package es.caib.bpm.beans;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.proxy.HibernateProxy;
import org.jbpm.identity.Membership;
import org.jbpm.identity.hibernate.IdentitySession;

import es.caib.bpm.exception.BPMException;
import es.caib.bpm.identity.hibernate.BPMIdentitySessionFactory;
import es.caib.bpm.identity.seycon.vo.Group;
import es.caib.bpm.identity.seycon.vo.User;


public class SeyconBPMIdentityBean implements SessionBean{


	private static final long serialVersionUID = 1L;
	
	private SessionContext context;
	private Logger log;
	
	public SeyconBPMIdentityBean() {
		 log = Logger.getLogger(SeyconBPMIdentityBean.class);
	}
	
	/**
     * 
     * @throws CreateException
     */
    
    public void ejbCreate() throws CreateException {
    }
	
	public void ejbActivate() throws EJBException, RemoteException {
	}

	public void ejbPassivate() throws EJBException, RemoteException {
	}

	public void ejbRemove() throws EJBException, RemoteException {
		
	}

	public void setSessionContext(SessionContext context) throws EJBException, RemoteException {
        this.context = context;
		
	}
	


	private boolean isInternalService ()
	{
		return context.isCallerInRole("BPM_INTERNAL");
	}

	
	public IdentitySession getIdentitySession(){
		return BPMIdentitySessionFactory.getCAIBIdentitySession();
		
	}
	
	
/*********  BUSINESS METHODS DECLARATIONS **/	
	
	
	
	/**Simple methods **/
	public User obtenirUsuariPerCodiUsuari(String userCode) throws BPMException{
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			org.jbpm.identity.User o=session.getUserByName(userCode);
			return (User)userToVO(o);
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null)session.close();
		}
	}


	//find user by its properties
	public User obtenirUsuariPerNif(String nif) throws BPMException{
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			Query q=session.getSession().createQuery("select u from es.caib.bpm.identity.entity.User u where lower(u.nif)=:nif");
			q.setString("nif", nif.toLowerCase());
			es.caib.bpm.identity.entity.User result=(es.caib.bpm.identity.entity.User)q.uniqueResult();
			if(result==null) return null;
			return (User) result.entityToVO();
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null) session.close();
		}
	}

	
	
	public Collection<User> obtenirUsuarisPerRolGrup(String role) throws BPMException{
		return obtenirUsuarisPerRolGrup(role,false);
	}

	public Collection obtenirUsuarisPerRolGrup(String role, boolean toString) throws BPMException{
		List users=new ArrayList();
		
		IdentitySession session=null;
		try{
			session=getIdentitySession();        
			if (role.contains("/")){
				int index = role.indexOf('/');
				String groupName = role.substring(0, index);
				String roleName = role.substring(index+1);
				org.jbpm.identity.Group g = session.getGroupByName(groupName);
				_addUsersRecursive (session, users, g, roleName,toString);
			} else {
				org.jbpm.identity.Group g = session.getGroupByName(role);
				
				if(toString){
					users.addAll(_getNames(g.getUsers()));
				}else{
					Collection vos=new es.caib.bpm.identity.entity.User().entityToVO(g.getUsers());
					users.addAll(vos);
				}
			}
			
			return users;
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null)session.close();
		}
		
	}
	


	private static void _addUsersRecursive(IdentitySession session, Collection<User> users2, org.jbpm.identity.Group g, String roleName, boolean toString) {
		if(g != null){
			Set users = g.getUsersForMembershipRole(roleName);
			if(toString){
				users.addAll(_getNames((Collection)users));
			}else{
				Collection<User> vos=(Collection<User>)new es.caib.bpm.identity.entity.User().entityToVO(users);
				users2.addAll(vos);
			}
			org.jbpm.identity.Group pare = g.getParent();
			_addUsersRecursive(session, users2, pare, roleName,toString);
		}
	}
	
	
	public Collection<User> obtenirUsuarisPerRolGrupExcloentGrupsHeretats(String role) throws BPMException{
		return  obtenirUsuarisPerRolGrupExcloentGrupsHeretats(role, false);
	}
	
	public Collection obtenirUsuarisPerRolGrupExcloentGrupsHeretats(String role,boolean toString) throws BPMException{
		Vector users=new Vector();
		
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			if (role.contains("/")){
				int index = role.indexOf('/');
				String groupName = role.substring(0, index);
				String roleName = role.substring(index+1);
				org.jbpm.identity.Group g = session.getGroupByName(groupName);
				if(g != null){
					
					Set users2 = g.getUsersForMembershipRole(roleName);
					if(toString){
						users.addAll(_getNames((Collection)users2));
					}else{
						Collection vos=new es.caib.bpm.identity.entity.User().entityToVO(users2);
						users.addAll(vos);
					}
				}
			} else {
				org.jbpm.identity.Group g = session.getGroupByName(role);
				if(toString){
					users.addAll(_getNames((Collection)users));
				}else{
					Collection vos=new es.caib.bpm.identity.entity.User().entityToVO(g.getUsers());
					users.addAll(vos);
				}
			}
			return users;
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null)session.close();
		}
	}

	
	public es.caib.bpm.identity.vo.Group obtenirGrupPerNom(String groupName) throws BPMException{
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			org.jbpm.identity.Group o=session.getGroupByName(groupName);
//			session.close();
			return groupToVo(o);
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null) session.close();
		}
	}


	//find group from relations
	/**
	 * Busca rols i grups a les taules de JBPM
	 * @param rol
	 * @param domini
	 * @return
	 */
	
	public Collection<String> obtenirGrupsPerCodiUsuari(String userName) throws BPMException{
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			List<String> out=new ArrayList<String>();
			
			
			
	        org.jbpm.identity.User user = session.getUserByName(userName);
	        if(user==null) return null;
	        
	        Vector<String> userGroups=new Vector<String>();
	        
			if((user==null && userName!=null) || isInternalService()){
	        	userGroups.add("anonymous"); //PJR afegim el rol anonymous al usuari anonymous	
	        }else{
	        	if (user == null) {
	        
	        		throw new BPMException("Usuari amb codi '" + userName
	                    + "' no trobat al sistema JBPM.", null, 0);
	        	}
		        for (Iterator<Membership> it = user.getMemberships().iterator(); it.hasNext();) {
		            org.jbpm.identity.Membership member = (org.jbpm.identity.Membership) it.next();
		            org.jbpm.identity.Group group = member.getGroup();
		            if (member.getRole() == null) {
		                userGroups.add(group.getName());
		            } else {
		                addGroupRecursive(userGroups, group, member.getRole());
		            }
		        }
	        }
	
	        return userGroups;
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null) session.close();
		}
	}
	
	public es.caib.bpm.identity.vo.Group obtenirGrupParePerGrup(String groupName) throws BPMException{
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			org.jbpm.identity.Group o=session.getGroupByName(groupName).getParent();
			return groupToVo(o);
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null) session.close();
		}
		
		
		
	}



	public es.caib.bpm.identity.vo.Group obtenirGrupPrimariPerCodiUsuari(String userCode) throws BPMException{
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			Query q=session.getSession().createQuery("" +
					" select m.group " +
					" from es.caib.bpm.identity.entity.PrimaryGroupMembership m " +
					"where lower(m.user.name)=:user");
			q.setString("user", userCode.toLowerCase());
			org.jbpm.identity.Group result=(org.jbpm.identity.Group)q.uniqueResult();
			
	
			
			if(result==null) return null;
			return  groupToVo(result);
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
    	}finally{
//			if(session!=null) session.close();
		}
	}
	
	
	public Group obtenirGrupPerSeccioPressupostaria(String seccioPressupostaria) throws BPMException{
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			Query q=session.getSession().createQuery("" +
				" select g " +
				" from es.caib.bpm.identity.entity.Group g inner join  g.seccions seccio " +
				"where seccio.seccio=:seccioPressupostaria");
			q.setString("seccioPressupostaria", seccioPressupostaria);
			
			es.caib.bpm.identity.entity.Group result=(es.caib.bpm.identity.entity.Group)q.uniqueResult();
//			session.close();
			if(result==null) return null;
			return  (Group)result.entityToVO();
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null)session.close();
		}
	}

	/** Advanced search methods **/

	public Object [] findUsersIdNomLlinatgesNifDgFromNomLlinatgesNif(String nom,String llinatges, String nif) throws BPMException{
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			Query q=session.getSession().createQuery("" +
				" select u.name, u.nom, u.llinatges, u.nif, g.name " +
				" from es.caib.bpm.identity.entity.PrimaryGroupMembership m inner join m.user u inner join m.group g " +
				" where lower(u.nom) like :nom " +
				" and lower(u.llinatges) like :llinatges " +
				" and lower(u.nif) like :nif "); 
			q.setString("nom", "%"+nom.toLowerCase()+"%");
			q.setString("llinatges", "%"+llinatges.toLowerCase()+"%");
			q.setString("nif", "%"+nif.toLowerCase()+"%");
			
			List out=q.list();
			
			if(out.size()==0) return new String [0];
			return (Object [])out.toArray();
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null)session.close();
		}
	}

	/** Advanced search methods **/

	public Object [] findUsersIdNomLlinatgesNifDgFromCodisUsuari(Collection codisUsuari) throws BPMException{
		if(codisUsuari==null || codisUsuari.size()==0) return new String [0][5];
		IdentitySession session=null;
		try{
			session=getIdentitySession();
			Query q=session.getSession().createQuery("" +
				" select u.name, u.nom, u.llinatges, u.nif, g.name " +
				" from es.caib.bpm.identity.entity.PrimaryGroupMembership m inner join m.user u inner join m.group g " +
				" where u.name in (:codisUsuari) ");
		
			q.setParameterList("codisUsuari",codisUsuari);
			
			List out=q.list();
			if(out.size()==0) return new String [0];
			return (Object [])out.toArray();
    	}catch(Throwable t){
    		Logger.getLogger(this.getClass()).error(t);
    		throw new BPMException(t,0);
		}finally{
//			if(session!=null)session.close();
		}
	}
	
	public Collection obtenirUsuarisPerRolQuePertanyenAlGrup(String role, String group) throws BPMException{
		return obtenirUsuarisPerRolQuePertanyenAlGrup(role, group, false);
	}
	public Collection obtenirUsuarisPerRolQuePertanyenAlGrup(String role, String group,boolean toString) throws BPMException{
				List users=new ArrayList();
				
				IdentitySession session=null;
				try{
					session=getIdentitySession();
					Query q=session.getSession().createQuery("" +
						" select u " +
						" from org.jbpm.identity.Membership m inner join m.user u inner join m.group g " +
						" where g.name = :role and g.type = 'security-role' and u in \n" +
						" ( \n" +
						" 	select u2 " +
						" 	from org.jbpm.identity.Membership m2 inner join m2.user u2 inner join m2.group g2 \n" +
						" 	where g2.name = :group and g2.type = 'organisation' \n" +
						" ) \n ");
				
					q.setParameter("role",role);
					q.setParameter("group",group);
					
					List users2=q.list();
					
					if(users2.size()==0){
						return new ArrayList<User>();
					}else{
						if(toString){
							users.addAll(_getNames((Collection)users2));
						}else{
							Collection vos=new es.caib.bpm.identity.entity.User().entityToVO(users2);
							users.addAll(vos);
						}
					}
		    	}catch(Throwable t){
		    		Logger.getLogger(this.getClass()).error(t);
		    		throw new BPMException(t,0);
				}finally{
//					if(session!=null)session.close();
				}
				return users;
				
		}
	
/**UTILITY methods */	
    private void addGroupRecursive(Collection v, org.jbpm.identity.Group group, String role) {
        v.add(group.getName() + "/" + role);
        for (Iterator it = group.getChildren().iterator(); it.hasNext();) {
        	org.jbpm.identity.Group child = (org.jbpm.identity.Group) it.next();
            addGroupRecursive(v, child, role);
        }
    }
	
	
	private static Collection<String> _getNames(Collection obj) {
		List<String> out=new ArrayList<String>();
		Iterator  it=obj.iterator();
		while(it.hasNext()){
			Object elem=it.next();
			String name;
			try {
				name = (String)elem.getClass().getMethod("getName",new Class[0]).invoke(elem,new Object[0]);
			} catch (Exception e) {
				Logger.getLogger(SeyconBPMIdentityBean.class).error(e.getMessage(),e);
				throw new ClassCastException(e.getMessage());
			}
			out.add(name);
		}
		
		return out;
	} 

	
	
	protected es.caib.bpm.identity.vo.Group groupToVo(org.jbpm.identity.Group o) {
		es.caib.bpm.identity.entity.Group oS=null;
		org.jbpm.identity.Group oB=null;
		if(o==null) return null;
		
		if (o instanceof HibernateProxy){  
				
			if(((HibernateProxy) o).getHibernateLazyInitializer().getImplementation() instanceof es.caib.bpm.identity.entity.Group){
			
				oS=(es.caib.bpm.identity.entity.Group)es.caib.bpm.identity.entity.Group.class.cast(((HibernateProxy) o).getHibernateLazyInitializer().getImplementation());
			
			}else if(((HibernateProxy) o).getHibernateLazyInitializer().getImplementation() instanceof org.jbpm.identity.Group){
				
				oB=(org.jbpm.identity.Group)org.jbpm.identity.Group.class.cast(((HibernateProxy) o).getHibernateLazyInitializer().getImplementation());
			
			}
		}else if(o instanceof es.caib.bpm.identity.entity.Group){
			oS=(es.caib.bpm.identity.entity.Group)o;
		}else if(o instanceof org.jbpm.identity.Group){
			oB=o;
		}else{
			throw new ClassCastException("Cannot cast from JBPM group to SEYCON group");
		}
		
		if(oB!=null) return es.caib.bpm.identity.vo.Group.entityToVO(oB);
		if(oS!=null) return oS.entityToVO();
		return null;
	}

   
	protected  es.caib.bpm.identity.vo.User userToVO(org.jbpm.identity.User o) {
		es.caib.bpm.identity.entity.User oS=null;
		org.jbpm.identity.User oB=null;
		if(o==null) return null;
		
		if (o instanceof HibernateProxy){  
				
			if(((HibernateProxy) o).getHibernateLazyInitializer().getImplementation() instanceof es.caib.bpm.identity.entity.User){
			
				oS=(es.caib.bpm.identity.entity.User)es.caib.bpm.identity.entity.User.class.cast(((HibernateProxy) o).getHibernateLazyInitializer().getImplementation());
			
			}else if(((HibernateProxy) o).getHibernateLazyInitializer().getImplementation() instanceof org.jbpm.identity.User){
				
				oB=(org.jbpm.identity.User)org.jbpm.identity.User.class.cast(((HibernateProxy) o).getHibernateLazyInitializer().getImplementation());
			
			}
		}else if(o instanceof es.caib.bpm.identity.entity.User){
			oS=(es.caib.bpm.identity.entity.User)o;
		}else if(o instanceof org.jbpm.identity.User){
			oB=o;
		}else{
			throw new ClassCastException("Cannot cast from JBPM group to SEYCON group");
		}
		
		if(oB!=null) return es.caib.bpm.identity.vo.User.entityToVO(oB);
		if(oS!=null) return oS.entityToVO();
		return null;
	}


}
