package es.caib.bpm.beans.local;

import java.util.Collection;

import javax.ejb.EJBLocalObject;

import es.caib.bpm.exception.BPMException;
import es.caib.bpm.identity.seycon.vo.Group;
import es.caib.bpm.identity.seycon.vo.User;




public interface SeyconBPMIdentityLocal extends EJBLocalObject {


	/**Simple methods **/
	public User obtenirUsuariPerCodiUsuari(String userCode) throws BPMException;

	//find user by its properties
	public User obtenirUsuariPerNif(String nif) throws BPMException;

	//find user By relations
	public Collection<User> obtenirUsuarisPerRolGrup(String role) throws BPMException;
	public Collection obtenirUsuarisPerRolGrup(String role, boolean toString) throws BPMException;
	public Collection<User> obtenirUsuarisPerRolGrupExcloentGrupsHeretats(String role) throws BPMException;
	public Collection obtenirUsuarisPerRolGrupExcloentGrupsHeretats(String role,boolean toString) throws BPMException;



	
	public es.caib.bpm.identity.vo.Group obtenirGrupPerNom(String groupName) throws BPMException;
	//find groups by its properties

	//find group from relations
	public Collection<String> obtenirGrupsPerCodiUsuari(String userName) throws BPMException;
	public es.caib.bpm.identity.vo.Group obtenirGrupParePerGrup(String groupName) throws BPMException;
	public Group obtenirGrupPerSeccioPressupostaria(String seccioPressupostaria) throws BPMException;

	/** Advanced search methods **/
	public Object [] findUsersIdNomLlinatgesNifDgFromNomLlinatgesNif(String nom, String llinatges, String nif) throws BPMException;
	public es.caib.bpm.identity.vo.Group obtenirGrupPrimariPerCodiUsuari(String userCode) throws BPMException;
	public Object [] findUsersIdNomLlinatgesNifDgFromCodisUsuari(Collection codisUsuari) throws BPMException;

	public Collection obtenirUsuarisPerRolQuePertanyenAlGrup(String role, String group) throws BPMException;
	public Collection obtenirUsuarisPerRolQuePertanyenAlGrup(String role, String group,boolean toString) throws BPMException;

}
