package es.caib.bpm.identity.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.hibernate.proxy.HibernateProxy;




/**
 * Extensió de grup amb dades de grup CAIB
 * @author u91940
 *
 */
public class Group extends org.jbpm.identity.Group{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public Set seccions;

	/**
	 * @return the seccions
	 */
	public synchronized Set getSeccions() {
		return seccions;
	}

	/**
	 * @param seccions the seccions to set
	 */
	public synchronized void setSeccions(Set seccions) {
		this.seccions = seccions;
	}

	public es.caib.bpm.identity.vo.Group entityToVO(){
		org.jbpm.identity.Group g=this;
		es.caib.bpm.identity.entity.Group g2=null;
		
		//El Lazy initializer ens ha tornat proxies als Groups, que poden ser instàncies de la subclasse, però per a poder fer el cast a la subclasse hem de fer això
		if (g instanceof HibernateProxy)  
			g2 = (es.caib.bpm.identity.entity.Group)org.jbpm.identity.Group.class.cast(((HibernateProxy) g).getHibernateLazyInitializer().getImplementation());  
		else if(g instanceof es.caib.bpm.identity.entity.Group)
			g2=this;
		else
			throw new ClassCastException("Cannot cast from JBPM user to SEYCON user");
		
		
		es.caib.bpm.identity.seycon.vo.Group out=new es.caib.bpm.identity.seycon.vo.Group();

		out.setName(g2.getName());
		if(g2.getSeccions()!=null){
			String [] sec=new String[g2.getSeccions().size()];
			Iterator<SeccioPressupostaria> it=g2.getSeccions().iterator();
			int i=0;
			while(it.hasNext()){
				sec[i]=((SeccioPressupostaria)it.next()).seccio;
				i++;
			}
			out.setSeccions(sec);		
		}
		
		return out;
	}
	
	public Collection<es.caib.bpm.identity.vo.Group> entityToVO(Collection<org.jbpm.identity.Group> in){
		List<es.caib.bpm.identity.vo.Group> out=new ArrayList<es.caib.bpm.identity.vo.Group>();

		Iterator<org.jbpm.identity.Group> it=in.iterator();
		
		while(it.hasNext()){
			org.jbpm.identity.Group g=(org.jbpm.identity.Group)it.next();
			//El Lazy initializer ens ha tornat proxies als Users, que poden ser instàncies de la subclasse, però per a poder fer el cast a la subclasse hem de fer això
			Group g2=null;
			
			//El Lazy initializer ens ha tornat proxies als Groups, que poden ser instàncies de la subclasse, però per a poder fer el cast a la subclasse hem de fer això
			if (g instanceof HibernateProxy)  
				g2 = (es.caib.bpm.identity.entity.Group)org.jbpm.identity.Group.class.cast(((HibernateProxy) g).getHibernateLazyInitializer().getImplementation());  
			else if(g instanceof es.caib.bpm.identity.entity.Group)
				g2=(es.caib.bpm.identity.entity.Group)g;
			else
				throw new ClassCastException("Cannot cast from JBPM user to SEYCON user");
		
			
			out.add(g2.entityToVO());
		}
		return out;
	}
	
	
}
