package es.caib.bpm.identity.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.hibernate.proxy.HibernateProxy;



/**
 * Extensió d'org.jbpm.identity.User per a que tingui més informació necessària.
 * @author u91940
 *
 */

public class User extends org.jbpm.identity.User{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public String nom;
	public String llinatges;
	public String nif;
	
	/**
	 * @return the usuCodi
	 */
	public synchronized String getNom() {
		return nom;
	}
	/**
	 * @param usuCodi the usuCodi to set
	 */
	public synchronized void setNom(String nom) {
		this.nom = nom;
	}
	/**
	 * @return the llinatges
	 */
	public synchronized String getLlinatges() {
		return llinatges;
	}
	/**
	 * @param llinatges the llinatges to set
	 */
	public synchronized void setLlinatges(String llinatges) {
		this.llinatges = llinatges;
	}
	/**
	 * @return the nif
	 */
	public synchronized String getNif() {
		return nif;
	}
	/**
	 * @param nif the nif to set
	 */
	public synchronized void setNif(String nif) {
		this.nif = nif;
	}
	
	public es.caib.bpm.identity.vo.User entityToVO(){
		
		org.jbpm.identity.User ju=this;
		es.caib.bpm.identity.entity.User cu=null;
		
		//El Lazy initializer ens ha tornat proxies als Users, que poden ser instàncies de la subclasse, però per a poder fer el cast a la subclasse hem de fer això
		if (ju instanceof HibernateProxy)  
			cu = (es.caib.bpm.identity.entity.User)org.jbpm.identity.User.class.cast(((HibernateProxy) ju).getHibernateLazyInitializer().getImplementation());  
		else if(ju instanceof es.caib.bpm.identity.entity.User)
			cu=this;
		else
			throw new ClassCastException("Cannot cast from JBPM user to SEYCON user");
		
		es.caib.bpm.identity.seycon.vo.User out=new es.caib.bpm.identity.seycon.vo.User();
		out.setNom(cu.getNom());
		out.setEmail(cu.getEmail());
		out.setId(cu.getName());
		out.setLlinatges(cu.getLlinatges());
		out.setNif(cu.getNif());
		
		return out;
	}
	
	
	public Collection<es.caib.bpm.identity.seycon.vo.User> entityToVO(Collection<org.jbpm.identity.User> in){
		List<es.caib.bpm.identity.seycon.vo.User> out=new ArrayList<es.caib.bpm.identity.seycon.vo.User>();
		Iterator<org.jbpm.identity.User> i=in.iterator();
		
		while(i.hasNext()){
			org.jbpm.identity.User ju=(org.jbpm.identity.User)i.next();
			es.caib.bpm.identity.entity.User cu=null;
			
			//El Lazy initializer ens ha tornat proxies als Users, que poden ser instàncies de la subclasse, però per a poder fer el cast a la subclasse hem de fer això
			if (ju instanceof HibernateProxy)  
				cu = (es.caib.bpm.identity.entity.User)org.jbpm.identity.User.class.cast(((HibernateProxy) ju).getHibernateLazyInitializer().getImplementation());  
			else if(ju instanceof es.caib.bpm.identity.entity.User)
				cu=(es.caib.bpm.identity.entity.User)ju;
			else
				throw new ClassCastException("Cannot cast from JBPM user to SEYCON user");
			 
			out.add((es.caib.bpm.identity.seycon.vo.User)cu.entityToVO());
		}
		
		return out;
	}
}
