package es.caib.bpm.identity.hibernate;

import java.sql.Connection;

import org.hibernate.cfg.Configuration;
import org.jbpm.db.JbpmSession;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.identity.hibernate.IdentitySessionFactory;

public class BPMIdentitySessionFactory extends IdentitySessionFactory {

	static BPMIdentitySessionFactory factory = null;

	private BPMIdentitySessionFactory(Configuration c) {
		configuration = c;
	}

	public static IdentitySession getCAIBIdentitySession() {

		if (factory == null) {
			Configuration c = IdentitySessionFactory.createConfiguration("bpm.identity-hibernate.cfg.xml");
			factory = new BPMIdentitySessionFactory(c);
		}

		//important !! reciclem la sessió actual 
		return new IdentitySession(factory.sessionFactory.getCurrentSession());
		

	}

}
