package es.caib.bpm.identity.seycon;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.log4j.Logger;

import es.caib.bpm.beans.home.SeyconBPMIdentityLocalHome;
import es.caib.bpm.beans.local.SeyconBPMIdentityLocal;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.identity.seycon.vo.User;
import es.caib.bpm.identity.vo.Group;

/**
 * Adapter, ha de retornar VOs
 * 
 * @author u91940
 *
 */

public class IdentityManager {

	protected SeyconBPMIdentityLocal identityBean=null;


	public IdentityManager() throws NamingException, CreateException {		
		identityBean=getIdentityBean();
	}

	
	protected static SeyconBPMIdentityLocal getIdentityBean() throws NamingException, CreateException {
		try{
			//localitzem l'EJB amb els parÃ metres definits al fitxer jndi.properties
			
			Context BPMContext = new InitialContext(System.getProperties());
			//lookup the home object 
			Object lookupObj = BPMContext.lookup(System.getProperty("es.caib.ibkey.identity.service.local","java:local/ejb/SeyconBPMIdentityBeanLocal"));
			SeyconBPMIdentityLocalHome home = (SeyconBPMIdentityLocalHome) PortableRemoteObject.narrow(lookupObj, SeyconBPMIdentityLocalHome.class);
	
			//create the bean object from the home object
			SeyconBPMIdentityLocal engine = (SeyconBPMIdentityLocal)home.create();
			return engine;
		}catch(NamingException e){
			Logger.getLogger(IdentityManager.class).error(e);
			throw e;
		}catch(CreateException e){
			Logger.getLogger(IdentityManager.class).error(e);
			throw e;
		}
	}

	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		try{
			identityBean.remove();
		}catch(Exception e){};
	}

	
	
	public synchronized es.caib.bpm.identity.vo.Group obtenirGrupPerNom(String nomGrup) throws Exception {
		return identityBean.obtenirGrupPerNom(nomGrup);			
	}

	
	public synchronized es.caib.bpm.identity.vo.User obtenirUsuariPerCodiUsuari(String user) throws Exception {
		return identityBean.obtenirUsuariPerCodiUsuari(user);			
	}
	
	/**
	 * Busca los usuarios de un rol en las tablas jbpm. Para el grupo actual y todos los grupos padre
	 * 
	 * @param ctx
	 * @param role
	 * @return
	 * @throws Exception
	 */
	public synchronized Collection obtenirUsuarisPerRolGrup(String role) throws Exception {
		return identityBean.obtenirUsuarisPerRolGrup(role);
		
	}

	
	/**
	 * Busca los usuarios de un rol en las tablas jbpm y que pertenezca al grupo
	 * 
	 * @param ctx
	 * @param role
	 * @return
	 * @throws Exception
	 */
	public synchronized Collection obtenirUsuarisPerRolQuePertanyenAlGrup(String role,String group) throws Exception {
		return identityBean.obtenirUsuarisPerRolQuePertanyenAlGrup(role,group);
		
	}

	/**
	 * Busca los usuarios de un rol en las tablas jbpmy que pertenezca al grupo
	 * 
	 * @param ctx
	 * @param role
	 * @return
	 * @throws Exception
	 */
	public synchronized Collection obtenirUsuarisPerRolQuePertanyenAlGrup(String role,String group, boolean toString) throws Exception {
		return identityBean.obtenirUsuarisPerRolQuePertanyenAlGrup(role,group,toString);
		
	}
	
	/**
	 * Busca los usuarios de un rol en las tablas jbpm. Sólo para el grupo actual
	 * 
	 * @param ctx
	 * @param role
	 * @return
	 * @throws Exception
	 */
	public synchronized Collection obtenirUsuarisPerRolGrupExcloentGrupsHeretats(String role) throws Exception {
		return identityBean.obtenirUsuarisPerRolGrupExcloentGrupsHeretats(role);

	}
	
	
	public synchronized es.caib.bpm.identity.vo.Group obtenirGrupParePerGrup(String group) throws Exception {
		return identityBean.obtenirGrupParePerGrup(group);
	}
	
	public synchronized Collection<String> obtenirGrupsPerCodiUsuari(String usercode) throws Exception {
		return identityBean.obtenirGrupsPerCodiUsuari(usercode);
	}

	/**
	 * Devuelve el correo del usuario. Se espera que exista una direccion de correo usercode@caib.es
	 * 
	 * @param ctx
	 * @param usercode
	 * @return
	 * @throws Exception
	 */
	public synchronized String obtenirCorreuPerCodiUsuari(String usercode) throws Exception {
		return identityBean.obtenirUsuariPerCodiUsuari(usercode).getEmail();
	}



	public synchronized es.caib.bpm.identity.vo.User obtenirUsuariPerNif(String nif) throws Exception {
		return identityBean.obtenirUsuariPerNif(nif);
	}
	
	
	/**
	 * Busca el grupo que contiene la SeccioPressupostaria pasada por par�metro
	 * 
	 * @param seccioPressupostaria
	 *           
	 * @return LDAPEntry entrada del directorio LDAP
	 */
	public synchronized String obtenirGrupPerSeccioPressupostaria (String seccioPressupostaria) throws Exception{
		return identityBean.obtenirGrupPerSeccioPressupostaria(seccioPressupostaria).getName();
	}

	/** 
	 * Recupera del directorio ldap el nif que se corresponde con el usuario pasado por par�metro
	 * 
	 * @param usercode
	 * @return
	 * @throws Exception
	 */
	public synchronized String obtenirNifPerCodiUsuari(String usercode) throws Exception {
		return ((es.caib.bpm.identity.seycon.vo.User)identityBean.obtenirUsuariPerCodiUsuari(usercode)).getNif();
	}


	
	public  synchronized String obtenirDireccioGeneralPerCodiUsuari(String _codiUsuari) throws Exception {
		String grupPrimari=obtenirGrupPrimariPerCodiUsuari(_codiUsuari);
		String grupActual=grupPrimari;
		
		while(grupActual!=null){
			if(obtenirDirectorPerGrup(grupActual)!=null) return grupActual;
			Group g=obtenirGrupParePerGrup(grupActual);
			if(g!=null) return g.getName();
			else return null;
		}
		
		throw new Exception("No existeix cap IBK_DIRECTOR per a cap dels grups als què pertany l'usuari "+_codiUsuari);

	}

	/**
	 * La conselleria s'obté des de les taules d'identitat de JBPM, i és el grup pare del grup corresponent a la direcció general.
	 * @param direccioGeneral
	 * @param ctx
	 * @return
	 * @throws Exception 
	 */
	public synchronized String obtenirConselleriaPerDireccioGeneral(String direccioGeneral) throws Exception {
       Group g= obtenirGrupParePerGrup(direccioGeneral);
        return g.getName();
	}
	
	public synchronized String obtenirGrupPrimariPerCodiUsuari(String codiUsuari) throws Exception{
		return identityBean.obtenirGrupPrimariPerCodiUsuari(codiUsuari).getName();
	}
	
	public synchronized Object obtenirDirectorPerGrup(String grupActual) throws Exception {

		Collection users=obtenirUsuarisPerRolGrupExcloentGrupsHeretats( grupActual+"/IBK_DIRECTOR");
		if(users.size()>1) throw new Exception("No pot haber més d'un "+grupActual+"/IBK_DIRECTOR");
		Iterator it=users.iterator();

		if(it.hasNext())
			return ((User)it.next()).getId();
		else
			return null;
	}
	
	public synchronized Object [] findUsersIdNomLlinatgesNifDgFromNomLlinatgesNif(String nom, String llinatges, String nif)throws BPMException{
		return identityBean.findUsersIdNomLlinatgesNifDgFromNomLlinatgesNif( nom,  llinatges,  nif);
	}
	
	public synchronized Object [] findUsersIdNomLlinatgesNifDgFromCodisUsuari(Collection codisUsuari) throws BPMException{
		return identityBean.findUsersIdNomLlinatgesNifDgFromCodisUsuari(codisUsuari);
	}
}