package es.caib.bpm.security;


import java.security.Principal;

import javax.naming.NamingException;

import org.jboss.security.SecurityAssociation;
import org.jbpm.security.AuthenticationService;

import es.caib.bpm.toolkit.PrincipalSignatureAuthenticator;
import es.caib.loginModule.client.SeyconPrincipal;
import es.caib.signatura.api.Signature;
import es.caib.signatura.impl.CMSSignaturev2;

public class SeyconAuthenticationService implements AuthenticationService, PrincipalSignatureAuthenticator{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3946296618076108944L;

	public String getActorId() {
		SeyconPrincipal principal;
		try {
			principal = SeyconPrincipal.getCurrent();
		} catch (NamingException e) {
			if (SecurityAssociation.getPrincipal() == null)
				return null;
			else
			return SecurityAssociation.getPrincipal().getName();
		}
		return principal.getName();
	}

	public void close() {
	}

    public void setActorId(String arg0) {
        // Ignorado
    }

	public boolean verifySignerIsPrincipal(Principal p, byte[] pkcs7) throws Exception{
		Signature sig=new CMSSignaturev2(pkcs7, "plain/text"); //el content type es indiferent perquè nomñes volem parsejar el certificat de la firma
		SeyconPrincipal principal;
		if ( p != null && p instanceof SeyconPrincipal)
			principal = (SeyconPrincipal) p;
		else
			principal = SeyconPrincipal.getCurrent();
		SeyconPrincipal signerPrincipal = new SeyconPrincipal (sig.getCert());
		if (principal.getNif() != null
				&& principal.getNif().equals(signerPrincipal.getNif()))
			return true;
		else
			return false;	
		
	}

}
