/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.servlet;

import es.caib.bpm.attachment.ProcessAttachmentManager;
import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.EJBContainer;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.bpm.vo.TaskInstance;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.reset();
        resp.addHeader("Expires", this.DATE_ONE);
        resp.setDateHeader("Last-Modified", new Date().getTime());
        String path = req.getPathInfo();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] split = path.split("/+");
        try {
            BPMEngineLocal engine = EJBContainer.getEJBContainer((HttpSession)req.getSession()).getEngine();
            Long id = new Long(split[0]);
            TaskAttachmentManager am = null;
            TaskInstance task = engine.getTask(id.longValue());
            if (task == null) {
                ProcessInstance process = engine.getProcess(id.longValue());
                if (process == null) {
                    resp.setStatus(204);
                    return;
                }
                am = new ProcessAttachmentManager(process);
            } else {
                am = new TaskAttachmentManager(task);
            }
            Document d = am.getDocument(split[1]);
            if (d == null) {
                resp.setStatus(204);
                return;
            }
            resp.setContentType(d.getMimeType());
            resp.addHeader("content-disposition", "inline; filename=" + d.getExternalName());
            d.openDownloadTransfer();
            byte[] b = d.nextDownloadPackage(8192);
            ServletOutputStream out = resp.getOutputStream();
            while (b != null) {
                out.write(b);
                b = d.nextDownloadPackage(8192);
            }
            d.endDownloadTransfer();
        }
        catch (CreateException e) {
            throw new ServletException("Session expired", (Throwable)e);
        }
        catch (NamingException e) {
            throw new ServletException("Cannot locate application server", (Throwable)e);
        }
        catch (BPMException e) {
            throw new ServletException("Cannot locate task " + split[0], (Throwable)e);
        }
        catch (DocumentBeanException e) {
            throw new ServletException("Cannot download document " + split[0] + "/" + split[1], (Throwable)e);
        }
    }
}

