/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.ui;

import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.toolkit.PrincipalSignatureAuthenticator;
import es.caib.bpm.toolkit.SignaturaHandler;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;
import es.caib.bpm.ui.CMSSignatureManagerHelper;
import es.caib.bpm.ui.CertifyDigitalCopyPDFSignatureManagerHelper;
import es.caib.bpm.ui.SignPDFSignatureManagerHelper;
import es.caib.signatura.api.Signature;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.Iterator;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Window;

public class SignatureManager
implements SignaturaHandler {
    private WorkflowWindow window;
    public static final String STAMP_TYPE_ALL = "ALL";
    public static final String STAMP_TYPE_ADOBE = "ADOBE";
    public static final String STAMP_TYPE_PDF417 = "PDF417";
    public static final String STAMP_TYPE_NONE = "NONE";
    public static final String STAMP_POSITION_ALL_TOP = "TOP";
    public static final String STAMP_POSITION_ADOBE_TOP_LEFT = "TOP_LEFT";
    public static final String STAMP_POSITION_ADOBE_TOP_RIGHT = "TOP_RIGHT";
    public static final String STAMP_POSITION_PDF417_LEFT = "LEFT";
    public static final String STAMP_POSITION_PDF417_RIGHT = "RIGHT";
    public static final String STAMP_POSITION_ALL_BOTTOM = "BOTTOM";
    public static final String STAMP_POSITION_ADOBE_BOTTOM_LEFT = "BOTTOM_LEFT";
    public static final String STAMP_POSITION_ADOBE_BOTTOM_RIGHT = "BOTTOM_RIGHT";
    public static final String STAMP_POSITION_ADOBE_LAST_PAGE = "LAST_PAGE";
    static /* synthetic */ Class class$es$caib$bpm$ui$SignatureManager;

    public SignatureManager(WorkflowWindow window) {
        this.window = window;
    }

    public void sign(String tag) throws WorkflowException {
        try {
            TaskAttachmentManager am = new TaskAttachmentManager(this.window.getTask());
            Document doc = am.getDocument(tag);
            if (doc == null) {
                throw new SystemWorkflowException(Labels.getLabel((String)"error.msgFirma3") + " " + tag);
            }
            Iterator it = doc.getSigns().iterator();
            while (it.hasNext()) {
                Signature sig = (Signature)it.next();
                if (!SignatureManager.verifyAuthor((Window)this.window, sig)) continue;
                return;
            }
            CMSSignatureManagerHelper.doSign((Window)this.window, am, tag, doc);
        }
        catch (UserWorkflowException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemWorkflowException((Throwable)e);
        }
    }

    public void signPDF(String inputTag, String outputTag, String enabledStampType, String[] enabledPositions, String forcedAdditionalText) throws WorkflowException {
        try {
            TaskAttachmentManager am = new TaskAttachmentManager(this.window.getTask());
            Document doc = am.getDocument(inputTag);
            if (doc == null) {
                throw new SystemWorkflowException(Labels.getLabel((String)"error.msgFirma3") + " " + inputTag);
            }
            SignPDFSignatureManagerHelper.doSignPDF(am, inputTag, outputTag, enabledStampType, enabledPositions, forcedAdditionalText);
        }
        catch (UserWorkflowException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemWorkflowException((Throwable)e);
        }
    }

    public void signPDF(String inputTag, String outputTag, String enabledStampType, String[] stampPositions, float top, float left, float height, float width, float rotation, String forcedAdditionalText) throws WorkflowException {
        try {
            TaskAttachmentManager am = new TaskAttachmentManager(this.window.getTask());
            Document doc = am.getDocument(inputTag);
            if (doc == null) {
                throw new SystemWorkflowException(Labels.getLabel((String)"error.msgFirma3") + " " + inputTag);
            }
            SignPDFSignatureManagerHelper.doSignPDF(am, inputTag, outputTag, enabledStampType, stampPositions, top, left, height, width, rotation, forcedAdditionalText);
        }
        catch (UserWorkflowException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemWorkflowException((Throwable)e);
        }
    }

    protected static boolean verifyAuthor(Window _window, Signature sig) throws Exception {
        if (System.getProperty("es.caib.bpm.checkUserCert") == null || System.getProperty("es.caib.bpm.checkUserCert") != null && "true".equals(System.getProperty("es.caib.bpm.checkUserCert").toLowerCase())) {
            Principal p = _window.getDesktop().getExecution().getUserPrincipal();
            String authenticationServiceClassName = System.getProperty("es.caib.bpm.principalSignatureAuthenticator", "es.caib.bpm.security.SeyconAuthenticationService");
            Class<?> authenticationServiceClass = (class$es$caib$bpm$ui$SignatureManager == null ? (class$es$caib$bpm$ui$SignatureManager = SignatureManager.class$("es.caib.bpm.ui.SignatureManager")) : class$es$caib$bpm$ui$SignatureManager).getClassLoader().loadClass(authenticationServiceClassName);
            Constructor<?> constructor = authenticationServiceClass.getConstructor(null);
            PrincipalSignatureAuthenticator authenticationService = (PrincipalSignatureAuthenticator)constructor.newInstance(null);
            return authenticationService.verifySignerIsPrincipal(p, sig.getPkcs7());
        }
        return true;
    }

    public void compulsaPDF(String inputTag, String outputTag, String url, String location, float x, float y, float rotation) throws WorkflowException {
        try {
            TaskAttachmentManager am = new TaskAttachmentManager(this.window.getTask());
            Document doc = am.getDocument(inputTag);
            if (doc == null) {
                throw new SystemWorkflowException(Labels.getLabel((String)"error.msgFirma3") + " " + inputTag);
            }
            CertifyDigitalCopyPDFSignatureManagerHelper.doCompulsaPDF(am, inputTag, outputTag, url, location, x, y, rotation);
        }
        catch (UserWorkflowException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemWorkflowException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

