/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.ui.admin;

import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.ui.inbox.ListitemCreator;
import es.caib.bpm.vo.Job;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.zkib.zkiblaf.Application;
import es.caib.zkib.zkiblaf.Frame;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Button;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Window;

public class ActiveJobHandler
extends Frame {
    private static final long serialVersionUID = 1L;
    private Listbox listbox;
    private Job currentJob;
    private Window currentJobWindow;

    public void onCreate() throws Exception {
        try {
            this.listbox = (Listbox)this.getFellow("listadoJobs");
            this.listbox.addEventListener("onSelect", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    ActiveJobHandler.this.onSelectJob();
                }
            });
            this.addEventListener("onReturn", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    ActiveJobHandler.this.refresh();
                }
            });
            this.refresh();
        }
        catch (Exception e) {
            throw new UiException((Throwable)e);
        }
    }

    public void onSelectJob() {
        if (this.listbox.getSelectedItem() != null) {
            if (this.currentJobWindow != null) {
                this.currentJobWindow.setVisible(false);
                this.currentJobWindow.setParent(null);
            }
            this.currentJob = (Job)this.listbox.getSelectedItem().getValue();
            Component[] components = Executions.getCurrent().createComponents("/wf/job.zul", new HashMap());
            if (components.length != 1) {
                throw new UiException("Expected only one component");
            }
            this.currentJobWindow = (Window)components[0];
            this.currentJobWindow.setParent((Component)this);
            SimpleDateFormat formatConHora = new SimpleDateFormat("dd/MM/yyyy hh:mm");
            ((Label)this.currentJobWindow.getFellow("job.id")).setValue(Long.toString(this.currentJob.getId()));
            ((Label)this.currentJobWindow.getFellow("job.process")).setValue(Long.toString(this.currentJob.getProcessId()));
            ((Label)this.currentJobWindow.getFellow("job.name")).setValue(this.currentJob.getName());
            ((Label)this.currentJobWindow.getFellow("job.dueDate")).setValue(formatConHora.format(this.currentJob.getDueDate()));
            ((Label)this.currentJobWindow.getFellow("job.failures")).setValue(Integer.toString(this.currentJob.getFailures()));
            ((Label)this.currentJobWindow.getFellow("job.error")).setValue(this.currentJob.getErrorMessage());
            Label statusLabel = (Label)this.currentJobWindow.getFellow("job.status");
            Button pauseButton = (Button)this.currentJobWindow.getFellow("pausebutton");
            Button resumeButton = (Button)this.currentJobWindow.getFellow("resumebutton");
            Button retryButton = (Button)this.currentJobWindow.getFellow("retrybutton");
            Button closeButton = (Button)this.currentJobWindow.getFellow("closebutton");
            Button processButton = (Button)this.currentJobWindow.getFellow("openprocess");
            processButton.addEventListener("onClick", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    ProcessInstance p = BPMApplication.getEngine().getProcess(ActiveJobHandler.this.currentJob.getProcessId());
                    String url = BPMApplication.getProcessURL((ProcessInstance)p);
                    ActiveJobHandler.this.currentJobWindow.setVisible(false);
                    ActiveJobHandler.this.currentJobWindow.setParent(null);
                    ActiveJobHandler.this.currentJobWindow = null;
                    ActiveJobHandler.this.currentJob = null;
                    Application.call((String)url);
                }
            });
            if (this.currentJob.isPaused()) {
                statusLabel.setValue(Labels.getLabel((String)"job.status.pause"));
                pauseButton.setVisible(false);
                retryButton.setVisible(false);
                resumeButton.addEventListener("onClick", new EventListener(){

                    public void onEvent(Event event) throws Exception {
                        BPMApplication.getEngine().resumeJob(ActiveJobHandler.this.currentJob);
                        ActiveJobHandler.this.refresh();
                    }
                });
            } else if (this.currentJob.isError()) {
                statusLabel.setValue(Labels.getLabel((String)"job.status.error"));
                pauseButton.setVisible(false);
                resumeButton.setVisible(false);
                retryButton.addEventListener("onClick", new EventListener(){

                    public void onEvent(Event event) throws Exception {
                        BPMApplication.getEngine().retryJob(ActiveJobHandler.this.currentJob);
                        ActiveJobHandler.this.refresh();
                    }
                });
            } else {
                if (this.currentJob.getFailures() > 0 && this.currentJob.getErrorMessage() != null) {
                    statusLabel.setValue(Labels.getLabel((String)"job.status.warning"));
                } else {
                    statusLabel.setValue(Labels.getLabel((String)"job.status.pending"));
                }
                retryButton.setVisible(false);
                resumeButton.setVisible(false);
                pauseButton.addEventListener("onClick", new EventListener(){

                    public void onEvent(Event event) throws Exception {
                        BPMApplication.getEngine().pauseJob(ActiveJobHandler.this.currentJob);
                        ActiveJobHandler.this.refresh();
                    }
                });
            }
            closeButton.addEventListener("onClick", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    ActiveJobHandler.this.currentJobWindow.setVisible(false);
                    ActiveJobHandler.this.currentJobWindow.setParent(null);
                    ActiveJobHandler.this.currentJobWindow = null;
                    ActiveJobHandler.this.currentJob = null;
                }
            });
            this.currentJobWindow.doOverlapped();
            this.listbox.setSelectedItem(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RemoteException, InterruptedException, CreateException, NamingException, BPMException {
        BPMEngineLocal engine = BPMApplication.getEngine();
        List jobs = null;
        Listitem item = null;
        jobs = engine.getActiveJobs();
        if (this.listbox.getItems() != null) {
            this.listbox.getItems().clear();
            this.listbox.setSelectedItem(null);
        }
        if (jobs != null) {
            ListitemCreator decorator = new ListitemCreator(engine);
            Iterator itTask = jobs.iterator();
            while (itTask.hasNext()) {
                Job job = (Job)itTask.next();
                item = decorator.createListitem(job);
                this.listbox.getItems().add(item);
            }
        }
    }
}

