/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.ui.admin;

import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.vo.ProcessDefinition;
import es.caib.zkib.zkiblaf.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Button;
import org.zkoss.zul.Fileupload;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Textbox;

public class DespliegueUI
extends Frame {
    private static final long serialVersionUID = 1L;
    private Listbox listbox;
    private Button disablebutton;
    private Button enablebutton;
    private static Logger log = Logger.getLogger((Class)(class$es$caib$bpm$ui$admin$DespliegueUI == null ? (class$es$caib$bpm$ui$admin$DespliegueUI = DespliegueUI.class$("es.caib.bpm.ui.admin.DespliegueUI")) : class$es$caib$bpm$ui$admin$DespliegueUI));
    static /* synthetic */ Class class$es$caib$bpm$ui$admin$DespliegueUI;

    public void onCreate() throws Exception {
        this.listbox = (Listbox)this.getFellow("listbox");
        this.disablebutton = (Button)this.getFellow("disableButton");
        this.enablebutton = (Button)this.getFellow("enableButton");
        this.cargarListadoProcesos();
    }

    public void cargarListadoProcesos() throws LoginException, RemoteException, CreateException, NamingException {
        BPMEngineLocal engine = BPMApplication.getEngine();
        List list = null;
        ProcessDefinition definition = null;
        Listitem item = null;
        list = engine.findProcessDefinitions(null, true);
        if (this.listbox.getItems() != null) {
            this.listbox.getItems().clear();
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            definition = (ProcessDefinition)it.next();
            item = new Listitem();
            item.getChildren().add(new Listcell(definition.getName()));
            item.getChildren().add(new Listcell(definition.getTag()));
            if (definition.isEnabled()) {
                item.getChildren().add(new Listcell(new Long(definition.getId()).toString()));
            } else {
                item.getChildren().add(new Listcell(Labels.getLabel((String)"deploy.lblDisabled")));
            }
            item.setValue((Object)definition);
            this.listbox.getItems().add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload() throws LoginException, CreateException, NamingException {
        this.getDesktop().getSession();
        BPMEngineLocal engine = BPMApplication.getEngine();
        Media dataSubida = null;
        InputStream streamLectura = null;
        int leidos = 0;
        byte[] buffer = new byte[4096];
        Textbox resultadoDespliegue = null;
        try {
            resultadoDespliegue = (Textbox)this.getFellow("txtResultadoDespliegue");
            dataSubida = Fileupload.get();
            if (dataSubida != null) {
                resultadoDespliegue.setText(Labels.getLabel((String)"deploy.msgDesplegandoProceso"));
                streamLectura = dataSubida.getStreamData();
                log.debug((Object)"Abrimos la transferencia");
                engine.openDeployParDefinitionTransfer();
                log.debug((Object)"Enviamos los paquetes");
                while ((leidos = streamLectura.read(buffer)) != -1) {
                    engine.nextDeployParDefinitionPackage(buffer, leidos);
                }
                log.debug((Object)"Cerramos la transferencia del archivo");
                engine.endDeployParDefinitionTransfer();
                String[] messages = engine.getDeployMessages();
                this.cargarListadoProcesos();
                log.debug((Object)"Se desplego el proceso correctamente.");
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy kk:mm:ss");
                String dataDesplegament = sdf.format(new Date());
                StringBuffer b = new StringBuffer();
                b.append(dataDesplegament + ": " + Labels.getLabel((String)"deploy.msgProcesoDesplegadoCorrectamente"));
                for (int i = 0; i < messages.length; ++i) {
                    b.append('\n');
                    b.append(messages[i]);
                }
                resultadoDespliegue.setText(b.toString());
            }
        }
        catch (BPMException e) {
            String[] messages = engine.getDeployMessages();
            StringBuffer b = new StringBuffer();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy kk:mm:ss");
            String dataDesplegament = sdf.format(new Date());
            b.append(dataDesplegament + ": " + Labels.getLabel((String)"deploy.msgErrorDesplegandoProceso"));
            for (int i = 0; i < messages.length; ++i) {
                b.append('\n');
                b.append(messages[i]);
            }
            resultadoDespliegue.setText(b.toString());
            log.error((Object)e);
        }
        catch (Exception e) {
            resultadoDespliegue.setText(Labels.getLabel((String)"deploy.msgErrorDesplegandoProceso") + e.toString());
            log.error((Object)e);
        }
        finally {
            if (streamLectura != null) {
                try {
                    streamLectura.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public void onSelect() {
        if (this.listbox.getSelectedItem() == null) {
            this.disablebutton.setDisabled(true);
            this.enablebutton.setDisabled(true);
        } else {
            ProcessDefinition def = (ProcessDefinition)this.listbox.getSelectedItem().getValue();
            this.disablebutton.setDisabled(!def.isEnabled());
            this.enablebutton.setDisabled(def.isEnabled());
        }
    }

    public void enable() throws BPMException, CreateException, NamingException, LoginException, RemoteException {
        if (this.listbox.getSelectedItem() != null) {
            ProcessDefinition def = (ProcessDefinition)this.listbox.getSelectedItem().getValue();
            def = BPMApplication.getEngine().enableProcessDefinition(def);
            this.listbox.getSelectedItem().setValue((Object)def);
            this.cargarListadoProcesos();
        }
    }

    public void disable() throws BPMException, CreateException, NamingException, LoginException, RemoteException {
        if (this.listbox.getSelectedItem() != null) {
            ProcessDefinition def = (ProcessDefinition)this.listbox.getSelectedItem().getValue();
            def = BPMApplication.getEngine().disableProcessDefinition(def);
            this.listbox.getSelectedItem().setValue((Object)def);
            this.cargarListadoProcesos();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

