/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.ui.inbox;

import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.ui.inbox.ListitemCreator;
import es.caib.bpm.util.Timer;
import es.caib.bpm.vo.TaskInstance;
import es.caib.zkib.zkiblaf.Application;
import es.caib.zkib.zkiblaf.Frame;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;

public abstract class AbstractInboxHandler
extends Frame {
    private static final long serialVersionUID = 1L;
    private Listbox listbox;

    public void onCreate() throws Exception {
        try {
            this.listbox = (Listbox)this.getFellow("listadoTareas");
            this.listbox.addEventListener("onSelect", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    Listitem item = AbstractInboxHandler.this.listbox.getSelectedItem();
                    TaskInstance task = (TaskInstance)item.getValue();
                    Application.call((String)BPMApplication.getTaskURL((TaskInstance)task));
                }
            });
            this.addEventListener("onReturn", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    AbstractInboxHandler.this.refresh();
                }
            });
            this.refresh();
        }
        catch (Exception e) {
            throw new UiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RemoteException, InterruptedException, CreateException, NamingException, BPMException {
        BPMEngineLocal engine = BPMApplication.getEngine();
        List tareas = null;
        Listitem item = null;
        TaskInstance task = null;
        tareas = this.getTasks(engine);
        if (this.listbox.getItems() != null) {
            this.listbox.getItems().clear();
            this.listbox.setSelectedItem(null);
        }
        if (tareas != null) {
            Collections.sort(tareas, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    TaskInstance t0 = (TaskInstance)arg0;
                    TaskInstance t1 = (TaskInstance)arg1;
                    if (t0.getPriority() < t1.getPriority()) {
                        return -1;
                    }
                    if (t0.getPriority() > t1.getPriority()) {
                        return 1;
                    }
                    if (t0.getCreate().getTime() < t1.getCreate().getTime()) {
                        return -1;
                    }
                    if (t0.getCreate().getTime() > t1.getCreate().getTime()) {
                        return 1;
                    }
                    return 0;
                }
            });
            Timer t2 = new Timer(new Timer[]{new Timer()});
            ListitemCreator decorator = new ListitemCreator(engine);
            Iterator itTask = tareas.iterator();
            while (itTask.hasNext()) {
                t2.reset();
                task = (TaskInstance)itTask.next();
                item = decorator.createListitem(task);
                this.listbox.getItems().add(item);
                t2.logTime("AbstractInboxHandler.createListitem", Integer.parseInt(System.getProperty("es.caib.ibkey.timer.fastTask.milis", "100")));
            }
        }
    }

    public abstract List getTasks(BPMEngineLocal var1) throws BPMException;
}

