/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.ui.inbox;

import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.vo.ProcessDefinition;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.zkib.zkiblaf.Application;
import es.caib.zkib.zkiblaf.Frame;
import es.caib.zkib.zkiblaf.Missatgebox;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Textbox;

public class Search
extends Frame {
    private static final long serialVersionUID = 1L;
    private Textbox txtTarea;
    private Datebox txtStartDate;
    private Datebox txtEndDate;
    private Checkbox chkFinalizada;
    private static Logger log = Logger.getLogger((Class)(class$es$caib$bpm$ui$inbox$Search == null ? (class$es$caib$bpm$ui$inbox$Search = Search.class$("es.caib.bpm.ui.inbox.Search")) : class$es$caib$bpm$ui$inbox$Search));
    static /* synthetic */ Class class$es$caib$bpm$ui$inbox$Search;

    public void onCreate() throws Exception {
        this.txtTarea = (Textbox)this.getFellow("txt");
        this.txtStartDate = (Datebox)this.getFellow("startDate");
        this.txtEndDate = (Datebox)this.getFellow("endDate");
        this.chkFinalizada = (Checkbox)this.getFellow("txtFinalizada");
    }

    private BPMEngineLocal getEngine(Session sesion) throws CreateException, NamingException {
        return BPMApplication.getEngine();
    }

    public void buscar() throws RemoteException, InterruptedException, CreateException, NamingException, WrongValueException, BPMException {
        Session sesion = this.getDesktop().getSession();
        BPMEngineLocal engine = this.getEngine(sesion);
        List resultado = null;
        Listitem item = null;
        Listbox resultadoBusqueda = null;
        try {
            SimpleDateFormat formatoLucene = new SimpleDateFormat("yyyyMMdd");
            String dataIni = null;
            String dataFi = null;
            if (this.txtStartDate.getValue() != null) {
                try {
                    dataIni = formatoLucene.format(this.txtStartDate.getValue());
                    if (dataIni.length() != 8) {
                        throw new Exception();
                    }
                }
                catch (Throwable th) {
                    throw new BPMException("Error: el format de la data d'inici ha de ser 'yyyyMMdd'", -1);
                }
            }
            if (this.txtEndDate.getValue() != null) {
                try {
                    dataFi = formatoLucene.format(this.txtEndDate.getValue());
                    if (dataFi.length() != 8) {
                        throw new Exception();
                    }
                }
                catch (Throwable th) {
                    throw new BPMException("Error: el format de la data de fi ha de ser 'yyyyMMdd'", -1);
                }
            }
            resultado = engine.searchProcessInstances(this.txtTarea.getValue(), dataIni, dataFi, this.chkFinalizada.isChecked());
            log.debug((Object)("Se encontraron " + resultado.size() + " instancias."));
            resultadoBusqueda = (Listbox)this.getFellow("resultadoBusqueda");
            resultadoBusqueda.getItems().clear();
            if (resultado.size() == 0) {
                Missatgebox.avis((String)Labels.getLabel((String)"observacion.resultadoVacio"));
            }
            SimpleDateFormat formatConHora = new SimpleDateFormat("dd/MM/yyyy hh:mm");
            Iterator it = resultado.iterator();
            while (it.hasNext()) {
                ProcessInstance instance = (ProcessInstance)it.next();
                if (!this.chkFinalizada.isChecked() && instance.getEnd() != null) continue;
                ProcessDefinition definition = engine.getProcessDefinition(instance);
                item = new Listitem();
                item.setValue((Object)instance);
                item.appendChild((Component)new Listcell(Long.toString(instance.getId())));
                item.appendChild((Component)new Listcell(definition.getName()));
                item.appendChild((Component)new Listcell(instance.getCurrentTask()));
                item.appendChild((Component)new Listcell(formatConHora.format(instance.getStart())));
                item.appendChild((Component)new Listcell(instance.getEnd() != null ? instance.getEnd().toString() : ""));
                resultadoBusqueda.appendChild((Component)item);
            }
        }
        catch (BPMException e) {
            String msgError = Labels.getLabel((String)("error.code." + e.getErrorCode()));
            if (msgError == null) {
                msgError = e.getMessage();
            }
            Missatgebox.error((String)msgError);
        }
    }

    public void seleccionarProceso(Listbox listbox) throws DocumentException, IOException, CreateException, NamingException, BPMException {
        Listitem item = listbox.getSelectedItem();
        ProcessInstance process = (ProcessInstance)item.getValue();
        listbox.setSelectedItem(null);
        Application.call((String)BPMApplication.getProcessURL((ProcessInstance)process));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

