/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.ui.process;

import es.caib.bpm.attachment.ProcessAttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.classloader.UIClassLoader;
import es.caib.bpm.datamodel.BPMDataNode;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.nas.exception.NASException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.toolkit.SignaturaHandler;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.ui.SignatureManager;
import es.caib.bpm.ui.inbox.ListitemCreator;
import es.caib.bpm.ui.tree.FirmaListitem;
import es.caib.bpm.vo.Job;
import es.caib.bpm.vo.ProcessDefinition;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.bpm.vo.TaskInstance;
import es.caib.bpm.vo.Token;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.zkib.component.DataGrid;
import es.caib.zkib.component.DataModel;
import es.caib.zkib.zkiblaf.Application;
import es.caib.zkib.zkiblaf.Frame;
import es.caib.zkib.zkiblaf.Missatgebox;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.imageio.ImageIO;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zul.Button;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Window;
import org.zkoss.zul.impl.InputElement;

public class ProcessUI
extends Frame {
    private long processId = 0L;
    Label proceso;
    Label asignadoA;
    Datebox fechaInicioProceso;
    Datebox fechaCreacionTarea;
    Datebox fechaFinalizacionProceso;
    Listbox tablaArchivos;
    private Listbox tablaJobs;
    private Listbox tablaTareas;
    private Label estado;
    private Label descripcion;
    private Label idproceso;
    Component ventanaDinamica = null;
    ProcessInstance currentProcess;
    ProcessDefinition currentDefinition;
    private Job currentJob;
    private Window currentJobWindow;
    private DataModel model;
    private DataGrid comments;
    private Component tabAnexos;
    private Component anexos;
    private Tabbox tabbox;
    private org.zkoss.zul.Image visorProceso;
    private Button btnUpgrade;
    private Button btnCancel;
    private static Logger log = Logger.getLogger((Class)(class$es$caib$bpm$ui$process$ProcessUI == null ? (class$es$caib$bpm$ui$process$ProcessUI = ProcessUI.class$("es.caib.bpm.ui.process.ProcessUI")) : class$es$caib$bpm$ui$process$ProcessUI));
    private static final long serialVersionUID = 1L;
    private static Hashtable classLoaders = new Hashtable();
    static /* synthetic */ Class class$es$caib$bpm$ui$process$ProcessUI;

    public ProcessUI() {
        HttpServletRequest req = (HttpServletRequest)Executions.getCurrent().getNativeRequest();
        String id = req.getParameter("id");
        if (id != null) {
            this.processId = Long.parseLong(id);
        }
    }

    public void onCreate() throws Exception {
        this.proceso = (Label)this.getFellow("txtProceso");
        this.idproceso = (Label)this.getFellow("txtIdProceso");
        this.descripcion = (Label)this.getFellow("txtDescripcion");
        this.fechaInicioProceso = (Datebox)this.getFellow("txtFechaInicio");
        this.fechaFinalizacionProceso = (Datebox)this.getFellow("txtFechaFinalizacion");
        this.fechaCreacionTarea = (Datebox)this.getFellow("txtFechaCreacion");
        this.asignadoA = (Label)this.getFellow("txtAsignadoA");
        this.estado = (Label)this.getFellow("txtEstado");
        this.tablaArchivos = this.getAttachmentsListbox();
        this.tablaTareas = (Listbox)this.getFellow("listadoTareas");
        this.tablaJobs = (Listbox)this.getFellow("listadoJobs");
        this.ventanaDinamica = this.getFellow("datosElementoWorkflow");
        this.model = (DataModel)this.getFellow("BPMdata");
        this.comments = (DataGrid)this.getFellow("comments");
        this.tabAnexos = this.getFellow("tabAnexos");
        this.anexos = this.getFellow("anexos");
        this.tabbox = (Tabbox)this.getFellow("tabbox");
        this.visorProceso = (org.zkoss.zul.Image)this.getFellow("visorProcesoWnd").getFellow("visorProceso");
        this.btnCancel = (Button)this.getFellow("btnCancel");
        this.btnUpgrade = (Button)this.getFellow("btnUpgrade");
        if (this.processId > 0L) {
            ProcessInstance pi = BPMApplication.getEngine().getProcess(this.processId);
            this.openProcessInstance(pi);
        }
        this.addEventListener("onReturn", new EventListener(){

            public void onEvent(Event event) throws Exception {
                ProcessInstance pi = BPMApplication.getEngine().getProcess(ProcessUI.this.processId);
                ProcessUI.this.openProcessInstance(pi);
            }
        });
    }

    private WorkflowWindow getWorkflowWindow() {
        if (this.ventanaDinamica.getChildren().size() > 0) {
            Component c = (Component)this.ventanaDinamica.getChildren().get(0);
            if (c instanceof WorkflowWindow) {
                return (WorkflowWindow)c;
            }
            return null;
        }
        return null;
    }

    public ProcessInstance getCurrentProcess() {
        return this.currentProcess;
    }

    public void setCurrentProcess(ProcessInstance currentProcess) {
        this.currentProcess = currentProcess;
        if (this.model != null) {
            BPMDataNode node = (BPMDataNode)this.model.getDataNode();
            node.setProcessInstance(currentProcess);
            this.model.refresh();
        } else if (currentProcess != null) {
            throw new RuntimeException("Intentado asignar tarea sin objeto BPMDataNode");
        }
    }

    public ProcessDefinition getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setCurrentDefinition(ProcessDefinition currentDefinition) {
        this.currentDefinition = currentDefinition;
        if (this.model != null) {
            BPMDataNode node = (BPMDataNode)this.model.getDataNode();
            node.setProcessDefinition(currentDefinition);
            this.model.refresh();
        } else if (this.currentProcess != null) {
            throw new RuntimeException("Intentado asignar tarea sin objeto BPMDataNode");
        }
    }

    public void refresh() throws IOException, DocumentException, ClassNotFoundException, SQLException, NamingException, CreateException, BPMException {
        this.openProcessInstance(this.getCurrentProcess());
        if (this.currentJobWindow != null) {
            this.currentJobWindow.setParent(null);
        }
        this.currentJobWindow = null;
        this.currentJob = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProcessInstance(ProcessInstance proc) throws IOException, DocumentException, ClassNotFoundException, SQLException, NamingException, CreateException, BPMException {
        block16: {
            BPMEngineLocal engine = this.getEngine();
            Executions.getCurrent().getUserPrincipal().getName();
            this.setCurrentProcess(proc);
            ProcessDefinition definicion = engine.getProcessDefinition(proc);
            this.setCurrentDefinition(definicion);
            String subject = null;
            try {
                subject = (String)proc.getVariables().get("Subject");
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            Application.setTitle((String)(subject == null ? definicion.getName() + " " + proc.getId() : subject));
            byte[] imagen = engine.getProcessDefinitionImage(definicion);
            BufferedImage imagenBuffered = ImageIO.read(new ByteArrayInputStream(imagen));
            imagenBuffered.getGraphics().setColor(Color.RED);
            int[] coordinates = engine.getCoordinates(proc);
            Graphics2D graph = (Graphics2D)imagenBuffered.getGraphics();
            graph.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graph.setPaint(new Color(255, 140, 140));
            graph.setStroke(new BasicStroke(2.5f));
            graph.draw(new Rectangle2D.Double(coordinates[0], coordinates[1], coordinates[2], coordinates[3]));
            ByteArrayOutputStream streamSalidaImagen = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)imagenBuffered, "jpeg", streamSalidaImagen);
            AImage imagenProceso = new AImage("image/jpeg", streamSalidaImagen.toByteArray());
            this.visorProceso.setContent((Image)imagenProceso);
            this.proceso.setValue(definicion.getName() + " (Ver. " + definicion.getTag() + ")");
            this.idproceso.setValue(Long.toString(proc.getId()));
            this.fechaFinalizacionProceso.setValue(proc.getEnd());
            this.fechaInicioProceso.setValue(proc.getStart());
            List tasks = engine.getActiveTasks(proc);
            if (tasks.isEmpty()) {
                this.asignadoA.setValue("-");
            } else {
                StringBuffer users = new StringBuffer();
                Iterator it = tasks.iterator();
                while (it.hasNext()) {
                    TaskInstance task = (TaskInstance)it.next();
                    this.fechaCreacionTarea.setValue(task.getCreate());
                    if (task.getActorId() != null) {
                        if (users.length() > 0) {
                            users.append(", ");
                        }
                        users.append(task.getActorId());
                        continue;
                    }
                    Iterator it2 = task.getPooledActors().iterator();
                    while (it2.hasNext()) {
                        if (users.length() > 0) {
                            users.append(", ");
                        }
                        users.append(it2.next());
                    }
                }
                this.asignadoA.setValue(users.toString());
            }
            this.describeTokens(proc, engine);
            ClassLoader heavenClassLoader = this.cargarClasesUI(definicion);
            try {
                this.ventanaDinamica.getChildren().clear();
                String ui = engine.getUI(proc);
                if (ui == null) {
                    PageDefinition def = Executions.getCurrent().getPageDefinition("/wf/process/default.zul");
                    Executions.createComponents((PageDefinition)def, (Component)this.ventanaDinamica, null);
                } else {
                    Executions.createComponentsDirectly((String)ui, (String)"zul", (Component)this.ventanaDinamica, null);
                }
                this.comments.setDataPath("BPMdata:/processInstance/comments");
                boolean canAdmin = engine.canAdmin(proc);
                this.btnCancel.setVisible(canAdmin && !this.isFinalized());
                this.btnUpgrade.setVisible(canAdmin && !this.isFinalized());
                WorkflowWindow window = this.getWorkflowWindow();
                if (window != null) {
                    window.setTask(null);
                    window.setProcessInstance(proc);
                    window.setEngine(engine);
                    window.setSignatureHandler((SignaturaHandler)new SignatureManager(window));
                    Events.sendEvent((Event)new Event("onLoad", (Component)window));
                    this.tabAnexos.setVisible(window.isShowAttachments());
                    this.anexos.setVisible(window.isShowAttachments());
                    this.cargarTablaArchivos(proc, this.tablaArchivos);
                    this.cargarTablaTareas(proc, this.tablaTareas);
                    this.cargarTablaJobs(proc, this.tablaJobs);
                    this.tabbox.setSelectedIndex(0);
                    break block16;
                }
                throw new UiException("El objecto generado debiera sera una instancia de WorkflowWindow");
            }
            finally {
                if (heavenClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(heavenClassLoader);
                }
            }
        }
    }

    private void describeTokens(ProcessInstance proc, BPMEngineLocal engine) throws BPMException {
        Token[] tokens = engine.getTokens(proc.getId());
        if (tokens == null || tokens.length == 0) {
            this.estado.setValue(Labels.getLabel((String)"token.lblFinished"));
        } else {
            StringBuffer status = new StringBuffer();
            for (int i = 0; i < tokens.length; ++i) {
                if (!"/".equals(tokens[i].getTokenName())) {
                    status.append(tokens[i].getTokenName());
                    status.append(": ");
                }
                status.append(this.describeToken(tokens[i]));
                status.append("\n");
            }
            this.estado.setValue(status.toString());
        }
    }

    private String describeToken(Token token) {
        StringBuffer text = new StringBuffer();
        text.append(token.getNodeName());
        if (token.isFinished()) {
            text.append(" (");
            text.append(Labels.getLabel((String)"token.lblFinished"));
            text.append(")");
        } else if (token.isSuspended()) {
            text.append(" (");
            text.append(Labels.getLabel((String)"token.lblSuspended"));
            text.append(")");
        } else if (token.isLocked()) {
            text.append(" (");
            text.append(Labels.getLabel((String)"token.lblLocked"));
            text.append(")");
        } else {
            text.append(" (");
            text.append(Labels.getLabel((String)"token.lblActive"));
            text.append(")");
        }
        return text.toString();
    }

    private void cargarTablaJobs(ProcessInstance proc, Listbox tablaJobs) throws CreateException, NamingException, BPMException {
        List jobs = this.getEngine().getActiveJobs(proc);
        if (jobs == null || jobs.isEmpty()) {
            tablaJobs.setVisible(false);
        } else {
            tablaJobs.setVisible(true);
            while (tablaJobs.getItemCount() > 0) {
                tablaJobs.getItemAtIndex(0).setParent(null);
            }
            ListitemCreator creator = new ListitemCreator(this.getEngine());
            Iterator it = jobs.iterator();
            while (it.hasNext()) {
                Job job = (Job)it.next();
                Listitem item = creator.createListitem(job);
                tablaJobs.getItems().add(item);
            }
        }
    }

    public void onSelectTask() {
        TaskInstance ti = (TaskInstance)this.tablaTareas.getSelectedItem().getValue();
        Application.call((String)BPMApplication.getTaskURL((TaskInstance)ti));
    }

    public void onSelectJob() {
        this.currentJob = (Job)this.tablaJobs.getSelectedItem().getValue();
        Component[] components = Executions.getCurrent().createComponents("/wf/job.zul", new HashMap());
        if (components.length != 1) {
            throw new UiException("Expected only one component");
        }
        if (this.currentJobWindow != null) {
            this.currentJobWindow.setParent(null);
        }
        this.currentJobWindow = (Window)components[0];
        this.currentJobWindow.setParent((Component)this);
        SimpleDateFormat formatConHora = new SimpleDateFormat("dd/MM/yyyy hh:mm");
        ((Label)this.currentJobWindow.getFellow("job.id")).setValue(Long.toString(this.currentJob.getId()));
        ((Label)this.currentJobWindow.getFellow("job.process")).setValue(Long.toString(this.currentJob.getProcessId()));
        ((Label)this.currentJobWindow.getFellow("job.name")).setValue(this.currentJob.getName());
        ((Label)this.currentJobWindow.getFellow("job.dueDate")).setValue(formatConHora.format(this.currentJob.getDueDate()));
        ((Label)this.currentJobWindow.getFellow("job.failures")).setValue(Integer.toString(this.currentJob.getFailures()));
        ((Label)this.currentJobWindow.getFellow("job.error")).setValue(this.currentJob.getErrorMessage());
        Label statusLabel = (Label)this.currentJobWindow.getFellow("job.status");
        Button pauseButton = (Button)this.currentJobWindow.getFellow("pausebutton");
        Button resumeButton = (Button)this.currentJobWindow.getFellow("resumebutton");
        Button retryButton = (Button)this.currentJobWindow.getFellow("retrybutton");
        Button closeButton = (Button)this.currentJobWindow.getFellow("closebutton");
        Button processButton = (Button)this.currentJobWindow.getFellow("openprocess");
        processButton.setVisible(false);
        if (this.currentJob.isPaused()) {
            statusLabel.setValue(Labels.getLabel((String)"job.status.pause"));
            pauseButton.setVisible(false);
            retryButton.setVisible(false);
            resumeButton.addEventListener("onClick", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    ProcessUI.this.getEngine().resumeJob(ProcessUI.this.currentJob);
                    ProcessUI.this.refresh();
                }
            });
        } else if (this.currentJob.isError()) {
            statusLabel.setValue(Labels.getLabel((String)"job.status.error"));
            pauseButton.setVisible(false);
            resumeButton.setVisible(false);
            retryButton.addEventListener("onClick", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    ProcessUI.this.getEngine().retryJob(ProcessUI.this.currentJob);
                    ProcessUI.this.refresh();
                }
            });
        } else {
            if (this.currentJob.getFailures() > 0 && this.currentJob.getErrorMessage() != null) {
                statusLabel.setValue(Labels.getLabel((String)"job.status.warning"));
            } else {
                statusLabel.setValue(Labels.getLabel((String)"job.status.pending"));
            }
            retryButton.setVisible(false);
            resumeButton.setVisible(false);
            pauseButton.addEventListener("onClick", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    ProcessUI.this.getEngine().pauseJob(ProcessUI.this.currentJob);
                    ProcessUI.this.refresh();
                }
            });
        }
        closeButton.addEventListener("onClick", new EventListener(){

            public void onEvent(Event event) throws Exception {
                ProcessUI.this.currentJobWindow.setVisible(false);
                ProcessUI.this.currentJobWindow.setParent(null);
                ProcessUI.this.currentJobWindow = null;
                ProcessUI.this.currentJob = null;
            }
        });
        this.currentJobWindow.doOverlapped();
        this.tablaJobs.setSelectedItem(null);
    }

    private void cargarTablaTareas(ProcessInstance proc, Listbox tablaTareas) throws CreateException, NamingException, BPMException {
        BPMEngineLocal engine = this.getEngine();
        List tasks = engine.getActiveTasks(proc);
        if (tasks == null || tasks.isEmpty()) {
            tablaTareas.setVisible(false);
        } else {
            tablaTareas.setVisible(true);
            while (tablaTareas.getItemCount() > 0) {
                tablaTareas.getItemAtIndex(0).setParent(null);
            }
            ListitemCreator creator = new ListitemCreator(engine);
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                TaskInstance task = (TaskInstance)it.next();
                Listitem item = creator.createListitem(task);
                tablaTareas.getItems().add(item);
            }
        }
    }

    private void disableInputbox(Component componente) {
        if (componente instanceof InputElement) {
            ((InputElement)componente).setReadonly(true);
        } else if (componente instanceof Listbox) {
            ((Listbox)componente).setDisabled(true);
        } else if (componente instanceof Button) {
            ((Button)componente).setDisabled(true);
        } else {
            Iterator it = componente.getChildren().iterator();
            while (it.hasNext()) {
                Component child = (Component)it.next();
                this.disableInputbox(child);
            }
        }
    }

    public void refreshListadoArchivos() throws IOException, NamingException, CreateException {
        this.getDesktop().getSession();
        Listbox tablaArchivos = null;
        tablaArchivos = this.getAttachmentsListbox();
        if (this.getCurrentProcess() != null) {
            this.cargarTablaArchivos(this.getCurrentProcess(), tablaArchivos);
        }
    }

    public void cargarTablaArchivos(ProcessInstance process, Listbox tablaArchivos) throws IOException, NamingException, CreateException {
        Listitem item = null;
        String roles = null;
        ProcessAttachmentManager business = new ProcessAttachmentManager(process);
        tablaArchivos.getItems().clear();
        Iterator it = business.getTags().iterator();
        while (it.hasNext()) {
            String tag = (String)it.next();
            Document document = business.getDocument(tag);
            item = new Listitem();
            item.appendChild((Component)new Listcell(document.getExternalName()));
            item.appendChild((Component)new Listcell(document.getMimeType()));
            item.setValue((Object)tag);
            if (document.getRoles().isEmpty()) {
                item.appendChild((Component)new Listcell("P\u00fablico"));
                item.appendChild((Component)new Listcell(""));
            } else {
                item.appendChild((Component)new Listcell("Privado"));
                roles = "";
                Iterator itRoles = document.getRoles().iterator();
                while (itRoles.hasNext()) {
                    String role = (String)itRoles.next();
                    roles = roles + role + " ";
                }
                item.appendChild((Component)new Listcell(roles));
            }
            tablaArchivos.getItems().add(item);
        }
    }

    public ClassLoader cargarClasesUI(ProcessDefinition def) throws ClassNotFoundException, SQLException, IOException, CreateException, NamingException {
        Map clases = null;
        UIClassLoader loader = null;
        this.getDesktop().getSession();
        BPMEngineLocal engine = this.getEngine();
        ClassLoader heavenLoader = null;
        heavenLoader = Thread.currentThread().getContextClassLoader();
        loader = (UIClassLoader)classLoaders.get(new Long(def.getId()));
        if (loader == null) {
            clases = engine.getUIClassesForTask(def);
            loader = new UIClassLoader(clases, heavenLoader);
            loader.cargarClases();
            classLoaders.put(new Long(def.getId()), loader);
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)loader);
        return heavenLoader;
    }

    public void cerrar() throws InterruptedException, IOException, CreateException, NamingException, BPMException, ClassNotFoundException, SQLException, DocumentException {
        Application.goBack();
    }

    private BPMEngineLocal getEngine() throws CreateException, NamingException {
        return BPMApplication.getEngine();
    }

    public void descargarArchivo() throws IOException, DocumentBeanException, BPMException, InterruptedException {
        Listbox tablaArchivos = null;
        Listitem item = null;
        ProcessAttachmentManager business = new ProcessAttachmentManager(this.getCurrentProcess());
        tablaArchivos = this.getAttachmentsListbox();
        if (tablaArchivos != null) {
            item = tablaArchivos.getSelectedItem();
            if (item != null) {
                String tag = (String)item.getValue();
                Executions.getCurrent().sendRedirect(business.getDownloadURL(tag), "_new");
            } else {
                Missatgebox.info((String)"Debe seleccionar un archivo");
            }
        } else {
            Missatgebox.info((String)"Debe cargar Archivos antes de intentar descargarlos");
        }
    }

    public void seleccionarDocumento() throws SignatureTimestampException, IOException, ClassNotFoundException, NASException, NamingException, CreateException {
        Listbox tablaArchivos = null;
        Listitem item = null;
        Listitem roleListItem = null;
        Document document = null;
        Set rolesDocumento = null;
        String role = null;
        Listbox tablaRoles = null;
        List firmas = null;
        Signature sign = null;
        Vbox roles = (Vbox)this.getFellow("rolesDocumento");
        ProcessAttachmentManager am = new ProcessAttachmentManager(this.getCurrentProcess());
        roles.setVisible(false);
        tablaArchivos = this.getAttachmentsListbox();
        tablaRoles = this.getRolesListbox();
        Listbox tablaFirmas = this.getSignaturesListbox();
        tablaRoles.getItems().clear();
        if (tablaArchivos != null && (item = tablaArchivos.getSelectedItem()) != null) {
            String tag = (String)item.getValue();
            document = am.getDocument(tag);
            rolesDocumento = document.getRoles();
            tablaRoles.getItems().clear();
            Iterator it = rolesDocumento.iterator();
            while (it.hasNext()) {
                role = (String)it.next();
                roleListItem = new Listitem();
                roleListItem.setValue((Object)role);
                roleListItem.appendChild((Component)new Listcell(role));
                tablaRoles.appendChild((Component)roleListItem);
            }
            tablaFirmas.getItems().clear();
            firmas = document.getSigns();
            for (int index = 0; index < firmas.size(); ++index) {
                sign = (Signature)firmas.get(index);
                tablaFirmas.getItems().add(new FirmaListitem(sign));
            }
        }
    }

    private Listbox getSignaturesListbox() {
        return (Listbox)this.getFellow("tablaFirmas");
    }

    private Listbox getRolesListbox() {
        return (Listbox)this.getFellow("tablaRoles");
    }

    private Listbox getAttachmentsListbox() {
        return (Listbox)this.getFellow("tablaArchivos");
    }

    public void downloadSign() throws InterruptedException, IOException, NamingException, DocumentBeanException {
        Iframe iframe = (Iframe)this.getFellowIfAny("iframe");
        Tree tree = null;
        FirmaListitem row = null;
        tree = (Tree)this.getFellowIfAny("treefirmas");
        if (tree != null && tree.getSelectedItem() != null) {
            row = (FirmaListitem)((Object)tree.getSelectedItem().getChildren().get(0));
            iframe.setContent((Media)new AMedia("firma.sign", ".sign", "application/octet-stream", row.getSign().getPkcs7()));
        } else {
            Missatgebox.avis((String)Labels.getLabel((String)"contenidoTarea.msgSeleccionFirma"), (String)"Custodia de Documentos");
        }
    }

    public void cancel() throws IOException, DocumentException, ClassNotFoundException, SQLException, NamingException, CreateException, BPMException {
        boolean result = Missatgebox.confirmaYES_NO((String)Labels.getLabel((String)"process.confirmCancel"), (String)Labels.getLabel((String)"process.warning"), (String)"~./zul/img/exclamation.gif");
        if (result) {
            this.setCurrentProcess(this.getEngine().cancel(this.getCurrentProcess()));
            this.refresh();
        }
    }

    public void upgrade() throws IOException, DocumentException, ClassNotFoundException, SQLException, NamingException, CreateException, BPMException {
        this.getEngine().upgradeProcess(this.getCurrentProcess());
        String[] result = this.getEngine().getDeployMessages();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            b.append(result[i]);
            b.append('\n');
        }
        Missatgebox.info((String)b.toString(), (String)Labels.getLabel((String)"process.upgraderesult"));
        this.refresh();
    }

    public boolean isFinalized() {
        return this.getCurrentProcess().getEnd() != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

