/*
 * Decompiled with CFR 0.152.
 */
package es.caib.bpm.ui.task;

import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.classloader.UIClassLoader;
import es.caib.bpm.datamodel.BPMDataNode;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.nas.exception.NASException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.toolkit.SignaturaHandler;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;
import es.caib.bpm.ui.SignatureManager;
import es.caib.bpm.ui.task.SeleccionUsuarioUI;
import es.caib.bpm.ui.tree.FirmaListitem;
import es.caib.bpm.vo.ProcessDefinition;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.bpm.vo.TaskInstance;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.zkib.component.DataGrid;
import es.caib.zkib.component.DataModel;
import es.caib.zkib.zkiblaf.Application;
import es.caib.zkib.zkiblaf.Frame;
import es.caib.zkib.zkiblaf.Missatgebox;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.imageio.ImageIO;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Fileupload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.impl.InputElement;

public class TaskUI
extends Frame
implements EventListener {
    private long taskId = 0L;
    Label proceso = null;
    Label tarea = null;
    Label asignadoA = null;
    Datebox fechaInicioProceso = null;
    Datebox fechaCreacionTarea = null;
    Datebox fechaFinalizacionProceso = null;
    Component ventanaDinamica = null;
    org.zkoss.zul.Image visorImagenes = null;
    Listbox tablaArchivos = null;
    Label estado = null;
    private DataModel model;
    private Label descripcion;
    private Label idtarea;
    private Label idproceso;
    private DataGrid comments;
    private Component newcommentBox = null;
    TaskInstance currentTask;
    ProcessInstance currentProcess;
    ProcessDefinition currentDefinition;
    private Component tabAnexos;
    private Component anexos;
    private Component uploadButton;
    private Component deleteButton;
    private static Logger log = Logger.getLogger((Class)(class$es$caib$bpm$ui$task$TaskUI == null ? (class$es$caib$bpm$ui$task$TaskUI = TaskUI.class$("es.caib.bpm.ui.task.TaskUI")) : class$es$caib$bpm$ui$task$TaskUI));
    private Tabbox tabbox;
    Textbox newComment;
    Hbox botonera = null;
    Button btnTomar = null;
    Button btnDelegar = null;
    private Button btnCerrar;
    private Button btnSalvar;
    private static final long serialVersionUID = 1L;
    private static Hashtable classLoaders = new Hashtable();
    static /* synthetic */ Class class$es$caib$bpm$ui$task$TaskUI;

    public boolean canClose() {
        if (!this.getDataModel().isCommitPending()) {
            return true;
        }
        boolean result = Missatgebox.confirmaYES_NO((String)Labels.getLabel((String)"task.msgDeseaSalir"), (String)Labels.getLabel((String)"task.titleDeseaSalir"), (String)"~./zul/img/question.gif");
        return result;
    }

    public TaskUI() {
        HttpServletRequest req = (HttpServletRequest)Executions.getCurrent().getNativeRequest();
        String id = req.getParameter("id");
        if (id != null) {
            this.taskId = Long.parseLong(id);
        }
    }

    public void onCreate() throws Exception {
        this.visorImagenes = (org.zkoss.zul.Image)this.getFellow("visorProcesoWnd").getFellow("visorProceso");
        this.fechaInicioProceso = (Datebox)this.getFellow("txtFechaInicio");
        this.fechaFinalizacionProceso = (Datebox)this.getFellow("txtFechaFinalizacion");
        this.fechaCreacionTarea = (Datebox)this.getFellow("txtFechaCreacion");
        this.asignadoA = (Label)this.getFellow("txtAsignadoA");
        this.estado = (Label)this.getFellow("txtEstado");
        this.model = (DataModel)this.getFellow("BPMdata");
        this.proceso = (Label)this.getFellow("txtProceso");
        this.tarea = (Label)this.getFellow("txtTarea");
        this.idproceso = (Label)this.getFellow("txtIdProceso");
        this.idtarea = (Label)this.getFellow("txtIdTarea");
        this.descripcion = (Label)this.getFellow("txtDescripcion");
        this.fechaInicioProceso = (Datebox)this.getFellow("txtFechaInicio");
        this.fechaFinalizacionProceso = (Datebox)this.getFellow("txtFechaFinalizacion");
        this.fechaCreacionTarea = (Datebox)this.getFellow("txtFechaCreacion");
        this.asignadoA = (Label)this.getFellow("txtAsignadoA");
        this.tablaArchivos = this.getAttachmentsListbox();
        this.comments = (DataGrid)this.getFellow("comments");
        this.newcommentBox = this.getFellow("newCommentBox");
        this.tabAnexos = this.getFellow("tabAnexos");
        this.anexos = this.getFellow("anexos");
        this.uploadButton = this.getFellow("uploadButton");
        this.deleteButton = this.getFellow("deleteButton");
        this.tabbox = (Tabbox)this.getFellow("tabTarea");
        this.newComment = (Textbox)this.getFellow("newComment");
        this.botonera = (Hbox)this.getFellow("botonera");
        this.btnTomar = (Button)this.botonera.getFellow("btnTomar");
        this.btnDelegar = (Button)this.botonera.getFellow("btnDelegar");
        this.btnSalvar = (Button)this.botonera.getFellow("btnSalvar");
        this.btnCerrar = (Button)this.botonera.getFellow("btnCerrar");
        this.ventanaDinamica = this.getFellow("datosElementoWorkflow");
        if (this.taskId > 0L) {
            TaskInstance ti = BPMApplication.getEngine().getTask(this.taskId);
            this.openTaskInstance(ti);
        }
    }

    public ProcessInstance getCurrentProcess() {
        return this.currentProcess;
    }

    public void setCurrentProcess(ProcessInstance currentProcess) {
        this.currentProcess = currentProcess;
        DataModel model = this.getDataModel();
        if (model != null) {
            BPMDataNode node = (BPMDataNode)model.getDataNode();
            node.setProcessInstance(currentProcess);
            model.refresh();
        } else if (this.currentTask != null) {
            throw new RuntimeException("Intentado asignar tarea sin objeto BPMDataNode");
        }
    }

    private DataModel getDataModel() {
        return this.model;
    }

    public ProcessDefinition getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setCurrentDefinition(ProcessDefinition currentDefinition) {
        this.currentDefinition = currentDefinition;
        DataModel model = this.getDataModel();
        if (model != null) {
            BPMDataNode node = (BPMDataNode)model.getDataNode();
            node.setProcessDefinition(currentDefinition);
            model.refresh();
        } else if (this.currentTask != null) {
            throw new RuntimeException("Intentado asignar tarea sin objeto BPMDataNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openTaskInstance(TaskInstance task) throws IOException, DocumentException, ClassNotFoundException, SQLException, NamingException, CreateException {
        block15: {
            BPMEngineLocal engine = this.getEngine();
            Component componenteGenerado = null;
            String user = Executions.getCurrent().getUserPrincipal().getName();
            boolean canManage = user.equals(task.getActorId()) && task.getStart() != null;
            Application.setTitle((String)task.getName());
            this.setCurrentTask(task);
            ProcessInstance instanciaProceso = engine.getProcessInstance(task);
            this.setCurrentProcess(instanciaProceso);
            ProcessDefinition definicion = engine.getProcessDefinition(instanciaProceso);
            this.setCurrentDefinition(definicion);
            byte[] imagen = engine.getProcessDefinitionImage(definicion);
            BufferedImage imagenBuffered = ImageIO.read(new ByteArrayInputStream(imagen));
            imagenBuffered.getGraphics().setColor(Color.RED);
            int[] coordinates = engine.getCoordinates(task);
            Graphics2D graph = (Graphics2D)imagenBuffered.getGraphics();
            graph.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graph.setPaint(new Color(255, 140, 140));
            graph.setStroke(new BasicStroke(2.5f));
            graph.draw(new Rectangle2D.Double(coordinates[0], coordinates[1], coordinates[2], coordinates[3]));
            ByteArrayOutputStream streamSalidaImagen = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)imagenBuffered, "jpeg", streamSalidaImagen);
            AImage imagenProceso = new AImage("image/jpeg", streamSalidaImagen.toByteArray());
            this.visorImagenes.setContent((Image)imagenProceso);
            this.proceso.setValue(definicion.getName() + " (Ver. " + definicion.getTag() + ")");
            this.idproceso.setValue(Long.toString(instanciaProceso.getId()));
            this.idtarea.setValue(Long.toString(task.getId()));
            this.descripcion.setValue(task.getDescription());
            this.fechaFinalizacionProceso.setValue(instanciaProceso.getEnd());
            this.tarea.setValue(task.getName());
            this.fechaInicioProceso.setValue(instanciaProceso.getStart());
            if (task.getActorId() == null) {
                String users = null;
                Iterator it = task.getPooledActors().iterator();
                while (it.hasNext()) {
                    if (users == null) {
                        users = (String)it.next();
                        continue;
                    }
                    users = users + ", " + (String)it.next();
                }
                this.asignadoA.setValue(users);
            } else {
                this.asignadoA.setValue(task.getActorId());
            }
            this.fechaCreacionTarea.setValue(task.getCreate());
            if (task.isOpen()) {
                if (task.getStart() == null) {
                    this.estado.setValue(Labels.getLabel((String)"task.estat.pendent"));
                } else {
                    this.estado.setValue(Labels.getLabel((String)"task.estat.encurs"));
                }
            } else {
                this.estado.setValue(Labels.getLabel((String)"task.estat.fi"));
            }
            ClassLoader heavenClassLoader = this.cargarClasesUI(definicion);
            try {
                String ui = engine.getUI(task);
                this.ventanaDinamica.getChildren().clear();
                if (ui != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("taskInstance", task);
                    map.put("processInstance", instanciaProceso);
                    map.put("engine", engine);
                    componenteGenerado = Executions.createComponentsDirectly((String)ui, (String)"zul", (Component)this.ventanaDinamica, map);
                    if (!canManage || task.isCancelled() || task.getEnd() != null) {
                        this.disableInputbox(componenteGenerado);
                    }
                }
                this.updateBotonera(componenteGenerado);
                this.comments.setDataPath("BPMdata:/processInstance/comments");
                this.newComment.setValue("");
                this.newcommentBox.setVisible(canManage);
                if (componenteGenerado != null && componenteGenerado instanceof WorkflowWindow) {
                    WorkflowWindow window = (WorkflowWindow)componenteGenerado;
                    window.setTask(task);
                    window.setProcessInstance(instanciaProceso);
                    window.setEngine(engine);
                    window.setSignatureHandler((SignaturaHandler)new SignatureManager(window));
                    Events.sendEvent((Event)new Event("onLoad", (Component)window));
                    this.tabAnexos.setVisible(window.isShowAttachments() && canManage);
                    this.anexos.setVisible(window.isShowAttachments() && canManage);
                    this.cargarTablaArchivos(task, this.tablaArchivos);
                    this.uploadButton.setVisible(window.isShowAttachments() && window.isCanAddAttachments() && canManage);
                    this.deleteButton.setVisible(window.isShowAttachments() && window.isCanDeleteAttachments() && canManage);
                    this.tabbox.setSelectedIndex(0);
                    break block15;
                }
                throw new UiException("El objecto generado debiera sera una instancia de WorkflowWindow");
            }
            finally {
                if (heavenClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(heavenClassLoader);
                }
            }
        }
    }

    private void disableInputbox(Component componente) {
        if (componente instanceof InputElement) {
            ((InputElement)componente).setReadonly(true);
        } else if (componente instanceof Listbox) {
            ((Listbox)componente).setDisabled(true);
        } else if (componente instanceof Button) {
            ((Button)componente).setDisabled(true);
        } else if (componente instanceof Radio) {
            ((Radio)componente).setDisabled(true);
        } else if (componente instanceof Checkbox) {
            ((Checkbox)componente).setDisabled(true);
        } else {
            Iterator it = componente.getChildren().iterator();
            while (it.hasNext()) {
                Component child = (Component)it.next();
                this.disableInputbox(child);
            }
        }
    }

    public void limpiarSeleccion() {
        this.tablaArchivos = this.getAttachmentsListbox();
        log.debug((Object)"Limpiamos");
        this.visorImagenes.setContent((Image)null);
        if (this.fechaInicioProceso != null) {
            this.fechaInicioProceso.setValue(null);
        }
        if (this.asignadoA != null) {
            this.asignadoA.setValue("");
        }
        if (this.fechaCreacionTarea != null) {
            this.fechaCreacionTarea.setValue(null);
        }
        if (this.fechaFinalizacionProceso != null) {
            this.fechaFinalizacionProceso.setValue(null);
        }
        if (this.tablaArchivos != null) {
            this.tablaArchivos.getItems().clear();
        }
        if (this.ventanaDinamica != null) {
            this.ventanaDinamica.getChildren().clear();
        }
    }

    public void refreshListadoArchivos() throws IOException, NamingException, CreateException {
        Listbox tablaArchivos = null;
        tablaArchivos = this.getAttachmentsListbox();
        if (this.getCurrentTask() != null) {
            this.cargarTablaArchivos(this.getCurrentTask(), tablaArchivos);
        }
    }

    public void cargarTablaArchivos(TaskInstance task, Listbox tablaArchivos) throws IOException, NamingException, CreateException {
        Listitem item = null;
        String roles = null;
        TaskAttachmentManager business = new TaskAttachmentManager(this.getCurrentTask());
        tablaArchivos.getItems().clear();
        Iterator it = business.getTags().iterator();
        while (it.hasNext()) {
            String tag = (String)it.next();
            Document document = business.getDocument(tag);
            item = new Listitem();
            item.appendChild((Component)new Listcell(document.getExternalName()));
            item.appendChild((Component)new Listcell(document.getMimeType()));
            item.setValue((Object)tag);
            if (document.getRoles().isEmpty()) {
                item.appendChild((Component)new Listcell("P\u00fablico"));
                item.appendChild((Component)new Listcell(""));
            } else {
                item.appendChild((Component)new Listcell("Privado"));
                roles = "";
                Iterator itRoles = document.getRoles().iterator();
                while (itRoles.hasNext()) {
                    String role = (String)itRoles.next();
                    roles = roles + role + " ";
                }
                item.appendChild((Component)new Listcell(roles));
            }
            tablaArchivos.getItems().add(item);
        }
    }

    public ClassLoader cargarClasesUI(ProcessDefinition def) throws ClassNotFoundException, SQLException, IOException, CreateException, NamingException {
        Map clases = null;
        UIClassLoader loader = null;
        BPMEngineLocal engine = this.getEngine();
        ClassLoader heavenLoader = null;
        heavenLoader = Thread.currentThread().getContextClassLoader();
        loader = (UIClassLoader)classLoaders.get(new Long(def.getId()));
        if (loader == null) {
            clases = engine.getUIClassesForTask(def);
            loader = new UIClassLoader(clases, heavenLoader);
            loader.cargarClases();
            classLoaders.put(new Long(def.getId()), loader);
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)loader);
        return heavenLoader;
    }

    public void updateBotonera(Component componenteGenerado) {
        TaskInstance task = this.getCurrentTask();
        String user = Executions.getCurrent().getUserPrincipal().getName();
        if (componenteGenerado instanceof WorkflowWindow) {
            this.btnDelegar.setDisabled(!((WorkflowWindow)componenteGenerado).isAllowDelegate());
        } else {
            this.btnDelegar.setDisabled(true);
        }
        this.botonera.getChildren().clear();
        this.btnTomar.setVisible(task.getStart() == null || !user.equals(task.getActorId()));
        this.btnDelegar.setVisible((task.getStart() == null || user.equals(task.getActorId())) && !task.isCancelled() && task.getEnd() == null);
        boolean iniciado = user.equals(task.getActorId()) && task.getStart() != null;
        this.btnSalvar.setVisible(iniciado && !task.isCancelled() && task.getEnd() == null);
        if (!task.isCancelled() && task.getEnd() == null) {
            Arrays.sort(task.getTransitions());
            Button button = null;
            for (int i = 0; iniciado && i < task.getTransitions().length; ++i) {
                button = new Button();
                button.setLabel(task.getTransitions()[i]);
                button.addEventListener("onClick", (EventListener)this);
                this.botonera.appendChild((Component)button);
            }
        }
    }

    public TaskInstance getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(TaskInstance currentTask) {
        this.currentTask = currentTask;
        DataModel model = this.getDataModel();
        if (model != null) {
            BPMDataNode node = (BPMDataNode)model.getDataNode();
            node.setTaskInstance(currentTask);
            model.refresh();
        } else if (currentTask != null) {
            throw new RuntimeException("Intentado asignar tarea sin objeto BPMDataNode");
        }
    }

    public void onEvent(Event evt) throws InterruptedException, IOException, CreateException, NamingException {
        if ("onClick".equals(evt.getName())) {
            this.ejecutarTarea(((Button)evt.getTarget()).getLabel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejecutarTarea(String transicion) throws InterruptedException, IOException, CreateException, NamingException {
        block10: {
            TaskInstance task = null;
            BPMEngineLocal engine = this.getEngine();
            WorkflowWindow workflowWindow = this.getWorkflowWindow();
            if (workflowWindow != null) {
                task = workflowWindow.getTask();
                try {
                    Events.sendEvent((Event)new Event("onSave", (Component)workflowWindow));
                    ProcessInstance process = this.getCurrentProcess();
                    engine.update(task);
                    if (this.newComment.getValue() != null && this.newComment.getValue().length() > 0) {
                        task = engine.addComment(task, this.newComment.getValue());
                        workflowWindow.setTask(task);
                    }
                    Events.sendEvent((Event)new Event("onPrepareTransition", (Component)workflowWindow, (Object)transicion));
                    task = engine.executeTask(task, transicion);
                    workflowWindow.setTask(task);
                    Events.sendEvent((Event)new Event("onCompleteTransition", (Component)workflowWindow, (Object)transicion));
                    List tasks = engine.getPendingTasks(process);
                    this.getDataModel().commit();
                    if (tasks != null && tasks.size() > 0) {
                        TaskInstance newTask = (TaskInstance)tasks.get(0);
                        newTask = engine.startTask(newTask);
                        Application.jumpTo((String)BPMApplication.getTaskURL((TaskInstance)newTask));
                        break block10;
                    }
                    Application.goBack();
                }
                catch (Exception ex) {
                    log.error((Object)"Error during transition", (Throwable)ex);
                    workflowWindow.refresh();
                    String message = Labels.getLabel((String)"task.msgError") + " " + ex.toString();
                    Throwable ex2 = ex;
                    while (ex2 != null) {
                        if (ex2 instanceof WorkflowException) {
                            message = Labels.getLabel((String)"task.msgError") + " " + ex2.getMessage();
                        }
                        if (ex2.getCause() == ex2) {
                            ex2 = null;
                            continue;
                        }
                        ex2 = ex2.getCause();
                    }
                    Missatgebox.error((String)message);
                }
                break block10;
            }
            Missatgebox.info((String)Labels.getLabel((String)"task.msgSeleccionTarea"), (String)"Workflow BPM");
        }
    }

    private WorkflowWindow getWorkflowWindow() {
        if (this.ventanaDinamica.getChildren().size() > 0) {
            Component c = (Component)this.ventanaDinamica.getChildren().get(0);
            if (c instanceof WorkflowWindow) {
                return (WorkflowWindow)c;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salvarTarea() throws InterruptedException, IOException, CreateException, NamingException {
        block9: {
            WorkflowWindow workflowWindow = null;
            TaskInstance task = null;
            BPMEngineLocal engine = this.getEngine();
            workflowWindow = this.getWorkflowWindow();
            if (workflowWindow != null) {
                task = workflowWindow.getTask();
                try {
                    Events.sendEvent((Event)new Event("onSave", (Component)workflowWindow));
                    engine.update(task);
                    if (this.newComment.getValue() != null && this.newComment.getValue().length() > 0) {
                        task = engine.addComment(task, this.newComment.getValue());
                        workflowWindow.setTask(task);
                    }
                    this.getDataModel().commit();
                    Application.goBack();
                    break block9;
                }
                catch (UiException ex) {
                    workflowWindow.refresh();
                    if (ex.getCause() != null && ex.getCause() instanceof UserWorkflowException) {
                        if (ex.getCause().getMessage() != null) {
                            Missatgebox.error((String)ex.getCause().getMessage());
                        }
                        break block9;
                    }
                    log.error((Object)"Error no esperado", (Throwable)ex);
                    throw ex;
                }
                catch (Exception ex) {
                    workflowWindow.refresh();
                    log.error((Object)"Error no esperado", (Throwable)ex);
                    break block9;
                }
            }
            Missatgebox.info((String)Labels.getLabel((String)"task.msgSeleccionTarea"), (String)"Workflow BPM");
        }
    }

    public void cerrarTarea() throws InterruptedException, IOException, CreateException, NamingException, BPMException, ClassNotFoundException, SQLException, DocumentException {
        Application.goBack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tomarTarea() throws InterruptedException, CreateException, NamingException {
        TaskInstance task = null;
        try {
            task = this.getEngine().startTask(this.getCurrentTask());
            Application.jumpTo((String)BPMApplication.getTaskURL((TaskInstance)task));
        }
        catch (Exception ex) {
            Missatgebox.error((String)(Labels.getLabel((String)"task.msgError") + " " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delegarTarea() throws InterruptedException, CreateException, NamingException {
        block7: {
            WorkflowWindow workflowWindow = this.getWorkflowWindow();
            TaskInstance task = null;
            BPMEngineLocal engine = this.getEngine();
            SeleccionUsuarioUI window = null;
            String usuarioSeleccionado = null;
            try {
                if (workflowWindow != null) {
                    task = workflowWindow.getTask();
                    Events.sendEvent((Component)workflowWindow, (Event)new Event("onInitDelegation", (Component)workflowWindow));
                    window = (SeleccionUsuarioUI)Executions.createComponents((String)"/wf/task/seleccionUsuario.zul", (Component)this, null);
                    window.doModal();
                    usuarioSeleccionado = window.getUsuarioSeleccionado();
                    if (usuarioSeleccionado != null) {
                        if (this.newComment.getValue() != null && this.newComment.getValue().length() > 0) {
                            task = engine.addComment(task, this.newComment.getValue());
                        }
                        task = engine.delegateTaskToUser(task, usuarioSeleccionado);
                        workflowWindow.setTask(task);
                        log.debug((Object)"Limpiamos la seleccion de tareas");
                        Application.goBack();
                    }
                    break block7;
                }
                Missatgebox.info((String)Labels.getLabel((String)"task.msgSeleccionTarea"), (String)"Workflow BPM");
            }
            catch (Exception ex) {
                Missatgebox.error((String)(Labels.getLabel((String)"task.msgError") + " " + ex.getMessage()));
            }
        }
    }

    private BPMEngineLocal getEngine() throws CreateException, NamingException {
        return BPMApplication.getEngine();
    }

    public void subirArchivo() throws InterruptedException, IOException, NamingException, CreateException, DocumentBeanException, BPMException {
        Media dataSubida = null;
        TaskAttachmentManager business = new TaskAttachmentManager(this.getCurrentTask());
        Session sesion = this.getDesktop().getSession();
        dataSubida = Fileupload.get((boolean)true);
        if (dataSubida != null) {
            String tag = ((HttpSession)sesion.getNativeSession()).getId();
            business.uploadFile(dataSubida, tag);
            this.refreshListadoArchivos();
        }
    }

    public void eliminarArchivo() throws Exception {
        Listbox listbox = this.getAttachmentsListbox();
        TaskAttachmentManager business = new TaskAttachmentManager(this.getCurrentTask());
        if (listbox.getSelectedItem() != null) {
            String tag = (String)listbox.getSelectedItem().getValue();
            business.eliminarArchivo(tag);
            this.refreshListadoArchivos();
        } else {
            Missatgebox.info((String)Labels.getLabel((String)"contenidoTarea.msgSeleccionArchivo"));
        }
    }

    public void descargarArchivo() throws IOException, DocumentBeanException, BPMException, InterruptedException {
        Listbox tablaArchivos = null;
        Listitem item = null;
        TaskAttachmentManager business = new TaskAttachmentManager(this.getCurrentTask());
        tablaArchivos = this.getAttachmentsListbox();
        if (tablaArchivos != null) {
            item = tablaArchivos.getSelectedItem();
            if (item != null) {
                String tag = (String)item.getValue();
                Executions.getCurrent().sendRedirect(business.getDownloadURL(tag), "_new");
            } else {
                Missatgebox.avis((String)"Debe seleccionar un archivo");
            }
        } else {
            Missatgebox.avis((String)"Debe cargar Archivos antes de intentar descargarlos");
        }
    }

    public void seleccionarDocumento() throws SignatureTimestampException, IOException, ClassNotFoundException, NASException, NamingException, CreateException {
        Listbox tablaArchivos = null;
        Listitem item = null;
        Listitem roleListItem = null;
        Document document = null;
        Set rolesDocumento = null;
        String role = null;
        Listbox tablaRoles = null;
        List firmas = null;
        Signature sign = null;
        Vbox roles = (Vbox)this.getFellow("rolesDocumento");
        TaskAttachmentManager am = new TaskAttachmentManager(this.getCurrentTask());
        roles.setVisible(false);
        tablaArchivos = this.getAttachmentsListbox();
        tablaRoles = this.getRolesListbox();
        Listbox tablaFirmas = this.getSignaturesListbox();
        tablaRoles.getItems().clear();
        if (tablaArchivos != null && (item = tablaArchivos.getSelectedItem()) != null) {
            String tag = (String)item.getValue();
            document = am.getDocument(tag);
            rolesDocumento = document.getRoles();
            tablaRoles.getItems().clear();
            Iterator it = rolesDocumento.iterator();
            while (it.hasNext()) {
                role = (String)it.next();
                roleListItem = new Listitem();
                roleListItem.setValue((Object)role);
                roleListItem.appendChild((Component)new Listcell(role));
                tablaRoles.appendChild((Component)roleListItem);
            }
            tablaFirmas.getItems().clear();
            firmas = document.getSigns();
            for (int index = 0; index < firmas.size(); ++index) {
                sign = (Signature)firmas.get(index);
                tablaFirmas.getItems().add(new FirmaListitem(sign));
            }
        }
    }

    private Listbox getSignaturesListbox() {
        return (Listbox)this.getFellow("tablaFirmas");
    }

    private Listbox getRolesListbox() {
        return (Listbox)this.getFellow("tablaRoles");
    }

    private Listbox getAttachmentsListbox() {
        return (Listbox)this.getFellow("tablaArchivos");
    }

    public void downloadSign() throws InterruptedException, IOException, NamingException, DocumentBeanException {
        Iframe iframe = (Iframe)this.getFellowIfAny("iframe");
        Tree tree = null;
        FirmaListitem row = null;
        tree = (Tree)this.getFellowIfAny("treefirmas");
        if (tree != null && tree.getSelectedItem() != null) {
            row = (FirmaListitem)((Object)tree.getSelectedItem().getChildren().get(0));
            iframe.setContent((Media)new AMedia("firma.sign", ".sign", "application/octet-stream", row.getSign().getPkcs7()));
        } else {
            Missatgebox.avis((String)Labels.getLabel((String)"contenidoTarea.msgSeleccionFirma"), (String)"Custodia de Documentos");
        }
    }

    public void cambiarPestana(Tabpanel newItem) {
        WorkflowWindow workflowWindow = this.getWorkflowWindow();
        Events.sendEvent((Component)workflowWindow, (Event)new Event("onTabSelected", (Component)workflowWindow, (Object)newItem.getId()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

