package es.caib.bpm.servlet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.zkoss.zk.ui.Executions;

import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.EJBContainer;
import es.caib.bpm.ui.task.TaskUI;
import es.caib.bpm.vo.TaskInstance;

public class UploadServlet extends HttpServlet {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException {
        String path = req.getPathInfo();
        while (path.startsWith("/"))
            path=path.substring(1);
        String split[] = path.split("/+");
        try {
			String taskUUID=split[0];
			//obtenim el task instance
			TaskUI taskUI = (TaskUI) Executions.getCurrent().getDesktop().getComponentByUuid(taskUUID);
			TaskInstance task = taskUI.getCurrentTask();
			//obtenim l'engine
			BPMEngineLocal engine = EJBContainer.getEJBContainer(req.getSession()).getEngine();
        	
            if (task == null)
            {
                resp.setStatus(HttpServletResponse.SC_NO_CONTENT);
                return;
            }
            TaskAttachmentManager am = new TaskAttachmentManager(task);
			String tag=split[1];
            String type = req.getParameter("type");
            String name = req.getParameter("name");
            Document d = am.createDocument(type == null ? "octet/binary-stream": type,
            							   name == null ? "unknown": name);
            d.openUploadTransfer();
            BufferedInputStream in = new BufferedInputStream (req.getInputStream());
            byte [] b = new byte [8192];
            int read = in.read(b);
   
            while (read > 0)
            {
            	d.nextUploadPackage(b, read);
                read = in.read(b);
            }
            d.endUploadTransfer();
            in.close();
            am.attach(tag, d);
            
            //si no fem update, el attach no es guarda
            engine.update(task);
            
            
        } catch (CreateException e) {
            throw new ServletException("Session expired", e);
        } catch (NamingException e) {
            throw new ServletException("Cannot locate application server", e);
        } catch (BPMException e) {
            throw new ServletException("Cannot locate task "+split[0], e);
        } catch (DocumentBeanException e) {
            throw new ServletException("Cannot upload document "+split[0]+"/"+split[1], e);
        } catch (InterruptedException e) {
            throw new ServletException("Cannot create document "+split[0]+"/"+split[1], e);
		}
    }
    
	/**
	 * Upload de pdfs signats desde zkiblaf/applet/SignApplet
	 * 
	 * @param req
	 * @param resp
	 * @throws ServletException
	 * @throws IOException
	 */
	protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		try{
			String path = req.getPathInfo();
			while (path.startsWith("/"))
				path = path.substring(1);
			String split[] = path.split("/+");
			
			String taskId=split[0];
			String mime=req.getContentType();
			String tag=split[1];
			InputStream in=req.getInputStream();

			//FIXME comentar això perquè és un trenca closques
			//obtenim el task instance
			//TaskUI taskUI = (TaskUI) Executions.getCurrent().getDesktop().getComponentByUuid(taskUUID);
			//TaskInstance task = taskUI.getCurrentTask();
			TaskInstance task = (TaskInstance)req.getSession().getAttribute("ZKActualTask-"+taskId);
			
			
			EJBContainer.getEJBContainer(req.getSession()).getEngine();
			
			
			if (task == null) {
				resp.setStatus(HttpServletResponse.SC_NO_CONTENT);
				return;
			}
			TaskAttachmentManager am = new TaskAttachmentManager(task);
	
			//inici procés d'upload al document manager
				Document doc=am.createDocument(mime,tag);
				doc.openUploadTransfer();
	         
				byte [] b = new byte [10240];
				int read = in.read(b);
	         
				while (read > 0)
				{
	         	
					doc.nextUploadPackage(b, read);
					read = in.read(b);
	             
				}
				doc.endUploadTransfer();
				in.close();
	         
				am.attach(tag, doc);
				
				//si no fem update, el attach no es guarda
				//engine.update(task);
	        	
	        //fi de procés d'upload al document manager
		}catch(Exception e){
			throw new ServletException(e);
		}
	}    

}
