package es.caib.bpm.ui;

import java.net.URL;
import java.util.Locale;

import org.zkoss.util.resource.LabelLocator;

public class BPMLabelLocator implements LabelLocator 
{
	public URL locate(Locale locale) throws Exception 
	{
		URL resource= null;
		String ubicacion= "es/caib/bpm/properties/bpm-label_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties";
		
		resource= BPMLabelLocator.class.getClassLoader().getResource(ubicacion);
		
		if(resource== null)
		{
			ubicacion= "es/caib/bpm/properties/bpm-label_" + locale.getLanguage() + ".properties";
			resource= BPMLabelLocator.class.getClassLoader().getResource(ubicacion);
			if(resource== null)
			{
				ubicacion= "es/caib/bpm/properties/bpm-label.properties";
				resource= BPMLabelLocator.class.getClassLoader().getResource(ubicacion);
			}
		}
		
		
		return resource;
	}

}
