package es.caib.bpm.ui;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.cert.CertificateEncodingException;

import javax.naming.NamingException;

import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Window;

import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.nas.exception.NASException;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.signatura.api.Signature;

public class CMSSignatureManagerHelper {
	protected static void doSign(Window window,TaskAttachmentManager am, String tag, Document doc) throws Exception {
    	// Generar archivo
		String url = am.getDownloadURL(tag);
		
		Window windowFirma = (Window) Path.getComponent("//sign/window");
		windowFirma.setAttribute("type", "CMS");
		Events.postEvent(new Event("onSetSource", windowFirma, url));
        
		windowFirma.doModal();
		
		// Recoger firma

		Signature signatura = (Signature) windowFirma.getAttribute("signature");
		if (signatura == null)
			throw new UserWorkflowException(Labels.getLabel("error.msgFirma1"));
		

		if (! SignatureManager.verifyAuthor(window,signatura))
			throw new UserWorkflowException(Labels.getLabel("error.msgFirma2")+" "+Executions.getCurrent().getUserPrincipal().getName());
		
		doc.addSign( signatura );
	}

}
