package es.caib.bpm.ui;

import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Window;

import es.caib.signatura.api.Signature;

public class SignApplet extends es.caib.zkib.zkiblaf.SignApplet{
	public void onLoadCerts(Event event){
		String[] certs = (String[]) event.getData();
		Listbox certificats = (Listbox) new Path("//sign/window/certificats").getComponent();
		certificats.getItems().clear ();
		
		int i=0;
		for ( i = 0 ; i < certs.length; i++)
		{
			new Listitem (certs[i], certs[i]).setParent(certificats);
		}
		if (i > 0)
			certificats.setSelectedIndex(0);
		else
		{
			new Path("//sign/window").getComponent().setAttribute("signature", null);
	    	new Path("//sign/window").getComponent().setVisible(false);
	    	es.caib.zkib.zkiblaf.Missatgebox.avis ("No disposa de cap certificat reconegut", "Avís");
		}
	}
	public void onSign(Event event){
			Window signWindow=(Window) new Path("//sign/window").getComponent();
			//System.out.println(signWindow.getAttribute("type"));
	    	if (new String("PDF").equals(signWindow.getAttribute("type"))) 
				signWindow.setAttribute("signature", "PDF");
	    	else if(new String("CMS").equals(signWindow.getAttribute("type")))
				signWindow.setAttribute("signature", (Signature)event.getData());
	    	else if(new String("PDF-CERTIFY").equals(signWindow.getAttribute("type")))
				signWindow.setAttribute("signature", "PDF-CERTIFY");					
	    	else if(new String("PDF-EXTENDED").equals(signWindow.getAttribute("type")))
				signWindow.setAttribute("signature", "PDF-EXTENDED");					
	    	
			signWindow.setVisible(false);
	}
	
	
	
	public int calculaPDFStampPositionValue() throws Exception{
		Window windowFirma = (Window) Path.getComponent("//sign/window");
		Radiogroup tipusSegell=(Radiogroup) windowFirma.getFellow("tipusFirmaPDF");

		if("ADOBE".equals(tipusSegell.getSelectedItem().getValue())){
			return calculaPosicioSegellAdobe();	
		}else if("PDF417".equals(tipusSegell.getSelectedItem().getValue())){
			return calculaPosicioCodiPunts();
		}else if("NONE".equals(tipusSegell.getSelectedItem().getValue())){
			return 0;
		}else{
			es.caib.zkib.zkiblaf.Missatgebox.avis ("Ha de sel.leccionar un tipus de segell vàlid.","Avís");
			return -1;
		}

	}

	public int calculaPosicioCodiPunts(){
		//calcula la posició final 
		Window windowFirma = (Window) Path.getComponent("//sign/window");
		Radiogroup posicioEstampaPDFCodiPunts=(Radiogroup) windowFirma.getFellow("posicioEstampaPDFCodiPunts");

		int posicio = Integer.parseInt(((Radiogroup)posicioEstampaPDFCodiPunts).getSelectedItem().getValue());
			
		return posicio;
	}

	public int calculaPosicioSegellAdobe(){
		//calcula la posició final 
		Window windowFirma = (Window) Path.getComponent("//sign/window");
		Radiogroup posicioEstampaPDFAdobe=(Radiogroup) windowFirma.getFellow("posicioEstampaPDFAdobe");

		Checkbox ADOBE_LAST_PAGE=(Checkbox) windowFirma.getFellow("ADOBE_LAST_PAGE");
		boolean afegirNomesUltimaPagina = ((Checkbox)ADOBE_LAST_PAGE).isChecked();
		
		int posicio = Integer.parseInt(((Radiogroup)posicioEstampaPDFAdobe).getSelectedItem().getValue());
			
		if(afegirNomesUltimaPagina){
			posicio=posicio | 16;
		}
		
		//Forcem estampa adobe
		posicio=posicio | 32;
		
		return posicio;
	}

}
