package es.caib.bpm.ui;

import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;

public class SignPDFSignatureManagerHelper {
	protected static void doSignPDF(TaskAttachmentManager am, String inputTag,String outputTag,String enabledStampType,String[] enabledPositions,String forcedAdditionalText) throws Exception {
    	// Generar archivo
		String downloadUrl = am.getDownloadURL(inputTag);
		String uploadUrl = am.getUploadURL(outputTag);
		
		Window windowFirma = (Window) Path.getComponent("//sign/window");

		windowFirma.setAttribute("type", "PDF");
		Events.postEvent(new Event("onSetTarget", windowFirma, uploadUrl )); //upload via HTTP mèthod PUT
		Events.postEvent(new Event("onSetSource", windowFirma, downloadUrl ));
        
		//control de tipos de sello permitidos
		if(SignatureManager.STAMP_TYPE_ALL.equals(enabledStampType)){
			windowFirma.getFellow("windowTipusSegell").setVisible(true);

			//default: sello_adobe
			Radio radio=(Radio)windowFirma.getFellow("sello_ADOBE");
			Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("tipusFirmaPDF"));
			selectRadioGroupItem(radio,radioGroup);


			windowFirma.getFellow("panellOpcionsPDFAdobe").setVisible(true);
			
		}else if(SignatureManager.STAMP_TYPE_ADOBE.equals(enabledStampType)){
			Radio radio=(Radio)windowFirma.getFellow("sello_ADOBE");
			Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("tipusFirmaPDF"));
			selectRadioGroupItem(radio,radioGroup);

			
			windowFirma.getFellow("panellOpcionsPDFAdobe").setVisible(true);
			
		}else if(SignatureManager.STAMP_TYPE_PDF417.equals(enabledStampType)){
			Radio radio=(Radio)windowFirma.getFellow("sello_PDF417");
			Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("tipusFirmaPDF"));
			selectRadioGroupItem(radio,radioGroup);

			
			windowFirma.getFellow("panellOpcionsPDF417").setVisible(true);
			
		}else if(SignatureManager.STAMP_TYPE_NONE.equals(enabledStampType)){
			Radio radio=(Radio)windowFirma.getFellow("sello_NONE");
			Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("tipusFirmaPDF"));
			selectRadioGroupItem(radio,radioGroup);

		}

		//control de posiciones admitidas
		//si es nulo, se admiten todas
		//si no es nulo, la primera que venga en el array es la seleccionada por defecto
		if(enabledPositions!=null){
			if(enabledPositions.length==0){
				throw new SystemWorkflowException("No s'ha configurat cap posició per a l'estampa de PDF");
			}else if(enabledPositions.length==1){
				if(enabledPositions.equals(SignatureManager.STAMP_POSITION_ADOBE_LAST_PAGE)){
					Checkbox check=(Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+SignatureManager.STAMP_POSITION_ADOBE_LAST_PAGE);
					check.setChecked(true);
				}else{
					//marquem l'opció sel.leccionada
					Radio radio=(Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+enabledPositions[0]);
					if(radio!=null){
						radio.setDisabled(false);
						Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("posicioEstampaPDFAdobe"));
						selectRadioGroupItem(radio,radioGroup);

					}else{
						throw new SystemWorkflowException("No s'ha configurat correctament cap posició per a l'estampa de PDF");
					}
				}
				//no permitim escollir posició
				windowFirma.getFellow("panellOpcionsPDFAdobe_Posicio").setVisible(false);
				windowFirma.getFellow("panellOpcionsPDFCodiPunts_Posicio").setVisible(false);
				
			}else{
				//Last page siempre lo permitimos en adobe
				//disable ADOBE
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+SignatureManager.STAMP_POSITION_ADOBE_TOP_LEFT)).setDisabled(true);
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+SignatureManager.STAMP_POSITION_ALL_TOP)).setDisabled(true);
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+SignatureManager.STAMP_POSITION_ADOBE_TOP_RIGHT)).setDisabled(true);
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+SignatureManager.STAMP_POSITION_ADOBE_BOTTOM_LEFT)).setDisabled(true);
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+SignatureManager.STAMP_POSITION_ALL_BOTTOM)).setDisabled(true);
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+SignatureManager.STAMP_POSITION_ADOBE_BOTTOM_RIGHT)).setDisabled(true);

				//disable PDF417
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_PDF417+"_"+SignatureManager.STAMP_POSITION_ALL_TOP)).setDisabled(true);
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_PDF417+"_"+SignatureManager.STAMP_POSITION_PDF417_LEFT)).setDisabled(true);
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_PDF417+"_"+SignatureManager.STAMP_POSITION_PDF417_RIGHT)).setDisabled(true);
				((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_PDF417+"_"+SignatureManager.STAMP_POSITION_ALL_BOTTOM)).setDisabled(true);

				
				
				//para adobe
				for(int i=0;i<enabledPositions.length;i++){
					try{
						Radio radio=(Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_ADOBE+"_"+enabledPositions[i]);
						if(radio!=null){
							radio.setDisabled(false);
							if(i==0){
								Radiogroup radioGroup=((Radiogroup)windowFirma.getFellow("posicioEstampaPDFAdobe"));
								selectRadioGroupItem(radio,radioGroup);
								
							}
						}
					}catch(ComponentNotFoundException e){//NO ES POSIOCIÓ ADOBE
					}
				}
				//para PDF417
				for(int i=0;i<enabledPositions.length;i++){
					try{
						Radio radio=(Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_PDF417+"_"+enabledPositions[i]);
						if(radio!=null){
							radio.setDisabled(false);
							if(i==0){
								Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("posicioEstampaPDFCodiPunts"));
								selectRadioGroupItem(radio,radioGroup);

							}
						}
					}catch(ComponentNotFoundException e){//NO ES POSIOCIÓ PDF417}
					}
				}
			}
		}else{
			//totes les opcions disponibles
			
			//habilitem posicions per defecte
			
			Radio radio=((Radio)windowFirma.getFellow(SignatureManager.STAMP_TYPE_PDF417+"_"+SignatureManager.STAMP_POSITION_ALL_TOP));
			Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("posicioEstampaPDFAdobe"));
			selectRadioGroupItem(radio,radioGroup);

		}
		

		
		
		//control de texto adicional
		if(forcedAdditionalText!=null){
			//pdf417
			Textbox textAddicional=((Textbox)windowFirma.getFellow("textAddicional"));
			textAddicional.setValue(forcedAdditionalText);
			textAddicional.setVisible(false);
			
			windowFirma.getFellow("panellOpcionsPDFCodiPunts_TextAddicional").setVisible(false);

			//adobe
			Textbox motiuDeFirma=((Textbox)windowFirma.getFellow("motiuDeFirma"));
			motiuDeFirma.setValue(forcedAdditionalText);
			motiuDeFirma.setVisible(false);

			windowFirma.getFellow("panellOpcionsPDFAdobe_MotiuDeFirma").setVisible(false);
		}else{
			//pdf417
			Textbox textAddicional=((Textbox)windowFirma.getFellow("textAddicional"));
			textAddicional.setValue("Aprovaci\u00F3 del document");
			textAddicional.setVisible(true);
			
			windowFirma.getFellow("panellOpcionsPDFCodiPunts_TextAddicional").setVisible(true);

			//adobe
			Textbox motiuDeFirma=((Textbox)windowFirma.getFellow("motiuDeFirma"));
			motiuDeFirma.setValue("Aprovaci\u00F3 del document");
			motiuDeFirma.setVisible(true);

			windowFirma.getFellow("panellOpcionsPDFAdobe_MotiuDeFirma").setVisible(true);
			
		}

		
		
		
		windowFirma.doModal();
		
		// Recoger firma, en firmaPDF debe llegar un string con valor "PDF"
		String signatura = (String) windowFirma.getAttribute("signature");
		
		if (signatura == null)
			throw new UserWorkflowException(Labels.getLabel("error.msgFirma1"));
	}

	
	private static void selectRadioGroupItem(Radio radio, Radiogroup radioGroup) {
		boolean found=false;
		for(int i=0;i<radioGroup.getItemCount();i++){
			if(radio.getId()!= null && radio.getId().equals(radioGroup.getItemAtIndex(i).getId())){
				radioGroup.setSelectedIndex(i);
				found=true;
				break;
			}
		}
		if ( ! found ) throw new UiException("Not a child: "+radio.getId());
		
	}


	protected static void doSignPDF(TaskAttachmentManager am, String inputTag,String outputTag,String enabledStampType,String[] enabledPositions,float top, float left, float height, float width, float rotation,String forcedAdditionalText) throws Exception {
    	// Generar archivo
		String downloadUrl = am.getDownloadURL(inputTag);
		String uploadUrl = am.getUploadURL(outputTag);
		
		Window windowFirma = (Window) Path.getComponent("//sign/window");

		windowFirma.setAttribute("type", "PDF-EXTENDED");
		Events.postEvent(new Event("onSetTarget", windowFirma, uploadUrl )); //upload via HTTP mèthod PUT
		Events.postEvent(new Event("onSetSource", windowFirma, downloadUrl ));
        
		//control de tipos de sello permitidos
		if(SignatureManager.STAMP_TYPE_ADOBE.equals(enabledStampType)){
			Radio radio=(Radio)windowFirma.getFellow("sello_ADOBE");
			Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("tipusFirmaPDF"));
			selectRadioGroupItem(radio,radioGroup);

			
			windowFirma.getFellow("panellOpcionsPDFAdobe").setVisible(true);
			
		}else if(SignatureManager.STAMP_TYPE_PDF417.equals(enabledStampType)){
			Radio radio=(Radio)windowFirma.getFellow("sello_PDF417");
			Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("tipusFirmaPDF"));
			selectRadioGroupItem(radio,radioGroup);

			windowFirma.getFellow("panellOpcionsPDF417").setVisible(true);
			
			
		}else if(SignatureManager.STAMP_TYPE_NONE.equals(enabledStampType)){
			Radio radio=(Radio)windowFirma.getFellow("sello_NONE");
			Radiogroup radioGroup = ((Radiogroup)windowFirma.getFellow("tipusFirmaPDF"));
			selectRadioGroupItem(radio,radioGroup);

		}
		
		//control de posiciones admitidas
		//no permitim escollir posició pero forcem si estampar adobe a ultima pàgina
		windowFirma.getFellow("panellOpcionsPDFCodiPunts_Posicio").setVisible(false);
		windowFirma.getFellow("panellOpcionsPDFAdobe_OpcionsPosicio").setVisible(false);
		
		
		
		//control de texto adicional
		if(forcedAdditionalText!=null){
			//pdf417
			Textbox textAddicional=((Textbox)windowFirma.getFellow("textAddicional"));
			textAddicional.setValue(forcedAdditionalText);
			textAddicional.setVisible(false);
			
			windowFirma.getFellow("panellOpcionsPDFCodiPunts_TextAddicional").setVisible(false);

			//adobe
			Textbox motiuDeFirma=((Textbox)windowFirma.getFellow("motiuDeFirma"));
			motiuDeFirma.setValue(forcedAdditionalText);
			motiuDeFirma.setVisible(false);

			windowFirma.getFellow("panellOpcionsPDFAdobe_MotiuDeFirma").setVisible(false);
		}else{
			//pdf417
			Textbox textAddicional=((Textbox)windowFirma.getFellow("textAddicional"));
			textAddicional.setValue("Aprovaci\u00F3 del document");
			textAddicional.setVisible(true);
			
			windowFirma.getFellow("panellOpcionsPDFCodiPunts_TextAddicional").setVisible(true);

			//adobe
			Textbox motiuDeFirma=((Textbox)windowFirma.getFellow("motiuDeFirma"));
			motiuDeFirma.setValue("Aprovaci\u00F3 del document");
			motiuDeFirma.setVisible(true);

			windowFirma.getFellow("panellOpcionsPDFAdobe_MotiuDeFirma").setVisible(true);
			
		}

		((Textbox)windowFirma.getFellow("signPDFExt_x")).setValue(""+left);
		((Textbox)windowFirma.getFellow("signPDFExt_y")).setValue(""+top);
		((Textbox)windowFirma.getFellow("signPDFExt_height")).setValue(""+height);
		((Textbox)windowFirma.getFellow("signPDFExt_width")).setValue(""+width);
		((Textbox)windowFirma.getFellow("signPDFExt_degrees")).setValue(""+rotation);
		
		//establim si estampar primera o última pàgina
		if(enabledPositions!=null && enabledPositions.length>0 && enabledPositions[0].equals(SignatureManager.STAMP_POSITION_ADOBE_LAST_PAGE))
			((Checkbox)windowFirma.getFellow("ADOBE_LAST_PAGE")).setChecked(true);
		else
			((Checkbox)windowFirma.getFellow("ADOBE_LAST_PAGE")).setChecked(false);
		
		
		windowFirma.doModal();
		
		// Recoger firma, en firmaPDF debe llegar un string con valor "PDF"
		String signatura = (String) windowFirma.getAttribute("signature");
		
		if (signatura == null)
			throw new UserWorkflowException(Labels.getLabel("error.msgFirma1"));
	}
}
