package es.caib.bpm.ui.admin;

import java.io.IOException;
import java.util.Map;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.zkoss.util.resource.Labels;
import es.caib.zkib.zkiblaf.Missatgebox;
import org.zkoss.zul.Textbox;
import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.zkib.zkiblaf.Frame;

public class ConfigureIndex extends Frame {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Textbox txt;

	public void onCreate () throws Exception
	{
		txt = (Textbox) getFellow("txt");
		Map m = BPMApplication.getEngine().getConfiguration();
		String value = (String) m.get(BPMEngineLocal.LUCENE_DIR_PARAM);
		txt.setValue(value);
	}
	
	public void configure () throws IOException, CreateException, NamingException
	{
		Map m = BPMApplication.getEngine().getConfiguration();
		m.put(BPMEngineLocal.LUCENE_DIR_PARAM, txt.getValue());
		BPMApplication.getEngine().changeConfiguration(m);
	}
	
	public void reindex () throws InterruptedException, CreateException, NamingException, IOException
	{
		BPMApplication.getEngine().reindex();
		Missatgebox.info(Labels.getLabel("configure.endIndexing"));
	}
}
