package es.caib.bpm.ui.admin;


import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;

import org.apache.log4j.Logger;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Button;
import org.zkoss.zul.Fileupload;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Textbox;
import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.vo.ProcessDefinition;
import es.caib.zkib.zkiblaf.Frame;

public class DespliegueUI extends Frame 
{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Listbox listbox;
	private Button disablebutton;
	private Button enablebutton;
	public void onCreate () throws Exception
	{
		listbox = (Listbox) getFellow("listbox");
		disablebutton = (Button) getFellow("disableButton");
		enablebutton = (Button) getFellow("enableButton");
		cargarListadoProcesos();
	}
	/**
	 * @throws LoginException 
	 * @throws RemoteException 
	 * @throws NamingException 
	 * @throws CreateException 
	 * 
	 */
	public void cargarListadoProcesos() throws LoginException, RemoteException, CreateException, NamingException 
	{
		BPMEngineLocal engine= BPMApplication.getEngine();
		List list= null;
		ProcessDefinition definition= null;
		Listitem item= null;

			list= engine.findProcessDefinitions(null, true);
			
			if(listbox.getItems()!= null) {
				listbox.getItems().clear();
			}
			
			for(Iterator it= list.iterator(); it.hasNext();) {
				definition= (ProcessDefinition)it.next();
				
				item= new Listitem();
				
				item.getChildren().add(new Listcell(definition.getName()));
				item.getChildren().add(new Listcell(definition.getTag()));
				if (definition.isEnabled())
					item.getChildren().add(new Listcell(new Long(definition.getId()).toString()));
				else
					item.getChildren().add(new Listcell(Labels.getLabel("deploy.lblDisabled")));
				item.setValue(definition);
				
				listbox.getItems().add(item);
			}
	}
	
	/**
	 * Sube un archivo a la aplicacion de workflow.
	 * @throws LoginException 
	 * @throws NamingException 
	 * @throws CreateException 
	 *
	 */
	public void upload() throws LoginException, CreateException, NamingException 
	{
		this.getDesktop().getSession();
		BPMEngineLocal engine= BPMApplication.getEngine();
		Media dataSubida= null;
		InputStream streamLectura= null;
		int leidos= 0;
		byte[] buffer= new byte[4096];
		Textbox resultadoDespliegue= null;
		
		try 
		{
			resultadoDespliegue= (Textbox)this.getFellow("txtResultadoDespliegue");
			
			dataSubida = Fileupload.get();
			
			if(dataSubida!= null)
			{
				resultadoDespliegue.setText(Labels.getLabel("deploy.msgDesplegandoProceso"));
				
				streamLectura= dataSubida.getStreamData();
				
	            log.debug("Abrimos la transferencia");
				engine.openDeployParDefinitionTransfer();
				
	            log.debug("Enviamos los paquetes");
	            while((leidos= streamLectura.read(buffer))!= -1)
	            {
	            	engine.nextDeployParDefinitionPackage(buffer, leidos);
	            }

	            log.debug("Cerramos la transferencia del archivo");
	            engine.endDeployParDefinitionTransfer();
	            String messages [] = engine.getDeployMessages (); 	
				this.cargarListadoProcesos();
				log.debug("Se desplego el proceso correctamente.");
				
				SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy kk:mm:ss");
				String dataDesplegament = sdf.format(new Date());
				
				StringBuffer b = new StringBuffer ();
				b.append(dataDesplegament+": "+Labels.getLabel("deploy.msgProcesoDesplegadoCorrectamente"));
				for (int i = 0; i < messages.length; i++)
				{
				    b.append ('\n');
				    b.append (messages[i]);
				}
				resultadoDespliegue.setText(b.toString());
			}
		}
		catch (BPMException e) 
		{
                    String messages [] = engine.getDeployMessages ();   
                    StringBuffer b = new StringBuffer ();

                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy kk:mm:ss");
    				String dataDesplegament = sdf.format(new Date());
                    
                    b.append(dataDesplegament+": "+Labels.getLabel("deploy.msgErrorDesplegandoProceso"));
                    for (int i = 0; i < messages.length; i++)
                    {
                        b.append ('\n');
                        b.append (messages[i]);
                    }
                    resultadoDespliegue.setText(b.toString());
                    log.error(e);
		} 
		catch (Exception e) 
		{
                    resultadoDespliegue.setText(Labels.getLabel("deploy.msgErrorDesplegandoProceso") + e.toString());
                    log.error(e);
		} 
		finally 
		{
			if(streamLectura!= null) 
			{
				try 
				{
					streamLectura.close();
				} 
				catch (IOException e) 
				{
					log.error(e);
				}
			}
		}
	}

	public void onSelect ()
	{
		if (listbox.getSelectedItem() == null)
		{
			disablebutton.setDisabled(true);
			enablebutton.setDisabled(true);
		} else {
			ProcessDefinition def = (ProcessDefinition) listbox.getSelectedItem().getValue();
			disablebutton.setDisabled(! def.isEnabled());
			enablebutton.setDisabled( def.isEnabled());
		}
	}
	
	public void enable () throws BPMException, CreateException, NamingException, LoginException, RemoteException
	{
		if (listbox.getSelectedItem() != null)
		{
			ProcessDefinition def = (ProcessDefinition) listbox.getSelectedItem().getValue();
			def = BPMApplication.getEngine().enableProcessDefinition(def);
			listbox.getSelectedItem().setValue(def);
			cargarListadoProcesos();
		}
	}

	public void disable () throws BPMException, CreateException, NamingException, LoginException, RemoteException
	{
		if (listbox.getSelectedItem() != null)
		{
			ProcessDefinition def = (ProcessDefinition) listbox.getSelectedItem().getValue();
			def = BPMApplication.getEngine().disableProcessDefinition(def);
			listbox.getSelectedItem().setValue(def);
			cargarListadoProcesos();
		}
	}

	private static Logger log= Logger.getLogger(DespliegueUI.class);
}
