package es.caib.bpm.ui.process;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.imageio.ImageIO;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.zkoss.image.AImage;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zul.Button;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Window;
import org.zkoss.zul.impl.InputElement;

import es.caib.bpm.attachment.ProcessAttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.classloader.UIClassLoader;
import es.caib.bpm.datamodel.BPMDataNode;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.nas.exception.NASException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.ui.SignatureManager;
import es.caib.bpm.ui.inbox.ListitemCreator;
import es.caib.bpm.ui.tree.FirmaListitem;
import es.caib.bpm.vo.Job;
import es.caib.bpm.vo.ProcessDefinition;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.bpm.vo.TaskInstance;
import es.caib.bpm.vo.Token;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.zkib.component.DataGrid;
import es.caib.zkib.component.DataModel;
import es.caib.zkib.zkiblaf.Application;
import es.caib.zkib.zkiblaf.Frame;
import es.caib.zkib.zkiblaf.Missatgebox;

public class ProcessUI extends Frame {
	
	private long processId = 0;

    Label proceso;
    Label asignadoA;
    Datebox fechaInicioProceso;
    Datebox fechaCreacionTarea;
    Datebox fechaFinalizacionProceso;
    Listbox tablaArchivos;
	private Listbox tablaJobs;
	private Listbox tablaTareas;
	private Label estado;
	private Label descripcion;
	private Label idproceso;
    Component ventanaDinamica = null;
    ProcessInstance currentProcess;
    ProcessDefinition currentDefinition;
	private Job currentJob;
	private Window currentJobWindow;

	private DataModel model;

	private DataGrid comments;

	private Component tabAnexos;

	private Component anexos;

	private Tabbox tabbox;

	private Image visorProceso;

	private Button btnUpgrade;

	private Button btnCancel;

    private static Logger log = Logger.getLogger(ProcessUI.class);


    
	public ProcessUI() {
		super();
		HttpServletRequest req = (HttpServletRequest) Executions.getCurrent().getNativeRequest();
		String id = req.getParameter("id");
		if (id != null) {
			processId  = Long.parseLong(id);
		}
	}

	public void onCreate ()  throws Exception  {
        // Establecemos los datos de proceso
        proceso = (Label) getFellow("txtProceso");
        idproceso = (Label) getFellow("txtIdProceso");
        descripcion = (Label) getFellow("txtDescripcion");
        fechaInicioProceso = (Datebox) getFellow("txtFechaInicio");
        fechaFinalizacionProceso = (Datebox) getFellow("txtFechaFinalizacion");
        fechaCreacionTarea = (Datebox) getFellow("txtFechaCreacion");
        asignadoA = (Label) getFellow("txtAsignadoA");
        estado = (Label) getFellow("txtEstado");
        tablaArchivos = getAttachmentsListbox();
        tablaTareas = (Listbox) getFellow("listadoTareas");
        tablaJobs = (Listbox) getFellow("listadoJobs");
        ventanaDinamica = getFellow("datosElementoWorkflow");
        model = (DataModel) getFellow("BPMdata");
        comments = (DataGrid) getFellow("comments");
        tabAnexos = getFellow("tabAnexos");
        anexos = getFellow("anexos");
        tabbox = (Tabbox) getFellow("tabbox");
        visorProceso = (Image) getFellow("visorProcesoWnd").getFellow("visorProceso");
        btnCancel = (Button) getFellow("btnCancel");
        btnUpgrade = (Button) getFellow("btnUpgrade");

        if (processId > 0) {
			ProcessInstance pi = BPMApplication.getEngine().getProcess(processId);
			openProcessInstance(pi);
		}
        
        addEventListener("onReturn", new EventListener() {
			public void onEvent(Event event) throws Exception {
				ProcessInstance pi = BPMApplication.getEngine().getProcess(processId);
				openProcessInstance(pi);
			}
		});
	}

    private WorkflowWindow getWorkflowWindow() {
    	
        if (ventanaDinamica.getChildren().size() > 0) 
        {
            Component c = (Component) ventanaDinamica.getChildren().get(0);
            if ( c instanceof WorkflowWindow)
            	return (WorkflowWindow) c;
            else
            	return null;
        }
        else
        	return null;
	}

    public ProcessInstance getCurrentProcess() {
        return currentProcess;
    }

    public void setCurrentProcess(ProcessInstance currentProcess) {
        this.currentProcess = currentProcess;
        if (model != null) {
            BPMDataNode node = (BPMDataNode) model.getDataNode();
            node.setProcessInstance(currentProcess);
            model.refresh();
        } else if (currentProcess != null)
            throw new RuntimeException(
                    "Intentado asignar tarea sin objeto BPMDataNode");
    }


    public ProcessDefinition getCurrentDefinition() {
        return currentDefinition;
    }

    public void setCurrentDefinition(ProcessDefinition currentDefinition) {
        this.currentDefinition = currentDefinition;
        if (model != null) {
            BPMDataNode node = (BPMDataNode) model.getDataNode();
            node.setProcessDefinition(currentDefinition);
            model.refresh();
        } else if (currentProcess != null)
            throw new RuntimeException(
                    "Intentado asignar tarea sin objeto BPMDataNode");
    }

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public void refresh() throws IOException, DocumentException, ClassNotFoundException, SQLException, NamingException, CreateException, BPMException {
    	openProcessInstance(getCurrentProcess());
		if (currentJobWindow != null)
			currentJobWindow.setParent(null);
		currentJobWindow = null;
		currentJob = null;
    }
    
    public void openProcessInstance(ProcessInstance proc) throws IOException,
            DocumentException, ClassNotFoundException, SQLException,
            NamingException, CreateException, BPMException {
        ProcessDefinition definicion;
        BPMEngineLocal engine = getEngine();
        String ui;
        ClassLoader heavenClassLoader;
        byte[] imagen;
        org.zkoss.image.Image imagenProceso;
        ByteArrayOutputStream streamSalidaImagen;

        Executions.getCurrent().getUserPrincipal().getName();
        setCurrentProcess(proc);
        definicion = engine.getProcessDefinition(proc);
        setCurrentDefinition(definicion);

        String subject = null;
        try {
        	subject = (String) proc.getVariables().get("Subject");
        } catch (ClassCastException e) {
        	
        }
        Application.setTitle (subject == null? definicion.getName()+" "+proc.getId(): subject);


        imagen = engine.getProcessDefinitionImage(definicion);

        BufferedImage imagenBuffered = ImageIO.read(new ByteArrayInputStream(
                imagen));
        imagenBuffered.getGraphics().setColor(Color.RED);

        int[] coordinates = engine.getCoordinates(proc);

        Graphics2D graph = (Graphics2D) imagenBuffered.getGraphics();
        graph.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
                1.0F));
        graph.setPaint(new Color(255, 140, 140));
        graph.setStroke(new BasicStroke(2.5f));

        // log.debug("Dibujamos en: X: " + coordinates[0] + " Y: " +
        // coordinates[1] + " Ancho: " + coordinates[2] + " Alto: " +
        // coordinates[3]);
        graph.draw(new Rectangle2D.Double((double) coordinates[0],
                (double) coordinates[1], (double) coordinates[2],
                (double) coordinates[3]));

        streamSalidaImagen = new ByteArrayOutputStream();
        ImageIO.write(imagenBuffered, "jpeg", streamSalidaImagen);

        imagenProceso = new AImage("image/jpeg", streamSalidaImagen
                .toByteArray());

        visorProceso.setContent((org.zkoss.image.Image) imagenProceso);


        proceso.setValue(definicion.getName() + " (Ver. " + definicion.getTag()
                + ")");
        idproceso.setValue(Long.toString(proc.getId()));
        fechaFinalizacionProceso.setValue(proc.getEnd());
        fechaInicioProceso.setValue(proc.getStart());
        List tasks = engine.getActiveTasks(proc);
        if (tasks.isEmpty())
        {
        	asignadoA.setValue("-");
        }
        else
        {
            StringBuffer users = new StringBuffer();
            for ( Iterator it = tasks.iterator(); it.hasNext(); )
            {
            	TaskInstance task = (TaskInstance) it.next();
            	fechaCreacionTarea.setValue(task.getCreate());
            	if (task.getActorId() != null)
            	{
            		if (users.length() > 0)
            			users.append (", ");
            		users.append(task.getActorId());
            	}
            	else
            	{
                    for (Iterator it2 = task.getPooledActors().iterator(); it2.hasNext();) {
                		if (users.length() > 0)
                			users.append (", ");
                         users.append(it2.next());
                    }
            	}
            }
            asignadoA.setValue(users.toString());
        }

        describeTokens(proc, engine);
        // Cargamos la interfaz dinamica
        heavenClassLoader = this.cargarClasesUI(definicion);
        try {

            ventanaDinamica.getChildren().clear();
            ui = engine.getUI(proc);
            
            if (ui == null)
            {
            	PageDefinition def = Executions.getCurrent().getPageDefinition("/wf/process/default.zul");
            	Executions.createComponents(def, ventanaDinamica, null);
            }
            else
            {
                Executions.createComponentsDirectly(ui,
                        "zul", ventanaDinamica, null);
            }

            // Actualizar comentarios
            comments.setDataPath("BPMdata:/processInstance/comments");
            // Desactivar botones de upgrade
            boolean canAdmin = engine.canAdmin(proc);
            btnCancel.setVisible(canAdmin && !isFinalized());
            btnUpgrade.setVisible(canAdmin && !isFinalized());

            WorkflowWindow window = getWorkflowWindow();
            if (window != null) {
                // log.debug("Establecemos tarea y variables");
                window.setTask(null);
                window.setProcessInstance(proc);
                window.setEngine(engine);
                window.setSignatureHandler(new SignatureManager(window));

                Events.sendEvent(new Event(WorkflowWindow.LOAD_EVENT, window));

                tabAnexos.setVisible(window.isShowAttachments());
                anexos.setVisible(window.isShowAttachments());

                cargarTablaArchivos(proc, tablaArchivos);
                cargarTablaTareas (proc, tablaTareas);
                cargarTablaJobs (proc, tablaJobs);
                
                tabbox.setSelectedIndex(0);
            } else {
                throw new UiException(
                        "El objecto generado debiera sera una instancia de WorkflowWindow");
            }

        } finally {
            if (heavenClassLoader != null) {
                Thread.currentThread().setContextClassLoader(heavenClassLoader);
            }

        }
    }

	private void describeTokens(ProcessInstance proc, BPMEngineLocal engine)
			throws BPMException {
		Token[] tokens = engine.getTokens(proc.getId());
        if (tokens == null || tokens.length == 0) {
            estado.setValue(Labels.getLabel("token.lblFinished"));
        } else {
        	StringBuffer status = new StringBuffer();
        	for (int i = 0; i <tokens.length; i++)
        	{
        		if (! "/".equals (tokens[i].getTokenName())) {
            		status.append (tokens[i].getTokenName());
            		status.append (": ");
        		}
        		status.append (describeToken(tokens[i]));
        		status.append ("\n");
        	}
        	estado.setValue(status.toString());
        }
	}

    private String describeToken(Token token) {
    	StringBuffer text = new StringBuffer();
    	text.append (token.getNodeName());
    	if (token.isFinished()) {
    		text.append (" (");
    		text.append(Labels.getLabel("token.lblFinished"));
    		text.append (")");
    	} else if (token.isSuspended()){
    		text.append (" (");
    		text.append(Labels.getLabel("token.lblSuspended"));
    		text.append (")");
    	} else if (token.isLocked()){
    		text.append (" (");
    		text.append(Labels.getLabel("token.lblLocked"));
    		text.append (")");
    	} else {
    		text.append (" (");
    		text.append(Labels.getLabel("token.lblActive"));
    		text.append (")");
    	}
    	return text.toString();
	}

	private void cargarTablaJobs(ProcessInstance proc, Listbox tablaJobs) throws CreateException, NamingException, BPMException {
		List jobs = getEngine().getActiveJobs(proc);
		if (jobs == null || jobs.isEmpty())
			tablaJobs.setVisible(false);
		else
		{
			// Visible
			tablaJobs.setVisible(true);
			// Limpiar
			while (tablaJobs.getItemCount() > 0)
				tablaJobs.getItemAtIndex(0).setParent(null);
			// Crear filas
			ListitemCreator creator = new ListitemCreator(getEngine());
			for (Iterator it = jobs.iterator(); it.hasNext(); )
			{
				Job job = (Job) it.next();
				
				Listitem item = creator.createListitem(job);

				tablaJobs.getItems().add(item);
			}
			
		}
		
	}

    public void onSelectTask ()
    {
    	TaskInstance ti = (TaskInstance) tablaTareas.getSelectedItem().getValue();
    	Application.call(BPMApplication.getTaskURL(ti));
    }
    
    public void onSelectJob ()
    {
    	currentJob = (Job) tablaJobs.getSelectedItem().getValue();
    	Component[] components = Executions.getCurrent().createComponents("/wf/job.zul", new HashMap());
    	if (components.length != 1)
    	{
    		throw new UiException ("Expected only one component");
    	}
    	if (currentJobWindow != null)
    		currentJobWindow.setParent(null);
    	currentJobWindow = (Window)components[0];
    	currentJobWindow.setParent(this);
    	SimpleDateFormat formatConHora = new SimpleDateFormat("dd/MM/yyyy hh:mm");
    	((Label)currentJobWindow.getFellow("job.id")).setValue(Long.toString(currentJob.getId()));
    	((Label)currentJobWindow.getFellow("job.process")).setValue(Long.toString(currentJob.getProcessId()));
    	((Label)currentJobWindow.getFellow("job.name")).setValue(currentJob.getName());
    	((Label)currentJobWindow.getFellow("job.dueDate")).setValue(formatConHora.format(currentJob.getDueDate()));
    	((Label)currentJobWindow.getFellow("job.failures")).setValue(Integer.toString(currentJob.getFailures()));
    	((Label)currentJobWindow.getFellow("job.error")).setValue(currentJob.getErrorMessage());
    	Label statusLabel =((Label)currentJobWindow.getFellow("job.status"));
    	Button pauseButton = (Button) currentJobWindow.getFellow("pausebutton");
    	Button resumeButton = (Button) currentJobWindow.getFellow("resumebutton");
    	Button retryButton = (Button) currentJobWindow.getFellow("retrybutton");
    	Button closeButton = (Button) currentJobWindow.getFellow("closebutton");
    	Button processButton = (Button) currentJobWindow.getFellow("openprocess");
    	processButton.setVisible(false);
    	if (currentJob.isPaused())
    	{
    		statusLabel.setValue(Labels.getLabel("job.status.pause"));
    		pauseButton.setVisible(false);
    		retryButton.setVisible(false);
    		resumeButton.addEventListener("onClick", new EventListener() {
				public void onEvent(Event event) throws Exception {
					getEngine().resumeJob(currentJob);
					refresh ();
				}
			});
    	}
    	else if (currentJob.isError())
    	{
    		statusLabel.setValue(Labels.getLabel("job.status.error"));
    		pauseButton.setVisible(false);
    		resumeButton.setVisible(false);
    		retryButton.addEventListener("onClick", new EventListener() {
				public void onEvent(Event event) throws Exception {
					getEngine().retryJob(currentJob);
					refresh ();
				}
					
			});
    	}
    	else 
    	{
    		if (currentJob.getFailures() > 0 && currentJob.getErrorMessage() != null)
    			statusLabel.setValue(Labels.getLabel("job.status.warning"));
    		else
    			statusLabel.setValue(Labels.getLabel("job.status.pending"));
    		retryButton.setVisible(false);
    		resumeButton.setVisible(false);
    		pauseButton.addEventListener("onClick", new EventListener() {
				public void onEvent(Event event) throws Exception {
					getEngine().pauseJob(currentJob);
					refresh ();
				}
					
			});
    	}
    		
		closeButton.addEventListener("onClick", new EventListener() {
			public void onEvent(Event event) throws Exception {
				currentJobWindow.setVisible(false);
				currentJobWindow.setParent(null);
				currentJobWindow = null;
				currentJob = null;
			}
		});

		currentJobWindow.doOverlapped();
    	
		tablaJobs.setSelectedItem(null);
    }
    
	private void cargarTablaTareas(ProcessInstance proc, Listbox tablaTareas) throws CreateException, NamingException, BPMException {
		BPMEngineLocal engine = getEngine();
		List tasks = engine.getActiveTasks(proc);
		if (tasks == null || tasks.isEmpty())
			tablaTareas.setVisible(false);
		else
		{
			// Visible
			tablaTareas.setVisible(true);
			// Limpiar
			while (tablaTareas.getItemCount() > 0)
				tablaTareas.getItemAtIndex(0).setParent(null);
			// Crear filas
			ListitemCreator creator = new ListitemCreator(engine);
			for (Iterator it = tasks.iterator(); it.hasNext(); )
			{
				TaskInstance task = (TaskInstance) it.next();

				
				Listitem item = creator.createListitem(task);
					tablaTareas.getItems().add(item);
			}
			
		}
	}


    private void disableInputbox(Component componente) {
        if (componente instanceof InputElement)
            ((InputElement) componente).setReadonly(true);
        else if (componente instanceof Listbox)
            ((Listbox) componente).setDisabled(true);
        else if (componente instanceof Button)
            ((Button) componente).setDisabled(true);
        else {
            for (Iterator it = componente.getChildren().iterator(); it
                    .hasNext();) {
                Component child = (Component) it.next();
                disableInputbox(child);
            }
        }

    }

    public void refreshListadoArchivos() throws IOException, NamingException,
            CreateException {
        this.getDesktop().getSession();
        Listbox tablaArchivos = null;

        tablaArchivos = getAttachmentsListbox();

        if (getCurrentProcess() != null) {
            this.cargarTablaArchivos(getCurrentProcess(), tablaArchivos);
        }
    }

    public void cargarTablaArchivos(ProcessInstance process, Listbox tablaArchivos)
            throws IOException, NamingException, CreateException {
        Listitem item = null;
        String roles = null;

        ProcessAttachmentManager business = new ProcessAttachmentManager(process);

        tablaArchivos.getItems().clear();

        for (Iterator it = business.getTags().iterator(); it.hasNext();) {
            String tag = (String) it.next();
            Document document = business.getDocument(tag);

            item = new Listitem();
            item.appendChild(new Listcell(document.getExternalName()));
            item.appendChild(new Listcell(document.getMimeType()));
            item.setValue(tag);

            if (document.getRoles().isEmpty()) {
                item.appendChild(new Listcell("Público"));
                item.appendChild(new Listcell(""));
            } else {
                item.appendChild(new Listcell("Privado"));
                roles = "";

                for (Iterator itRoles = document.getRoles().iterator(); itRoles
                        .hasNext();) {
                    String role = (String) itRoles.next();

                    roles += role + " ";
                }

                item.appendChild(new Listcell(roles));
            }

            tablaArchivos.getItems().add(item);
        }
    }

    private static java.util.Hashtable classLoaders = new java.util.Hashtable();

    public ClassLoader cargarClasesUI(ProcessDefinition def)
            throws ClassNotFoundException, SQLException, IOException,
            CreateException, NamingException {
        Map clases = null;
        UIClassLoader loader = null;
        this.getDesktop().getSession();
        BPMEngineLocal engine = getEngine();
        ClassLoader heavenLoader = null;

        heavenLoader = Thread.currentThread().getContextClassLoader();

        loader = (UIClassLoader) classLoaders.get(new Long(def.getId()));
        if (loader == null) {
            clases = engine.getUIClassesForTask(def);

            loader = new UIClassLoader(clases, heavenLoader);

            loader.cargarClases();

            classLoaders.put(new Long(def.getId()), loader);
        }

        Thread.currentThread().setContextClassLoader(loader);

        return heavenLoader;
    }



    public void cerrar() throws InterruptedException, IOException,
            CreateException, NamingException, BPMException, ClassNotFoundException, SQLException, DocumentException {
       	Application.goBack();
    }


    private BPMEngineLocal getEngine() throws CreateException, NamingException {
        return BPMApplication.getEngine();
    }


    public void descargarArchivo() throws IOException, DocumentBeanException, BPMException, InterruptedException
    {
            Listbox tablaArchivos= null;
            Listitem item= null;
            ProcessAttachmentManager business= new ProcessAttachmentManager(getCurrentProcess());
            
            //Tomamos la tabla de archivos
            tablaArchivos= getAttachmentsListbox();

            if(tablaArchivos!= null)
            {
                    //tomamos el item seleccionado
                    item= tablaArchivos.getSelectedItem();
                    
                    if(item!= null)
                    {
                            String tag = (String) item.getValue();
                            Executions.getCurrent().sendRedirect(business.getDownloadURL(tag), "_new");
                    }
                    else
                    {
                    		Missatgebox.info("Debe seleccionar un archivo");
                    }
            }
            else
            {
            	Missatgebox.info("Debe cargar Archivos antes de intentar descargarlos");                      
            }
    }
    
    public void seleccionarDocumento() throws SignatureTimestampException, IOException, ClassNotFoundException, NASException, NamingException, CreateException
    {
            Listbox tablaArchivos= null;
            Listitem item= null;
            Listitem roleListItem= null;
            Document document= null;
            Set rolesDocumento= null;
            String role= null;
            Listbox tablaRoles= null;
            List firmas= null;
            Signature sign= null;
            
            Vbox roles= (Vbox)this.getFellow("rolesDocumento");
            ProcessAttachmentManager am = new ProcessAttachmentManager(getCurrentProcess());
            
            roles.setVisible(false);
            
            //Tomamos la tabla de archivos
            tablaArchivos= getAttachmentsListbox();
            tablaRoles= getRolesListbox();
            Listbox tablaFirmas = getSignaturesListbox();
            
            //Limpiamos la tabla de roles
            tablaRoles.getItems().clear();
            
            if(tablaArchivos!= null)
            {
                    //tomamos el item seleccionado
                    item = tablaArchivos.getSelectedItem();
                    
                    if(item!= null)
                    {
                            String tag = (String) item.getValue();
                    
                            document = am.getDocument(tag);
                            
                            // Actualizar roles
                            rolesDocumento= document.getRoles();
                            
                            tablaRoles.getItems().clear ();
                            for(Iterator it= rolesDocumento.iterator(); it.hasNext();)
                            {
                                    role= (String)it.next();
                                    
                                    roleListItem= new Listitem();
                                    
                                    roleListItem.setValue(role);
                                    roleListItem.appendChild(new Listcell(role));
                                    
                                    tablaRoles.appendChild(roleListItem);
                            }
                            
                            // Actualizar firmas
                            tablaFirmas.getItems().clear ();
                            firmas= document.getSigns();

                            for(int index= 0; index< firmas.size(); index++)
                            {
                                sign= ((Signature)firmas.get(index));
                                tablaFirmas.getItems().add(new FirmaListitem(sign));
                            }
                    }
            }
    }

    private Listbox getSignaturesListbox() {
        return (Listbox) getFellow ("tablaFirmas");
    }

    private Listbox getRolesListbox() {
        return (Listbox) getFellow ("tablaRoles");
    }

    private Listbox getAttachmentsListbox() {
        return (Listbox) getFellow("tablaArchivos");
    }
    
    public void downloadSign() throws InterruptedException, IOException, NamingException, DocumentBeanException
    {
            Iframe iframe= (Iframe)this.getFellowIfAny("iframe");
            Tree tree= null;
            FirmaListitem row= null;

            tree= (Tree)this.getFellowIfAny("treefirmas");

            if(tree!=null && tree.getSelectedItem()!= null)
            {
                    row= (FirmaListitem)tree.getSelectedItem().getChildren().get(0);
                    
                    iframe.setContent(new AMedia("firma.sign", ".sign", "application/octet-stream", row.getSign().getPkcs7()));
            }
            else
            {
            	Missatgebox.avis(Labels.getLabel("contenidoTarea.msgSeleccionFirma"), "Custodia de Documentos");
            }
    }
    


    public void cancel( ) throws IOException, DocumentException, ClassNotFoundException, SQLException, NamingException, CreateException, BPMException {
			boolean result = Missatgebox.confirmaYES_NO(Labels.getLabel("process.confirmCancel"),
					Labels.getLabel("process.warning")
					,Messagebox.EXCLAMATION);
			if (result)
			{
				setCurrentProcess(getEngine().cancel(getCurrentProcess()));
				refresh();
			}

    }

    public void upgrade( ) throws IOException, DocumentException, ClassNotFoundException, SQLException, NamingException, CreateException, BPMException {
		getEngine().upgradeProcess(getCurrentProcess());
		String result []= getEngine().getDeployMessages();
		StringBuffer b = new StringBuffer();
		for (int i = 0; i < result.length; i++)
		{
			b.append (result[i]);
			b.append ('\n');
		}
		Missatgebox.info(b.toString(),
				Labels.getLabel("process.upgraderesult"));
		refresh();
    }
    
    /**
     * returns a boolean indicating if the process has ended. Used to enable/disable buttons
     */
    public boolean isFinalized(){
    	return (getCurrentProcess().getEnd()!=null);   
    }
}
