package es.caib.bpm.ui.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.Button;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

import es.caib.bpm.identity.IdentityManager;
import es.caib.bpm.identity.vo.User;


public class SeleccionUsuarioUI extends Window 
{
	
	private static final long serialVersionUID = 1L;
	private String delegateUsuCodi=null;
	public Comparator [] cmpAsc=new StringArrayComparator[3];
	public Comparator [] cmpDsc=new StringArrayComparator[3];
	
	public SeleccionUsuarioUI() {
		cmpAsc[2]=new StringArrayComparator(true,1);
		cmpAsc[1]=new StringArrayComparator(true,1);
		cmpAsc[0]=new StringArrayComparator(true,0);

		cmpDsc[2]=new StringArrayComparator(false,1);
		cmpDsc[1]=new StringArrayComparator(false,1);
		cmpDsc[0]=new StringArrayComparator(false,0);
				

	}

	
	public String getUsuarioSeleccionado()
	{
		return delegateUsuCodi;
	}
	

	private void removeSearchRows() {
		Component comp=getFellow("busquedafirmanterows");
		
		Listbox rows=(Listbox) comp;
		List l=rows.getItems();		
		int size=l.size();
		Listitem r[]=(Listitem [])l.toArray(new Listitem[size]);
		//saltamos la primera fila
		
		for(int i=0;i<size;i++){
			
			rows.removeItemAt(i);
		}
		
	}
	



	public void setDelegat(String usuCodi){
		delegateUsuCodi=usuCodi;
	}
	
	private static Logger log= Logger.getLogger(SeleccionUsuarioUI.class);
	
	public class SeleccionUsuarioUIItemRenderer implements ListitemRenderer{
		Button delegar=null;
		
		public void render(Listitem item, java.lang.Object data){
			Object [] cols =(Object [])data;
			int i=0;
			for(i=0;i<cols.length;i++){
				Label lb=new Label((String)cols[i]);
				Listcell cell=new Listcell();
				cell.appendChild(lb);
				item.appendChild(cell);
			}
			
			Listcell cell2=new Listcell();
			delegar=new Button("Delega");
			delegar.setAttribute("usucodi",(String)cols[0]);
			delegar.addEventListener("onClick",new SeleccionUsuarioUIDelegarBtnEventListener((String)cols[0]));
			cell2.appendChild(delegar);
			item.appendChild(cell2);


		} 
		
	}

	
	protected class SeleccionUsuarioUIDelegarBtnEventListener implements EventListener{
		private String codiUsuari;

		public SeleccionUsuarioUIDelegarBtnEventListener(String codiUsuari) {
			this.codiUsuari=codiUsuari;
		}

		public void onEvent(Event arg0) {
           		setDelegat(codiUsuari);
           		detach();
       	}
	}

	public void findUsers(String nom, String llinatges) throws Exception{
		
		removeSearchRows();
		IdentityManager identity=new IdentityManager();
		Collection users = identity.buscaUsuariPerNomEmail(nom,llinatges);

//		Iterator it=users.iterator();
//		String [][] out=new String [users.size()][2];
//		int i=0;
//		while(it.hasNext()){
//			User user=(User)it.next();
//			out[i][0]=user.getId();
//			out[i][1]=user.getEmail();
//			i++;
//		}
//		ListModelArray model=new ListModelArray(out);

		((Listbox)getFellow("busquedafirmanterows")).setModel(new SeleccionUsuarioListModel(users));
		((Listbox)getFellow("busquedafirmanterows")).setItemRenderer(new SeleccionUsuarioUIItemRenderer());

	}
	
	protected class SeleccionUsuarioListModel extends AbstractListModel{
		List model= new ArrayList();
		public SeleccionUsuarioListModel(Collection model) {
			this.model.addAll(model);
		}

		public Object getElementAt(int index) {
			if(model==null) return null;
			if(model.size()<=index) return new IndexOutOfBoundsException();
			User u=((User)model.get(index));
			return new String [] {u.getId(),u.getEmail()};
		}

		public int getSize() {
			return model.size();
		}
		

		
	}

	public void searchDelegateUsers() throws WrongValueException, Exception{
		Textbox nom_t=(Textbox)getFellow("usu_nom");
		Textbox lli_t=(Textbox)getFellow("usu_mail");
		findUsers( nom_t.getValue(), lli_t.getValue());
	}
		
	
	
	

	public class StringArrayComparator implements Comparator{
		boolean asc=true;
		int col=0;
	
		public StringArrayComparator(boolean ascending,int column) {
			this.asc=ascending;
			this.col=column;
	
		}
		
		public int compare(Object arg0, Object arg1) {
			int cmp=((String)((Object[]) arg0)[col]).toLowerCase().compareTo(((String)((Object [])arg1)[col]).toLowerCase());
			return (asc)?cmp:-cmp;
		}
		
		
	}

	
}
