package es.caib.bpm.ui.task;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.ejb.CreateException;
import javax.imageio.ImageIO;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.zkoss.image.AImage;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Fileupload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.impl.InputElement;

import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.local.BPMEngineLocal;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.classloader.UIClassLoader;
import es.caib.bpm.datamodel.BPMDataNode;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.nas.exception.NASException;
import es.caib.bpm.toolkit.BPMApplication;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;
import es.caib.bpm.ui.SignatureManager;
import es.caib.bpm.ui.tree.FirmaListitem;
import es.caib.bpm.vo.ProcessDefinition;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.bpm.vo.TaskInstance;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.zkib.component.DataGrid;
import es.caib.zkib.component.DataModel;
import es.caib.zkib.util.SynchronizableBoolean;
import es.caib.zkib.zkiblaf.Application;
import es.caib.zkib.zkiblaf.Frame;
import es.caib.zkib.zkiblaf.Missatgebox;

public class TaskUI extends Frame implements EventListener {
	
	private long taskId = 0;
    Label proceso = null;
    Label tarea = null;
    Label asignadoA = null;
    Datebox fechaInicioProceso = null;
    Datebox fechaCreacionTarea = null;
    Datebox fechaFinalizacionProceso = null;
    Component ventanaDinamica = null;
    Image visorImagenes = null;
    Listbox tablaArchivos = null;
    Label estado = null;
	private DataModel model;
	private Label descripcion;
	private Label idtarea;
	private Label idproceso;
	private DataGrid comments;
	private Component newcommentBox = null;
	TaskInstance currentTask;
    ProcessInstance currentProcess;
    ProcessDefinition currentDefinition;
	private Component tabAnexos;
	private Component anexos;
	private Component uploadButton;
	private Component deleteButton;
    private static Logger log = Logger.getLogger(TaskUI.class);
    private Tabbox tabbox;
    Textbox newComment;
    Hbox botonera = null;
    Button btnTomar = null;
    Button btnDelegar = null;
	private Button btnCerrar;
	private Button btnSalvar;

    
	public boolean canClose() {
        boolean result;

		if (! getDataModel().isCommitPending())
			return true;
		
		result=Missatgebox.confirmaYES_NO(Labels.getLabel("task.msgDeseaSalir"),
				Labels.getLabel("task.titleDeseaSalir")
				,Messagebox.QUESTION);

        return result;
	}

	public TaskUI() {
		super();
		HttpServletRequest req = (HttpServletRequest) Executions.getCurrent().getNativeRequest();
		String id = req.getParameter("id");
		if (id != null) {
			taskId  = Long.parseLong(id);
		}
	}

	public void onCreate ()  throws Exception {
	    visorImagenes = (Image) getFellow("visorProcesoWnd").getFellow("visorProceso");

	    fechaInicioProceso = (Datebox) getFellow("txtFechaInicio");
	    fechaFinalizacionProceso = (Datebox) getFellow("txtFechaFinalizacion");
	    fechaCreacionTarea = (Datebox) getFellow("txtFechaCreacion");
	    asignadoA = (Label) getFellow("txtAsignadoA");
	    estado = (Label) getFellow("txtEstado");
        model = (DataModel) getFellow("BPMdata");

        proceso = (Label) getFellow("txtProceso");
        tarea = (Label) getFellow("txtTarea");
        idproceso = (Label) getFellow("txtIdProceso");
        idtarea = (Label) getFellow("txtIdTarea");
        descripcion = (Label) getFellow("txtDescripcion");
        fechaInicioProceso = (Datebox) getFellow("txtFechaInicio");
        fechaFinalizacionProceso = (Datebox) getFellow("txtFechaFinalizacion");
        fechaCreacionTarea = (Datebox) getFellow("txtFechaCreacion");
        asignadoA = (Label) getFellow("txtAsignadoA");
        tablaArchivos = getAttachmentsListbox();
        comments = (DataGrid) getFellow("comments");
        newcommentBox = getFellow("newCommentBox");
        tabAnexos = getFellow("tabAnexos");
        anexos = getFellow("anexos");
        uploadButton = getFellow("uploadButton");
        deleteButton = getFellow("deleteButton");
        tabbox = (Tabbox) getFellow("tabTarea");
        newComment = (Textbox) getFellow("newComment");
        botonera = (Hbox) getFellow("botonera");
        btnTomar = (Button) botonera.getFellow("btnTomar");
        btnDelegar = (Button) botonera.getFellow("btnDelegar");
        btnSalvar = (Button) botonera.getFellow("btnSalvar");
        btnCerrar = (Button) botonera.getFellow("btnCerrar");
        ventanaDinamica = getFellow("datosElementoWorkflow");

		if (taskId > 0) {
			TaskInstance ti = BPMApplication.getEngine().getTask(taskId);
			openTaskInstance(ti);
		}
		
	}


    public ProcessInstance getCurrentProcess() {
        return currentProcess;
    }

    public void setCurrentProcess(ProcessInstance currentProcess) {
        this.currentProcess = currentProcess;
        DataModel model = getDataModel();
        if (model != null) {
            BPMDataNode node = (BPMDataNode) model.getDataNode();
            node.setProcessInstance(currentProcess);
            model.refresh();
        } else if (currentTask != null)
            throw new RuntimeException(
                    "Intentado asignar tarea sin objeto BPMDataNode");
    }

    private DataModel getDataModel() {
        return model;
    }

    public ProcessDefinition getCurrentDefinition() {
        return currentDefinition;
    }

    public void setCurrentDefinition(ProcessDefinition currentDefinition) {
        this.currentDefinition = currentDefinition;
        DataModel model = getDataModel();
        if (model != null) {
            BPMDataNode node = (BPMDataNode) model.getDataNode();
            node.setProcessDefinition(currentDefinition);
            model.refresh();
        } else if (currentTask != null)
            throw new RuntimeException(
                    "Intentado asignar tarea sin objeto BPMDataNode");
    }

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public void openTaskInstance(TaskInstance task) throws IOException,
            DocumentException, ClassNotFoundException, SQLException,
            NamingException, CreateException {
        ProcessDefinition definicion;
        BPMEngineLocal engine = getEngine();
        Component componenteGenerado = null;
        ProcessInstance instanciaProceso;
        String ui;
        ClassLoader heavenClassLoader;
        byte[] imagen;
        org.zkoss.image.Image imagenProceso;
        ByteArrayOutputStream streamSalidaImagen;

        String user = Executions.getCurrent().getUserPrincipal().getName();
        boolean canManage = user.equals(task.getActorId())
                && task.getStart() != null;

        Application.setTitle(task.getName());
        setCurrentTask(task);

        instanciaProceso = engine.getProcessInstance(task);
        setCurrentProcess(instanciaProceso);
        definicion = engine.getProcessDefinition(instanciaProceso);
        setCurrentDefinition(definicion);

        imagen = engine.getProcessDefinitionImage(definicion);

        BufferedImage imagenBuffered = ImageIO.read(new ByteArrayInputStream(
                imagen));
        imagenBuffered.getGraphics().setColor(Color.RED);

        int[] coordinates = engine.getCoordinates(task);

        Graphics2D graph = (Graphics2D) imagenBuffered.getGraphics();
        graph.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
                1.0F));
        graph.setPaint(new Color(255, 140, 140));
        graph.setStroke(new BasicStroke(2.5f));

        // log.debug("Dibujamos en: X: " + coordinates[0] + " Y: " +
        // coordinates[1] + " Ancho: " + coordinates[2] + " Alto: " +
        // coordinates[3]);
        graph.draw(new Rectangle2D.Double((double) coordinates[0],
                (double) coordinates[1], (double) coordinates[2],
                (double) coordinates[3]));

        streamSalidaImagen = new ByteArrayOutputStream();
        ImageIO.write(imagenBuffered, "jpeg", streamSalidaImagen);

        imagenProceso = new AImage("image/jpeg", streamSalidaImagen
                .toByteArray());

        visorImagenes.setContent((org.zkoss.image.Image) imagenProceso);

        // Establecemos los datos de proceso

        proceso.setValue(definicion.getName() + " (Ver. " + definicion.getTag()
                + ")");
        idproceso.setValue(Long.toString(instanciaProceso.getId()));
        idtarea.setValue(Long.toString(task.getId()));
        descripcion.setValue(task.getDescription());
        fechaFinalizacionProceso.setValue(instanciaProceso.getEnd());
        tarea.setValue(task.getName());
        fechaInicioProceso.setValue(instanciaProceso.getStart());
        if (task.getActorId() == null) {
            String users = null;
            for (Iterator it = task.getPooledActors().iterator(); it.hasNext();) {
                if (users == null)
                    users = (String) it.next();
                else
                    users = users + ", " + (String) it.next();
            }
            asignadoA.setValue(users);
        } else
            asignadoA.setValue(task.getActorId());
        fechaCreacionTarea.setValue(task.getCreate());

        if (task.isOpen()) {
            if (task.getStart() == null) {
                estado.setValue(Labels.getLabel("task.estat.pendent"));
            } else {
                estado.setValue(Labels.getLabel("task.estat.encurs"));
            }
        } else {
            estado.setValue(Labels.getLabel("task.estat.fi"));
        }
        // Cargamos la interfaz dinamica

        heavenClassLoader = this.cargarClasesUI(definicion);
        try {
            ui = engine.getUI(task);

            ventanaDinamica.getChildren().clear();

            if (ui != null) {
                HashMap map = new HashMap();
                map.put("taskInstance", task);
                map.put("processInstance", instanciaProceso);
                map.put("engine", engine);
                componenteGenerado = Executions.createComponentsDirectly(ui,
                        "zul", ventanaDinamica, map);
                if (!canManage || task.isCancelled() || task.getEnd()!=null)
                    disableInputbox(componenteGenerado);
            }

            this.updateBotonera(componenteGenerado);

            // Actualizar comentarios
            comments.setDataPath("BPMdata:/processInstance/comments");
            newComment.setValue("");
            newcommentBox.setVisible(canManage);

            if (componenteGenerado != null
                    && componenteGenerado instanceof WorkflowWindow) {
                WorkflowWindow window = (WorkflowWindow) componenteGenerado;

                // log.debug("Establecemos tarea y variables");
                window.setTask(task);
                window.setProcessInstance(instanciaProceso);
                window.setEngine(engine);
                window.setSignatureHandler(new SignatureManager(window));

                Events.sendEvent(new Event(WorkflowWindow.LOAD_EVENT, window));

                tabAnexos.setVisible(
                        window.isShowAttachments() && canManage);
                anexos.setVisible(
                        window.isShowAttachments() && canManage);

                this.cargarTablaArchivos(task, tablaArchivos);
                uploadButton.setVisible(
                        window.isShowAttachments()
                                && window.isCanAddAttachments() && canManage);
                deleteButton
                        .setVisible(
                                window.isShowAttachments()
                                        && window.isCanDeleteAttachments()
                                        && canManage);                
                tabbox.setSelectedIndex(0);
            } else {
                throw new UiException(
                        "El objecto generado debiera sera una instancia de WorkflowWindow");
            }

        } finally {
            if (heavenClassLoader != null) {
                Thread.currentThread().setContextClassLoader(heavenClassLoader);
            }

        }
    }


    private void disableInputbox(Component componente) {
        if (componente instanceof InputElement)
            ((InputElement) componente).setReadonly(true);
        else if (componente instanceof Listbox)
            ((Listbox) componente).setDisabled(true);
        else if (componente instanceof Button)
            ((Button) componente).setDisabled(true);
        else if (componente instanceof Radio)
            ((Radio) componente).setDisabled(true);
        else if (componente instanceof Checkbox)
            ((Checkbox) componente).setDisabled(true);
        else {
            for (Iterator it = componente.getChildren().iterator(); it
                    .hasNext();) {
                Component child = (Component) it.next();
                disableInputbox(child);
            }
        }

    }

    public void limpiarSeleccion() {
        
        tablaArchivos = getAttachmentsListbox ();

        log.debug("Limpiamos");
        visorImagenes.setContent((org.zkoss.image.Image) null);
        if (fechaInicioProceso != null)
            fechaInicioProceso.setValue(null);
        if (asignadoA != null)
            asignadoA.setValue("");
        if (fechaCreacionTarea != null)
            fechaCreacionTarea.setValue(null);
        if (fechaFinalizacionProceso != null)
            fechaFinalizacionProceso.setValue(null);
        if (tablaArchivos != null)
            tablaArchivos.getItems().clear();

        if (ventanaDinamica != null)
            ventanaDinamica.getChildren().clear();
    }

    public void refreshListadoArchivos() throws IOException, NamingException,
            CreateException {
        Listbox tablaArchivos = null;

        tablaArchivos = getAttachmentsListbox();

        if (getCurrentTask() != null) {
            this.cargarTablaArchivos(getCurrentTask(), tablaArchivos);
        }
    }

    public void cargarTablaArchivos(TaskInstance task, Listbox tablaArchivos)
            throws IOException, NamingException, CreateException {
        Listitem item = null;
        String roles = null;

        TaskAttachmentManager business = new TaskAttachmentManager(
                getCurrentTask());

        tablaArchivos.getItems().clear();

        for (Iterator it = business.getTags().iterator(); it.hasNext();) {
            String tag = (String) it.next();
            Document document = business.getDocument(tag);

            item = new Listitem();
            item.appendChild(new Listcell(document.getExternalName()));
            item.appendChild(new Listcell(document.getMimeType()));
            item.setValue(tag);

            if (document.getRoles().isEmpty()) {
                item.appendChild(new Listcell("Público"));
                item.appendChild(new Listcell(""));
            } else {
                item.appendChild(new Listcell("Privado"));
                roles = "";

                for (Iterator itRoles = document.getRoles().iterator(); itRoles
                        .hasNext();) {
                    String role = (String) itRoles.next();

                    roles += role + " ";
                }

                item.appendChild(new Listcell(roles));
            }

            tablaArchivos.getItems().add(item);
        }
    }

    private static java.util.Hashtable classLoaders = new java.util.Hashtable();

    public ClassLoader cargarClasesUI(ProcessDefinition def)
            throws ClassNotFoundException, SQLException, IOException,
            CreateException, NamingException {
        Map clases = null;
        UIClassLoader loader = null;
        BPMEngineLocal engine = getEngine();
        ClassLoader heavenLoader = null;

        heavenLoader = Thread.currentThread().getContextClassLoader();

        loader = (UIClassLoader) classLoaders.get(new Long(def.getId()));
        if (loader == null) {
            clases = engine.getUIClassesForTask(def);

            loader = new UIClassLoader(clases, heavenLoader);

            loader.cargarClases();

            classLoaders.put(new Long(def.getId()), loader);
        }

        Thread.currentThread().setContextClassLoader(loader);

        return heavenLoader;
    }

    public void updateBotonera(Component componenteGenerado) {
        TaskInstance task = getCurrentTask();
        String user = Executions.getCurrent().getUserPrincipal().getName();

        if (componenteGenerado instanceof WorkflowWindow)
            btnDelegar.setDisabled(!((WorkflowWindow) componenteGenerado)
                    .isAllowDelegate());
        else
            btnDelegar.setDisabled(true);

        botonera.getChildren().clear();

        btnTomar.setVisible(task.getStart() == null
                || !user.equals(task.getActorId()));

        btnDelegar.setVisible(
        		(task.getStart() == null || user.equals(task.getActorId())) 
        		&& !task.isCancelled() && task.getEnd()==null		);

        boolean iniciado = user.equals(task.getActorId())
                && task.getStart() != null;
        btnSalvar.setVisible(iniciado && !task.isCancelled() && task.getEnd()==null);
        
        //només mostrar botons de transició si la tasca està activa
        if(!task.isCancelled() && task.getEnd()==null){
	        Arrays.sort(task.getTransitions());
	        Button button = null;
	        for (int i = 0; iniciado && i < task.getTransitions().length; i++) {
	            button = new Button();
	            button.setLabel(task.getTransitions()[i]);
	            button.addEventListener("onClick", this);
	            botonera.appendChild(button);
	        }
        }
    }

    public TaskInstance getCurrentTask() {
        return currentTask;
    }

    public void setCurrentTask(TaskInstance currentTask) {
        this.currentTask = currentTask;
        DataModel model = getDataModel();
        if (model != null) {
            BPMDataNode node = (BPMDataNode) model.getDataNode();
            node.setTaskInstance(currentTask);
            model.refresh();
        } else if (currentTask != null)
            throw new RuntimeException(
                    "Intentado asignar tarea sin objeto BPMDataNode");
    }

    public void onEvent(Event evt) throws InterruptedException, IOException,
            CreateException, NamingException {
        if ("onClick".equals(evt.getName())) {
            ejecutarTarea(((Button) evt.getTarget()).getLabel());
        }
    }

    public void ejecutarTarea(String transicion) throws InterruptedException,
            IOException, CreateException, NamingException {
        TaskInstance task = null;
        BPMEngineLocal engine = getEngine();

        try {
        	WorkflowWindow workflowWindow = getWorkflowWindow ();
            if (workflowWindow != null) {

                task = workflowWindow.getTask();

                try {
                    Events.sendEvent(new Event(WorkflowWindow.SAVE_EVENT,
                            workflowWindow));

                    ProcessInstance process = getCurrentProcess();
                    engine.update(task);
                    if (newComment.getValue() != null
                            && newComment.getValue().length() > 0) {
                        task = engine.addComment(task, newComment.getValue());
                        workflowWindow.setTask(task);
                    }

                    Events.sendEvent(new Event(
                            WorkflowWindow.PREPARE_TRANSITION_EVENT,
                            workflowWindow, transicion));

                    task = engine.executeTask(task, transicion);
                    workflowWindow.setTask(task);

                    Events.sendEvent(new Event(
                            WorkflowWindow.COMPLETE_TRANSITION_EVENT,
                            workflowWindow, transicion));

                    // Locate next task from same process
                    List tasks = engine.getPendingTasks(process);

                    getDataModel().commit();
                    if (tasks != null && tasks.size() > 0) {
                        TaskInstance newTask = (TaskInstance) tasks.get(0);
                        newTask = engine.startTask(newTask);
                        
                        Application.jumpTo(BPMApplication.getTaskURL(newTask));
                    } else {
                    	Application.goBack();
                    }

                } catch (Exception ex) {
                    log.error("Error during transition", ex);
                    workflowWindow.refresh();
                    // Localizar el mensaje
                    String message = Labels.getLabel("task.msgError") + " "
                            + ex.toString();
                    Throwable ex2 = ex;
                    while (ex2 != null) {
                        if (ex2 instanceof WorkflowException)
                            message = Labels.getLabel("task.msgError")
                                    + " " + ex2.getMessage();

                        if (ex2.getCause() == ex2)
                            ex2 = null;
                        else
                            ex2 = ex2.getCause();
                    }
                    Missatgebox.error(message);
                }
            } else {
            	Missatgebox.info(Labels.getLabel("task.msgSeleccionTarea"),
                        "Workflow BPM");
            }
        } finally {
        }
    }


    private WorkflowWindow getWorkflowWindow() {
    	
        if (ventanaDinamica.getChildren().size() > 0) 
        {
            Component c = (Component) ventanaDinamica.getChildren().get(0);
            if ( c instanceof WorkflowWindow)
            	return (WorkflowWindow) c;
            else
            	return null;
        }
        else
        	return null;
	}

	public void salvarTarea() throws InterruptedException, IOException,
            CreateException, NamingException {
        WorkflowWindow workflowWindow = null;
        TaskInstance task = null;
        BPMEngineLocal engine = getEngine();

        try {
        	workflowWindow = getWorkflowWindow();
            if (workflowWindow != null) {

                task = workflowWindow.getTask();

                try {
                    Events.sendEvent(new Event(WorkflowWindow.SAVE_EVENT,
                            workflowWindow));

                    engine.update(task);
                    if (newComment.getValue() != null
                            && newComment.getValue().length() > 0)
                    {
                        task = engine.addComment(task, newComment.getValue());
                        workflowWindow.setTask(task);
                    }

                    getDataModel().commit();
                    Application.goBack();
                } catch (UiException ex) {
                    workflowWindow.refresh();
                    if (ex.getCause() != null
                            && ex.getCause() instanceof UserWorkflowException) {
                        if (ex.getCause().getMessage() != null)
                        	Missatgebox.error(ex.getCause().getMessage());
                    } else {
                        log.error("Error no esperado", ex);
                        throw ex;
                    }
                } catch (Exception ex) {
                    workflowWindow.refresh();
                    log.error("Error no esperado", ex);
                }
            } else {
            	Missatgebox.info(Labels.getLabel("task.msgSeleccionTarea"),
                        "Workflow BPM");
            }
        } finally {
        }
    }

    public void cerrarTarea() throws InterruptedException, IOException,
            CreateException, NamingException, BPMException, ClassNotFoundException, SQLException, DocumentException {
       	Application.goBack();
    }

    public void tomarTarea() throws InterruptedException, CreateException,
            NamingException {
        TaskInstance task = null;

        try {
            task = getEngine().startTask(getCurrentTask());
            Application.jumpTo(BPMApplication.getTaskURL(task));
        } catch (Exception ex) {
        	Missatgebox.error(Labels.getLabel("task.msgError") + " "
                    + ex.getMessage());
        } finally {
        }
    }

    public void delegarTarea() throws InterruptedException, CreateException,
            NamingException {
        WorkflowWindow workflowWindow = getWorkflowWindow();
        TaskInstance task = null;
        BPMEngineLocal engine = getEngine();
        SeleccionUsuarioUI window = null;
        String usuarioSeleccionado = null;

        try {
        	
            if (workflowWindow != null) {
                task = workflowWindow.getTask();

                //PJR- afegeixo això per si cal amagar plugins adobe de previsualització de documents, ja que impedeixen que la finestra de selecció d'usuari es vegi
                Events.sendEvent(workflowWindow,new Event(WorkflowWindow.DELEGATION_INIT_EVENT,
                        workflowWindow));
                
                
                window = (SeleccionUsuarioUI) Executions.createComponents(
                        "/wf/task/seleccionUsuario.zul", this, null);
                window.doModal();

                usuarioSeleccionado = window.getUsuarioSeleccionado();

                if (usuarioSeleccionado != null) {
                    if (newComment.getValue() != null
                            && newComment.getValue().length() > 0)
                        task = engine.addComment(task, newComment.getValue());
                    task = engine.delegateTaskToUser(task,
                            usuarioSeleccionado);
                    workflowWindow.setTask(task);

                    log.debug("Limpiamos la seleccion de tareas");
                    Application.goBack();
                }
            } else {
            	Missatgebox.info(Labels.getLabel("task.msgSeleccionTarea"),
                        "Workflow BPM");
            }

        } catch (Exception ex) {
            Missatgebox.error(Labels.getLabel("task.msgError") + " "
                    + ex.getMessage());
        } finally {
        }
    }

    private BPMEngineLocal getEngine() throws CreateException, NamingException {
        return BPMApplication.getEngine();
    }

    public void subirArchivo() throws InterruptedException, IOException, NamingException, CreateException, DocumentBeanException, BPMException
    {

            Media dataSubida= null;
            TaskAttachmentManager business= new TaskAttachmentManager(getCurrentTask());
            Session sesion= this.getDesktop().getSession();
            
            dataSubida = Fileupload.get(true);
            
            if(dataSubida!= null)
            {
                    String tag = ((HttpSession)sesion.getNativeSession()).getId();
                    business.uploadFile(dataSubida, tag);
                    refreshListadoArchivos();
            }
    }

    public void eliminarArchivo() throws Exception
    {
            Listbox listbox= getAttachmentsListbox();

            TaskAttachmentManager business= new TaskAttachmentManager(getCurrentTask());
            
            if(listbox.getSelectedItem()!= null)
            {
                    String tag= (String)listbox.getSelectedItem().getValue();
            
                    business.eliminarArchivo(tag);
                    
                    refreshListadoArchivos();
            }
            else
            {
            	Missatgebox.info(Labels.getLabel("contenidoTarea.msgSeleccionArchivo"));
            }
    }

    public void descargarArchivo() throws IOException, DocumentBeanException, BPMException, InterruptedException
    {
            Listbox tablaArchivos= null;
            Listitem item= null;
            TaskAttachmentManager business= new TaskAttachmentManager(getCurrentTask());
            
            //Tomamos la tabla de archivos
            tablaArchivos= getAttachmentsListbox();

            if(tablaArchivos!= null)
            {
                    //tomamos el item seleccionado
                    item= tablaArchivos.getSelectedItem();
                    
                    if(item!= null)
                    {
                            String tag = (String) item.getValue();
                            Executions.getCurrent().sendRedirect(business.getDownloadURL(tag), "_new");
                    }
                    else
                    {
                    	Missatgebox.avis("Debe seleccionar un archivo");
                    }
            }
            else
            {
            	Missatgebox.avis("Debe cargar Archivos antes de intentar descargarlos");                      
            }
    }
    
    public void seleccionarDocumento() throws SignatureTimestampException, IOException, ClassNotFoundException, NASException, NamingException, CreateException
    {
            Listbox tablaArchivos= null;
            Listitem item= null;
            Listitem roleListItem= null;
            Document document= null;
            Set rolesDocumento= null;
            String role= null;
            Listbox tablaRoles= null;
            List firmas= null;
            Signature sign= null;
            
            Vbox roles= (Vbox)this.getFellow("rolesDocumento");
            TaskAttachmentManager am = new TaskAttachmentManager(getCurrentTask());
            
            roles.setVisible(false);
            
            //Tomamos la tabla de archivos
            tablaArchivos= getAttachmentsListbox();
            tablaRoles= getRolesListbox();
            Listbox tablaFirmas = getSignaturesListbox();
            
            //Limpiamos la tabla de roles
            tablaRoles.getItems().clear();
            
            if(tablaArchivos!= null)
            {
                    //tomamos el item seleccionado
                    item = tablaArchivos.getSelectedItem();
                    
                    if(item!= null)
                    {
                            String tag = (String) item.getValue();
                    
                            document = am.getDocument(tag);
                            
                            // Actualizar roles
                            rolesDocumento= document.getRoles();
                            
                            tablaRoles.getItems().clear ();
                            for(Iterator it= rolesDocumento.iterator(); it.hasNext();)
                            {
                                    role= (String)it.next();
                                    
                                    roleListItem= new Listitem();
                                    
                                    roleListItem.setValue(role);
                                    roleListItem.appendChild(new Listcell(role));
                                    
                                    tablaRoles.appendChild(roleListItem);
                            }
                            
                            // Actualizar firmas
                            tablaFirmas.getItems().clear ();
                            firmas= document.getSigns();

                            for(int index= 0; index< firmas.size(); index++)
                            {
                                sign= ((Signature)firmas.get(index));
                                tablaFirmas.getItems().add(new FirmaListitem(sign));
                            }
                    }
            }
    }

    private Listbox getSignaturesListbox() {
        return (Listbox) getFellow ("tablaFirmas");
    }

    private Listbox getRolesListbox() {
        return (Listbox) getFellow ("tablaRoles");
    }

    private Listbox getAttachmentsListbox() {
        return (Listbox) getFellow("tablaArchivos");
    }
    
    public void downloadSign() throws InterruptedException, IOException, NamingException, DocumentBeanException
    {
            Iframe iframe= (Iframe)this.getFellowIfAny("iframe");
            Tree tree= null;
            FirmaListitem row= null;

            tree= (Tree)this.getFellowIfAny("treefirmas");

            if(tree!=null && tree.getSelectedItem()!= null)
            {
                    row= (FirmaListitem)tree.getSelectedItem().getChildren().get(0);
                    
                    iframe.setContent(new AMedia("firma.sign", ".sign", "application/octet-stream", row.getSign().getPkcs7()));
            }
            else
            {
            	Missatgebox.avis(Labels.getLabel("contenidoTarea.msgSeleccionFirma"), "Custodia de Documentos");
            }
    }
    
    /**
     * Notifica el canvi de selecció entre pestanyes.
     * @param newItem
     */
    public void cambiarPestana(Tabpanel newItem){
        WorkflowWindow workflowWindow = getWorkflowWindow();
    	Events.sendEvent(workflowWindow,new Event(WorkflowWindow.TAB_SELECTED_EVENT,
                workflowWindow,newItem.getId()));    	
    }
}
