/**
 * 
 */
package es.caib.ibkey.alfresco.client;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;

import org.alfresco.www.ws.cml._1_0.CML;
import org.alfresco.www.ws.cml._1_0.CMLCreate;
import org.alfresco.www.ws.model.content._1_0.ContentFormat;
import org.alfresco.www.ws.model.content._1_0.NamedValue;
import org.alfresco.www.ws.model.content._1_0.Node;
import org.alfresco.www.ws.model.content._1_0.ParentReference;
import org.alfresco.www.ws.model.content._1_0.Predicate;
import org.alfresco.www.ws.model.content._1_0.Query;
import org.alfresco.www.ws.model.content._1_0.Reference;
import org.alfresco.www.ws.model.content._1_0.Store;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationFault;
import org.alfresco.www.ws.service.content._1_0.Content;
import org.alfresco.www.ws.service.content._1_0.ContentFault;
import org.alfresco.www.ws.service.content._1_0.ContentServiceSoapBindingStub;
import org.alfresco.www.ws.service.content._1_0.Read;
import org.alfresco.www.ws.service.content._1_0.Write;
import org.alfresco.www.ws.service.repository._1_0.Get;
import org.alfresco.www.ws.service.repository._1_0.GetStores;
import org.alfresco.www.ws.service.repository._1_0.RepositoryFault;
import org.alfresco.www.ws.service.repository._1_0.RepositoryServiceSoapBindingStub;
import org.alfresco.www.ws.service.repository._1_0.Update;
import org.alfresco.www.ws.service.repository._1_0.UpdateResult;
import org.apache.axis.utils.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.alfresco.model.ContentModel;

import es.caib.ibkey.alfresco.ws.AuthenticationUtils;
import es.caib.ibkey.alfresco.ws.ISO9075;
import es.caib.ibkey.alfresco.ws.InternalErrorException;
import es.caib.ibkey.alfresco.ws.WebServiceFactory;
import es.caib.ibkey.alfresco.ws.WebServiceFactory.WebServiceFactoryConfig;
import es.caib.ibkey.bpm.common.ContentTypeRegistry;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.utils.NamedContent;

/**
 * @author u91940
 *
 */
public class AlfrescoRepositoryClient {

	private WebServiceFactoryConfig config=null;

	private static Logger log=Logger.getLogger(AlfrescoRepositoryClient.class.getCanonicalName());
	
	public AlfrescoRepositoryClient() {
	}
	
	public AlfrescoRepositoryClient(WebServiceFactoryConfig config) {
		this.config=config;
	}	

	public static void main(String[] args) {
		String documentName = "prueba-ibkey"+Math.round((Math.random()*1000));
		String documentTitle = documentName;
		String documentDescription = "descripción de "+documentName;
		String documentAuthor = "u91940";
		String nodeParentPath="";
		String nodeName= "test_"+Math.round(Math.random()*1000);
		String alfrescoServicesURL="http://192.168.200.109:18080/alfresco/api";
		//public String BASE="http://sdesalflin1.caib.es:18080";

		String alfrescoUser="u91940";
		String alfrescoUserPassword="abc123";
		String documentStoreScheme = "workspace";
		String documentStoreAddress = "SpacesStore";
		WebServiceFactoryConfig config=new WebServiceFactoryConfig(alfrescoServicesURL, 60000);
	     
		AlfrescoRepositoryClient alf=new AlfrescoRepositoryClient(config);
		 // Set up a simple configuration that logs on the console.
	     //DOMConfigurator.configure(alf.getClass().getClassLoader().getResource("log4j.xml"));

		try {
			AuthenticationUtils.startSession(config,alfrescoUser, alfrescoUserPassword, 3600000);
		} catch (AuthenticationFault e) {
			log.error(e.getMessage(),e);
		} catch (InternalErrorException e) {
			log.error(e.getMessage(),e);
		}
	    try{
	    	alf.doTestBusiness(documentName, documentTitle, documentDescription, documentAuthor,documentStoreScheme, documentStoreAddress, nodeParentPath, nodeName);
	    }catch(Exception e){
	    	log.error(e.getMessage(),e);
	    }finally{
	    	try {
				AuthenticationUtils.endSession(config);
			} catch (InternalErrorException e) {
				log.error(e.getMessage(),e);
			}
	    }

	}

	

	/**
	 * Define la lógica de prueba de subir un fichero a alfresco
	 * @param author 
	 * @param description 
	 * @param title 
	 * @param name 
	 * @param documentStore 
	 * @param nodeParentPath 
	 * @param nodeName 
	 * @param nodeName2 
	 * @throws InternalErrorException 
	 * @throws RemoteException 
	 * @throws UnsupportedEncodingException 
	 */
	private void doTestBusiness(String documentName, String documentTitle, String documentDescription, String documentAuthor,String documentStoreScheme, String documentStoreAddress, String nodeParentPath, String nodeName) throws RemoteException, InternalErrorException, UnsupportedEncodingException {
		RepositoryServiceSoapBindingStub repo=null;

			try {
				repo=WebServiceFactory.getRepositoryService(config);
			} catch (InternalErrorException e) {
				log.error(e.getMessage(),e);
				throw e;
			}

			Store stores[];
			try {
				stores = repo.getStores(new GetStores());
			} catch (RepositoryFault e) {
				log.error(e.getMessage(),e);
				throw e;
			} catch (RemoteException e) {
				log.error(e.getMessage(),e);
				throw e;
			}
			Store store = selectStore(stores,documentStoreScheme,documentStoreAddress);
			Reference reference=createContentNode(store,nodeParentPath,nodeName,documentName,documentTitle,documentDescription,documentAuthor);
			byte[] content;
			try {
				content = "esto es una prueba".getBytes("UTF-8");
				uploadContent(store,reference,"text/plain","UTF-8",content);
			} catch (UnsupportedEncodingException e) {
				log.error(e.getMessage(),e);
				throw e;
			}

		
	}
	
	public boolean alreadyExistsContent(Store store,String path) throws InternalErrorException, RemoteException{
		Content c[]=null;
		try {
			Reference ref=new Reference(store, null, path);
			ContentServiceSoapBindingStub content=WebServiceFactory.getContentService(config);//ISO9075.encode("pere1234");
			c=content.read(new Read(new Predicate(new Reference[]{ref},null,null),ContentModel.TYPE_CONTENT.toString()));
		} catch (InternalErrorException e) {
			log.error(e.getMessage(),e);
			throw e;
		} catch (ContentFault e) {
			//ATENCION: alfresco 3.2.1 no es capaz de devolver ficheros con nombres raros (por ejemplo con espacios)
			// la versión 3.4.6 lo soluciona
			// así que la 3.2.1 siempre devolverá que no existe el fichero
			if(e.getMessage1().contains("found 0 nodes")){
				return false;
			}else{
				log.error(e.getMessage(),e);
				throw e;
			}
		} catch (RemoteException e) {
			log.error(e.getMessage(),e);
			throw e;
		}

		return true;
	}
	public boolean alreadyExistsFolder(Store store,String path) throws InternalErrorException, RemoteException{
		try {
			if(path.endsWith("/")) path=path.substring(0,path.length()-2);
			Reference ref=new Reference(store, null, path);
			ContentServiceSoapBindingStub content=WebServiceFactory.getContentService(config);
			content.read(new Read(new Predicate(new Reference[]{ref},null,null),ContentModel.TYPE_FOLDER.toString()));
		} catch (InternalErrorException e) {
			log.error(e.getMessage(),e);
			throw e;
		} catch (ContentFault e) {
			if(e.getMessage1().contains("found 0 nodes")){
				return false;
			}else{
				log.error(e.getMessage(),e);
				throw e;
			}
		} catch (RemoteException e) {
			log.error(e.getMessage(),e);
			throw e;
		}
		return true;
	}

	public Reference createContentNode(Store store,String parentPath, String nodeName, String name, String title, String description, String author) throws RemoteException, InternalErrorException {
		createNodePath(store,parentPath,"",author);
		
		int i=1;
		String uniqueNodeName=nodeName;
		do{
			if(alreadyExistsContent(store, parentPath+"/cm:"+ISO9075.encode(uniqueNodeName))){
				uniqueNodeName=nodeName+" ("+i+")";
				i++;
			}else{
				break;
			}
		}while(i<10);
		if(i==10) throw new InternalErrorException("Too many files with same name: "+parentPath+"/cm:"+nodeName);
		
		ParentReference parentReference=new ParentReference(store,null,parentPath,ContentModel.ASSOC_CONTAINS.toString(),null);
		parentReference.setChildName("cm:"+ISO9075.encode(uniqueNodeName));
		CMLCreate createNodeStmt=new CMLCreate(
				"1"
				, parentReference
				, null
				, null
				, null
				, ContentModel.TYPE_CONTENT.toString()
				, buildCustomProperties(uniqueNodeName, title, description, author));
		
		//build the CML object
		CML cml = new CML();
		cml.setCreate(new CMLCreate[]{createNodeStmt});
		//perform a complete CML update
		UpdateResult[] result;
		try {
			result = WebServiceFactory.getRepositoryService(config).update(new Update(cml));
		} catch (RepositoryFault e) {
			log.error(e.getMessage(),e);
			throw e;
		} catch (RemoteException e) {
			log.error(e.getMessage(),e);
			throw e;
		} catch (InternalErrorException e) {
			log.error(e.getMessage(),e);
			throw e;
		}
		
		if(result!= null && result.length>0 && result[result.length-1]!=null)
			return result[result.length-1].getDestination();
		else
			return null;
	}
	
	public void createNodePath(Store store, String parentPath,String description,String author) throws RemoteException, InternalErrorException{
		if(!alreadyExistsFolder(store, parentPath)){
			String paths[]=parentPath.split("\\/");
			StringBuffer tempPath=null;
			String tempParentPath=null;
			int j=0;
			//build path from deepest leaf to root directory
			for(j=paths.length;j>0;j--){
				tempPath=new StringBuffer();
				//build path
				for(int l=0;l<j;l++){
					if("".equals(paths[l])) continue;
					tempPath.append("/");
					tempPath.append(paths[l]);
				}
				if(alreadyExistsFolder(store, tempPath.toString())){
					break;
				}
			}
			
			//create nodes from first non-existing directory to deepest leaf
			
			for(int i=j;i<paths.length;i++){
				tempPath=new StringBuffer();
				//build path
				for(int l=0;l<i;l++){
					if("".equals(paths[l])) continue;
					tempPath.append("/");
					tempPath.append(paths[l]);
				}
				
				ParentReference parentReference=new ParentReference(store,null,tempPath.toString(),ContentModel.ASSOC_CONTAINS.toString(),null);
				String tempName=paths[i].replaceAll("cm:", "");
				tempName=ISO9075.decode(tempName);
				parentReference.setChildName("{http://www.alfresco.org/model/content/1.0}"+tempName);
				
				CMLCreate createNodeStmt=new CMLCreate(
						"1"
						, parentReference
						, null
						, null
						, null
						, ContentModel.TYPE_FOLDER.toString()
						, buildCustomProperties(tempName, tempName, description, author));
				
				//build the CML object
				CML cml = new CML();
				cml.setCreate(new CMLCreate[]{createNodeStmt});
				//perform a complete CML update
				UpdateResult[] result;
				try {
					result = WebServiceFactory.getRepositoryService(config).update(new Update(cml));
				} catch (RepositoryFault e) {
					log.error(e.getMessage(),e);
					throw e;
				} catch (RemoteException e) {
					log.error(e.getMessage(),e);
					throw e;
				} catch (InternalErrorException e) {
					log.error(e.getMessage(),e);
					throw e;
				}
			}
		}
		
	}

	public static NamedValue[] buildCustomProperties(String name, String title, String description,String author) {
		NamedValue[] properties = new NamedValue[4];
		properties[0] = new NamedValue("{" + ContentModel.TYPE_CONTENT.getNamespaceURI() + "}name",new Boolean(false),name,null);
		properties[1] = new NamedValue("{" + ContentModel.TYPE_CONTENT.getNamespaceURI() + "}title",new Boolean(false),title,null);
		properties[2] = new NamedValue("{" + ContentModel.TYPE_CONTENT.getNamespaceURI() + "}description",new Boolean(false),description,null);
		properties[3] = new NamedValue("{" + ContentModel.TYPE_CONTENT.getNamespaceURI() + "}userName",new Boolean(false),author,null);
		return properties;
		}

	/**
	 * Sube contenido a un nodo referenciado
	 * @param store
	 * @param reference
	 * @throws InternalErrorException
	 * @throws RemoteException 
	 */
	public void uploadContent(Store store,Reference reference,String mimeType,String encoding,byte[] content) throws InternalErrorException, RemoteException {
		ContentServiceSoapBindingStub contentService=null;

		try {
			contentService=WebServiceFactory.getContentService(config);
		} catch (InternalErrorException e1) {
			e1.printStackTrace();
			throw e1;
		}
		
		ContentFormat format = new ContentFormat(mimeType, encoding);		
		try {
			contentService.write(new Write(reference,ContentModel.PROP_CONTENT.toString(),content, format));
		} catch (ContentFault e) {
			log.error(e.getMessage(),e);
			throw e;
		} catch (RemoteException e) {
			log.error(e.getMessage(),e);
			throw e;
		}

		
	}

	/**
	 * Baja contenido desde un nodo referenciado
	 * @param store
	 * @param reference
	 * @throws Exception 
	 */
	public es.caib.ibkey.utils.NamedContent getContentByHashlink(String  hashlink) throws Exception {

		log.debug("Inicio de descarga del documento: "+hashlink);	
		ContentServiceSoapBindingStub contentService=null;

		try {
			contentService=WebServiceFactory.getContentService(config);
		} catch (InternalErrorException e1) {
			log.error(e1.getMessage(),e1);
			throw e1;
		}
		
		
		
		try {
			Reference [] references=new Reference[1];
			Store store=new Store(
					IBkeyConfig.getAlfrescoStoreScheme()
					,IBkeyConfig.getAlfrescoStoreAddress());

				references[0]=new Reference(store,hashlink,null);

			
			Content content[]=contentService.read(
					new Read(
							new Predicate(
									references
									,null
									,null)
							,ContentModel.PROP_CONTENT.toString()
							)
					);
			
			es.caib.ibkey.utils.Content simpleContent=getContentByURL(content[0].getUrl());
			
    		//recuperem el títol del fitxer
 			
			Node[] nodes=getNode(new String [] {hashlink});
 			
 			String name=null;
 			
 			NamedValue[] nodeProps=nodes[0].getProperties();
 			for (int m=0;m<nodeProps.length;m++){//{http://www.alfresco.org/model/content/1.0}title
 				if(ContentModel.PROP_TITLE.toString().equals(nodeProps[m].getName()))
 					name=nodeProps[m].getValue();
 			}

 			
 			
			es.caib.ibkey.utils.NamedContent outContent=new NamedContent(simpleContent,name);
			
			log.debug("Fin de descarga del documento: "+hashlink);
			return outContent;

		} catch (Exception e) {
			log.error(e.getMessage(),e);
			throw e;
		}

		
	}

	/**
	 * Filtra un store de una lista 
	 * @param stores
	 * @param scheme
	 * @param address
	 * @return
	 */
	public static Store selectStore(Store[] stores,String scheme, String address) {
		Store selected=null;
		
		for(int i=0;i<stores.length;i++){
			if(stores[i].getScheme()!=null && stores[i].getScheme().equals(scheme) && stores[i].getAddress()!=null && stores[i].getAddress().equals(address)){
				selected=stores[i];
				break;
			}
		}
		
		return selected;
	}

	public Node[] getNode(String[] hashlinks) throws InternalErrorException, RemoteException {
		RepositoryServiceSoapBindingStub repoService=null;

		try {
			repoService=WebServiceFactory.getRepositoryService();
		} catch (InternalErrorException e1) {
			log.error(e1.getMessage(),e1);
			throw e1;
		}
		
		
		
		try {
			Reference references[]=new Reference[hashlinks.length];
			Store store=new Store(
					IBkeyConfig.getAlfrescoStoreScheme()
					,IBkeyConfig.getAlfrescoStoreAddress());
			
			for(int i=0;i<hashlinks.length;i++){
				references[i]=new Reference(store,hashlinks[i],null);
			}
			
			Node[] nodes=repoService.get(
					new Get(
							new Predicate(
									references
									,null
									,null
									)
							)
					);
			
			
			
			return nodes;
			
		} catch (ContentFault e) {
			log.error(e.getMessage(),e);
			throw  e;
		} catch (RemoteException e) {
			log.error(e.getMessage(),e);
			throw e;
		}

	}

	
	public static es.caib.ibkey.utils.Content getContentByURL(String url) throws Exception
    {
		es.caib.ibkey.utils.Content outContent=new es.caib.ibkey.utils.Content();
		
		String strUrl;
        ByteArrayOutputStream readContent=new ByteArrayOutputStream();
        InputStream is;
        String ticket = AuthenticationUtils.getTicket();
        strUrl = (new StringBuilder()).append(url).append("?ticket=").append(ticket).toString();
        is = null;
        try
        {
    	
        	
        	URL urlAuth = new URL(strUrl);
            URLConnection conn = urlAuth.openConnection();
            conn.setRequestProperty("Cookie", (new StringBuilder()).append("JSESSIONID=").append(AuthenticationUtils.getAuthenticationDetails().getSessionId()).append(";").toString());
            
            is = conn.getInputStream();
            byte [] buf=new byte[4096];
            int readed=0;
            while(readed!=-1){
            	readed=is.read(buf);
            	if(readed!=-1)
            		readContent.write(buf, 0, readed);
            }
            
            outContent.setContent(readContent.toByteArray());
            outContent.setContentEncoding(conn.getContentType().split(";")[1]);
            outContent.setMimeType(conn.getContentType().split(";")[0]);
        }
        catch(Exception exception)
        {
            throw new Exception("Unable to get content as string.", exception);
        }
        if(is != null)
            try
            {
                is.close();
            }
            catch(Throwable e) { }
    	
        return outContent;
    }
}
