package es.caib.ibkey.bpm.common;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.jbpm.graph.exe.ExecutionContext;


import es.caib.bpm.identity.seycon.IdentityManager;
import es.caib.bpm.identity.seycon.vo.User;
import es.indra.www.portafirmasws.cws.Signer;

public class PortafirmasIdentityHelper {

	public PortafirmasIdentityHelper() {
	}
	
	/**
	 * Genera Signers a partir d'un rol a un LDAP
	 * @param ctx 
	 * @param role
	 * @return
	 * @throws Exception 
	 */
	public static Collection findUsersFromRole( String role) throws Exception {
		//recuperamos los usuarios desde las tablas de usuarios de JBPM
		IdentityManager idMgr=new IdentityManager();
		Collection entries=idMgr.obtenirUsuarisPerRolGrup(role);
		Vector signers=new Vector();
		
		for(Iterator it=entries.iterator();it.hasNext();){
			User entry=(User)it.next();

			Signer signer=new Signer();
			signer.setName(entry.getId());
			signer.setEmail(entry.getEmail());
			signer.setId(entry.getNif());
			
			signers.add(signer);
		}
		
		return signers;
		
		
	}

	/**
	 * Genera Signers a partir d'un user a un LDAP
	 * @param ctx 
	 * @param role
	 * @return
	 * @throws Exception 
	 */
	public static Signer findUser(String user) throws Exception {
		Signer signer=new Signer();
		signer.setName(user);
		
		//generar el signer a partir de lo obtenido del identityManager
		IdentityManager idMgr=new IdentityManager();
		String nif = idMgr.obtenirNifPerCodiUsuari(user);
		signer.setId(nif);
		
		String mail = idMgr.obtenirCorreuPerCodiUsuari(user);
		signer.setEmail(mail);
		
		return signer;
	}


	
}
