package es.caib.ibkey.bpm.common;


import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;


/**
 * Clase con utileria para el tratamiento de ficheros de configuraci�n
 * .properties. El fichero cargado que se desea cargar se puede establecer
 * en el constructor, si no se establece se carga uno por defecto 
 * (esources/config.properties). 
 * 
 * @author u93387
 *
 */
public class PropertiesFileUtil {
	
	/** Nombre del fichero de configuraci�n por defecto **/
	private String FICHERO_CONFIGURACION = "config.properties";
	private Properties properties;
	
	/** Carga el fichero de configuracin por defecto **/
	public PropertiesFileUtil() throws IOException{		
		this.loadFile();
	}

	/** Carga el fichero de configuracin indicado **/
	public PropertiesFileUtil(String nameFile) throws IOException{
		this.FICHERO_CONFIGURACION = nameFile;	
		this.loadFile();
	}
	
	/** Carga el fichero de configuracin que le llega **/
	public PropertiesFileUtil(InputStream input) throws IOException{
		this.loadFile(input);
	}
	
	/**
	 * Carga el fichero de configuraci�n .properties en una hash como atributo de
	 * clase con todas las parejas clave-valor establecidas en el fichero. 
	 * 
	 * @throws IOException
	 */
	private void loadFile() throws IOException{
		InputStream is = null;
		try {
			// Carga del fichero de propiedades
			is = this.getClass().getClassLoader().getResourceAsStream(FICHERO_CONFIGURACION);
			this.loadFile(is);
		} finally {
			if(is != null)
				try {
					is.close();
				} catch (IOException e) {
					Logger.getLogger(PropertiesFileUtil.class).error(e.getMessage(),e);
				}
		}		
	}
	
	/**
	 * Carga el fichero de configuraci�n .properties en una hash como atributo de
	 * clase con todas las parejas clave-valor establecidas en el fichero. 
	 * 
	 * @throws IOException
	 */
	private void loadFile(InputStream input) throws IOException{		
		properties = new Properties();
		properties.load(input);		
	}
	
	/**
	 * Recupera el valor de una entrada en el fichero a partir de la clave
	 * pasada por par�metro
	 * 
	 * @param key
	 * @return
	 * @throws PropertyNotFoundException
	 */
	public String getProperty(String key) throws PropertyNotFoundException{
		String prop = properties.getProperty(key);
		if(prop == null){
			throw new PropertyNotFoundException(key);
		}
		
		return prop;
	}
}
