package es.caib.ibkey.bpm.pdf.helper;


import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;

import es.caib.ibkey.bpm.conversion.exception.ConversionException;

/**
 * Classe per generar PDF/A a partir d'imatges. 
 * @author u91940
 *
 */
public class PDFAFromImageGeneratorHelper extends PDFAGeneratorHelper{
	
	protected byte [] imageBytes=null;
	protected boolean scaleImageToFitPage=false;
	protected Rectangle pageSize=null;
	protected boolean rotateWhenWidthGreaterThanHeight=true;
	protected float topMargin=0.0f;
	protected float leftMargin=0.0f;
	protected float bottomMargin=0.0f;
	protected float rightMargin=0.0f;
	
	//private
	private float height;
	private float width;
	private Image image;
	
	
	
	
	
	/**
	 * @return the topMargin
	 */
	public float getTopMargin() {
		return topMargin;
	}

	/**
	 * @param topMargin the topMargin to set
	 */
	public void setTopMargin(float topMargin) {
		this.topMargin = topMargin;
	}

	/**
	 * @return the leftMargin
	 */
	public float getLeftMargin() {
		return leftMargin;
	}

	/**
	 * @param leftMargin the leftMargin to set
	 */
	public void setLeftMargin(float leftMargin) {
		this.leftMargin = leftMargin;
	}

	/**
	 * @return the bottomMargin
	 */
	public float getBottomMargin() {
		return bottomMargin;
	}

	/**
	 * @param bottomMargin the bottomMargin to set
	 */
	public void setBottomMargin(float bottomMargin) {
		this.bottomMargin = bottomMargin;
	}

	/**
	 * @return the rightMargin
	 */
	public float getRightMargin() {
		return rightMargin;
	}

	/**
	 * @param rightMargin the rightMargin to set
	 */
	public void setRightMargin(float rightMargin) {
		this.rightMargin = rightMargin;
	}

	public void setScaleImageToFitPage(boolean scaleImageToFitPage) {
		this.scaleImageToFitPage = scaleImageToFitPage;
	}
	
	public void setPageSize(Rectangle pageSize) {
		this.pageSize = pageSize;
	}
	
	public void setRotateWhenWidthGreaterThanHeight(boolean rotateWhenWidthGreaterThanHeight) {
		this.rotateWhenWidthGreaterThanHeight = rotateWhenWidthGreaterThanHeight;
	}
	
	
	/**
	 * Genera un PDF i hi incrusta una imatge.
	 * @param imageBytes
	 * @throws ConversionException
	 */
	
	public PDFAFromImageGeneratorHelper(byte[] imageBytes) throws ConversionException {
		
		try {
			this.imageBytes=imageBytes;
			
			//Obtenim la imatge
			image=Image.getInstance(imageBytes);
			height=image.getHeight();
			width=image.getWidth();
		} catch (BadElementException e) {//			Logger.getLogger(this.getClass()).error(e);

			e.printStackTrace();
			throw new ConversionException(e);
		} catch (MalformedURLException e) {
			e.printStackTrace();
			throw new ConversionException(e);
		} catch (IOException e) {
			e.printStackTrace();
			throw new ConversionException(e);
		}
			
	}
		
	protected void customizeContent(Document doc, PdfWriter writer) throws ConversionException{
		try{
			boolean vertical=(height>width)?true:false;

			
			//set pagesize
			
			if(pageSize==null){
				pageSize=getDocumentPageSize();
				if(!vertical && rotateWhenWidthGreaterThanHeight) pageSize.rotate();

				
			}

			if(scaleImageToFitPage || imageGreaterThanPageSize(image, pageSize) ){
				scaleImageToFitPage(image, pageSize);
			}

			
			doc.setPageSize(pageSize);
			
			
			
			
			image.setAbsolutePosition(leftMargin,pageSize.getHeight()-image.getScaledHeight()-topMargin);
			doc.add(image);

		
		} catch (BadElementException e) {//			Logger.getLogger(this.getClass()).error(e);

			e.printStackTrace();
			throw new ConversionException(e);
		} catch (DocumentException e) {
			e.printStackTrace();
			throw new ConversionException(e);
		}
	}

	private boolean imageGreaterThanPageSize(Image image2, Rectangle pageSize2) {
		return (image2.getWidth()>pageSize2.getWidth() || image2.getHeight()>pageSize2.getHeight());
	}

	protected void scaleImageToFitPage(Image image,Rectangle pageSize2) {
		image.scaleAbsolute(((Rectangle)pageSize2).getWidth()-leftMargin-rightMargin,((Rectangle)pageSize2).getHeight()-topMargin-bottomMargin);		
	}

	protected Rectangle pageSizeFromImage(float height, float width,boolean verticalOrientation, boolean rotateWhenWidthGreaterThanHeight) {
		
		float verticalWidth=(verticalOrientation)?width:height;
		float verticalHeight=(verticalOrientation)?height:width;
		
		if(verticalWidth<=595 && verticalHeight<=842)
			if(!verticalOrientation && rotateWhenWidthGreaterThanHeight)return PageSize.A4.rotate(); //
			else return PageSize.A4;
		else if(verticalWidth<=842 && verticalHeight<=1191)
			if(!verticalOrientation && rotateWhenWidthGreaterThanHeight)return PageSize.A4.rotate(); //return PageSize.A3.rotate();
			else return PageSize.A4; //return PageSize.A3;
		else if(verticalWidth<=1191 && verticalHeight<=1684)
			if(!verticalOrientation && rotateWhenWidthGreaterThanHeight)return PageSize.A4.rotate(); //return PageSize.A2.rotate();
			else return PageSize.A4; //return PageSize.A2;
		else 
			if(!verticalOrientation && rotateWhenWidthGreaterThanHeight)return PageSize.A4.rotate(); //return PageSize.A1.rotate();
			else return PageSize.A4; //return PageSize.A1;
	}
	
	


	protected static void readBytes(FileInputStream in, ByteArrayOutputStream out) throws IOException {
		//read image
		byte b[]=new byte [10240];
		int readed=0;
		do{
			readed=in.read(b);
			if(readed!=0 && readed!=-1)
				out.write(b,0,readed);
		}while(readed!=0 && readed!=-1);
						
	}

	@Override
	public Rectangle getDocumentPageSize() {
		if(pageSize==null){
			boolean vertical=(height>width)?true:false;

			return pageSizeFromImage(height,width,vertical,rotateWhenWidthGreaterThanHeight);
			
		}else{
			return pageSize;
		}
	}
	
	
	
	public static void main(String[] args) {
		try{
			ByteArrayOutputStream imageBytes=new ByteArrayOutputStream();
			readBytes(new FileInputStream(new File(args[0])),imageBytes);

			PDFAFromImageGeneratorHelper helper=new PDFAFromImageGeneratorHelper(imageBytes.toByteArray());
			
			FileOutputStream out1=new FileOutputStream(new File(args[1],"test_1.pdf")) ;
			FileOutputStream out2=new FileOutputStream(new File(args[1],"test_2.pdf")) ;
			FileOutputStream out3=new FileOutputStream(new File(args[1],"test_3.pdf")) ;
			FileOutputStream out4=new FileOutputStream(new File(args[1],"test_4.pdf")) ;
			
	
			ByteArrayOutputStream colorProfileBytes=new ByteArrayOutputStream();
			readBytes(new FileInputStream(new File("c:/app/caib/ibkey/srgb.profile")),colorProfileBytes);			

			
			helper.generatePDFA(out1,colorProfileBytes.toByteArray());
			
			helper.setPageSize(null);
			helper.setScaleImageToFitPage(false);
			helper.setRotateWhenWidthGreaterThanHeight(false);
			helper.generatePDFA(out2,colorProfileBytes.toByteArray());
			
			helper.setPageSize(null);
			helper.setScaleImageToFitPage(true);
			helper.setRotateWhenWidthGreaterThanHeight(false);
			helper.generatePDFA(out3,colorProfileBytes.toByteArray());

			helper.setPageSize(null);
			helper.setScaleImageToFitPage(true);
			helper.setRotateWhenWidthGreaterThanHeight(true);
			helper.setBottomMargin(20);
			helper.setTopMargin(40);
			helper.setLeftMargin(100);
			helper.setRightMargin(50);
			helper.generatePDFA(out4,colorProfileBytes.toByteArray());


			
			
		}catch(Exception e){
			e.printStackTrace();
			System.exit(1);
		}
	}
}
