package es.caib.ibkey.bpm.pdf.helper;


import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.log4j.Logger;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;

import es.caib.ibkey.bpm.conversion.exception.ConversionException;


public abstract class PDFAGeneratorHelper {

	
	public void generatePDFA(OutputStream outputStream, byte[] profileInputStream) throws ConversionException{
		try {
			Document doc = new Document(getDocumentPageSize());
			PdfWriter writer = PdfWriter.getInstance(doc, outputStream);
			writer.setPDFXConformance(PdfWriter.PDFA1B);
			doc.open();
			PdfDictionary outi = new PdfDictionary(PdfName.OUTPUTINTENT);
			outi.put(PdfName.OUTPUTCONDITIONIDENTIFIER, new PdfString("sRGB IEC61966-2.1"));
			outi.put(PdfName.INFO, new PdfString("sRGB IEC61966-2.1"));
			outi.put(PdfName.S, PdfName.GTS_PDFA1);
			ICC_Profile icc = ICC_Profile.getInstance(profileInputStream);
			PdfICCBased ib = new PdfICCBased(icc);
			ib.remove(PdfName.ALTERNATE);
			outi.put(PdfName.DESTOUTPUTPROFILE, writer.addToBody(ib).getIndirectReference());
			writer.getExtraCatalog().put(PdfName.OUTPUTINTENTS, new PdfArray(outi));
		
			try {
				customizeContent(doc,writer);
			} catch (ConversionException e) {
				throw e;
			}
			
			writer.createXmpMetadata();
			doc.close();
		} catch (DocumentException e) {
			Logger.getLogger(this.getClass()).error(e);
			throw new ConversionException(e);
		} catch (IOException e) {
			Logger.getLogger(this.getClass()).error(e);
			throw new ConversionException(e);
		}
	
	
	}

	public abstract Rectangle getDocumentPageSize();

	protected abstract void customizeContent(Document doc, PdfWriter writer) throws ConversionException;

}
