package es.caib.ibkey.bpm.pdf.helper;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

import javax.imageio.ImageIO;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;


public class PDFToImageHelper {
	/**
	 * Converts the first page of a pdf file into a image
	 * @param buf
	 * @param maxHeight 
	 * @param maxWidth 
	 * @return
	 * @throws IOException
	 */
	public static BufferedImage convertPDFToImage(PDFPage page, float maxHeight, float maxWidth) throws IOException{

		
        
        //cogemos el tamaño del bounding box del pdf 
		float height=page.getHeight(); //1285 a 100%
		float width=page.getWidth(); //910 a 100%
		float aspectRatio=height/width;

		float resizeRatioH=maxHeight/height;
		float resizeRatioW=maxWidth/width;
		float newHeight=(aspectRatio>1)?maxHeight:height*resizeRatioW;
		float newWidth=(aspectRatio>1)?width*resizeRatioH:maxWidth;
		
		//esto no hace resize así que debemos coger la imagen de toda la página y después hacer resize
        Rectangle rect = new Rectangle(0,0,
                (int)width,
                (int)height);
        
        //Obtenemos la imagen
        Image img = page.getImage(
                rect.width, rect.height, //tamaño
                rect, // el mismo para hacer clipping
                null, // ningun imageObserver
                true, // rellena con fondo blanco
                true  // ejecución síncrona
                );
        Image resized=img.getScaledInstance((int)newWidth,(int)newHeight, Image.SCALE_FAST );
        img=null;
        return toBufferedImage(resized);
        
	}
	
	/**
	 * Saves the image
	 * @param im
	 * @param destPath
	 * @throws IOException
	 */
	public static void saveImage(BufferedImage im,String destPath) throws IOException{
		ImageIO.write(im, "jpg", new File(destPath));
	}
	
	/**
	 * Converts Image to BufferedImage needed to be saved to a file
	 * @param src
	 * @return
	 */
	public static BufferedImage toBufferedImage(Image src) {
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        int type = BufferedImage.TYPE_INT_RGB;  // other options
        BufferedImage dest = new BufferedImage(w, h, type);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return dest;
    }


    /**
     * 
     * @param args args[0]:path pdf d'entrada, args[1]:path jpg de sortida
     */
	public static void main(String[] args) {
		RandomAccessFile raf = null;
		FileChannel channel=null;
		
		try {
			File file = new File(args[0]);    
			raf = new RandomAccessFile(file, "r");
			channel = raf.getChannel();
	        ByteBuffer buf = null;
			buf = channel.map(FileChannel.MapMode.READ_ONLY, 0, channel.size());

			PDFFile pdffile = null;
			pdffile = new PDFFile(buf);
			
	        //cogemos la primera pagina
			PDFPage page = pdffile.getPage(0);
			
			BufferedImage im_buf=PDFToImageHelper.convertPDFToImage(page,800.0f,800.0f);
			PDFToImageHelper.saveImage(im_buf, args[1]);

		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if(channel!=null)try{channel.close();}catch(Exception e){}
			if(raf!=null)try{raf.close();}catch(Exception e){}

		}
	}
}
