package es.caib.ibkey.bpm.sap.util;


import org.apache.log4j.Logger;

import com.sap.mw.jco.*;
import com.sap.mw.jco.JCO.Client;

import es.caib.bpm.toolkit.exception.UserWorkflowException;



/**
* Cliente sap
*/

public class SAPConnector {
			Logger log=Logger.getLogger(SAPManager.class);
       		private static final long serialVersionUID = 1L;

            /** El repositorio de SAP que se utilizar **/
       		private static JCO.Client conexion;
            /** Usuario de conexi�n SAP*/
       		private String usuario;
            /** Password del usuario*/
       		private String password;
            /** HOST donde se aloja SAP */
       		private String host;
            /** client number del servidor */
       		private String client;
            /** System number de la instancia de SAP */
       		private String sysNumber;
            /** Idioma del servidor */
       		private String lng;
            /** Bloquea usuarios valores : S,N */
       		private String desbloqueo;
           // static Hashtable pools = new Hashtable();
            /**
            * Constructor
            * @param params Par�metros de configuraci�n:
            * <li>0 = c�digo de usuario SAP </li>
            * <li>1 = contrase�a de acceso SAP </li>
            * <li>2 = host</li>
            * <li>3 = client </li>
            * <li>4 = System Number </li>
            * <li>5 = Idioma de la conexi�n </li>
            */
       public SAPConnector (String[] params) {
    	   usuario = params[0];
    	   // password = Password.decode(params[1]).getPassword();
           password = params[1];
           host = params[2];
           client = params[3];
           sysNumber = params[4];
           lng  = params[5];
           desbloqueo = params[6];
           if (desbloqueo==null){
        	   desbloqueo = "N";
           } 
       }
       
       public SAPConnector (String user, String pass, String host, String client, String sys, String lang) {
           this.usuario = user;
           this.password = pass;
           this.host = host;
           this.client = client;
           this.sysNumber = sys;
           this.lng  = lang;           
           if (this.desbloqueo==null){
        	   this.desbloqueo = "N";
           } 
         }
      

       
     /**
     * Establece la conexion con sap a traves del pool
     * 
     * @throws Exception
     */
    private void stablishConnection() throws UserWorkflowException{
          try {
        	  if(JCO.getClientPoolManager().getPool("x10") == null){        	 
        	   	  JCO.addClientPool( "x10", // Alias for this pool
                  5,                  // Max. number of connections
                  client,            // SAP client
                  usuario,          // userid
                  password,        // password
                  lng,            // language
                  host,          // host name
                  sysNumber ); //poolcreated=true;
        	  
        	  }
        	  conexion = JCO.getClient("x10");              
          }catch (Throwable ex) {        	
        	  throw new UserWorkflowException ("Error en la conexi�n con SAP:", ex);
          }
      }

      /* Devolvemos el repositorio */
      protected IRepository createRepository(Client conexion) throws UserWorkflowException{
    	  try {
    		  IRepository repository = new JCO.Repository("Repo", conexion);

               return(repository);
          }catch (Throwable ex) { 
        	  throw new UserWorkflowException("Error en la creación del repositorio:", ex);
          }
      }
      
      
      //Cerramos la conexi�n
      protected void cerrarConexion() throws UserWorkflowException{
    	  try{
    		  if (conexion!=null){
    			  JCO.releaseClient(conexion);
    			  conexion = null;
    		  }
    	  }catch(Throwable ex){
    		  throw new UserWorkflowException("No se ha podido cerrar la conexión con SAP:", ex);
    	  }
      }

      
      protected JCO.Client getConnection() throws UserWorkflowException{
    	  if(conexion == null) stablishConnection();
    	  return conexion;
      }

}




