package es.caib.ibkey.bpm.sap.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import org.alfresco.model.ContentModel;
import org.alfresco.www.ws.model.content._1_0.NamedValue;
import org.alfresco.www.ws.model.content._1_0.Node;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationFault;
import org.alfresco.www.ws.service.content._1_0.Content;
import org.apache.log4j.Logger;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.JCO.Table;

import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.alfresco.client.AlfrescoRepositoryClient;
import es.caib.ibkey.alfresco.ws.AuthenticationUtils;
import es.caib.ibkey.alfresco.ws.InternalErrorException;
import es.caib.ibkey.bpm.common.ContentTypeRegistry;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.utils.NamedContent;

/**
 *	Proporciona la funcionalidad en SAP
 */
public class SAPManager extends SAPConnector{
	
	Logger log=Logger.getLogger(SAPManager.class);
	
	public SAPManager(String user, String pass, String host, String client,
			String sys, String lang) {
		super(user, pass, host, client, sys, lang);		
	}
	

	/**
	 * Recupera un documento a partir de su identificador
	 * 
	 * @param code codigo del documento (clase[5]+ejercicioExp[4]+numeroExp[10]+numeroDoc[10]+ejercicioDoc[4])
	 * @return
	 * @throws Exception
	 */
	public es.caib.ibkey.utils.NamedContent getAnexo(String code) throws UserWorkflowException{
    	  JCO.Client client = getConnection();
          try{
        	  if(code == null || code.length() != 33){
        	  	  throw new Exception("Identificador de anexo incorrecto");
        	  }
        	  
        	  IRepository repository = createRepository (client);
              IFunctionTemplate ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_GET_ANEXO);
              JCO.Function function = ftemplate.getFunction();
              
              
			  String expcla = code.substring(0,5);				
			  String expeje = code.substring(5,9);
			  String expnum = code.substring(9, 19);
			  String docnum = code.substring(19, 29);
			  String doceje = code.substring(29,33);
       
              JCO.Structure idibkey = function.getImportParameterList().getStructure(SAPConstants.PAR_ID_IN);
              idibkey.setValue(expcla, SAPConstants.VAR_EXPCLA);
              idibkey.setValue(docnum, SAPConstants.VAR_DOCNUM);
              idibkey.setValue(expnum, SAPConstants.VAR_EXPNUM);
              idibkey.setValue(expeje, SAPConstants.VAR_EXPEJE);
              idibkey.setValue(doceje, SAPConstants.VAR_DOCEJE);
              
              client.execute(function);
              
              String name = function.getExportParameterList().getString(SAPConstants.PAR_NAME_OUT);
              String content = function.getExportParameterList().getString(SAPConstants.PAR_FILE_OUT);
	
              String coderr = function.getExportParameterList().getString("CODERR");
              
              es.caib.ibkey.utils.NamedContent anexeDoc=null;
              
	            if("0".equals(coderr)){            
		            	anexeDoc=getAnnexeDocFromSap(name,content);
	  		            
	                }else if("6".equals(coderr)){ 
	                	anexeDoc=getAnnexeDocFromAlfresco(name,content);
	                	
	                }else{
	                	//ERROR!!!
	                	String descerr = function.getExportParameterList().getString("DESCERR");
		            	throw new UserWorkflowException ("Codigo: " + coderr +" Error al recuperar el anexo en SAP"+ code + " : " +descerr);
	                }
				
			return anexeDoc;
				
          } catch (Throwable e){
        	  log.error("Error al recuperar el documento anexo al expediente:", e);
        	  throw new UserWorkflowException ("Error al recuperar el documento anexo al expediente:"+ e);
          } finally {
              cerrarConexion();
          } 
      }
      
	  
    /**
     * Recuopera los identificadores de los documentos adjuntos de un expediente dado. 
     * 
     * @param expcla
     * @param expeje
     * @param expnum
     * @param docnum
     * @param doceje
     * @return una cadena de caracteres formada por los identificadores de los documentos del expediente
     * 		   separados por ";"
     *  
     * @throws Exception
     */
    public String getAnexosList(String expcla, String expeje, String expnum, String docnum, String doceje) throws UserWorkflowException{
    	  JCO.Client client = getConnection();
          try{
        	  IRepository repository = createRepository (client);
              IFunctionTemplate ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_GET_LISTA_ANEXOS);
              JCO.Function function = ftemplate.getFunction();			  
       
              JCO.Structure idibkey = function.getImportParameterList().getStructure(SAPConstants.PAR_ID_IN);
              idibkey.setValue(expcla, SAPConstants.VAR_EXPCLA);
              idibkey.setValue(docnum, SAPConstants.VAR_DOCNUM);
              idibkey.setValue(expnum, SAPConstants.VAR_EXPNUM);
              idibkey.setValue(expeje, SAPConstants.VAR_EXPEJE);
              idibkey.setValue(doceje, SAPConstants.VAR_DOCEJE);
              
              client.execute(function);
              String ret = function.getExportParameterList().getString(SAPConstants.PAR_ANEXOSLIST_OUT);
              
              return ret;
          } catch (Throwable e){
        	  log.error("Error al recuperar la lista de anexos:",e);
        	  throw new UserWorkflowException ("Error al recuperar la lista de anexos:"+ e);
          } finally {
              cerrarConexion();
          } 
      }
      
      
     /** 
      * Cambia el estado de un expediente
      * 	
      *  0 � Iniciado
      *	 1 � Rechazado
      *  2 � Firma VIP
      *  3 � Firma 
      *  9 � Otros
      */
      public void changeState(String expcla, String expeje, String expnum, 
    		  				  String docnum, String doceje, String state, String desc) 
      			  throws UserWorkflowException{
    	  			
          try{
        	  JCO.Client client = getConnection();
        	  
        	  IRepository repository = createRepository (client);
              IFunctionTemplate ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_SET_STATE);
              JCO.Function function = ftemplate.getFunction();
       
              JCO.Structure idibkey = function.getImportParameterList().getStructure(SAPConstants.PAR_ID_IN);
              idibkey.setValue(expcla, SAPConstants.VAR_EXPCLA);
              idibkey.setValue(docnum, SAPConstants.VAR_DOCNUM);
              idibkey.setValue(expnum, SAPConstants.VAR_EXPNUM);
              idibkey.setValue(expeje, SAPConstants.VAR_EXPEJE);
              idibkey.setValue(doceje, SAPConstants.VAR_DOCEJE);
              
              function.getImportParameterList().setValue(state, SAPConstants.PAR_STATE_IN);
              function.getImportParameterList().setValue(desc, SAPConstants.PAR_TEXT_IN);
              
              client.execute(function);
              String coderr = function.getExportParameterList().getString("CODERR");
              if(!"0".equals(coderr)){            
            	  String descerr = function.getExportParameterList().getString("DESCERR");
            	  throw new UserWorkflowException ("Codigo: " + coderr +" Error al cambiar el estado del expediente en SAP: " +descerr);
              }
              
          } catch (Exception e){
        	  log.error("Error al cambiar el estado del expediente:",e);
        	  throw new UserWorkflowException ("Error al cambiar el estado del expediente:", e);
          } finally {
				cerrarConexion();          
          } 
      }
      
    /**
     * Recupera los documentos adjuntos de un expediente dado. 
     * 
     * 
     * @param expcla
     * @param expeje
     * @param expnum
     * @param docnum
     * @param doceje
     * 
     * @return un listado de con los documentos codificados en BASE64
     * @throws Exception
     */
    public es.caib.ibkey.utils.NamedContent[] getAnexos(String expcla, String expeje, String expnum, String docnum, String doceje) throws Exception{
    	  JCO.Client client = getConnection();
    	  es.caib.ibkey.utils.NamedContent[] anexeDocList = null;
          try{
        	  IRepository repository = createRepository (client);
              IFunctionTemplate ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_GET_LISTA_ANEXOS);
              JCO.Function function = ftemplate.getFunction();			  
       
              JCO.Structure idibkey = function.getImportParameterList().getStructure(SAPConstants.PAR_ID_IN);
              idibkey.setValue(expcla, SAPConstants.VAR_EXPCLA);
              idibkey.setValue(docnum, SAPConstants.VAR_DOCNUM);
              idibkey.setValue(expnum, SAPConstants.VAR_EXPNUM);
              idibkey.setValue(expeje, SAPConstants.VAR_EXPEJE);
              idibkey.setValue(doceje, SAPConstants.VAR_DOCEJE);
              
              client.execute(function);
              String idAnnexosList = function.getExportParameterList().getString(SAPConstants.PAR_ANEXOSLIST_OUT);
              log.debug("Recuperada lista de anexos del documento: "+expcla+" "+expeje+" "+expnum+" "+docnum);
              if(idAnnexosList != null && !"".equals(idAnnexosList)){
	  				String idAnnexos[] = idAnnexosList.split(";");
	  				anexeDocList = new es.caib.ibkey.utils.NamedContent[idAnnexos.length];
	  				for(int i = 0; i < idAnnexos.length; i++){				
	  					ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_GET_ANEXO);
	  		            function = ftemplate.getFunction();
	  		              
	  					expcla = idAnnexos[i].substring(0,5);				
	  					expeje = idAnnexos[i].substring(5,9);
	  					expnum = idAnnexos[i].substring(9, 19);
	  					docnum = idAnnexos[i].substring(19, 29);
	  					doceje = idAnnexos[i].substring(29,33);
	  		       
	  		            idibkey = function.getImportParameterList().getStructure(SAPConstants.PAR_ID_IN);
	  		            idibkey.setValue(expcla, SAPConstants.VAR_EXPCLA);
	  		            idibkey.setValue(docnum, SAPConstants.VAR_DOCNUM);
	  		            idibkey.setValue(expnum, SAPConstants.VAR_EXPNUM);
	  		            idibkey.setValue(expeje, SAPConstants.VAR_EXPEJE);
	  		            idibkey.setValue(doceje, SAPConstants.VAR_DOCEJE);
	  		              
	  		            client.execute(function);
	  		              
	  		            String name = function.getExportParameterList().getString(SAPConstants.PAR_NAME_OUT);
	  		            String content = function.getExportParameterList().getString(SAPConstants.PAR_FILE_OUT);
	  		              
	  		            String coderr = function.getExportParameterList().getString("CODERR");
		            	
	  		            
	  		            if("0".equals(coderr)){       
	  		            	anexeDocList[i]=getAnnexeDocFromSap(name,content);
	  		            	log.debug("Anexo recuperado de SAP: "+idAnnexos[i]);
 		                }else if("6".equals(coderr)){ 
 		                	anexeDocList[i]=getAnnexeDocFromAlfresco(name,content);
 		                	log.debug("Anexo recuperado de ARCHIVELINK: "+idAnnexos[i]);
 		                	
 		                }else{
 		                	//ERROR!!!
 		                	String descerr = function.getExportParameterList().getString("DESCERR");
	  		            	throw new UserWorkflowException ("Codigo: " + coderr +" Error al recuperar el anexo en SAP"+ idAnnexos[i] + " : " +descerr);
 		                }
	  		            		
	  				}
              }else{
                  log.debug("Documento sin anexos: "+expcla+" "+expeje+" "+expnum+" "+docnum);

              }
              
              return anexeDocList;
              
          } catch (Throwable e){
        	  log.error("Error al recuperar la lista de anexos:",e);
        	  throw new UserWorkflowException ("Error al recuperar la lista de anexos:"+ e);
          } finally {
              cerrarConexion();
          } 
          
      }
      
      
      
    private es.caib.ibkey.utils.NamedContent getAnnexeDocFromAlfresco(String archiveId, String hashlink) throws Throwable {
    	//document archivelink a alfresco
     	//hem de mirar si tenim configurat l'acces per a l'entorn d'alfresco al que està el document de SAP
    	log.debug("Inicio de recuperación del anexo de sap desde alfresco: "+hashlink);
    	if(IBkeyConfig.getAlfrescoIBkeySAPArchiveId().equals(archiveId)){
    		

    		//client d'alfresco
    		AlfrescoRepositoryClient alfresco_client=new AlfrescoRepositoryClient();

     		//autentiquem agafant propietats de sistema
    		try {
    			AuthenticationUtils.startSession(
    					null
    					,IBkeyConfig.getSapUser()
    					,IBkeyConfig.getSapPassword()
    					,Long.parseLong(IBkeyConfig.getAlfrescoWSTimeoutMilis()));    			
    		} catch (AuthenticationFault e) {
    			log.error(e.getMessage(),e);
    			throw e;
    		} catch (InternalErrorException e) {
    			log.error(e.getMessage(),e);
    			throw e;
    		}
    		
    		log.debug("Sesión de alfresco autenticada: "+AuthenticationUtils.getTicket());
    		
    		try{
        		//recuperem el contingut amb el nom
        		NamedContent out=alfresco_client.getContentByHashlink(hashlink);
        		
        		//hem de posar la extensió al nom del fitxer ja que el handler d'enviament al portasignatures ho espera així
        		String extension=new ContentTypeRegistry().getExtensionByContentType(out.getMimeType());
        		out.setName(out.getName()+extension);
        		
        		log.debug("Fin de descarga del anexo de sap desde alfresco: "+hashlink);
        		return out;	
        			
     		}catch(Throwable e){
     			log.error(e.getMessage(),e);
        			throw e;
     		}finally{
     			//tanquem sessió alfresco
                	String __ticket=AuthenticationUtils.getTicket();
                	try {
	           			AuthenticationUtils.endSession(null);
	           		} catch (InternalErrorException e) {
	           			log.error(e.getMessage(),e);
	           			
	           		}
	           		log.debug("Sesión de alfresco finalizada: "+__ticket);	
     		}
     		
     	}else{
     		throw new SystemWorkflowException("No es pot recuperar el document d'alfresco perque no esta a l'entorn associat a l'aplicació ibkey: "+IBkeyConfig.getAlfrescoIBkeySAPArchiveId());
     	}
		
	}


	private es.caib.ibkey.utils.NamedContent getAnnexeDocFromSap(String name, String content) throws IOException {
    	//ve codificat en base64, descodifiquem
           byte [] outContent = new sun.misc.BASE64Decoder().decodeBuffer(content);//System.out.println(new String(content,"utf8"));
           //recuperem el mime a partir de la extensió del fitxer
           String mimeType=extractMimeTypeFromFileName(name);
           //generem el AnnexeDoc per a encapsular aquesta informació
           return new es.caib.ibkey.utils.NamedContent(name, outContent,mimeType,"UTF-8");
		
	}


	private String extractMimeTypeFromFileName(String fileName) throws IOException {
    	String fileExtension=fileName.substring(fileName.lastIndexOf("."));
		String mime = new ContentTypeRegistry().getContentTypeByExtension(fileExtension);
		if(mime == null) mime="plain/text";
		
		return mime;
	}


	private byte[][] decodeContent(Content[] encodedContent) throws UnsupportedEncodingException {
			byte results[][]=new byte[encodedContent.length][];
    			
    			for(int i=0;i<encodedContent.length;i++){
    				
    				try {
    					results[i]=encodedContent[i].getProperty().getBytes(encodedContent[i].getFormat().getEncoding());
    				} catch (UnsupportedEncodingException e) {
    					log.error(e.getMessage(),e);
    					throw e;
    				}
    			}
    		return results;
	}


	/**
     * Asocia al expediente un ticket de custodia
     * 
     * @param expcla
     * @param expeje
     * @param expnum
     * @param docnum
     * @param doceje
     * @param file
     * @throws Exception
     */
    public void setTicket(String expcla, String expeje, String expnum, String docnum, String doceje, String file) throws UserWorkflowException{
    	  JCO.Client client = getConnection();
          try{        	  
        	  IRepository repository = createRepository (client);        	
              IFunctionTemplate ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_SET_TICKET);
              JCO.Function function = ftemplate.getFunction();     
       
              JCO.Structure idibkey = function.getImportParameterList().getStructure(SAPConstants.PAR_ID_IN);
              idibkey.setValue(expcla, SAPConstants.VAR_EXPCLA);
              idibkey.setValue(docnum, SAPConstants.VAR_DOCNUM);
              idibkey.setValue(expnum, SAPConstants.VAR_EXPNUM);
              idibkey.setValue(expeje, SAPConstants.VAR_EXPEJE);
              idibkey.setValue(doceje, SAPConstants.VAR_DOCEJE);
              
              function.getImportParameterList().setValue(file, SAPConstants.PAR_FILE_IN);
              
              client.execute(function);
              
              String coderr = function.getExportParameterList().getString("CODERR");
          	
	          if(!"0".equals(coderr)){            
	            	String descerr = function.getExportParameterList().getString("DESCERR");
	            	throw new UserWorkflowException ("Codigo: " + coderr +" Error al subir el ticket en SAP: " +descerr);
	          }
          } catch (Throwable e){
        	  log.error("Error al asociar el ticket al expediente:",e);
        	  throw new UserWorkflowException ("Error al asociar el ticket al expediente:"+ e.getMessage());

          } finally {
              cerrarConexion();
          } 
      }
      
    
    /**
     * LLama a la RFC de SAP ARCHIV_CONNECTION_INSERT para crear un archivelink.
     * Para ello primero se debe asignar el aspecto correspondiente en el nodo de alfresco.
     * @param archivId
     * @param arcDocId
     * @param arObject
     * @param mandant
     * @param objectId
     * @param sapObject
     * @param docType
     * @throws UserWorkflowException 
     */
    protected void creaArchiveLinkSAP(String archivId, String arcDocId, String arObject, String mandant, String objectId, String sapObject, String docType) throws UserWorkflowException {
    	  JCO.Client client = getConnection();
        try{        	  
      	  IRepository repository = createRepository (client);        	
            IFunctionTemplate ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_CREATE_ARCHIVELINK);
            JCO.Function function = ftemplate.getFunction();     
     
            function.getImportParameterList().setValue(archivId,"ARCHIV_ID");
            function.getImportParameterList().setValue(arcDocId,"ARC_DOC_ID");
            function.getImportParameterList().setValue(arObject,"AR_OBJECT");
            function.getImportParameterList().setValue(mandant,"MANDANT");
            function.getImportParameterList().setValue(objectId,"OBJECT_ID");
            function.getImportParameterList().setValue(sapObject,"SAP_OBJECT");
            function.getImportParameterList().setValue(docType,"DOC_TYPE");

            client.execute(function);
            
      /**      String coderr = function.getExportParameterList().getString("CODERR");
        	
            if(!"0".equals(coderr)){            
              	String descerr = function.getExportParameterList().getString("DESCERR");
              	throw new UserWorkflowException ("Codigo: " + coderr +" Error al subir el ticket en SAP: " +descerr);
            }
      **/
        } catch (Throwable e){
      	  log.error("Error al crear el archivelink:",e);
      	  throw new UserWorkflowException ("Error al crear el archivelink:"+ e.getMessage());

        } finally {
            cerrarConexion();
        } 

  		
  	}
    
    
    
    
   
      public String[][] readTable(String tableName,String [] query,String [] fieldSpecs) throws UserWorkflowException, SystemWorkflowException{
    	  JCO.Client client = getConnection();
    	  try{
    	  
	    	  IRepository repository = createRepository (client);        	
	    	  IFunctionTemplate ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_READ_TABLE);
	    	  JCO.Function function = ftemplate.getFunction();
	          if(function == null)
	              throw new SystemWorkflowException((new StringBuilder("'")).append(SAPConstants.FUN_READ_TABLE).append("' not found in SAP.").toString());
	          
	          function.getImportParameterList().setValue( tableName,"QUERY_TABLE");
	          function.getImportParameterList().setValue(";","DELIMITER");
	          Table optionsTable = function.getTableParameterList().getTable("OPTIONS");
	          for(int i = 0; i < query.length; i++)
	          {
	        	  optionsTable.appendRow();
	        	  optionsTable.setRow(i);
	        	  optionsTable.setValue(query[i],0 );
	          }
	          if(fieldSpecs.length!=0){
		          Table fields = function.getTableParameterList().getTable("FIELDS");
		          int row = 0;
		          for(int i = 0; i < fieldSpecs.length; i++)
		          {
		              fields.appendRow();
		              fields.setRow(row);
		              fields.setValue(fieldSpecs[i],0);
//		              fields.setValue(fieldSpecs[i + 1],1);
//		              fields.setValue(fieldSpecs[i + 2],2);
//		              i += 2;
		              row++;
		          }
	          }	
	          client.execute(function);
	          Table codes = function.getTableParameterList().getTable("DATA");
	          log.debug((new StringBuilder("Numero de entradas en SAP que coiciden con los criterios de búsqueda: '")).append(codes.getNumRows()).append("'").toString());
	          StringBuffer sbuff = new StringBuffer();
	          String results [][]=null;
	          
	          for(int i = 0; i < codes.getNumRows(); i++)
	          {
        		  codes.setRow(i);
	        	  for(int j=0;j<codes.getFieldCount();j++){
	        		  if(results==null) results=new String[codes.getNumRows()][codes.getFieldCount()];
		              results[i][j]=codes.getString(j);
		          }
	          }
	
              return results;
              
	      } catch (Throwable e){
	    	  log.error("Error al recuperar datos de la tabla SAP:",e);
	    	  throw new UserWorkflowException ("Error al recuperar datos de la tabla SAP:"+ e.getMessage());
	
	      } finally {
	          cerrarConexion();
	      } 
              
      }
	

	public void appendArchiveLinkToExpedient(String archivId, String arcDocId, String arObject, String objectId, String docType, String clase, String ejexp, String numexp, String filename) throws UserWorkflowException {
		
  	  JCO.Client client = getConnection();
      try{        	  
    	  IRepository repository = createRepository (client);        	
          IFunctionTemplate ftemplate = repository.getFunctionTemplate(SAPConstants.FUN_REPLACE_DOC_WITH_ARCHIVELINK);
          JCO.Function function = ftemplate.getFunction();     
   
          function.getImportParameterList().setValue(docType,"DOC_TYPE");
          function.getImportParameterList().setValue(clase,"CLASE");
          function.getImportParameterList().setValue(ejexp,"EJEEXP");
          function.getImportParameterList().setValue(numexp,"NUMEXP");
          function.getImportParameterList().setValue(filename,"FILENAME");
          function.getImportParameterList().setValue(archivId,"ARCHIV_ID");
          function.getImportParameterList().setValue(arcDocId,"ARC_DOC_ID");
          function.getImportParameterList().setValue(objectId,"OBJECT_ID");
          function.getImportParameterList().setValue(arObject,"AR_OBJECT");
          
          client.execute(function);
          
          String coderr = function.getExportParameterList().getStructure("RETURN").getString("TYPE");
          String msgerr = function.getExportParameterList().getStructure("RETURN").getString("MESSAGE"); 
          
          if("E".equals(coderr)){ 
        	  throw new UserWorkflowException ("Error en la llamada "+SAPConstants.FUN_REPLACE_DOC_WITH_ARCHIVELINK+" ["+coderr+"] "+msgerr);
          }else if("W".equals(coderr)){
        	  log.warn("Alerta en la llamada a SAP "+SAPConstants.FUN_REPLACE_DOC_WITH_ARCHIVELINK+": "+msgerr);
          }
    
      } catch (Throwable e){
    	  log.error("Error al substituir un documento por un archivelink:",e);
    	  throw new UserWorkflowException ("Error al substituir un documento por un archivelink:"+ e.getMessage());

      } finally {
          cerrarConexion();
      } 
	
	}


	public boolean checkExpedientExists(String clase,String exercici,String expedient) throws UserWorkflowException, SystemWorkflowException{
		String [][] entradas=readTable("/GEX/01",
				new String[]{
					" CLASE = '"+clase+"' AND ",
					" EJEEXP = '"+exercici+"' AND ",
					" NUMEXP = '"+expedient+"' ",
				}
				, new String []{"TITULO"});
	
		if(entradas==null || entradas.length==0)
			return false;
		else
			return true;
	}
    	  
      


}
