package es.caib.ibkey.ghostscript.helper;

import java.io.IOException;
import java.util.Map;
import java.util.Vector;

import org.apache.log4j.Logger;

import com.sun.star.uno.Exception;

import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.conversion.exception.ConversionException;
import es.caib.ibkey.oppenoffice.helper.OOoServer;
import es.caib.ibkey.oppenoffice.helper.Pipe;
import es.caib.ibkey.utils.Log4jOutputStreamAdapter;
import es.caib.ibkey.utils.Log4jPrintStreamAdapter;

/**
 * Conversor de PDF a PDFA a partir d'un ps template.
 * 
 * Les FilterOptions disponibles són:
 * GS.documentUUID: per a establir un documentUUID, sinó ghostscript genera un aleatori.
 * 
 * Les opcions de sistema per a la configuració són:
 * es.caib.ibkey.ghostscript.exec=ruta a l'executable
 * es.caib.ibkey.ghostscript.fontpath=path al directori que conté les fonts
 * es.caib.ibkey.ghostscript.pdfatemplate=path al template de conversió a PDFA
 * es.caib.ibkey.ghostscript.deviceColorModel=model de color del document
 * @author u91940
 *
 */
public class GhostScriptConversionHelper {
	
	private Pipe errStreamHandler;

	private Pipe outStreamHandler;
	
	
	public String convertDocument(String stringInputDocument, String stringConvertType, String stringOutputDocument, Map filterOptions) throws IOException, ConversionException, InterruptedException {
		Logger log=Logger.getLogger(this.getClass()) ;
		Runtime r=Runtime.getRuntime();
		
		Process gsProcess=null;
		
		try{
			

			
			gsProcess = r.exec(getGSCommand(stringInputDocument,stringOutputDocument, filterOptions));
	        outStreamHandler=new Pipe();
	        outStreamHandler.pipe(gsProcess.getInputStream(), new Log4jPrintStreamAdapter(log, Log4jPrintStreamAdapter.DEBUG), "CO> ");
	        errStreamHandler=new Pipe();
	        errStreamHandler.pipe(gsProcess.getErrorStream(), new Log4jPrintStreamAdapter(log, Log4jPrintStreamAdapter.ERROR), "CE> ");
	        
	        //este comando sí finaliza
	        gsProcess.waitFor();
	        
		}catch(IOException e){
	  		log.error(e.getMessage(),e);
	  		throw e;
	  	} catch (InterruptedException e) {
	  		log.error(e.getMessage(),e);
	  		throw e;
		}finally{
		    
			if(gsProcess!=null && gsProcess.exitValue()!=0){
		    	throw new ConversionException("Ghostscript process exitted with error value "+gsProcess.exitValue());
		    }
	
		    	if(outStreamHandler!=null)outStreamHandler.unpipe();
	  			if(errStreamHandler!=null)errStreamHandler.unpipe();
	  	}
	  	
	  	return stringOutputDocument;
	}


	private String[] getGSCommand(String stringInputDocument, String stringOutputDocument,Map filterOptions) {
		Vector buf=new Vector();
		
//		String os=System.getProperty("os.name").toLowerCase();

			
			//path a l'executable
			buf.add(IBkeyConfig.getGhostScriptExecutablePath());
			buf.add("-dUseCIEColor=true");
			buf.add("-dPDFA");

			
			if(IBkeyConfig.getGhostScriptDeviceColorModel()!=null){
				buf.add("-sProcessColorModel="+IBkeyConfig.getGhostScriptDeviceColorModel());
			}else{
				buf.add("-sProcessColorModel=DeviceRGB"); 
			}
			
			if(filterOptions!=null && filterOptions.get("GS.documentUUID")!=null){
				buf.add("-sDocumentUUID="+filterOptions.get("GS.documentUUID"));
			}
			
			buf.add("-sDEVICE=pdfwrite");
			buf.add("-dNOPAUSE");
			buf.add("-dBATCH");
			buf.add("-sSAFE");
			buf.add("-sFONTPATH="+IBkeyConfig.getGhostScriptFontPath());
			buf.add("-sOutputFile="+stringOutputDocument);			
			buf.add(IBkeyConfig.getGhostScriptPDFATemplatePath());
			buf.add(stringInputDocument);
			
			return (String []) buf.toArray(new String[buf.size()]);
		
	}
}
