package es.caib.ibkey.ldap;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.apache.log4j.Logger;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchResults;

import es.indra.www.portafirmasws.cws.Signer;



public class LDAPManager {
	public Logger log = Logger.getLogger(LDAPManager.class);
	
	
	private LDAPConnection lc = null;
	/** Puerto de conexion LDAP * */
	private int ldapPort = LDAPConnection.DEFAULT_PORT;
	/** Version del servidor LDAP */
	private int ldapVersion = LDAPConnection.LDAP_V3;
	/** Usuario root de conexión LDAP */
	private String loginDN;
	/** Password del usuario administrador cn=root,dc=caib,dc=es */
	private String password;
	/** HOST donde se aloja LDAP */
	private String ldapHost;
	/** Rama base del arbol */
	private String containerName;
	/** ofuscador de claves SHA */
	private static MessageDigest digest;
	

	
	/**
	 * Constructor
	 * 
	 * @param params
	 *            Parámetros de configuración:
	 *            <li>0 = código de usuario LDAP </li>
	 *            <li>1 = contraseña de acceso LDAP </li>
	 *            <li>2 = host</li>
	 *            <li>3 = Rama base del arbol </li>
	 */
	public LDAPManager(String[] params){		
		loginDN = params[0];
		//password = Password.decode(params[1]).getPassword();
		password = params[1];
		ldapHost = params[2];
		containerName = params[3];
	}
	
	/**
	 * obtiene conexión con el directorio LDAP
	 * 
	 * @throws InternalErrorException
	 *             imposible conectar con el servidor LDAP
	 */
	private LDAPConnection getConnection() throws UnsupportedEncodingException,  LDAPException{				
		if (lc == null) {
			lc = new LDAPConnection();		
			lc.connect(ldapHost, ldapPort);
			lc.bind(ldapVersion, loginDN, password.getBytes("UTF8"));
		}
		return (lc);
	}

	/**
	 * Cierra la conexion con el directorio LDAP.
	 * @throws LDAPException 
	 * 
	 */
	private void closeConnection() throws LDAPException {
		if (lc != null) {			
			lc.disconnect();
			lc=null;
		}
	}


}
